/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.CoordinatorEnvironmentBean;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.ActionManager;
import com.arjuna.ats.arjuna.coordinator.TxStatsMBean;
import com.arjuna.ats.arjuna.coordinator.internal.TxCommitStatistic;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class TxStats
implements TxStatsMBean {
    private static TxStats _instance = new TxStats();
    private static CoordinatorEnvironmentBean _environmentBean;
    private AtomicLong numberOfTransactions = new AtomicLong(0L);
    private AtomicLong numberOfNestedTransactions = new AtomicLong(0L);
    private AtomicLong numberOfAbortedTransactions = new AtomicLong(0L);
    private AtomicLong numberOfHeuristics = new AtomicLong(0L);
    private AtomicLong numberOfTimeouts = new AtomicLong(0L);
    private AtomicLong numberOfApplicationAborts = new AtomicLong(0L);
    private AtomicLong numberOfSystemAborts = new AtomicLong(0L);
    private AtomicLong numberOfResourceAborts = new AtomicLong(0L);
    private AtomicReference<TxCommitStatistic> commitStatistic = new AtomicReference<TxCommitStatistic>(new TxCommitStatistic(0L, 0L));

    private TxStats() {
    }

    public static boolean enabled() {
        if (_environmentBean == null) {
            _environmentBean = arjPropertyManager.getCoordinatorEnvironmentBean();
        }
        return _environmentBean.isEnableStatistics();
    }

    public static TxStats getInstance() {
        return _instance;
    }

    public long getNumberOfTransactions() {
        return this.numberOfTransactions.longValue();
    }

    public long getNumberOfNestedTransactions() {
        return this.numberOfNestedTransactions.longValue();
    }

    public long getNumberOfHeuristics() {
        return this.numberOfHeuristics.get();
    }

    public long getNumberOfCommittedTransactions() {
        return ((TxCommitStatistic)this.commitStatistic.get()).getNumberOfCommittedTransactions();
    }

    public long getAverageCommitTime() {
        return ((TxCommitStatistic)this.commitStatistic.get()).getAverageCommitTime();
    }

    public long getNumberOfAbortedTransactions() {
        return this.numberOfAbortedTransactions.get();
    }

    public long getNumberOfInflightTransactions() {
        return ActionManager.manager().getNumberOfInflightTransactions();
    }

    public long getNumberOfTimedOutTransactions() {
        return this.numberOfTimeouts.get();
    }

    public long getNumberOfApplicationRollbacks() {
        return this.numberOfApplicationAborts.get();
    }

    public long getNumberOfSystemRollbacks() {
        return this.numberOfSystemAborts.get();
    }

    public long getNumberOfResourceRollbacks() {
        return this.numberOfResourceAborts.get();
    }

    public void printStatus(PrintWriter pw) {
        pw.println("JBoss Transaction Service statistics.");
        pw.println(Calendar.getInstance().getTime() + "\n");
        pw.println("Number of created transactions: " + this.getNumberOfTransactions());
        pw.println("Number of nested transactions: " + this.getNumberOfNestedTransactions());
        pw.println("Number of heuristics: " + this.getNumberOfHeuristics());
        pw.println("Number of committed transactions: " + this.getNumberOfCommittedTransactions());
        pw.println("Number of rolled back transactions: " + this.getNumberOfAbortedTransactions());
        pw.println("Number of inflight transactions: " + this.getNumberOfInflightTransactions());
        pw.println("Number of timed-out transactions: " + this.getNumberOfTimedOutTransactions());
        pw.println("Number of application rolled back transactions: " + this.getNumberOfApplicationRollbacks());
        pw.println("Number of resource rolled back transactions: " + this.getNumberOfResourceRollbacks());
        pw.println("Average time (in nanosecs) to commit a transaction: " + this.getAverageCommitTime());
    }

    void incrementTransactions() {
        this.numberOfTransactions.incrementAndGet();
    }

    void incrementNestedTransactions() {
        this.numberOfNestedTransactions.incrementAndGet();
    }

    void incrementAbortedTransactions() {
        this.numberOfAbortedTransactions.incrementAndGet();
    }

    @Deprecated
    void incrementCommittedTransactions() {
        this.incrementCommittedTransactions(0L);
    }

    private long nextAverage(long duration, long prevCount, long prevAvg) {
        long nCount = prevCount + 1L;
        double d1 = duration / nCount;
        double d2 = prevAvg / nCount * prevCount;
        return Math.round(d1 + d2);
    }

    void incrementCommittedTransactions(long duration) {
        long nextAvg;
        long prevCount;
        TxCommitStatistic next;
        TxCommitStatistic prev;
        while (!this.commitStatistic.compareAndSet(prev = (TxCommitStatistic)this.commitStatistic.get(), next = new TxCommitStatistic((prevCount = prev.getNumberOfCommittedTransactions()) + 1L, nextAvg = this.nextAverage(duration, prevCount, prev.getAverageCommitTime())))) {
        }
    }

    void incrementHeuristics() {
        this.numberOfHeuristics.incrementAndGet();
    }

    void incrementTimeouts() {
        this.numberOfTimeouts.incrementAndGet();
    }

    void incrementApplicationRollbacks() {
        this.numberOfApplicationAborts.incrementAndGet();
    }

    void incrementSystemRollbacks() {
        this.numberOfSystemAborts.incrementAndGet();
    }

    void incrementResourceRollbacks() {
        this.numberOfResourceAborts.incrementAndGet();
    }
}

