/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.jms.internal.events.impl;

import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.jbatch.container.ws.WSTopLevelStepExecution;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.jms.internal.BatchJmsMessageHelper;
import com.ibm.ws.jbatch.rest.utils.BatchJSONHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.resource.ResourceConfig;
import com.ibm.wsspi.resource.ResourceConfigFactory;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import java.util.Map;
import java.util.Set;
import javax.batch.runtime.BatchStatus;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.jbatch.jms.events"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={BatchEventsPublisher.class}, property={"service.vendor=IBM"})
public class BatchEventsPublisherImpl
implements BatchEventsPublisher {
    private static final TraceComponent tc = Tr.register(BatchEventsPublisherImpl.class, (String)"wsbatch", (String)"com.ibm.ws.jbatch.jms.internal.resources.BatchJmsMessages");
    private static final JsonBuilderFactory builderFactory = Json.createBuilderFactory(null);
    private ResourceFactory jmsConnectionFactory;
    private ResourceConfigFactory resourceConfigFactory;
    private String topicRoot = "";
    protected boolean deactivated = false;
    private byte[] initHelperLock = new byte[0];
    private volatile InitHelper initHelper;
    static final long serialVersionUID = -4830004526756152988L;

    @Reference(service=ResourceConfigFactory.class)
    protected void setResourceConfigFactory(ResourceConfigFactory svc) {
        this.resourceConfigFactory = svc;
    }

    @Reference(target="(id=unbound)")
    protected void setJMSConnectionFactory(ResourceFactory factory, Map<String, String> serviceProps) {
        this.jmsConnectionFactory = factory;
    }

    protected void unsetJmsConnectionFactory(ResourceFactory svc) {
        if (svc == this.jmsConnectionFactory) {
            this.jmsConnectionFactory = null;
        }
    }

    protected void unsetResourceConfigFactory(ResourceConfigFactory svc) {
        if (svc == this.resourceConfigFactory) {
            this.resourceConfigFactory = null;
        }
    }

    public void setTopicRoot(String s) {
        this.topicRoot = s != null ? s : "batch";
        Tr.info((TraceComponent)tc, (String)"info.batch.events.publish.topic", (Object[])new Object[]{this.topicRoot + '/'});
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) throws Exception {
        this.setTopicRoot((String)config.get("topicRoot"));
    }

    protected void deactivate() {
        this.deactivated = true;
    }

    private ConnectionFactory getConnectionFactory() {
        return this.getInitHelper().jmsCf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    InitHelper getInitHelper() {
        InitHelper result = this.initHelper;
        if (result != null) return result;
        byte[] byArray = this.initHelperLock;
        synchronized (this.initHelperLock) {
            result = this.initHelper;
            if (result != null) return result;
            this.initHelper = result = new InitHelper();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    private void publishEventWithCorrelationId(JsonObject jsonObj, String event, String correlationId) {
        Connection topicConnection = null;
        Session topicSession = null;
        String topicName = null;
        if (tc.isEntryEnabled()) {
            JsonObject trJsonObj = this.removeJsonPair(jsonObj, "contents");
            Tr.entry((TraceComponent)tc, (String)"publishEventWithCorrelationId", (Object[])new Object[]{trJsonObj, event, correlationId});
        }
        if (this.deactivated) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No-op; component deactivated = " + this), (Object[])new Object[0]);
            }
        } else {
            event = this.resolveTopicRoot(event);
            try {
                topicConnection = this.getConnectionFactory().createConnection();
                topicSession = topicConnection.createSession(false, 1);
                TextMessage eventMsg = topicSession.createTextMessage();
                BatchJmsMessageHelper.setJobEventMessage(eventMsg, jsonObj);
                if (correlationId != null) {
                    eventMsg.setJMSCorrelationID(correlationId);
                }
                Topic topicToPublish = topicSession.createTopic(event);
                MessageProducer publisher = topicSession.createProducer((Destination)topicToPublish);
                publisher.send((Message)eventMsg);
                topicName = topicToPublish.getTopicName();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    StringBuffer msgBuf = new StringBuffer("topicName=" + topicName + " publisher destination=" + publisher.getDestination());
                    if (correlationId != null) {
                        msgBuf.append(" published correlationId for instance id " + jsonObj.getJsonNumber("instanceId").longValue() + " = " + correlationId);
                    }
                    Tr.debug((TraceComponent)tc, (String)msgBuf.toString(), (Object[])new Object[0]);
                }
                this.cleanUpJms(topicConnection, topicSession);
            }
            catch (JMSException eventMsg) {
                try {
                    void ex;
                    FFDCFilter.processException((Throwable)eventMsg, (String)"com.ibm.ws.jbatch.jms.internal.events.impl.BatchEventsPublisherImpl", (String)"243", (Object)this, (Object[])new Object[]{jsonObj, event, correlationId});
                    Exception linkedException = ex.getLinkedException() != null ? ex.getLinkedException() : ex;
                    Tr.warning((TraceComponent)tc, (String)"warning.batch.events.unable.to.publish", (Object[])new Object[]{topicName, jsonObj.toString(), linkedException});
                    this.cleanUpJms(topicConnection, topicSession);
                }
                catch (Throwable throwable) {
                    this.cleanUpJms(topicConnection, topicSession);
                    throw throwable;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"publishEventWithCorrelationId");
        }
    }

    private void cleanUpJms(Connection connection, Session session) {
        try {
            connection.close();
            session.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.jms.internal.events.impl.BatchEventsPublisherImpl", (String)"265", (Object)this, (Object[])new Object[]{connection, session});
        }
    }

    public void publishPartitionEvent(int partitionNumber, BatchStatus batchStatus, String exitStatus, String stepName, long topLevelInstanceId, long topLevelExecutionId, long topLevelStepExecutionId, String eventToPublish, String correlationId) {
        JsonObject jsonObj = BatchJSONHelper.convertPartitionToJsonObjectBuilderForEvent((int)partitionNumber, (BatchStatus)batchStatus, (String)exitStatus, (String)stepName, (long)topLevelInstanceId, (long)topLevelExecutionId, (long)topLevelStepExecutionId).build();
        this.publishEventWithCorrelationId(jsonObj, eventToPublish, correlationId);
    }

    public void publishCheckpointEvent(String stepName, long jobInstanceId, long jobExecutionId, long stepExecutionId, String correlationId) {
        JsonObject jsonObj = BatchJSONHelper.convertCheckpointToJsonObjectBuilderForEvent((String)stepName, (long)jobInstanceId, (long)jobExecutionId, (long)stepExecutionId).build();
        this.publishEventWithCorrelationId(jsonObj, "batch/jobs/execution/step/checkpoint", correlationId);
    }

    public void publishSplitFlowEvent(String splitName, String flowName, long instanceId, long executionId, String splitFlowTopicString, String correlationId) {
        JsonObject jsonObj = BatchJSONHelper.convertSplitFlowToJsonObjectBuilderForEvent((String)splitName, (String)flowName, (long)instanceId, (long)executionId).build();
        this.publishEventWithCorrelationId(jsonObj, splitFlowTopicString, correlationId);
    }

    public void publishJobInstanceEvent(WSJobInstance jobInstance, String event, String correlationId) {
        JsonObject jsonObj = BatchJSONHelper.toJsonObjectBuilder((WSJobInstance)jobInstance).build();
        this.publishEventWithCorrelationId(jsonObj, event, correlationId);
    }

    public void publishJobExecutionEvent(WSJobExecution jobExecution, String event, String correlationId) {
        JsonObject jsonObj = BatchJSONHelper.toJsonObjectBuilderInBasicFormat((WSJobExecution)jobExecution).build();
        this.publishEventWithCorrelationId(jsonObj, event, correlationId);
    }

    public void publishStepEvent(WSStepThreadExecutionAggregate objectToPublish, String event, String correlationId) {
        JsonObject jsonObj = BatchJSONHelper.convertStepExecutionToJsonObjectInBasicFormatNoLink((WSTopLevelStepExecution)objectToPublish.getTopLevelStepExecution(), null).build();
        this.publishEventWithCorrelationId(jsonObj, event, correlationId);
    }

    @ManualTrace
    public void publishJobLogEvent(long topLevelInstanceId, long topLevelExecutionId, String appName, String stepName, Integer partitionNumber, String splitName, String flowName, int partNum, boolean finalLog, String jobLogContent, String correlationId) {
        String jobLogEvent = "batch/jobs/execution/jobLogPart";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"publishJobLogEvent", (Object[])new Object[]{topLevelInstanceId, topLevelExecutionId, appName, stepName, partitionNumber, splitName, flowName, partNum, finalLog, correlationId});
        }
        JsonObject jsonObj = BatchJSONHelper.convertJobLogToJsonObjectBuilderForEvent((long)topLevelInstanceId, (long)topLevelExecutionId, (String)appName, (int)partNum, (Integer)partitionNumber, (String)stepName, (String)splitName, (String)flowName, (boolean)finalLog, (String)jobLogContent).build();
        this.publishEventWithCorrelationId(jsonObj, jobLogEvent, correlationId);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"publishJobLogEvent");
        }
    }

    @Trivial
    private JsonObject removeJsonPair(JsonObject jObj, String k) {
        JsonObjectBuilder builder = builderFactory.createObjectBuilder();
        Set jSet = jObj.entrySet();
        for (Map.Entry e : jSet) {
            if (((String)e.getKey()).compareTo(k) == 0) continue;
            builder = builder.add((String)e.getKey(), (JsonValue)e.getValue());
        }
        return builder.build();
    }

    public String resolveTopicRoot(String eventString) {
        if (this.topicRoot != null && !this.topicRoot.equals("batch")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"resolveTopicRoot", (Object[])new Object[]{"Non-default resolution with topicRoot = " + this.topicRoot});
            }
            return eventString.replaceFirst("batch" + (this.topicRoot.isEmpty() ? "/" : ""), this.topicRoot);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"resolveTopicRoot", (Object[])new Object[]{"Default resolution with topicRoot = " + this.topicRoot});
        }
        return eventString;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class InitHelper {
        private ConnectionFactory jmsCf = null;
        static final long serialVersionUID = -979480775765949952L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private InitHelper() {
            this.initJMSResources();
        }

        /*
         * WARNING - void declaration
         */
        private void initJMSResources() {
            try {
                ResourceConfig cfResourceConfig = BatchEventsPublisherImpl.this.resourceConfigFactory.createResourceConfig(ConnectionFactory.class.getName());
                cfResourceConfig.setResAuthType(0);
                this.jmsCf = (ConnectionFactory)BatchEventsPublisherImpl.this.jmsConnectionFactory.createResource((ResourceInfo)cfResourceConfig);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("        jmsCf = " + this.jmsCf.toString()), (Object[])new Object[0]);
                }
            }
            catch (Exception cfResourceConfig) {
                void e;
                FFDCFilter.processException((Throwable)cfResourceConfig, (String)"com.ibm.ws.jbatch.jms.internal.events.impl.BatchEventsPublisherImpl$InitHelper", (String)"186", (Object)this, (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"error.batch.events.publisher.jms.resource.activate", (Object[])new Object[]{e});
                throw new RuntimeException((Throwable)e);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.jms.internal.events.impl.BatchEventsPublisherImpl$InitHelper", InitHelper.class, (String)"wsbatch", null);
        }
    }
}

