/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectStreamField;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.rmi.impl.AnyFieldDescriptor;
import org.apache.yoko.rmi.impl.BooleanFieldDescriptor;
import org.apache.yoko.rmi.impl.ByteFieldDescriptor;
import org.apache.yoko.rmi.impl.CharFieldDescriptor;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.CorbaObjectFieldDescriptor;
import org.apache.yoko.rmi.impl.DoubleFieldDescriptor;
import org.apache.yoko.rmi.impl.FloatFieldDescriptor;
import org.apache.yoko.rmi.impl.IntFieldDescriptor;
import org.apache.yoko.rmi.impl.LongFieldDescriptor;
import org.apache.yoko.rmi.impl.ModelElement;
import org.apache.yoko.rmi.impl.ObjectFieldDescriptor;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.RemoteFieldDescriptor;
import org.apache.yoko.rmi.impl.ShortFieldDescriptor;
import org.apache.yoko.rmi.impl.StringFieldDescriptor;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueFieldDescriptor;
import org.omg.CORBA.Object;
import org.omg.CORBA.ValueMember;

abstract class FieldDescriptor
extends ModelElement
implements Comparable {
    static Logger logger = Logger.getLogger(FieldDescriptor.class.getName());
    org.apache.yoko.rmi.util.corba.Field field;
    Class type;
    Class declaringClass;
    boolean isFinal;
    ValueMember valuemember;
    boolean isPublic;

    protected FieldDescriptor(Class owner, Class type, String name, Field f, TypeRepository repo) {
        super(repo, name);
        this.type = type;
        this.init();
        this.declaringClass = owner;
        if (f != null) {
            this.isPublic = Modifier.isPublic(f.getModifiers());
            this.field = new org.apache.yoko.rmi.util.corba.Field(f);
            this.isFinal = Modifier.isFinal(f.getModifiers());
        } else {
            this.isPublic = false;
            this.field = null;
            this.isFinal = false;
        }
    }

    @Override
    protected final String genIDLName() {
        return this.java_name;
    }

    ValueMember getValueMember(TypeRepository rep) {
        if (this.valuemember == null) {
            TypeDescriptor desc = rep.getDescriptor(this.type);
            TypeDescriptor owner = rep.getDescriptor(this.declaringClass);
            this.valuemember = new ValueMember(this.getIDLName(), desc.getRepositoryID(), owner.getRepositoryID(), "1.0", desc.getTypeCode(), null, (short)(this.isPublic ? 1 : 0));
        }
        return this.valuemember;
    }

    public Class getType() {
        return this.type;
    }

    public int compareTo(java.lang.Object other) {
        FieldDescriptor desc = (FieldDescriptor)other;
        if (this.isPrimitive() && !desc.isPrimitive()) {
            return -1;
        }
        if (!this.isPrimitive() && desc.isPrimitive()) {
            return 1;
        }
        return this.java_name.compareTo(desc.java_name);
    }

    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    abstract void read(ObjectReader var1, java.lang.Object var2) throws IOException;

    abstract void write(ObjectWriter var1, java.lang.Object var2) throws IOException;

    abstract void readFieldIntoMap(ObjectReader var1, Map var2) throws IOException;

    abstract void writeFieldFromMap(ObjectWriter var1, Map var2) throws IOException;

    abstract void copyState(java.lang.Object var1, java.lang.Object var2, CopyState var3);

    static FieldDescriptor get(Field f, TypeRepository repository) {
        return FieldDescriptor.get(f.getDeclaringClass(), f.getType(), f.getName(), f, repository);
    }

    static FieldDescriptor getForSerialPersistentField(Class declaringClass, ObjectStreamField field, TypeRepository repository) {
        Field f = null;
        try {
            f = declaringClass.getDeclaredField(field.getName());
        }
        catch (NoSuchFieldException e) {
            logger.log(Level.FINER, "Cannot find java field \"" + field.getName() + "\" in class \"" + declaringClass.getName() + "\" - perhaps it is handled in readObject()/writeObject()");
        }
        return FieldDescriptor.get(declaringClass, field.getType(), field.getName(), f, repository);
    }

    static FieldDescriptor get(Class owner, Class type, String name, Field f, TypeRepository repository) {
        FieldDescriptor desc = FieldDescriptor.get0(owner, type, name, f, repository);
        desc.init();
        return desc;
    }

    private static FieldDescriptor get0(Class owner, Class type, String name, Field f, TypeRepository repository) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return new BooleanFieldDescriptor(owner, type, name, f, repository);
            }
            if (type == Byte.TYPE) {
                return new ByteFieldDescriptor(owner, type, name, f, repository);
            }
            if (type == Short.TYPE) {
                return new ShortFieldDescriptor(owner, type, name, f, repository);
            }
            if (type == Character.TYPE) {
                return new CharFieldDescriptor(owner, type, name, f, repository);
            }
            if (type == Integer.TYPE) {
                return new IntFieldDescriptor(owner, type, name, f, repository);
            }
            if (type == Long.TYPE) {
                return new LongFieldDescriptor(owner, type, name, f, repository);
            }
            if (type == Float.TYPE) {
                return new FloatFieldDescriptor(owner, type, name, f, repository);
            }
            if (type == Double.TYPE) {
                return new DoubleFieldDescriptor(owner, type, name, f, repository);
            }
            throw new RuntimeException("unknown field type " + type);
        }
        if (Object.class.isAssignableFrom(type)) {
            return new CorbaObjectFieldDescriptor(owner, type, name, f, repository);
        }
        if (java.lang.Object.class.equals((java.lang.Object)type) || Externalizable.class.equals((java.lang.Object)type) || Serializable.class.equals((java.lang.Object)type)) {
            return new AnyFieldDescriptor(owner, type, name, f, repository);
        }
        if (Remote.class.isAssignableFrom(type) || Remote.class.equals((java.lang.Object)type)) {
            return new RemoteFieldDescriptor(owner, type, name, f, repository);
        }
        if (String.class.equals((java.lang.Object)type)) {
            return new StringFieldDescriptor(owner, type, name, f, repository);
        }
        if (Serializable.class.isAssignableFrom(type)) {
            return new ValueFieldDescriptor(owner, type, name, f, repository);
        }
        if (type.isInterface() && type.getMethods().length == 0) {
            return new ObjectFieldDescriptor(owner, type, name, f, repository);
        }
        return new ValueFieldDescriptor(owner, type, name, f, repository);
    }

    void print(PrintWriter pw, Map recurse, java.lang.Object val) {
        pw.print(this.java_name);
        pw.print("=");
        try {
            java.lang.Object obj = this.field.get(val);
            if (obj == null) {
                pw.print("null");
            } else {
                TypeDescriptor desc = this.repo.getDescriptor(obj.getClass());
                desc.print(pw, recurse, obj);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

