/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.LiteralExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;

public class ExtractOperator
extends ExpressionOperator {
    private static List<String> defaultDbStrings() {
        ArrayList<String> dbStrings = new ArrayList<String>(5);
        dbStrings.add("EXTRACT(");
        dbStrings.add(" FROM ");
        dbStrings.add(")");
        return dbStrings;
    }

    public ExtractOperator() {
        this(ExtractOperator.defaultDbStrings());
    }

    protected ExtractOperator(List<String> dbStrings) {
        this.setType(5);
        this.setSelector(138);
        this.setName("EXTRACT");
        this.printsAs(dbStrings);
        this.setArgumentIndices(new int[]{1, 0});
        this.bePrefix();
        this.setNodeClass(ClassConstants.FunctionExpression_Class);
    }

    private void printPartSql(Expression first, Expression second, ExpressionSQLPrinter printer) {
        if (printer.getPlatform().isDynamicSQLRequiredForFunctions() && Boolean.FALSE.equals(this.isBindingSupported())) {
            printer.getCall().setUsesBinding(false);
        }
        int[] indices = this.getArgumentIndices(2);
        String[] dbString = this.getDatabaseStrings();
        int dbStringPos = 0;
        if (this.isPrefix() && dbString.length > dbStringPos) {
            printer.printString(dbString[dbStringPos++]);
        }
        if (indices[0] == 0) {
            first.printSQL(printer);
        }
        if (indices[0] == 1) {
            second.printSQL(printer);
        }
        if (dbString.length > dbStringPos) {
            printer.printString(dbString[dbStringPos++]);
        }
        if (indices[1] == 0) {
            first.printSQL(printer);
        }
        if (indices[1] == 1) {
            second.printSQL(printer);
        }
        if (dbString.length > dbStringPos) {
            printer.printString(dbString[dbStringPos]);
        }
    }

    protected void printYearSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
        this.printPartSql(first, second, printer);
    }

    protected void printQuarterSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
        this.printPartSql(first, second, printer);
    }

    protected void printMonthSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
        this.printPartSql(first, second, printer);
    }

    protected void printWeekSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
        this.printPartSql(first, second, printer);
    }

    protected void printDaySQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
        this.printPartSql(first, second, printer);
    }

    protected void printHourSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
        this.printPartSql(first, second, printer);
    }

    protected void printMinuteSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
        this.printPartSql(first, second, printer);
    }

    protected void printSecondSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
        this.printPartSql(first, second, printer);
    }

    protected void printDateSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
        this.printPartSql(first, second, printer);
    }

    protected void printTimeSQL(Expression first, Expression second, ExpressionSQLPrinter printer) {
        this.printPartSql(first, second, printer);
    }

    @Override
    public void printDuo(Expression first, Expression second, ExpressionSQLPrinter printer) {
        if (second.isLiteralExpression()) {
            switch (((LiteralExpression)second).getValue().toUpperCase()) {
                case "YEAR": {
                    this.printYearSQL(first, second, printer);
                    return;
                }
                case "QUARTER": {
                    this.printQuarterSQL(first, second, printer);
                    return;
                }
                case "MONTH": {
                    this.printMonthSQL(first, second, printer);
                    return;
                }
                case "WEEK": {
                    this.printWeekSQL(first, second, printer);
                    return;
                }
                case "DAY": {
                    this.printDaySQL(first, second, printer);
                    return;
                }
                case "HOUR": {
                    this.printHourSQL(first, second, printer);
                    return;
                }
                case "MINUTE": {
                    this.printMinuteSQL(first, second, printer);
                    return;
                }
                case "SECOND": {
                    this.printSecondSQL(first, second, printer);
                    return;
                }
                case "DATE": {
                    this.printDateSQL(first, second, printer);
                    return;
                }
                case "TIME": {
                    this.printTimeSQL(first, second, printer);
                    return;
                }
            }
            throw new IllegalArgumentException("Unknown EXTRACT function datetime_field: " + ((LiteralExpression)second).getValue().toUpperCase());
        }
        super.printDuo(first, second, printer);
    }

    @Override
    public void printCollection(List<Expression> items, ExpressionSQLPrinter printer) {
        Expression second;
        if (items.size() == 2 && (second = items.get(1)).isLiteralExpression()) {
            switch (((LiteralExpression)second).getValue().toUpperCase()) {
                case "YEAR": {
                    this.printYearSQL(items.get(0), second, printer);
                    return;
                }
                case "QUARTER": {
                    this.printQuarterSQL(items.get(0), second, printer);
                    return;
                }
                case "MONTH": {
                    this.printMonthSQL(items.get(0), second, printer);
                    return;
                }
                case "WEEK": {
                    this.printWeekSQL(items.get(0), second, printer);
                    return;
                }
                case "DAY": {
                    this.printDaySQL(items.get(0), second, printer);
                    return;
                }
                case "HOUR": {
                    this.printHourSQL(items.get(0), second, printer);
                    return;
                }
                case "MINUTE": {
                    this.printMinuteSQL(items.get(0), second, printer);
                    return;
                }
                case "SECOND": {
                    this.printSecondSQL(items.get(0), second, printer);
                    return;
                }
                case "DATE": {
                    this.printDateSQL(items.get(0), second, printer);
                    return;
                }
                case "TIME": {
                    this.printTimeSQL(items.get(0), second, printer);
                    return;
                }
            }
            throw new IllegalArgumentException("Unknown EXTRACT function datetime_field: " + ((LiteralExpression)second).getValue().toUpperCase());
        }
        super.printCollection(items, printer);
    }

    private void printPartJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
        int[] indices = this.getArgumentIndices(2);
        String[] dbString = this.getDatabaseStrings();
        if (this.isPrefix()) {
            printer.printString(dbString[0]);
        }
        if (indices[0] == 0) {
            first.printJava(printer);
        }
        if (indices[0] == 1) {
            second.printJava(printer);
        }
        if (dbString.length > 1) {
            printer.printString(dbString[1]);
        }
        if (indices[1] == 0) {
            first.printJava(printer);
        }
        if (indices[1] == 1) {
            second.printJava(printer);
        }
        if (dbString.length > 2) {
            printer.printString(dbString[2]);
        }
    }

    protected void printYearJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
        this.printPartJava(first, second, printer);
    }

    protected void printQuarterJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
        this.printPartJava(first, second, printer);
    }

    protected void printMonthJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
        this.printPartJava(first, second, printer);
    }

    protected void printWeekJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
        this.printPartJava(first, second, printer);
    }

    protected void printDayJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
        this.printPartJava(first, second, printer);
    }

    protected void printHourJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
        this.printPartJava(first, second, printer);
    }

    protected void printMinuteJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
        this.printPartJava(first, second, printer);
    }

    protected void printSecondJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
        this.printPartJava(first, second, printer);
    }

    protected void printDateJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
        this.printPartJava(first, second, printer);
    }

    protected void printTimeJava(Expression first, Expression second, ExpressionJavaPrinter printer) {
        this.printPartJava(first, second, printer);
    }

    @Override
    public void printJavaDuo(Expression first, Expression second, ExpressionJavaPrinter printer) {
        if (second.isLiteralExpression()) {
            switch (((LiteralExpression)second).getValue().toUpperCase()) {
                case "YEAR": {
                    this.printYearJava(first, second, printer);
                    return;
                }
                case "QUARTER": {
                    this.printQuarterJava(first, second, printer);
                    return;
                }
                case "MONTH": {
                    this.printMonthJava(first, second, printer);
                    return;
                }
                case "WEEK": {
                    this.printWeekJava(first, second, printer);
                    return;
                }
                case "DAY": {
                    this.printDayJava(first, second, printer);
                    return;
                }
                case "HOUR": {
                    this.printHourJava(first, second, printer);
                    return;
                }
                case "MINUTE": {
                    this.printMinuteJava(first, second, printer);
                    return;
                }
                case "SECOND": {
                    this.printSecondJava(first, second, printer);
                    return;
                }
                case "DATE": {
                    this.printDateJava(first, second, printer);
                    return;
                }
                case "TIME": {
                    this.printTimeJava(first, second, printer);
                    return;
                }
            }
            throw new IllegalArgumentException("Unknown EXTRACT function datetime_field: " + ((LiteralExpression)second).getValue().toUpperCase());
        }
        super.printJavaDuo(first, second, printer);
    }

    @Override
    public void printJavaCollection(List<Expression> items, ExpressionJavaPrinter printer) {
        Expression second;
        if (items.size() == 2 && (second = items.get(1)).isLiteralExpression()) {
            switch (((LiteralExpression)second).getValue().toUpperCase()) {
                case "YEAR": {
                    this.printYearJava(items.get(0), second, printer);
                    return;
                }
                case "QUARTER": {
                    this.printQuarterJava(items.get(0), second, printer);
                    return;
                }
                case "MONTH": {
                    this.printMonthJava(items.get(0), second, printer);
                    return;
                }
                case "WEEK": {
                    this.printWeekJava(items.get(0), second, printer);
                    return;
                }
                case "DAY": {
                    this.printDayJava(items.get(0), second, printer);
                    return;
                }
                case "HOUR": {
                    this.printHourJava(items.get(0), second, printer);
                    return;
                }
                case "MINUTE": {
                    this.printMinuteJava(items.get(0), second, printer);
                    return;
                }
                case "SECOND": {
                    this.printSecondJava(items.get(0), second, printer);
                    return;
                }
                case "DATE": {
                    this.printDateJava(items.get(0), second, printer);
                    return;
                }
                case "TIME": {
                    this.printTimeJava(items.get(0), second, printer);
                    return;
                }
            }
            throw new IllegalArgumentException("Unknown EXTRACT function datetime_field: " + ((LiteralExpression)second).getValue().toUpperCase());
        }
        super.printJavaCollection(items, printer);
    }
}

