/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openid20.consumer;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openid20.OpenidClientConfig;
import com.ibm.ws.security.openid20.internal.UserInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Utils {
    static final TraceComponent tc = Tr.register(Utils.class, (String)"OpenId", (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages");
    private OpenidClientConfig openidClientConfig;
    private int maxDiscoverRetry;
    static final long serialVersionUID = -3045025654373050675L;

    Utils(OpenidClientConfig openidClientConfig) {
        this.openidClientConfig = openidClientConfig;
        this.maxDiscoverRetry = openidClientConfig.getMaxDiscoverRetry();
    }

    public void verificationFailed(VerificationResult verificationResult, DiscoveryInformation discoveryInfo) throws IOException {
        String statusMsg = verificationResult.getStatusMsg();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"verification result status message from ConsumerManager: ", (Object[])new Object[]{statusMsg});
        }
        String identifier = null;
        Identifier claimIdentifier = discoveryInfo.getClaimedIdentifier();
        if (claimIdentifier != null) {
            identifier = claimIdentifier.getIdentifier();
        }
        if (identifier != null) {
            Tr.error((TraceComponent)tc, (String)"OPENID_RP_NO_RESULT_ERR", (Object[])new Object[]{identifier});
            if (statusMsg == null) {
                statusMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages", (String)"OPENID_RP_NO_RESULT_ERR", (Object[])new Object[]{identifier}, (String)"CWWKS1506E: OpenID can not get a valid result for claim identifier {0}.");
            }
        } else {
            String opEndPoint = discoveryInfo.getOPEndpoint().toString();
            Tr.error((TraceComponent)tc, (String)"OPENID_RP_CAN_NOT_ACCESS_OP", (Object[])new Object[]{opEndPoint});
            if (statusMsg == null) {
                statusMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages", (String)"OPENID_RP_CAN_NOT_ACCESS_OP", (Object[])new Object[]{opEndPoint}, (String)"CWWKS1511E: Cannot access the OpenID provider {0}");
            }
        }
        throw new IOException(statusMsg);
    }

    public String getOpEndPoint(DiscoveryInformation discovered, AuthSuccess authSuccess, Map<String, Object> attributes) {
        String opEndPoint = authSuccess.getOpEndpoint();
        if (opEndPoint == null) {
            opEndPoint = discovered.getOPEndpoint().toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Get OpEndPoint from discovered object =" + opEndPoint), (Object[])new Object[0]);
            }
        }
        attributes.put("OpEndPoint", opEndPoint);
        return opEndPoint;
    }

    public String getReceivingUrl(HttpServletRequest req) {
        StringBuffer receivingURL = req.getRequestURL();
        String queryString = req.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            receivingURL.append("?").append(req.getQueryString());
        }
        return receivingURL.toString();
    }

    public String resolveMapUserName(AuthSuccess authSuccess, Map<String, Object> attributes) {
        if (this.openidClientConfig.isUseClientIdentity()) {
            return this.getIdentityOrClaimedId(authSuccess);
        }
        String alias = this.getUserMappingFromUserInfo(attributes);
        if (alias == null) {
            alias = this.getIdentityOrClaimedId(authSuccess);
        }
        return alias;
    }

    protected String getUserMappingFromUserInfo(Map<String, Object> attributes) {
        ArrayList value;
        UserInfo userInfo;
        String key;
        List<UserInfo> userInfoList = this.openidClientConfig.getUserInfo();
        if (userInfoList == null || userInfoList.isEmpty()) {
            return null;
        }
        String alias = null;
        int max = this.openidClientConfig.getSearchNumberOfUserInfoToMap();
        for (int i = 0; i < max && ((key = (userInfo = userInfoList.get(i)).getAlias()) == null || (value = (ArrayList)attributes.get(key)) == null || (alias = (String)value.get(0)) == null); ++i) {
        }
        return alias;
    }

    protected String getIdentityOrClaimedId(AuthSuccess authSuccess) {
        String alias = authSuccess.getIdentity();
        if (alias == null) {
            alias = authSuccess.getClaimed();
        }
        return alias;
    }

    public DiscoveryInformation discoverOpenID(ConsumerManager consumerManager, String identifier) throws IOException {
        String protocol;
        List<?> discoveries = null;
        discoveries = this.tryToDiscoverOpenID(consumerManager, identifier, discoveries);
        DiscoveryInformation discovered = consumerManager.associate(discoveries);
        if (this.openidClientConfig.ishttpsRequired() && !"https".equals(protocol = discovered.getOPEndpoint().getProtocol())) {
            Tr.error((TraceComponent)tc, (String)"OPENID_OP_URL_PROTOCOL_NOT_HTTPS", (Object[])new Object[]{protocol});
            throw new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages", (String)"OPENID_OP_URL_PROTOCOL_NOT_HTTPS", (Object[])new Object[]{protocol}, (String)"CWWKS1510E: The relying party requires SSL but the openID provider URL protocol is {0}."));
        }
        String version = discovered.getVersion();
        if (!discovered.isVersion2() && tc.isDebugEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"OPENID_VERSION_NOT_TEST", (Object[])new Object[]{version});
        }
        return discovered;
    }

    /*
     * WARNING - void declaration
     */
    protected List<?> tryToDiscoverOpenID(ConsumerManager consumerManager, String identifier, List<?> discoveries) throws IOException {
        int retries = 0;
        while (retries < this.maxDiscoverRetry) {
            try {
                ++retries;
                discoveries = consumerManager.discover(identifier);
                break;
            }
            catch (DiscoveryException discoveryException) {
                void e;
                FFDCFilter.processException((Throwable)discoveryException, (String)"com.ibm.ws.security.openid20.consumer.Utils", (String)"253", (Object)this, (Object[])new Object[]{consumerManager, identifier, discoveries});
                if (retries != this.maxDiscoverRetry) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Hit maxDiscoverRetry (" + retries + ") allowed to discover..."), (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"OPENID_RP_CAN_NOT_ACCESS_OP", (Object[])new Object[]{identifier});
                throw new IOException(e.getLocalizedMessage());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number call of discover(): " + retries), (Object[])new Object[0]);
        }
        return discoveries;
    }

    public String createReturnToUrl(HttpServletRequest req, String uniqueKey) throws IOException {
        String result = null;
        StringBuffer builder = req.getRequestURL();
        builder.append("?");
        builder.append("rp_identifier").append("=").append(uniqueKey);
        result = builder.toString();
        return result;
    }

    public String getRpRealm(HttpServletRequest req) {
        StringBuilder builder = new StringBuilder(128);
        builder.append(req.getScheme());
        builder.append("://");
        builder.append(req.getServerName());
        int port = req.getServerPort();
        if (port != 80 && port != 443) {
            builder.append(":");
            builder.append(req.getServerPort());
        }
        builder.append(req.getContextPath());
        return builder.toString();
    }

    public void addUserInfoAttributes(AuthRequest authReq) throws Exception {
        FetchRequest fetch = FetchRequest.createFetchRequest();
        ArrayList attributes = (ArrayList)this.openidClientConfig.getUserInfo();
        if (attributes != null && !attributes.isEmpty()) {
            for (UserInfo att : attributes) {
                fetch.addAttribute(att.getAlias(), att.getType(), att.getRequired(), att.getCount());
            }
            authReq.addExtension((MessageExtension)fetch);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Map<String, Object> receiveUserInfoAttributes(AuthSuccess authSuccess) throws IOException {
        Map<String, Object> result = new HashMap<String, Object>();
        if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
            MessageExtension ext = null;
            try {
                ext = authSuccess.getExtension("http://openid.net/srv/ax/1.0");
            }
            catch (MessageException messageException) {
                void e;
                FFDCFilter.processException((Throwable)messageException, (String)"com.ibm.ws.security.openid20.consumer.Utils", (String)"345", (Object)this, (Object[])new Object[]{authSuccess});
                throw new IOException(e.getLocalizedMessage());
            }
            if (ext instanceof FetchResponse) {
                FetchResponse axResponse = (FetchResponse)ext;
                result = axResponse.getAttributes();
            }
        }
        return result;
    }

    public String getRealmName(OpenidClientConfig openidClientConfig, Map<String, Object> attributes) {
        ArrayList values;
        String realm = null;
        String realmIdentifier = openidClientConfig.getRealmIdentifier();
        if (realmIdentifier != null && !realmIdentifier.isEmpty() && (values = (ArrayList)attributes.get(realmIdentifier)) != null && !values.isEmpty()) {
            realm = (String)values.get(0);
        }
        return realm;
    }

    public ArrayList<String> getGroups(OpenidClientConfig openidClientConfig, Map<String, Object> attributes, String realm) {
        ArrayList<String> groups = new ArrayList<String>();
        String groupIdentifier = openidClientConfig.getGroupIdentifier();
        if (groupIdentifier != null) {
            ArrayList values = (ArrayList)attributes.get(groupIdentifier);
            if (realm == null || realm.isEmpty()) {
                return values;
            }
            if (values != null && !values.isEmpty()) {
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    String group = new StringBuffer("group:").append(realm).append("/").append(it.next()).toString();
                    groups.add(group);
                }
            }
        }
        return groups;
    }
}

