/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser;

import com.ibm.ws.sip.parser.Separators;
import com.ibm.ws.sip.parser.SipParser;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.URI;

public class URIParser
extends SipParser
implements Separators {
    public URIParser(boolean unescape) {
        super(unescape);
    }

    public URIParser() {
        this(true);
    }

    public URI parse(String uriToParse) throws SipParseException {
        return this.parse(uriToParse.toCharArray(), 0, uriToParse.length());
    }

    public URI parse(char[] buffer, int offset, int length) throws SipParseException {
        this.setSrc(buffer, offset, length);
        URI toRet = this.parseURI();
        this.rewind();
        return toRet;
    }

    public URI parse(String scheme, String schemeData) throws SipParseException {
        char[] buffer = schemeData.toCharArray();
        int length = schemeData.length();
        this.setSrc(buffer, length);
        boolean uriWithBrackets = buffer[length - 1] == '>';
        URI toRet = this.parseURI(scheme, uriWithBrackets);
        int position = this.mark();
        if (!uriWithBrackets && position < length || uriWithBrackets && position < length - 1) {
            throw new SipParseException("Expected end-of-string in [" + schemeData + "] at position [" + position + ']', schemeData);
        }
        this.rewind();
        return toRet;
    }

    public NameAddress parseNameAddress(String uriToParse) throws SipParseException {
        this.setSrc(uriToParse.toCharArray(), uriToParse.length());
        NameAddress nameAddr = super.parseNameAddress();
        this.rewind();
        return nameAddr;
    }
}

