/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class ThreadContextInputStream
extends ObjectInputStream {
    public ThreadContextInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        ClassLoader threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader bundleClassLoader = this.getClass().getClassLoader();
        Class<?> loadedClass = null;
        try {
            loadedClass = Class.forName(desc.getName(), false, threadContextClassLoader);
        }
        catch (ClassNotFoundException e2) {
            loadedClass = Class.forName(desc.getName(), false, bundleClassLoader);
        }
        return loadedClass;
    }
}

