/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.timer;

import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.timer.AppSessionTimerListener;
import com.ibm.ws.sip.container.timer.BaseTimer;
import com.ibm.ws.sip.container.timer.ExpirationTimerListener;
import com.ibm.ws.sip.container.timer.TransactionUserTimerListener;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import javax.servlet.sip.SipApplicationSession;

public class ExpirationTimer
extends BaseTimer {
    private static final long serialVersionUID = -3321722369180702164L;
    private ExpirationTimerListener m_expInvoker;
    private Object m_synchronizer;

    public ExpirationTimer(ExpirationTimerListener expInvoker, Object synchronizer) {
        this.m_expInvoker = expInvoker;
        this.m_synchronizer = synchronizer;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(96);
        buffer.append("Appication Session Timer:");
        buffer.append(this.m_expInvoker);
        buffer.append(" ,Delay:");
        buffer.append(this.getDelay());
        buffer.append(" ,Period:");
        buffer.append(this.getPeriod());
        buffer.append(" ,Fixed Delay:");
        buffer.append(this.isFixedDelay());
        buffer.append(" ,Cancelled:");
        buffer.append(this.isCancelled());
        return buffer.toString();
    }

    @Override
    public int compareTo(Object o) {
        int rc = super.compareTo(o);
        if (rc == 0 && o instanceof ExpirationTimerListener) {
            ExpirationTimerListener otherExpirationInvoker = (ExpirationTimerListener)o;
            rc = otherExpirationInvoker.getId().compareTo(this.m_expInvoker.getId());
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.getSynchronizer();
        synchronized (object) {
            super.cancel();
            this.m_expInvoker = null;
        }
    }

    @Override
    public void run() {
        if (this.m_expInvoker != null) {
            this.m_expInvoker.invokeExpiredTimer();
        }
    }

    public ExpirationTimerListener getExpInvoker() {
        return this.m_expInvoker;
    }

    public void setExpInvoker(ExpirationTimerListener invoker) {
        this.m_expInvoker = invoker;
    }

    @Override
    protected int extractQueueIndex() {
        if (this.m_expInvoker != null) {
            String sessId = this.m_expInvoker.getApplicationId();
            int result = SipApplicationSessionImpl.extractAppSessionCounter(sessId);
            return result;
        }
        return 0;
    }

    @Override
    public int priority() {
        return 100;
    }

    @Override
    public Object getServiceSynchronizer() {
        return this.m_expInvoker.getServiceSynchronizer();
    }

    @Override
    public String getAppName() {
        if (this.m_expInvoker != null) {
            return this.m_expInvoker.getApplicationName();
        }
        return null;
    }

    @Override
    public Integer getAppIndexForPMI() {
        if (this.m_expInvoker != null) {
            return this.m_expInvoker.getApplicationIdForPMI();
        }
        return null;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        if (this.m_expInvoker instanceof AppSessionTimerListener) {
            return ((AppSessionTimerListener)this.m_expInvoker).getApplicationSession();
        }
        if (this.m_expInvoker instanceof TransactionUserTimerListener) {
            TransactionUserWrapper tu = ((TransactionUserTimerListener)this.m_expInvoker).getTuWrapper();
            return tu.getApplicationSession(false);
        }
        return null;
    }

    @Override
    public TransactionUserWrapper getTuWrapper() {
        if (this.m_expInvoker instanceof TransactionUserTimerListener) {
            return ((TransactionUserTimerListener)this.m_expInvoker).getTuWrapper();
        }
        return null;
    }

    private Object getSynchronizer() {
        return this.m_synchronizer;
    }
}

