/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.header.ExtendedHeader;
import com.ibm.ws.jain.protocol.ip.sip.header.GenericNameAddressHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.GenericParametersHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.NameAddressHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.servlets.AddressImpl;
import com.ibm.ws.sip.container.servlets.CommitedAddressImpl;
import com.ibm.ws.sip.container.servlets.ContactSystemAddressImpl;
import com.ibm.ws.sip.container.servlets.EmptyEnumeration;
import com.ibm.ws.sip.container.servlets.EmptyIterator;
import com.ibm.ws.sip.container.servlets.FromToAddressImpl;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.ParameterableImpl;
import com.ibm.ws.sip.container.servlets.ServletConfigWrapper;
import com.ibm.ws.sip.container.servlets.SystemAddressImpl;
import com.ibm.ws.sip.container.servlets.SystemFromToAddressImpl;
import com.ibm.ws.sip.container.servlets.WildcardNameAddress;
import com.ibm.ws.sip.container.servlets.ext.SipServletMessageExt;
import com.ibm.ws.sip.container.transaction.SipTransaction;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.virtualhost.VirtualHostAlias;
import com.ibm.ws.sip.parser.HeaderCreator;
import com.ibm.ws.sip.stack.properties.StackProperties;
import com.ibm.ws.sip.stack.util.SipStackUtil;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.AddressFactory;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.AcceptLanguageHeader;
import jain.protocol.ip.sip.header.CallIdHeader;
import jain.protocol.ip.sip.header.ContactHeader;
import jain.protocol.ip.sip.header.ContentLengthHeader;
import jain.protocol.ip.sip.header.ContentTypeHeader;
import jain.protocol.ip.sip.header.ExpiresHeader;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderFactory;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.header.ParametersHeader;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.MessageFactory;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;

public abstract class SipServletMessageImpl
implements SipServletMessageExt,
Serializable {
    private static final String SIP_MESSAGE_ARRIVAL_TIME = "sip.message.arrival.time";
    static final long serialVersionUID = 2937453914520727560L;
    protected static final String CONTENT_LANGUAGE = "Content-Language";
    private static final String TEXT_MIME_TYPE = "text";
    public static final String UNAUTHENTICATED = "com.ibm.sip.unauthenticated";
    private static final String DEFAULT_CHARSET_ENCODING = "UTF-8";
    private static final String INITIAL_REMOTE_TAG = "initial-remote";
    private static final String LOCAL_ADDRESS_TAG = "local-address";
    private static final LogMgr c_logger = Log.get(SipServletMessageImpl.class);
    private Message m_message;
    protected transient SipProvider m_sipProvider;
    private transient long m_transactionId;
    private transient SipTransaction m_transaction;
    private transient Address m_fromAddress;
    private transient Address m_toAddress;
    protected Address _origContact;
    protected transient String m_clientAddress;
    protected TransactionUserWrapper m_transactionUser;
    protected Hashtable m_attributes;
    private boolean m_isCommited;
    private boolean m_isFailovered;
    private transient HttpServletRequest m_httpServletRequest;
    private transient HttpServletResponse m_httpServletResponse;
    protected static boolean c_appCompositionEnabled = true;
    protected static final String TLS = "tls";
    protected static final String UDP = "udp";
    protected static final String SIPS = "sips";
    private static transient List<Locale> c_defaultLocales;
    private transient long m_arrivedTime;
    protected transient String m_initialRemoteAddr;
    protected transient int m_initialRemotePort;
    protected transient String m_remoteAddr;
    protected transient int m_remotePort;
    protected transient String m_localAddr;
    protected transient int m_localPort;
    protected transient String m_initialTransport;
    private transient boolean _updateMessageListLater;
    protected transient boolean m_isDefaultContactHeader;
    protected boolean _isInternallyGenerated;

    public SipServletMessageImpl() {
        this.m_isCommited = true;
        this.m_isFailovered = false;
        this.m_httpServletRequest = null;
        this.m_httpServletResponse = null;
        this.m_arrivedTime = -1L;
        this.m_initialRemoteAddr = null;
        this.m_initialRemotePort = -1;
        this.m_remoteAddr = null;
        this.m_remotePort = -1;
        this.m_localAddr = null;
        this.m_localPort = -1;
        this.m_initialTransport = null;
        this._updateMessageListLater = false;
        this.m_isDefaultContactHeader = false;
        this._isInternallyGenerated = false;
    }

    public SipServletMessageImpl(IncomingSipServletRequest request) {
        this.m_isCommited = true;
        this.m_isFailovered = false;
        this.m_httpServletRequest = null;
        this.m_httpServletResponse = null;
        this.m_arrivedTime = -1L;
        this.m_initialRemoteAddr = null;
        this.m_initialRemotePort = -1;
        this.m_remoteAddr = null;
        this.m_remotePort = -1;
        this.m_localAddr = null;
        this.m_localPort = -1;
        this.m_initialTransport = null;
        this._updateMessageListLater = false;
        this.m_isDefaultContactHeader = false;
        this._isInternallyGenerated = false;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "SipServletMessageImpl", "Dead copy of incoming request created !!! - this requeset is not for use");
        }
        this.m_message = request.getMessage();
        this.m_fromAddress = request.getFrom();
        this.m_toAddress = request.getTo();
        this._origContact = request._origContact;
        this.m_clientAddress = request.m_clientAddress;
        this.m_attributes = request.m_attributes;
        this.m_httpServletRequest = request.getHttpServletRequest();
        this.m_httpServletResponse = request.getHttpServletResponse();
        this.m_arrivedTime = request.getArrivedTime();
        this.m_remoteAddr = request.getRemoteAddr();
        this.m_remotePort = request.getRemotePort();
        this.m_localAddr = request.getLocalAddr();
        this.m_localPort = request.getLocalPort();
        this.m_initialRemoteAddr = request.getInitialRemoteAddr();
        this.m_initialRemotePort = request.getInitialRemotePort();
        this.m_initialTransport = request.getInitialTransport();
        this._updateMessageListLater = this.getUpdateMessageListLater();
        this.m_isDefaultContactHeader = this.getIsDefaultContactHeader();
    }

    public boolean getUpdateMessageListLater() {
        return this._updateMessageListLater;
    }

    public boolean getIsDefaultContactHeader() {
        return this.m_isDefaultContactHeader;
    }

    public SipServletMessageImpl(Message message, long transactionId, SipProvider provider) {
        block5: {
            this();
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{this.getClass().getName() + "@" + Integer.toHexString(this.hashCode())};
                c_logger.traceEntry((Object)SipServletMessageImpl.class.getName(), "SipServletMessageImpl", params);
            }
            try {
                Header header = message.getHeader("IBM-Client-Address", true);
                if (header != null) {
                    this.m_clientAddress = header.getValue();
                    message.removeHeader("IBM-Client-Address", true);
                }
            }
            catch (Exception e2) {
                if (!c_logger.isTraceDebugEnabled()) break block5;
                c_logger.traceDebug((Object)"SipServletMessageImpl", "SipServletMessageImpl", "there is no valid IBM_CLIENT_ADDRESS header");
            }
        }
        this.m_message = message;
        this.m_transactionId = transactionId;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "SipServletMessageImpl", "provider=" + provider);
        }
        this.m_sipProvider = provider;
    }

    @Override
    public Locale getAcceptLanguage() {
        Locale rValue;
        block7: {
            rValue = null;
            HeaderIterator iterator = this.m_message.getAcceptLanguageHeaders();
            if (iterator != null && iterator.hasNext()) {
                try {
                    AcceptLanguageHeader header = (AcceptLanguageHeader)iterator.next();
                    String acceptLanguage = header.getLanguageRange();
                    float qValue = header.getQValue();
                    while (iterator.hasNext()) {
                        header = (AcceptLanguageHeader)iterator.next();
                        if (!(header.getQValue() > qValue)) continue;
                        acceptLanguage = header.getLanguageRange();
                        qValue = header.getQValue();
                    }
                    rValue = this.getLocale(acceptLanguage);
                }
                catch (HeaderParseException e2) {
                    if (c_logger.isErrorEnabled()) {
                        Object[] args = new Object[]{this};
                        c_logger.error("error.get.accept.language", "Request", args, (Throwable)e2);
                    }
                }
                catch (NoSuchElementException e3) {
                    if (!c_logger.isErrorEnabled()) break block7;
                    Object[] args = new Object[]{this};
                    c_logger.error("error.get.accept.language", "Request", args, (Throwable)e3);
                }
            }
        }
        if (!this.isJSR289Application() && rValue == null) {
            rValue = Locale.getDefault();
        }
        return rValue;
    }

    private String getLocale(Locale locale) {
        char ch;
        int i;
        String language = locale.getLanguage();
        String country = locale.getCountry();
        int languageLen = language.length();
        int countryLen = country.length();
        if (countryLen == 0) {
            return language.toLowerCase();
        }
        StringBuilder buf = new StringBuilder(languageLen + countryLen + 1);
        for (i = 0; i < languageLen; ++i) {
            ch = language.charAt(i);
            buf.append(Character.toLowerCase(ch));
        }
        buf.append('-');
        for (i = 0; i < countryLen; ++i) {
            ch = country.charAt(i);
            buf.append(Character.toLowerCase(ch));
        }
        return buf.toString();
    }

    private Locale getLocale(String localeString) {
        Locale locale = null;
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = null;
        tokenizer = localeString.indexOf("_") >= 0 ? new StringTokenizer(localeString, "_") : new StringTokenizer(localeString, "-");
        String lang = tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                variant = tokenizer.nextToken();
            }
        }
        locale = new Locale(lang, country, variant);
        return locale;
    }

    @Override
    public Iterator<Locale> getAcceptLanguages() {
        HeaderIterator iterator = this.m_message.getAcceptLanguageHeaders();
        if (null == iterator || !iterator.hasNext()) {
            if (this.isJSR289Application()) {
                return EmptyIterator.getInstance();
            }
            if (c_defaultLocales == null) {
                LinkedList<Locale> lst = new LinkedList<Locale>();
                lst.add(Locale.getDefault());
                c_defaultLocales = Collections.unmodifiableList(lst);
            }
            return c_defaultLocales.iterator();
        }
        boolean first = true;
        LinkedList<AcceptLanguageHeader> orderList = new LinkedList<AcceptLanguageHeader>();
        while (iterator.hasNext()) {
            try {
                int i;
                AcceptLanguageHeader h = (AcceptLanguageHeader)iterator.next();
                if (first) {
                    orderList.add(0, h);
                    first = false;
                    continue;
                }
                float q = 1.0f;
                if (h.hasQValue()) {
                    q = h.getQValue();
                }
                for (i = 1; i < orderList.size(); ++i) {
                    AcceptLanguageHeader tmpH = (AcceptLanguageHeader)orderList.get(i);
                    float tmpQ = 1.0f;
                    if (tmpH.hasQValue()) {
                        tmpQ = tmpH.getQValue();
                    }
                    if (q > tmpQ) break;
                }
                orderList.add(i, h);
            }
            catch (HeaderParseException e2) {
                if (!c_logger.isErrorEnabled()) continue;
                Object[] args = new Object[]{this};
                c_logger.error("error.get.accept.languages", "Request", args, (Throwable)e2);
            }
            catch (NoSuchElementException e3) {
                if (!c_logger.isErrorEnabled()) continue;
                Object[] args = new Object[]{this};
                c_logger.error("error.get.accept.languages", "Request", args, (Throwable)e3);
            }
        }
        LinkedList<Locale> lst = new LinkedList<Locale>();
        Locale locale = null;
        for (AcceptLanguageHeader h : orderList) {
            locale = this.getLocale(h.getValue());
            lst.add(locale);
        }
        return lst.iterator();
    }

    @Override
    public Address getAddressHeader(String name) throws ServletParseException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{name};
            c_logger.traceEntry((Object)SipServletMessageImpl.class.getName(), "getAddressHeader", params);
        }
        boolean outboundEnable = PropertiesStore.getInstance().getProperties().getBoolean("enableSetOutboundIF");
        Address address = null;
        try {
            Header header = this.m_message.getHeader(name, true);
            if (name.equalsIgnoreCase("Contact") && header == null && this.shouldCreateContactIfNotExist()) {
                header = outboundEnable ? this.createAndSetContactHeader(this.m_message, this.constructContactHeaderURI(), true) : this.createAndSetContactHeader(this.m_message, null, true);
            }
            if (header != null) {
                if (header instanceof ContactHeader) {
                    address = this.getContactHeaderAddress(header);
                    this._origContact = address instanceof WildcardNameAddress ? (Address)address.clone() : (Address)((AddressImpl)address).clone(true);
                } else if (header instanceof NameAddressHeader) {
                    address = this.getNameAddress(header, name);
                } else {
                    address = this.getGenericNameAddress(header, name);
                    NameAddressHeader newHeader = ((AddressImpl)address).getNameAddressHeader();
                    this.m_message.setHeader(newHeader, true);
                }
            }
        }
        catch (SipParseException e2) {
            if (c_logger.isErrorEnabled()) {
                Object[] args = new Object[]{name};
                c_logger.error("error.get.address.header", "Request", args, (Throwable)e2);
            }
            throw new ServletParseException(e2.getMessage());
        }
        if (address != null && this.isCommitted()) {
            address = new CommitedAddressImpl(((AddressImpl)address).getNameAddressHeader());
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)SipServletMessageImpl.class.getName(), "getAddressHeader", address);
        }
        return address;
    }

    protected abstract boolean shouldCreateContactIfNotExist();

    private Address getGenericNameAddress(Header header, String name) throws IllegalArgumentException, SipParseException {
        String strAddress = header.getValue();
        GenericNameAddressHeaderImpl naHeader = new GenericNameAddressHeaderImpl(name);
        naHeader.setValue(strAddress);
        naHeader.parse();
        return new AddressImpl(naHeader);
    }

    private Address getNameAddress(Header header, String name) {
        AddressImpl address = null;
        address = this.checkIsSystemHeader(name) ? (this.isJSR289Application() && ("To".equalsIgnoreCase(name) || "From".equalsIgnoreCase(name)) ? (!ServletConfigWrapper.getSupportedList().contains("from-change") ? new SystemFromToAddressImpl((NameAddressHeader)header) : new FromToAddressImpl((NameAddressHeader)header)) : new SystemAddressImpl((NameAddressHeader)header)) : new AddressImpl((NameAddressHeader)header);
        return address;
    }

    public boolean isJSR289Application() {
        if (this.m_transactionUser == null) {
            return false;
        }
        SipServletDesc desc = this.m_transactionUser.getSipServletDesc();
        return desc != null && desc.getSipApp().isJSR289Application();
    }

    private Address getContactHeaderAddress(Header header) {
        Address address = null;
        address = ((ContactHeader)header).isWildCard() ? new WildcardNameAddress() : (SipContainer.getInstance().canModifySysHeaders() ? new AddressImpl((NameAddressHeader)header) : (this.checkIsSystemContactHeader() ? new ContactSystemAddressImpl((NameAddressHeader)header) : new AddressImpl((NameAddressHeader)header)));
        return address;
    }

    @Override
    public Parameterable getParameterableHeader(String name) throws ServletParseException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{name};
            c_logger.traceEntry((Object)SipServletMessageImpl.class.getName(), "getParameterableHeader", params);
        }
        Parameterable param = null;
        if (name == null) {
            throw new NullPointerException("name argument is null");
        }
        if (this.checkIsSystemAddressHeader(name)) {
            param = this.getAddressHeader(name);
        } else {
            try {
                Header header = this.m_message.getHeader(name, true);
                if (header != null) {
                    param = this.createAndParseParameterableHeader(name, header);
                }
            }
            catch (SipParseException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{name};
                    c_logger.error("error.get.address.header", "Request", args, (Throwable)e2);
                }
                throw new ServletParseException(e2.getMessage());
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)SipServletMessageImpl.class.getName(), "getParameterableHeader", param);
        }
        return param;
    }

    private Parameterable createAndParseParameterableHeader(String name, Header header) throws SipParseException {
        return this.createAndParseParameterableHeader(name, header, null);
    }

    private Parameterable createAndParseParameterableHeader(String name, Header header, List<ParametersHeaderImpl> multipleHeadersToReplace) throws SipParseException {
        ParameterableImpl param = null;
        ParametersHeaderImpl newHeader = null;
        if (header instanceof ParametersHeaderImpl) {
            newHeader = (ParametersHeaderImpl)header;
            param = new ParameterableImpl(newHeader);
        } else {
            newHeader = new GenericNameAddressHeaderImpl(name);
            String strAddress = header.getValue();
            newHeader.setValue(strAddress);
            try {
                newHeader.parse();
                param = new AddressImpl((GenericNameAddressHeaderImpl)newHeader);
            }
            catch (SipParseException spe) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("createAndParseParameterableHeader: trying to parse " + name + " header as GenericNameAddressHeaderImpl failed, trying to parse as GenericParametersHeaderImpl now....");
                }
                newHeader = new GenericParametersHeaderImpl(name);
                strAddress = header.getValue();
                newHeader.setValue(strAddress);
                newHeader.parse();
                param = new ParameterableImpl(newHeader);
            }
            if (multipleHeadersToReplace == null) {
                this.m_message.setHeader(newHeader, true);
            }
        }
        if (multipleHeadersToReplace != null) {
            multipleHeadersToReplace.add(newHeader);
        }
        return param;
    }

    @Override
    public ListIterator<Address> getAddressHeaders(String name) throws ServletParseException {
        LinkedList<Address> rList = new LinkedList<Address>();
        HeaderIterator iter = this.m_message.getHeaders(name);
        boolean foundNonAddressHeader = false;
        Address address = null;
        boolean outboundEnable = PropertiesStore.getInstance().getProperties().getBoolean("enableSetOutboundIF");
        try {
            Header header;
            if (name.equalsIgnoreCase("Contact") && iter == null && this.shouldCreateContactIfNotExist() && (header = outboundEnable ? this.createAndSetContactHeader(this.m_message, this.constructContactHeaderURI(), true) : this.createAndSetContactHeader(this.m_message, null, true)) != null) {
                iter = this.m_message.getHeaders(name);
            }
            while (iter != null && iter.hasNext()) {
                header = iter.next();
                if (header == null) continue;
                if (header instanceof ContactHeader) {
                    address = this.getContactHeaderAddress(header);
                } else if (header instanceof NameAddressHeader) {
                    address = this.getNameAddress(header, name);
                } else {
                    address = this.getGenericNameAddress(header, name);
                    foundNonAddressHeader = true;
                }
                rList.add(address);
            }
        }
        catch (SipParseException e2) {
            if (c_logger.isErrorEnabled()) {
                Object[] args = new Object[]{name};
                c_logger.error("error.get.address.headers", "Request", args, (Throwable)e2);
            }
            throw new ServletParseException(e2.getMessage());
        }
        catch (NoSuchElementException e3) {
            if (c_logger.isErrorEnabled()) {
                Object[] args = new Object[]{name};
                c_logger.error("error.get.address.headers", "Request", args, (Throwable)e3);
            }
            throw new ServletParseException(e3.getMessage());
        }
        if (foundNonAddressHeader) {
            this.m_message.removeHeaders(name);
            ListIterator lIter = rList.listIterator();
            while (lIter != null && lIter.hasNext()) {
                AddressImpl a = (AddressImpl)lIter.next();
                this.m_message.addHeader(a.getNameAddressHeader(), false);
            }
        }
        ArrayList externalList = new ArrayList(rList);
        List unModify = Collections.unmodifiableList(externalList);
        return unModify.listIterator();
    }

    public ListIterator<Parameterable> getParameterableHeaders(String name) throws ServletParseException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{name};
            c_logger.traceEntry((Object)SipServletMessageImpl.class.getName(), "getParameterableHeaders", params);
        }
        ListIterator<Parameterable> listIter = null;
        if (this.checkIsSystemAddressHeader(name)) {
            listIter = this.getAddressHeaders(name);
        } else {
            ArrayList<Parameterable> externalList = new ArrayList<Parameterable>();
            LinkedList<ParametersHeaderImpl> rList = new LinkedList<ParametersHeaderImpl>();
            HeaderIterator iter = this.m_message.getHeaders(name);
            boolean hadToCreateAndParseNewHeader = false;
            while (iter != null && iter.hasNext()) {
                try {
                    Header header = iter.next();
                    Parameterable param = this.createAndParseParameterableHeader(name, header, rList);
                    hadToCreateAndParseNewHeader = hadToCreateAndParseNewHeader || rList.get(rList.size() - 1) != header;
                    externalList.add(param);
                }
                catch (SipParseException e2) {
                    if (c_logger.isErrorEnabled()) {
                        Object[] args = new Object[]{name};
                        c_logger.error("error.get.address.headers", "Request", args, (Throwable)e2);
                    }
                    throw new ServletParseException(e2.getMessage());
                }
                catch (NoSuchElementException e3) {
                    if (c_logger.isErrorEnabled()) {
                        Object[] args = new Object[]{name};
                        c_logger.error("error.get.address.headers", "Request", args, (Throwable)e3);
                    }
                    throw new ServletParseException(e3.getMessage());
                }
            }
            if (hadToCreateAndParseNewHeader) {
                this.m_message.removeHeaders(name);
                ListIterator lIter = rList.listIterator();
                while (lIter != null && lIter.hasNext()) {
                    this.m_message.addHeader((Header)lIter.next(), false);
                }
            }
            List unModify = Collections.unmodifiableList(externalList);
            listIter = unModify.listIterator();
        }
        return listIter;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        return this.getApplicationSession(true);
    }

    @Override
    public SipApplicationSession getApplicationSession(boolean create) {
        if (!this.isLiveMessage("getApplicationSession")) {
            return null;
        }
        if (this.m_transactionUser == null) {
            return null;
        }
        return this.m_transactionUser.getApplicationSession(create);
    }

    @Override
    public Object getAttribute(String name) {
        Object obj;
        block4: {
            obj = null;
            if (this.m_attributes != null) {
                obj = this.m_attributes.get(name);
            }
            if (obj == null && this.m_httpServletRequest != null) {
                try {
                    obj = this.m_httpServletRequest.getAttribute(name);
                }
                catch (NullPointerException e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block4;
                    c_logger.traceDebug(this, "getAttribute", "Internal HttpRequest is not valid, can not get attributes from it, httprequest: " + this.m_httpServletRequest);
                }
            }
        }
        return obj;
    }

    @Override
    public Enumeration getAttributeNames() {
        if (null != this.m_attributes) {
            return this.m_attributes.keys();
        }
        return EmptyEnumeration.getInstance();
    }

    public void isSessionIsValid() throws IllegalStateException {
        if (this.m_transactionUser != null) {
            this.m_transactionUser.ensureTUActive();
        }
    }

    @Override
    public synchronized void setAttribute(String name, Object o) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        if (this.m_attributes == null) {
            this.m_attributes = new Hashtable();
        }
        this.m_attributes.put(name, o);
    }

    @Override
    public String getCallId() {
        String rValue = null;
        CallIdHeader header = this.m_message.getCallIdHeader();
        if (null != header) {
            rValue = header.getCallId();
        }
        return rValue;
    }

    public CallIdHeader getCallIdHeader() {
        return this.m_message.getCallIdHeader();
    }

    private static void assertCharacterEncoding(String charset) throws UnsupportedEncodingException {
        boolean supported;
        try {
            supported = Charset.isSupported(charset);
        }
        catch (Exception e2) {
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException(charset);
            unsupportedEncodingException.initCause(e2);
            throw unsupportedEncodingException;
        }
        if (!supported) {
            throw new UnsupportedEncodingException(charset);
        }
    }

    @Override
    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        SipServletMessageImpl.assertCharacterEncoding(enc);
        try {
            ContentTypeHeader cType = (ContentTypeHeader)this.findHeader("Content-Type");
            if (null == cType) {
                this.setHeader("Content-Type", "text/plain;charset=" + enc);
            } else {
                cType.setParameter("charset", enc);
            }
        }
        catch (Exception e2) {
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException();
            unsupportedEncodingException.initCause(e2);
            throw unsupportedEncodingException;
        }
    }

    @Override
    public String getCharacterEncoding() {
        String rValue;
        block3: {
            rValue = null;
            try {
                ContentTypeHeader cType = (ContentTypeHeader)this.findHeader("Content-Type");
                if (null != cType) {
                    rValue = cType.getParameter("charset");
                }
            }
            catch (HeaderParseException e2) {
                if (!c_logger.isErrorEnabled()) break block3;
                c_logger.error("error.get.character.encoding", "Create", null, (Throwable)e2);
            }
        }
        return rValue;
    }

    @Override
    public Object getContent() throws IOException, UnsupportedEncodingException {
        byte[] body = this.m_message.getBodyAsBytes();
        Object rValue = body;
        if (null != rValue && this.getContentType().startsWith(TEXT_MIME_TYPE)) {
            String encoding = this.getCharacterEncoding();
            if (null == encoding || encoding.length() == 0) {
                encoding = DEFAULT_CHARSET_ENCODING;
            }
            rValue = new String(body, encoding);
        }
        return rValue;
    }

    @Override
    public Locale getContentLanguage() {
        Locale locale = null;
        String sLocale = this.getHeader(CONTENT_LANGUAGE);
        if (null != sLocale && sLocale.length() > 0) {
            locale = this.getLocale(sLocale);
        }
        return locale;
    }

    @Override
    public int getContentLength() {
        int rValue;
        block2: {
            rValue = -1;
            try {
                ContentLengthHeader h = this.m_message.getContentLengthHeader();
                rValue = h != null ? h.getContentLength() : 0;
            }
            catch (HeaderParseException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                Object[] args = new Object[]{this};
                c_logger.error("error.get.content.length", "Request", args, (Throwable)e2);
            }
        }
        return rValue;
    }

    Object getContent(Class[] classes) throws IOException, UnsupportedEncodingException {
        throw new UnsupportedOperationException("getContent: Not Done Yet");
    }

    @Override
    public String getContentType() {
        String contentType;
        block4: {
            contentType = null;
            if (this.m_message != null && this.m_message.getBodyAsBytes() != null) {
                try {
                    ContentTypeHeader header = this.m_message.getContentTypeHeader();
                    if (header != null) {
                        contentType = header.getValue();
                    }
                }
                catch (HeaderParseException e2) {
                    if (!c_logger.isErrorEnabled()) break block4;
                    Object[] args = new Object[]{this};
                    c_logger.error("error.get.content.type", "Request", args, (Throwable)e2);
                }
            }
        }
        return contentType;
    }

    @Override
    public int getExpires() {
        int rc;
        block3: {
            rc = -1;
            try {
                ExpiresHeader eHeader = this.m_message.getExpiresHeader();
                if (eHeader != null) {
                    rc = Integer.parseInt(eHeader.getValue());
                }
            }
            catch (HeaderParseException e2) {
                if (!c_logger.isErrorEnabled()) break block3;
                Object[] args = new Object[]{this};
                c_logger.error("error.get.expires", "Request", args);
            }
        }
        return rc;
    }

    @Override
    public Address getFrom() {
        Address address = this.m_fromAddress;
        if (null == address) {
            try {
                address = this.getAddressHeader("From");
                if (this.m_transactionUser != null) {
                    this.m_fromAddress = address;
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getFrom", "TU is not set on the request, From header is not saved");
                }
            }
            catch (ServletParseException e2) {
                this.log("getFrom", "Unable to get Form header", (Throwable)((Object)e2));
            }
        }
        return address;
    }

    @Override
    public String getHeader(String name) {
        String rValue;
        block5: {
            rValue = null;
            try {
                Header h = this.m_message.getHeader(name, true);
                if (null != h) {
                    rValue = h.getValue();
                }
            }
            catch (HeaderParseException e2) {
                rValue = e2.getHeader().getValue();
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getHeader", "Failed to parse header = " + name + " return as a string.");
                }
            }
            catch (IllegalArgumentException e3) {
                if (!c_logger.isErrorEnabled()) break block5;
                Object[] args = new Object[]{name};
                c_logger.error("error.get.header", "Request", args, (Throwable)e3);
            }
        }
        return rValue;
    }

    @Override
    public Iterator getHeaderNames() {
        Iterator rValue = null;
        HeaderIterator headerIterator = ((MessageImpl)this.m_message).getHeadersUnparsed();
        if (null != headerIterator) {
            HashMap<String, String> map = new HashMap<String, String>(20);
            while (headerIterator.hasNext()) {
                Object[] args;
                try {
                    map.put(headerIterator.next().getName(), "");
                }
                catch (HeaderParseException e2) {
                    if (!c_logger.isErrorEnabled()) continue;
                    args = new Object[]{this};
                    c_logger.error("error.get.header.names", "Request", args, (Throwable)e2);
                }
                catch (NoSuchElementException e3) {
                    if (!c_logger.isErrorEnabled()) continue;
                    args = new Object[]{this};
                    c_logger.error("error.get.header.names", "Request", args, (Throwable)e3);
                }
            }
            rValue = map.keySet().iterator();
        }
        return rValue;
    }

    @Override
    public ListIterator getHeaders(String name) {
        LinkedList<String> list = new LinkedList<String>();
        HeaderIterator headerIterator = ((MessageImpl)this.m_message).getHeadersUnparsed(name);
        if (null != headerIterator) {
            while (headerIterator.hasNext()) {
                Object[] args;
                try {
                    Header h = headerIterator.next();
                    list.add(h.getValue());
                }
                catch (HeaderParseException e2) {
                    if (!c_logger.isErrorEnabled()) continue;
                    args = new Object[]{name};
                    c_logger.error("error.get.headers", "Request", args, (Throwable)e2);
                }
                catch (NoSuchElementException e3) {
                    if (!c_logger.isErrorEnabled()) continue;
                    args = new Object[]{name};
                    c_logger.error("error.get.headers", "Request", args, (Throwable)e3);
                }
            }
        }
        List unModify = Collections.unmodifiableList(list);
        return unModify.listIterator();
    }

    @Override
    public String getLocalAddr() {
        return null;
    }

    @Override
    public int getLocalPort() {
        return -1;
    }

    @Override
    public String getProtocol() {
        return "SIP/2.0";
    }

    @Override
    public byte[] getRawContent() throws IOException {
        byte[] content = null;
        if (null != this.m_message) {
            content = this.m_message.getBodyAsBytes();
        }
        return content;
    }

    @Override
    public String getRemoteAddr() {
        return null;
    }

    @Override
    public int getRemotePort() {
        return -1;
    }

    @Override
    public String getInitialRemoteAddr() {
        return null;
    }

    @Override
    public int getInitialRemotePort() {
        return -1;
    }

    @Override
    public String getRemoteUser() {
        if (null != this.m_httpServletRequest) {
            if (this.isUnauthenticatedUser()) {
                return null;
            }
            return this.m_httpServletRequest.getRemoteUser();
        }
        return null;
    }

    @Override
    public SipSession getSession() {
        if (this.getTransactionUser().isValid()) {
            return this.getSession(true);
        }
        return this.getSession(false);
    }

    public TransactionUserWrapper getTransactionUser() {
        if (!this.isLiveMessage("getSessionForInrernalUse")) {
            return null;
        }
        return this.m_transactionUser;
    }

    @Override
    public SipSession getSession(boolean create) {
        if (!this.isLiveMessage("getSession")) {
            return null;
        }
        if (create && !this.getTransactionUser().isValid()) {
            throw new IllegalStateException("The session of this message was invalidated. Calling getSession(boolean) with create argument of the value ture, is not allowed.");
        }
        if (this.m_transactionUser.isProxying()) {
            return this.getProxySession(create);
        }
        return this.m_transactionUser.getSipSession(create);
    }

    SipSession getProxySession(boolean create) {
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append(" WRONG STATE !! ");
            buff.append("This method can be called only from IncomingSipServletRequest ");
            buff.append("or from IncomingSipServletResponse. Transaction Id = ");
            buff.append(this.m_transactionUser.getId());
            c_logger.traceDebug(this, "getDerivedSession", buff.toString());
        }
        return null;
    }

    @Override
    public Address getTo() {
        Address address = this.m_toAddress;
        if (null == address) {
            try {
                address = this.getAddressHeader("To");
                if (this.m_transactionUser != null) {
                    this.m_toAddress = address;
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getTo", "TU is not set on the request, To header is not saved");
                }
            }
            catch (ServletParseException e2) {
                this.log("getTo", "Unable to get To header", (Throwable)((Object)e2));
            }
        }
        return address;
    }

    @Override
    public String getTransport() {
        return null;
    }

    @Override
    public String getInitialTransport() {
        return null;
    }

    @Override
    public Principal getUserPrincipal() {
        if (null != this.m_httpServletRequest) {
            if (this.isUnauthenticatedUser()) {
                return null;
            }
            return this.m_httpServletRequest.getUserPrincipal();
        }
        return null;
    }

    @Override
    public boolean isCommitted() {
        return this.m_isCommited;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean isUserInRole(String role) {
        if (null != this.m_httpServletRequest) {
            if (this.isUnauthenticatedUser()) {
                return false;
            }
            return this.m_httpServletRequest.isUserInRole(role);
        }
        return false;
    }

    @Override
    public void addAcceptLanguage(Locale locale) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        this.addHeader("Accept-Language", this.getLocale(locale));
    }

    @Override
    public void addAddressHeader(String name, Address addr, boolean first) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        this.handleAddressHeader(name, addr, false, first);
    }

    @Override
    public void addParameterableHeader(String name, Parameterable param, boolean first) throws IllegalArgumentException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        this.handleParameterableHeader(name, param, false, first);
    }

    @Override
    public void addHeader(String name, String value) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        this.checkIsLegalHeader(name);
        this.addHeader(name, value, false);
    }

    public void addHeader(boolean ignoreLegalCheck, String name, String value) {
        if (!ignoreLegalCheck) {
            this.checkIsLegalHeader(name);
        }
        this.addHeader(name, value, false);
    }

    public void addHeader(String name, String value, boolean first) {
        block5: {
            if (name == null || name.equals("") || value == null) {
                throw new NullPointerException("The name or value is null");
            }
            try {
                Header header = this.getHeadersFactory().createHeader(name, value);
                this.m_message.addHeader(header, first);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{name, value};
                    c_logger.error("error.add.header", "Request", args, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block5;
                Object[] args = new Object[]{name, value};
                c_logger.error("error.add.header", "Request", args, (Throwable)e3);
            }
        }
    }

    @Override
    public void setAcceptLanguage(Locale locale) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        String sipLanguage = this.getLocale(locale);
        this.setHeader("Accept-Language", sipLanguage);
    }

    @Override
    public void setAddressHeader(String name, Address addr) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        this.handleAddressHeader(name, addr, true, true);
    }

    @Override
    public void setParameterableHeader(String name, Parameterable param) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{name, param};
            c_logger.traceEntry((Object)SipServletMessageImpl.class.getName(), "setParameterableHeader", params);
        }
        if (this.isCommitted()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        this.handleParameterableHeader(name, param, true, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleAddressHeader(String name, Address addr, boolean remove, boolean first) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{name, addr, remove, first};
            c_logger.traceEntry((Object)SipServletMessageImpl.class.getName(), "handleAddressHeader", params);
        }
        this.checkIsLegalHeader(name);
        try {
            HeaderImpl header = HeaderCreator.createHeader(name);
            if (header instanceof NameAddressHeaderImpl) {
                NameAddressHeaderImpl h = (NameAddressHeaderImpl)header;
                if (addr.isWildcard()) {
                    if (!(h instanceof ContactHeader)) throw new IllegalArgumentException("Wildcard Address objects are legal only in Contact header fields");
                    ((ContactHeader)((Object)h)).setWildCard();
                } else {
                    h.assign(((AddressImpl)addr).getNameAddressHeader());
                }
            } else {
                header = new GenericNameAddressHeaderImpl(name);
                ((NameAddressHeaderImpl)header).assign(((AddressImpl)addr).getNameAddressHeader());
            }
            if (remove) {
                this.removeHeader(name, false);
            }
            this.m_message.addHeader(header, first);
            if (!(header instanceof ContactHeader)) return;
            this.m_isDefaultContactHeader = false;
            return;
        }
        catch (Exception e2) {
            if (!c_logger.isErrorEnabled()) throw new IllegalArgumentException("The specified header field is a system header or it cannot legally appear in this message");
            Object[] args = new Object[]{name, addr};
            c_logger.error("error.set.header", "Request", args, (Throwable)e2);
            throw new IllegalArgumentException("The specified header field is a system header or it cannot legally appear in this message");
        }
    }

    private void handleParameterableHeader(String headerName, Parameterable param, boolean remove, boolean first) throws IllegalArgumentException {
        block18: {
            ParametersHeaderImpl source;
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{headerName, param, remove, first};
                c_logger.traceEntry((Object)SipServletMessageImpl.class.getName(), "handleParameterableHeader", params);
            }
            this.checkIsLegalHeader(headerName);
            if (param == null) {
                throw new IllegalArgumentException("null parameterable");
            }
            if (!(param instanceof ParameterableImpl)) {
                throw new IllegalArgumentException("expected [" + ParameterableImpl.class.getName() + "] but got [" + param.getClass().getName() + ']');
            }
            ParameterableImpl parameterable = (ParameterableImpl)param;
            HeaderImpl header = HeaderCreator.createHeader(headerName);
            if (header instanceof NameAddressHeaderImpl) {
                NameAddressHeaderImpl nameAddressHeader = (NameAddressHeaderImpl)header;
                ParametersHeader source2 = parameterable.getParametersHeader();
                if (source2 instanceof NameAddressHeader) {
                    NameAddressHeader nameAddressSource = (NameAddressHeader)source2;
                    nameAddressHeader.assign(nameAddressSource);
                } else {
                    try {
                        header.setValue(source2.getValue());
                        header.parse();
                    }
                    catch (SipParseException e2) {
                        throw new IllegalArgumentException("address header [" + headerName + "] cannot have non-address value [" + param.toString() + ']', e2);
                    }
                }
            } else if (header instanceof ParametersHeaderImpl) {
                source = (ParametersHeaderImpl)parameterable.getParametersHeader();
                String sourceValue = source.getValue();
                try {
                    header.setValue(sourceValue);
                    header.parse();
                }
                catch (SipParseException e3) {
                    throw new IllegalArgumentException("parameters header [" + headerName + "] cannot have non-parameters value [" + param.toString() + ']', e3);
                }
            } else if (header instanceof ExtendedHeader) {
                source = (ParametersHeaderImpl)parameterable.getParametersHeader();
                String sourceFieldValue = parameterable.getValue();
                GenericParametersHeaderImpl genericParametersHeaderImpl = new GenericParametersHeaderImpl(headerName);
                genericParametersHeaderImpl.setFieldValue(sourceFieldValue);
                header = genericParametersHeaderImpl;
                genericParametersHeaderImpl.assign(source);
            } else {
                throw new IllegalArgumentException("not a parameterable header name [" + headerName + "] value [" + param.toString() + ']');
            }
            try {
                if (remove) {
                    this.removeHeader(headerName, false);
                }
                this.m_message.addHeader(header, first);
            }
            catch (IllegalArgumentException e4) {
                if (!c_logger.isErrorEnabled()) break block18;
                Object[] args = new Object[]{headerName, param};
                c_logger.error("error.set.header", "Request", args, (Throwable)e4);
            }
        }
    }

    @Override
    public void removeAttribute(String name) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        if (this.m_attributes != null) {
            this.m_attributes.remove(name);
        }
    }

    @Override
    public void setContent(Object content, String contentType) throws UnsupportedEncodingException {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        if (null == content) {
            throw new IllegalArgumentException("setContent: content can't be null");
        }
        if (null == contentType) {
            throw new IllegalArgumentException("setContent: contentType can't be null");
        }
        try {
            ContentTypeHeader contentTypeHeader;
            ContentTypeHeader newContentTypeHeader = (ContentTypeHeader)this.getHeadersFactory().createHeader("Content-Type", contentType);
            String encoding = newContentTypeHeader.getParameter("charset");
            if (null == encoding && null != (contentTypeHeader = (ContentTypeHeader)this.findHeader("Content-Type")) && null != (encoding = contentTypeHeader.getParameter("charset"))) {
                newContentTypeHeader.setParameter("charset", encoding);
            }
            if (encoding != null) {
                SipServletMessageImpl.assertCharacterEncoding(encoding);
            }
            this.m_message.setBody(this.getBodyAsBytes(content, newContentTypeHeader), newContentTypeHeader);
        }
        catch (SipParseException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    public void setContentLanguage(Locale locale) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        String sipLanguage = this.getLocale(locale);
        this.setHeader(CONTENT_LANGUAGE, sipLanguage);
    }

    @Override
    public void setContentLength(int len) {
        ContentLengthHeader contentLength;
        if (this.isCommitted()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setContentLength", "use SetContent instead");
        }
        HeaderFactory hf = this.getHeadersFactory();
        try {
            contentLength = hf.createContentLengthHeader(len);
        }
        catch (SipParseException e2) {
            throw new RuntimeException(e2);
        }
        this.m_message.setContentLengthHeader(contentLength);
    }

    @Override
    public void setContentType(String type) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        this.setHeader("Content-Type", type);
    }

    @Override
    public void setExpires(int seconds) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        this.setHeader("Expires", String.valueOf(seconds));
    }

    @Override
    public void setHeader(String name, String value) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        this.setHeader(name, value, true);
    }

    protected void setHeader(String name, String value, boolean checkIsLegalHeader) {
        block9: {
            if (name == null || name.equals("") || value == null) {
                throw new NullPointerException("The name or value is null");
            }
            if (checkIsLegalHeader) {
                this.checkIsLegalHeader(name);
            }
            try {
                this.removeHeader(name, false);
                Header header = this.getHeadersFactory().createHeader(name, value);
                this.m_message.setHeader(header, false);
                if ("From".equalsIgnoreCase(name)) {
                    this.m_fromAddress = null;
                } else if ("To".equalsIgnoreCase(name)) {
                    this.m_toAddress = null;
                }
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{name, value};
                    c_logger.error("error.set.header", "Request", args, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block9;
                Object[] args = new Object[]{name, value};
                c_logger.error("error.set.header", "Request", args, (Throwable)e3);
            }
        }
    }

    protected void checkIsLegalHeader(String name) {
        if (this.checkIsSystemHeader(name)) {
            throw new IllegalArgumentException("Illegal operation, trying to modify system header");
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)SipServletMessageImpl.class.getName(), "checkIsLegalHeader", "header name: " + name + " true");
        }
    }

    protected boolean checkIsSystemHeader(String name) {
        boolean isSystemHeader = false;
        if (!SipContainer.getInstance().canModifySysHeaders()) {
            boolean isJSR289 = this.isJSR289Application();
            if (name.equalsIgnoreCase("Contact")) {
                if (this.checkIsSystemContactHeader()) {
                    isSystemHeader = true;
                }
            } else if (name.equalsIgnoreCase("Via") || name.equalsIgnoreCase("Record-Route") || name.equalsIgnoreCase("Route") || name.equalsIgnoreCase("CSeq") || name.equalsIgnoreCase("To") || name.equalsIgnoreCase("From") || name.equalsIgnoreCase("Call-ID")) {
                isSystemHeader = true;
            } else if (isJSR289 && (name.equalsIgnoreCase("RAck") || name.equalsIgnoreCase("RSeq"))) {
                isSystemHeader = true;
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)SipServletMessageImpl.class.getName(), "checkIsSystemHeader", "header name: " + name + " " + isSystemHeader);
        }
        return isSystemHeader;
    }

    private boolean checkIsSystemAddressHeader(String name) {
        return name.equalsIgnoreCase("Contact") ? this.checkIsSystemContactHeader() : name.equalsIgnoreCase("Record-Route") || name.equalsIgnoreCase("Route") || name.equalsIgnoreCase("To") || name.equalsIgnoreCase("From");
    }

    protected abstract boolean checkIsSystemContactHeader();

    @Override
    public void removeHeader(String name) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        this.removeHeader(name, true);
    }

    public void removeHeader(String name, boolean isLegal) {
        if (isLegal) {
            this.checkIsLegalHeader(name);
        }
        this.m_message.removeHeaders(name);
    }

    public Message getMessage() {
        return this.m_message;
    }

    protected void setMessage(Message message) {
        this.m_message = message;
    }

    public SipProvider getSipProvider() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getSipProvider", "provider=" + this.m_sipProvider);
        }
        return this.m_sipProvider;
    }

    public long getTransactionId() {
        return this.m_transactionId;
    }

    protected MessageFactory getMessageFactory() {
        return this.getStackProperties().getMessageFactory();
    }

    protected HeaderFactory getHeadersFactory() {
        return this.getStackProperties().getHeadersFactory();
    }

    protected AddressFactory getAddressFactory() {
        return this.getStackProperties().getAddressFactory();
    }

    protected StackProperties getStackProperties() {
        return StackProperties.getInstance();
    }

    private int parsePortNumber(String str, int start, int end) {
        int number = 0;
        for (int i = start; i < end; ++i) {
            char c = str.charAt(i);
            int d = c - 48;
            if (0 <= d && d <= 9) {
                number *= 10;
                number += d;
                continue;
            }
            number = -1;
            break;
        }
        return number;
    }

    protected void parseTransport() throws HeaderParseException {
        if (this.m_clientAddress != null && this.m_clientAddress.length() > 0) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("parseTransport: parsing clientAddress=" + this.m_clientAddress);
            }
            int delimeter = this.m_clientAddress.indexOf(";");
            int initialRemoteDelim = this.m_clientAddress.indexOf(";", delimeter + 1);
            int transportDelim = -1;
            if (initialRemoteDelim > 0) {
                transportDelim = this.m_clientAddress.indexOf(";", initialRemoteDelim + 1);
            }
            String remoteAddrAndPort = this.m_clientAddress.substring(0, delimeter);
            String localAddrAndPort = null;
            if (initialRemoteDelim < 0) {
                localAddrAndPort = this.m_clientAddress.substring(delimeter + 1);
            } else {
                localAddrAndPort = this.m_clientAddress.substring(delimeter + 1, initialRemoteDelim);
                if (!this.m_clientAddress.substring(initialRemoteDelim + 1).startsWith(INITIAL_REMOTE_TAG)) {
                    transportDelim = initialRemoteDelim;
                    initialRemoteDelim = -1;
                }
            }
            int remotePortStart = remoteAddrAndPort.lastIndexOf(":");
            int localPortStart = localAddrAndPort.lastIndexOf(":");
            int initialRemotePortDelim = this.m_clientAddress.lastIndexOf(":");
            this.m_remoteAddr = this.m_clientAddress.substring(0, remotePortStart);
            this.m_remotePort = this.parsePortNumber(this.m_clientAddress, remotePortStart + 1, delimeter);
            this.m_localAddr = localAddrAndPort.substring(LOCAL_ADDRESS_TAG.length() + 1, localPortStart);
            if (initialRemoteDelim < 0) {
                initialRemoteDelim = this.m_clientAddress.length();
                this.m_initialRemoteAddr = this.m_remoteAddr;
                this.m_initialRemotePort = this.m_remotePort;
                this.m_initialTransport = this.getTransportInt();
            } else {
                this.m_initialRemoteAddr = this.m_clientAddress.substring(initialRemoteDelim + INITIAL_REMOTE_TAG.length() + 2, initialRemotePortDelim);
                this.m_initialRemotePort = this.parsePortNumber(this.m_clientAddress, initialRemotePortDelim + 1, transportDelim);
            }
            if (transportDelim > 0) {
                this.m_initialTransport = this.m_clientAddress.substring(transportDelim + 1);
            }
            this.m_localPort = this.parsePortNumber(localAddrAndPort, localPortStart + 1, localAddrAndPort.length());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)"SipServletMessageImpl", "parseTransport", "localAddr: " + this.m_localAddr + " , localPort: " + this.m_localPort + " ,remoteAddr: " + this.m_remoteAddr + " , remotePort: " + this.m_remotePort + " ,initialRemoteAddress: " + this.m_initialRemoteAddr + " , initialRemotePort: " + this.m_initialRemotePort + " ,initialTransport: " + this.m_initialTransport);
        }
    }

    protected SipURI constructContactHeaderURI() {
        return null;
    }

    protected String createIBMClientAddrHeaderForLoopbackMessages() {
        String host = null;
        int port = -1;
        String transport = null;
        boolean isSetLbOutboundIfEnabled = PropertiesStore.getInstance().getProperties().getBoolean("enableSetLBOutboundIF");
        String initialRemoteHost = null;
        int initialRemotePort = -1;
        if (this.m_clientAddress == null) {
            TransactionUserWrapper tu;
            ListeningPoint lPoint = this.getSipProvider().getListeningPoint();
            transport = lPoint.getTransport();
            if (isSetLbOutboundIfEnabled && (tu = this.getTransactionUser()) != null) {
                SipProxyInfo proxyInfo = SipProxyInfo.getInstance();
                int index = tu.getPreferedOutboundIface(transport);
                if (index != -1) {
                    SipURI sipURI = proxyInfo.getOutboundInterface(index, transport);
                    host = sipURI.getHost();
                    port = sipURI.getPort();
                    initialRemoteHost = host;
                    initialRemotePort = port;
                }
            }
            if (host == null) {
                host = lPoint.getHost();
                port = lPoint.getPort();
                initialRemoteHost = host;
                initialRemotePort = port;
            }
        } else {
            host = this.getLocalAddrInt();
            port = this.getLocalPortInt();
            transport = this.getInitialTransportInt();
            initialRemoteHost = this.getInitialRemoteAddrInt();
            initialRemotePort = this.getInitialRemotePortInt();
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(host).append(':').append(port).append(';').append(LOCAL_ADDRESS_TAG).append('=').append(host).append(':').append(port).append(';').append(INITIAL_REMOTE_TAG).append('=').append(initialRemoteHost).append(':').append(initialRemotePort).append(';').append(transport);
        return sb.toString();
    }

    Message getJainSipMessage() {
        return this.m_message;
    }

    List getViaHeaders() {
        HeaderIterator iterator = this.m_message.getViaHeaders();
        Vector<Header> viaHeaders = new Vector<Header>(10);
        while (iterator.hasNext()) {
            try {
                viaHeaders.addElement(iterator.next());
            }
            catch (HeaderParseException e2) {
                if (!c_logger.isErrorEnabled()) continue;
                Object[] args = new Object[]{this};
                c_logger.error("error.get.via.headers", "Request", args, (Throwable)e2);
            }
        }
        return viaHeaders;
    }

    String getTopVia() {
        try {
            Header via = this.m_message.getHeader("Via", true);
            if (via != null) {
                return via.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    ContactHeader getContactHeader() {
        ContactHeader contactHeader;
        block3: {
            HeaderIterator iterator;
            contactHeader = null;
            if (null != this.m_message && null != (iterator = this.m_message.getContactHeaders()) && iterator.hasNext()) {
                try {
                    contactHeader = (ContactHeader)iterator.next();
                }
                catch (HeaderParseException e2) {
                    if (!c_logger.isErrorEnabled()) break block3;
                    Object[] args = new Object[]{this};
                    c_logger.error("error.get.contact.header", "Request", args, (Throwable)e2);
                }
            }
        }
        return contactHeader;
    }

    void setSipProvider(SipProvider sipProvider) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setSipProvider", "provider=" + sipProvider);
        }
        this.m_sipProvider = sipProvider;
    }

    public void setTransactionUser(TransactionUserWrapper transactionUser) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(SipServletMessageImpl.class.getName(), "setTransactionUser");
        }
        if (transactionUser == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setTransactionUser", "transaction user is null");
            }
            return;
        }
        if (this.m_transactionUser != null && c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setTransactionUser", "Overwriting old TU: " + this.m_transactionUser + " With TU: " + transactionUser);
        }
        this.m_transactionUser = transactionUser;
        if (this._updateMessageListLater) {
            this.updateUnCommittedMessagesList(this.m_isCommited);
            this._updateMessageListLater = false;
        }
    }

    void setTransactionId(long transactionId) {
        this.m_transactionId = transactionId;
    }

    abstract Address getLocalParty();

    abstract Address getRemoteParty();

    public void setIsCommited(boolean isCommited) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{isCommited, Integer.toHexString(this.hashCode())};
            c_logger.traceEntry((Object)SipServletMessageImpl.class.getName(), "setIsCommited", params);
        }
        this.m_isCommited = isCommited;
        if (this.m_transactionUser != null) {
            if (!this.m_transactionUser.isValid()) {
                return;
            }
            this.updateUnCommittedMessagesList(isCommited);
        } else {
            this._updateMessageListLater = true;
        }
    }

    abstract void updateUnCommittedMessagesList(boolean var1);

    protected Iterator getJainSipHeaders() {
        final HeaderIterator hIterator = this.m_message.getHeaders();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return hIterator.hasNext();
            }

            public Object next() {
                Header next;
                block4: {
                    next = null;
                    try {
                        next = hIterator.next();
                    }
                    catch (HeaderParseException e2) {
                        if (c_logger.isErrorEnabled()) {
                            Object[] args = new Object[]{this};
                            c_logger.error("error.get.jain.sip.headers", "Request", args, (Throwable)e2);
                        }
                    }
                    catch (NoSuchElementException e3) {
                        if (!c_logger.isErrorEnabled()) break block4;
                        Object[] args = new Object[]{this};
                        c_logger.error("error.get.jain.sip.headers", "Request", args, (Throwable)e3);
                    }
                }
                return next;
            }

            @Override
            public void remove() {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getJainSipHeaders", "Remove operation not supported by this iterator");
                }
            }
        };
    }

    public SipTransaction getTransaction() {
        return this.m_transaction;
    }

    public void setTransaction(SipTransaction transaction) {
        this.m_transaction = transaction;
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        this.m_httpServletRequest = request;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.m_httpServletRequest;
    }

    public void setHttpServletResponse(HttpServletResponse response) {
        this.m_httpServletResponse = response;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.m_httpServletResponse;
    }

    protected byte[] getBodyAsBytes(Object body, ContentTypeHeader contentTypeHeader) throws UnsupportedEncodingException {
        String contentType;
        if (null == body || body instanceof byte[]) {
            return (byte[])body;
        }
        byte[] rValue = null;
        String string = contentType = contentTypeHeader == null ? null : contentTypeHeader.getContentType();
        if (!(body instanceof String) && !contentType.equals(TEXT_MIME_TYPE)) {
            throw new IllegalArgumentException("unsupported content type [93");
        }
        String encoding = contentTypeHeader.getParameter("charset");
        if (null == encoding || encoding.length() == 0) {
            encoding = DEFAULT_CHARSET_ENCODING;
        }
        rValue = body.toString().getBytes(encoding);
        return rValue;
    }

    public HeaderIterator getJainHeaders() {
        return this.m_message.getHeaders();
    }

    public HeaderIterator getJainHeaders(String headerName) {
        return this.m_message.getHeaders(headerName);
    }

    protected Header findHeader(String name) throws HeaderParseException {
        return this.m_message.getHeader(name, true);
    }

    protected void log(String method, String message, Throwable t) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, method, message, t);
        }
    }

    protected void log(String method, String message) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, method, message);
        }
    }

    public String toString() {
        if (null != this.m_message) {
            return this.m_message.toString();
        }
        return super.toString();
    }

    protected void logException(Exception e2) {
        if (c_logger.isErrorEnabled()) {
            c_logger.error("error.exception", "Create", null, (Throwable)e2);
        }
    }

    @Override
    public SipServletMessage.HeaderForm getHeaderForm() {
        MessageImpl message = (MessageImpl)this.m_message;
        MessageImpl.HeaderForm form = message.getHeaderForm();
        switch (form) {
            case COMPACT: {
                return SipServletMessage.HeaderForm.COMPACT;
            }
            case DEFAULT: {
                return SipServletMessage.HeaderForm.DEFAULT;
            }
            case LONG: {
                return SipServletMessage.HeaderForm.LONG;
            }
        }
        throw new RuntimeException("unknown header form [" + (Object)((Object)form) + ']');
    }

    @Override
    public void setHeaderForm(SipServletMessage.HeaderForm form) {
        MessageImpl message = (MessageImpl)this.m_message;
        switch (form) {
            case COMPACT: {
                message.setHeaderForm(MessageImpl.HeaderForm.COMPACT);
                break;
            }
            case DEFAULT: {
                message.setHeaderForm(MessageImpl.HeaderForm.DEFAULT);
                break;
            }
            case LONG: {
                message.setHeaderForm(MessageImpl.HeaderForm.LONG);
                break;
            }
            default: {
                throw new RuntimeException("unknown header form [" + (Object)((Object)form) + ']');
            }
        }
    }

    public boolean isFailovered() {
        return this.m_isFailovered;
    }

    protected boolean isLiveMessage(String methodName) {
        if (this.isFailovered()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, methodName, "This Request was failovered - cannot perform this action");
            }
            return false;
        }
        return true;
    }

    public void logExceptionToSessionLog(int status, Exception e2) {
        if (this.m_transactionUser != null) {
            this.m_transactionUser.logToContext(status, e2.getMessage(), (Object)this);
        }
    }

    protected ContactHeader createAndSetContactHeader(Message message, SipURI sipURI, boolean first) throws SipParseException {
        if (this.m_sipProvider == null) {
            this.selectProvider(this.getTransport());
            this.m_isDefaultContactHeader = true;
        }
        ListeningPoint point = this.getSipProvider().getListeningPoint();
        String transport = point.getTransport();
        String host = null;
        int port = -1;
        if (sipURI == null) {
            host = point.getSentBy();
            port = point.getPort();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createAndSetContactHeader", "Using the local listening point - " + host + ":" + port);
            }
        } else {
            host = sipURI.getHost();
            port = sipURI.getPort();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createAndSetContactHeader", "Using the prefered outbound interface - " + host + ":" + port);
            }
        }
        SipURL sipUrl = null;
        ContactHeader currentContact = this.getContactHeader();
        if (currentContact != null) {
            sipUrl = (SipURL)currentContact.getNameAddress().getAddress();
            sipUrl.setHost(host);
        } else {
            sipUrl = this.getAddressFactory().createSipURL(host);
        }
        sipUrl.setPort(port);
        sipUrl.setTransport(transport);
        this.setContactScheme(sipUrl);
        SipStackUtil.fixTargetSipUri(sipUrl);
        if (currentContact == null) {
            NameAddress address = this.getAddressFactory().createNameAddress(sipUrl);
            currentContact = this.getHeadersFactory().createContactHeader(address);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createAndSetContactHeader", "Create a new Contact header - " + currentContact);
            }
            message.setHeader(currentContact, first);
        }
        return currentContact;
    }

    protected void setContactScheme(SipURL sipUrl) throws IllegalArgumentException, SipParseException {
    }

    @Override
    public long getArrivedTime() {
        return this.m_arrivedTime;
    }

    public void setArrivedTime(long arrivedTime) {
        this.m_arrivedTime = arrivedTime;
        boolean prop = PropertiesStore.getInstance().getProperties().getBoolean("msgArrivalTimeAttr");
        if (prop) {
            this.setAttribute(SIP_MESSAGE_ARRIVAL_TIME, arrivedTime);
        }
    }

    protected boolean selectProvider(String transport) {
        TransactionUserWrapper tUser;
        SipProvider provider;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)SipServletMessageImpl.class.getName(), "selectProvider", (Object)transport);
        }
        boolean changed = false;
        if (transport == null) {
            transport = UDP;
        }
        if (null == (provider = this.m_sipProvider) || !provider.getListeningPoint().getTransport().equalsIgnoreCase(transport)) {
            provider = StackProperties.getInstance().getProvider(transport);
            this.setSipProvider(provider);
            changed = true;
        }
        if ((tUser = this.getTransactionUser()) != null) {
            tUser.setProvider(provider);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "selectProvider", "Allocated provider: " + provider);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "selectProvider", provider);
        }
        return changed;
    }

    private boolean compareHosts(String aliasHost, String lpHost) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "compareHosts", "comparing hosts: aliasHost: " + aliasHost + "lpHost: " + lpHost);
        }
        if (aliasHost.equals("*")) {
            return true;
        }
        return aliasHost.equals(lpHost);
    }

    private boolean compareLPToVHAlias(VirtualHostAlias alias, ListeningPoint lp) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "compareLPToVHAlias", "comparing: alias: " + alias + "listeningPoint: " + lp);
        }
        boolean result = true;
        if (!alias.isAnyHost()) {
            result = alias.getHost().equals(lp.getHost());
        }
        if (result && !alias.isAnyPort()) {
            result = result && alias.getPort() == lp.getPort();
        }
        return result;
    }

    public String getIbmClientAddress() {
        return this.m_clientAddress;
    }

    public void setIbmClientAddress(String address) {
        this.m_clientAddress = address;
    }

    protected String getLocalAddrInt() {
        if (null == this.m_localAddr) {
            try {
                this.parseTransport();
            }
            catch (HeaderParseException e2) {
                this.log("getLocaleAddr", "Unable to get local transport", e2);
            }
        }
        return this.m_localAddr;
    }

    protected int getLocalPortInt() {
        if (-1 == this.m_localPort) {
            try {
                this.parseTransport();
            }
            catch (HeaderParseException e2) {
                this.log("getLocalPort", "Unable to get local transport", e2);
            }
        }
        return this.m_localPort;
    }

    protected String getRemoteAddrInt() {
        if (null == this.m_remoteAddr) {
            try {
                this.parseTransport();
            }
            catch (HeaderParseException e2) {
                this.log("getRemoteAddr", "Unable to get remote transport", e2);
            }
        }
        return this.m_remoteAddr;
    }

    protected String getLocalTransportInt() {
        if (this.m_initialTransport == null) {
            try {
                this.parseTransport();
            }
            catch (HeaderParseException e2) {
                this.log("getLocalPort", "Unable to get local transport", e2);
            }
        }
        return this.m_initialTransport;
    }

    protected int getRemotePortInt() {
        if (-1 == this.m_remotePort) {
            try {
                this.parseTransport();
            }
            catch (HeaderParseException e2) {
                this.log("getRemotePort", "Unable to get remote transport", e2);
            }
        }
        return this.m_remotePort;
    }

    protected String getInitialRemoteAddrInt() {
        if (null == this.m_initialRemoteAddr) {
            try {
                this.parseTransport();
            }
            catch (HeaderParseException e2) {
                this.log("getInitialRemoteAddr", "Unable to get initial remote transport", e2);
            }
        }
        return this.m_initialRemoteAddr;
    }

    protected int getInitialRemotePortInt() {
        if (-1 == this.m_initialRemotePort) {
            try {
                this.parseTransport();
            }
            catch (HeaderParseException e2) {
                this.log("getInitialRemotePort", "Unable to get initial remote port", e2);
            }
        }
        return this.m_initialRemotePort;
    }

    protected String getTransportInt() {
        if (!this.isLiveMessage("getTransport")) {
            return null;
        }
        if (this.getSipProvider() != null) {
            return this.getSipProvider().getListeningPoint().getTransport();
        }
        return null;
    }

    protected String getInitialTransportInt() {
        if (this.m_initialTransport == null) {
            try {
                this.parseTransport();
            }
            catch (HeaderParseException e2) {
                this.log("getInitialTransport", "Unable to get initial transport", e2);
            }
        }
        return this.m_initialTransport;
    }

    private void cloneForObjectGrid(ObjectOutput out) throws IOException {
        MessageImpl msg = (MessageImpl)this.m_message.clone();
        out.writeObject(msg);
    }

    protected void resetContentLength() {
    }

    private boolean isUnauthenticatedUser() {
        String remoteUser = this.m_httpServletRequest.getRemoteUser();
        if (remoteUser != null && UNAUTHENTICATED.equals(remoteUser)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "isUnauthenticatedUser", "user is unauthenticated according to the TAI");
            }
            return true;
        }
        return false;
    }

    static {
        PropertiesStore store = PropertiesStore.getInstance();
        c_appCompositionEnabled = store.getProperties().getBoolean("appCompositionEnabled");
        if (!c_appCompositionEnabled && c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)"SipServletMessageImpl", "Static Init", "Application Composition is Disabled");
        }
    }

    public static enum MessageType {
        INCOMING_REQUEST,
        OUTGOING_REQUEST,
        INCOMING_RESPONSE,
        OUTGOING_RESPONSE;

    }
}

