/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.load;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.load.Weighable;
import com.ibm.ws.sip.container.pmi.LoadManager;
import com.ibm.ws.sip.container.pmi.PerfUtil;

public abstract class LoadCounterAbs
implements Weighable {
    private static final LogMgr c_logger = Log.get(LoadCounterAbs.class);
    private int _stepSize;
    private int _lastWeight = 2;
    private int _maximumAllowed;
    private int _waterMarkSize;
    private int _myId;
    public static final int FREE_WEIGHT = 10;
    protected StringBuffer _myInfo = null;
    private long _loadAtLastWeightCalc = 0L;

    public LoadCounterAbs(int maximumAllowed, int waterMarkSize, int initialWeight, int id, int averagePeriod) {
        if (averagePeriod < 1000) {
            maximumAllowed = maximumAllowed / averagePeriod * 1000;
        }
        this.init(maximumAllowed, waterMarkSize, initialWeight, id);
    }

    public LoadCounterAbs(int maximumAllowed, int waterMarkSize, int initialWeight, int id) {
        this.init(maximumAllowed, waterMarkSize, initialWeight, id);
    }

    private void init(int maximumAllowed, int waterMarkSize, int initialWeight, int id) {
        if (maximumAllowed < 10) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "init", "Maximum allowed should not be less then 10 - changing automatically to 10");
            }
            maximumAllowed = 10;
        }
        this._maximumAllowed = maximumAllowed;
        this._stepSize = this._maximumAllowed / 10;
        this._waterMarkSize = this._stepSize * waterMarkSize / 100;
        this._lastWeight = 10 - initialWeight;
        this._myId = id;
        this._myInfo = new StringBuffer();
        this._myInfo.append("Parameters:");
        this._myInfo.append(PerfUtil.getTypeStr(this._myId));
        this._myInfo.append(" id = ");
        this._myInfo.append(this._myId);
        this._myInfo.append(" __maximumAllowed = ");
        this._myInfo.append(this._maximumAllowed);
        this._myInfo.append(" _stepSize = ");
        this._myInfo.append(this._stepSize);
        this._myInfo.append(" _lastWeight = ");
        this._myInfo.append(this._lastWeight);
        this._myInfo.append(" _waterMarkSize = ");
        this._myInfo.append(this._waterMarkSize);
    }

    protected boolean calculateNewWeight(long currentLoad) {
        boolean weightChanged = false;
        long newWeight = currentLoad / (long)this._stepSize;
        this._loadAtLastWeightCalc = currentLoad;
        if (newWeight > 10L) {
            if (newWeight > 11L) {
                LoadManager.getInstance().setThrowMsgInOverload(true);
            }
            newWeight = 10L;
        } else if (newWeight < (long)this._lastWeight) {
            long stepValue = newWeight * (long)this._stepSize;
            if (currentLoad > (stepValue += (long)this._waterMarkSize)) {
                ++newWeight;
            }
        }
        if ((long)this._lastWeight != newWeight) {
            this._lastWeight = (int)newWeight;
            weightChanged = true;
        }
        return weightChanged;
    }

    @Override
    public int getWeight() {
        return 10 - this._lastWeight;
    }

    @Override
    public void calculateWeight() {
        this.calculateNewWeight(this.getCurrentLoad());
        this.reset();
    }

    @Override
    public int getCounterID() {
        return this._myId;
    }

    abstract void reset();

    @Override
    public long getLoadUsedForLastWeightCalc() {
        return this._loadAtLastWeightCalc;
    }
}

