/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl.netty;

import com.ibm.ws.sip.channel.resolver.dns.impl.netty.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.netty.ResourceRecord;
import io.netty.buffer.ByteBuf;

public class SRVRecord
extends ResourceRecord {
    private String _service;
    private String _protocol;
    private String _name;
    private short _priority;
    private short _weight;
    private short _port;
    private Name _target;

    protected SRVRecord() {
        this._service = null;
        this._protocol = null;
        this._name = null;
        this._priority = 0;
        this._weight = 0;
        this._port = 0;
        this._target = null;
    }

    protected SRVRecord(ByteBuf buffer, Name name) {
        super(buffer);
        String[] sa = name.getString().split("\\.");
        this._service = sa[0];
        this._protocol = sa[1];
        this._name = "";
        for (int i = 2; i < sa.length; ++i) {
            this._name = this._name + sa[i] + ".";
        }
        this._priority = buffer.readShort();
        this._weight = buffer.readShort();
        this._port = buffer.readShort();
        this._target = new Name(buffer);
    }

    public void setService(String s) {
        this._service = s;
    }

    public void setProtocol(String s) {
        this._protocol = s;
    }

    public void setName(String s) {
        this._name = s;
    }

    public void setPriority(short s) {
        this._priority = s;
    }

    public Short getPriority() {
        return this._priority;
    }

    public void setWeight(short s) {
        this._weight = s;
    }

    public Short getWeight() {
        return this._weight;
    }

    public void setPort(short s) {
        this._port = s;
    }

    public short getPort() {
        return this._port;
    }

    public String getService() {
        return this._service;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getSrvName() {
        return this._name;
    }

    public void setTarget(Name name) {
        this._target = name;
    }

    public Name getTarget() {
        return this._target;
    }

    @Override
    protected void toBuffer(ByteBuf buffer) {
        super.toBuffer(buffer);
        buffer.writeShort((int)this._priority);
        buffer.writeShort((int)this._weight);
        buffer.writeShort((int)this._port);
        this._target.toBuffer(buffer);
    }

    public short calcrdLength() {
        int length = 0;
        length = 6 + this._target.length();
        return (short)length;
    }

    @Override
    public String toString() {
        String s = new String();
        s = super.toString();
        s = s + "      service: " + this._service.toString() + "\n      protocol: " + this._protocol.toString() + "\n      name: " + this._name.toString() + "\n      priority: " + new Short(this._priority).toString() + "\n      weight: " + new Short(this._weight).toString() + "\n      port: " + new Short(this._port).toString() + "\n      target: " + this._target.toString() + "\n";
        return s;
    }
}

