/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml;

import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.sso20.metadata.AcsDOMMetadataProvider;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.service.cm.ConfigurationAdmin;

public interface SsoConfig {
    public Constants.SamlSsoVersion getSamlVersion();

    public String getProviderId();

    public AuthenticationFilter getAuthFilter(ConcurrentServiceReferenceMap<String, AuthenticationFilter> var1);

    public String getAuthFilterId();

    public long getClockSkew();

    public boolean isWantAssertionsSigned();

    public boolean isAuthnRequestsSigned();

    public boolean isIncludeX509InSPMetadata();

    public boolean isForceAuthn();

    public boolean isPassive();

    public Boolean getAllowCreate();

    public String[] getAuthnContextClassRef();

    public String getAuthnContextComparisonType();

    public String getNameIDFormat();

    public String getIdpMetadata();

    public AcsDOMMetadataProvider getIdpMetadataProvider();

    public String getKeyStoreRef();

    public String getKeyAlias();

    @Sensitive
    public String getKeyPassword();

    public String getLoginPageURL();

    public String getErrorPageURL();

    public long getTokenReplayTimeout();

    public long getSessionNotOnOrAfter();

    public String getUserIdentifier();

    public String getGroupIdentifier();

    public String getUserUniqueIdentifier();

    public String getRealmIdentifier();

    public boolean isIncludeTokenInSubject();

    public Constants.MapToUserRegistry getMapToUserRegistry();

    public String getSignatureMethodAlgorithm();

    public boolean isDisableInitialRequestCookie();

    public boolean isDisableLtpaCookie();

    public String getSpCookieName(WsLocationAdmin var1);

    public boolean isPkixTrustEngineEnabled();

    public List<String> getPkixX509CertificateList();

    public List<String> getPkixCrlList();

    public Collection<X509Certificate> getPkixTrustAnchors();

    public long getAuthnRequestTime();

    public String[] getPkixTrustedIssuers();

    public boolean isEnabled();

    public String getRealmName();

    public boolean isHttpsRequired();

    public boolean isAllowCustomCacheKey();

    public String getSpHostAndPort();

    public boolean createSession();

    public String getCspHeader();

    public void setConfigAdmin(ConfigurationAdmin var1);

    public Collection<X509CRL> getX509Crls();

    public String getHeaderName();

    public ArrayList<String> getHeaderNames();

    public String[] getAudiences();

    public boolean isReAuthnOnAssertionExpire();

    public long getReAuthnCushion();

    public String getTargetPageUrl();

    public boolean getUseRelayStateForTarget();

    public String getPostLogoutRedirectUrl();

    public boolean isServletRequestLogoutPerformsSamlLogout();
}

