/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.rest.APIRoot;
import com.ibm.ws.ui.internal.rest.AdminCenterRestHandler;
import com.ibm.ws.ui.internal.rest.HTTPConstants;
import com.ibm.ws.ui.internal.rest.v1.CatalogAPI;
import com.ibm.ws.ui.internal.rest.v1.DeployValidation;
import com.ibm.ws.ui.internal.rest.v1.IconRestHandler;
import com.ibm.ws.ui.internal.rest.v1.ToolDataAPI;
import com.ibm.ws.ui.internal.rest.v1.ToolboxAPI;
import com.ibm.ws.ui.internal.rest.v1.V1Root;
import com.ibm.ws.ui.internal.rest.v1.utils.FeatureUtils;
import com.ibm.ws.ui.internal.rest.v1.utils.URLUtils;
import com.ibm.ws.ui.internal.rest.v1.utils.UtilsRoot;
import com.ibm.ws.ui.internal.v1.ICatalogService;
import com.ibm.ws.ui.internal.v1.IFeatureToolService;
import com.ibm.ws.ui.internal.v1.IToolDataService;
import com.ibm.ws.ui.internal.v1.IToolboxService;
import com.ibm.ws.ui.internal.v1.utils.Utils;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.root=/adminCenter", "com.ibm.wsspi.rest.handler.custom.security=true"})
public class AdminCenterRouter
implements RESTHandler,
HTTPConstants {
    private static final transient TraceComponent tc = Tr.register(AdminCenterRouter.class);
    private ICatalogService catalogService;
    private IToolboxService toolboxService;
    private IToolDataService tooldataService;
    private IFeatureToolService featureToolService;
    private Map<String, AdminCenterRestHandler> handlers;

    public AdminCenterRouter() {
    }

    @Reference(service=ICatalogService.class)
    protected void setICatalogService(ICatalogService catalogService) {
        this.catalogService = catalogService;
    }

    protected void unsetICatalogService(ICatalogService catalogService) {
        if (this.catalogService == catalogService) {
            this.catalogService = null;
        }
    }

    @Reference(service=IToolboxService.class)
    protected void setIToolboxService(IToolboxService toolboxService) {
        this.toolboxService = toolboxService;
    }

    protected void unsetIToolboxService(IToolboxService toolboxService) {
        if (this.toolboxService == toolboxService) {
            this.toolboxService = null;
        }
    }

    @Reference(service=IToolDataService.class)
    protected void setITooldataService(IToolDataService tooldataService) {
        this.tooldataService = tooldataService;
    }

    protected void unsetITooldataService(IToolDataService tooldataService) {
        if (this.tooldataService == tooldataService) {
            this.tooldataService = null;
        }
    }

    @Reference(service=IFeatureToolService.class)
    protected void setIFeatureToolService(IFeatureToolService featureToolService) {
        this.featureToolService = featureToolService;
    }

    protected void unsetIFeatureToolService(IFeatureToolService featureToolService) {
        if (this.featureToolService == featureToolService) {
            this.featureToolService = null;
        }
    }

    private final void addHandler(Map<String, AdminCenterRestHandler> defaultHandlers, AdminCenterRestHandler handler) {
        defaultHandlers.put(handler.baseURL(), handler);
    }

    @Activate
    protected void activate() {
        HashMap<String, AdminCenterRestHandler> defaultHandlers = new HashMap<String, AdminCenterRestHandler>();
        this.addHandler(defaultHandlers, new APIRoot());
        this.addHandler(defaultHandlers, new V1Root());
        this.addHandler(defaultHandlers, new CatalogAPI(this.catalogService));
        this.addHandler(defaultHandlers, new ToolboxAPI(this.toolboxService));
        this.addHandler(defaultHandlers, new ToolDataAPI(this.tooldataService, this.toolboxService));
        this.addHandler(defaultHandlers, new UtilsRoot());
        this.addHandler(defaultHandlers, new FeatureUtils(this.featureToolService));
        this.addHandler(defaultHandlers, new URLUtils());
        this.addHandler(defaultHandlers, new IconRestHandler(this.featureToolService));
        this.addHandler(defaultHandlers, new DeployValidation());
        this.handlers = Collections.unmodifiableMap(defaultHandlers);
    }

    @Deactivate
    protected void deactivate() {
        this.handlers = null;
    }

    AdminCenterRouter(Map<String, AdminCenterRestHandler> handlers) {
        this.handlers = handlers;
    }

    private AdminCenterRestHandler getHandler(String requestURL) {
        if (requestURL == null) {
            return null;
        }
        if (this.handlers.keySet().isEmpty()) {
            return null;
        }
        AdminCenterRestHandler handler = this.handlers.get(requestURL);
        if (handler != null) {
            return handler;
        }
        String bestMatchRoot = "";
        for (Map.Entry<String, AdminCenterRestHandler> entry : this.handlers.entrySet()) {
            char nextChar;
            String key = entry.getKey();
            AdminCenterRestHandler keyHandler = entry.getValue();
            if (!requestURL.startsWith(key) || (nextChar = requestURL.charAt(key.length())) != '/' || requestURL.length() > key.length() + 1 && !keyHandler.hasChildren() || key.length() <= bestMatchRoot.length()) continue;
            bestMatchRoot = key;
        }
        if (bestMatchRoot.length() > 0) {
            return this.handlers.get(bestMatchRoot);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        AdminCenterRestHandler handler;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("REST request received from " + request.getRemoteHost() + ":" + request.getRemotePort() + " - path: " + request.getPath() + " - URI: " + request.getURI()), (Object[])new Object[0]);
        }
        if ((handler = this.getHandler(Utils.getPath(request))) != null) {
            try {
                RequestNLS.setRESTRequest(request);
                handler.handleRequest(request, response);
                this.setSecurityHeaders(response);
            }
            finally {
                RequestNLS.clearThreadLocal();
            }
        } else {
            response.setStatus(404);
        }
    }

    protected void setSecurityHeaders(RESTResponse response) {
        if (response != null) {
            response.setResponseHeader("X-XSS-Protection", "1");
            response.setResponseHeader("X-Content-Type-Options", "nosniff");
            response.setResponseHeader("X-Frame-Options", "SAMEORIGIN");
            response.setResponseHeader("Content-Security-Policy", "default-src 'self'; form-action 'self'; frame-ancestors 'self'");
        }
    }

    Map<String, AdminCenterRestHandler> getHandlers() {
        return this.handlers;
    }
}

