/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.joblog;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jbatch.joblog.JobExecutionLog;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.runtime.JobInstance;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JobInstanceLog {
    private final JobInstance jobInstance;
    private final List<File> instanceLogRootDirs;
    private final List<JobExecutionLog> jobExecutionLogs = new ArrayList<JobExecutionLog>();
    static final long serialVersionUID = -5611442038349513782L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JobInstanceLog(JobInstance jobInstance, List<File> rootDirs) {
        this.jobInstance = jobInstance;
        this.instanceLogRootDirs = rootDirs;
    }

    public List<File> getInstanceLogRootDirs() {
        return this.instanceLogRootDirs;
    }

    public void addJobExecutionLog(JobExecutionLog jobExecutionLog) {
        this.jobExecutionLogs.add(jobExecutionLog);
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public List<File> getJobLogFiles() {
        ArrayList<File> retMe = new ArrayList<File>();
        for (JobExecutionLog jobExecutionLog : this.jobExecutionLogs) {
            retMe.addAll(jobExecutionLog.getJobLogFiles());
        }
        return retMe;
    }

    public List<JobExecutionLog> getJobExecutionLogs() {
        return this.jobExecutionLogs;
    }

    public boolean purge() {
        boolean success = true;
        for (JobExecutionLog execLog : this.jobExecutionLogs) {
            success = success && execLog.purge();
        }
        for (final File instanceDir : this.instanceLogRootDirs) {
            Boolean isThere = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = -7372830553326583852L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return instanceDir.exists();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.JobInstanceLog$1", 1.class, null, null);
                }
            });
            if (success && isThere.booleanValue()) {
                success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                    static final long serialVersionUID = 7546659741384292281L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Boolean run() {
                        return instanceDir.delete();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.JobInstanceLog$2", 2.class, null, null);
                    }
                });
            }
            if (!success || !isThere.booleanValue()) continue;
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = -4627615512105200881L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return instanceDir.getParentFile().delete();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.JobInstanceLog$3", 3.class, null, null);
                }
            });
        }
        return success;
    }

    public boolean areExecutionsLocal() {
        for (JobExecutionLog execLog : this.jobExecutionLogs) {
            if (execLog.getLocalState() == JobExecutionLog.LogLocalState.EXECUTION_LOCAL) continue;
            return false;
        }
        return true;
    }

    public boolean hasRemotePartitionLogs() {
        for (JobExecutionLog execLog : this.jobExecutionLogs) {
            if (execLog.getRemotePartitionLogs() == null) continue;
            return true;
        }
        return false;
    }

    public HashSet<String> getRemotePartitionLogURLs() {
        HashSet<String> retMe = new HashSet<String>();
        for (JobExecutionLog execLog : this.jobExecutionLogs) {
            retMe.addAll(execLog.getRemotePartitionEndpointURLs());
        }
        return retMe;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.JobInstanceLog", JobInstanceLog.class, null, null);
    }
}

