/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class AliasChainValidator {
    private static final TraceComponent tc = SibTr.register(AliasChainValidator.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Collector collector = new Collector();

    public CompoundName getFirstInChain() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getFirstInChain");
        }
        CompoundName firstInChain = this.collector.getFirst();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getFirstInChain", (Object)firstInChain);
        }
        return firstInChain;
    }

    public void validate(String destName, String busName) throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"validate", (Object)new Object[]{destName, busName});
        }
        if (this.collector.contains(destName, busName)) {
            String chainText = this.toStringPlus(destName, busName);
            CompoundName firstInChain = this.getFirstInChain();
            String nlsMessage = nls.getFormattedMessage("ALIAS_CIRCULAR_DEPENDENCY_ERROR_CWSIP0621", new Object[]{firstInChain, chainText, busName}, null);
            SINotPossibleInCurrentConfigurationException e = new SINotPossibleInCurrentConfigurationException(nlsMessage);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"validate", (Object)nlsMessage);
            }
            throw e;
        }
        this.collector.add(destName, busName);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"validate");
        }
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"toString");
        }
        Set destinations = this.collector.keySet();
        Iterator iter = destinations.iterator();
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            sb.append((String)iter.next());
            if (!iter.hasNext()) continue;
            sb.append(" -> ");
        }
        String returnString = sb.toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"toString", (Object)returnString);
        }
        return returnString;
    }

    public String toStringPlus(String destName, String busName) {
        StringBuffer sb = new StringBuffer(this.toString());
        String compoundName = new CompoundName(destName, busName).toString();
        sb.append(" -> ");
        sb.append(compoundName);
        return sb.toString();
    }

    private class Collector
    extends LinkedHashMap {
        private static final long serialVersionUID = 2130290956123711056L;

        private Collector() {
        }

        private void add(String destName, String busName) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"add", (Object)new Object[]{destName, busName});
            }
            AliasChainValidator.this.collector.put(CompoundName.compound(destName, busName), new CompoundName(destName, busName));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"add");
            }
        }

        private boolean contains(String destName, String busName) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"contains", (Object)new Object[]{destName, busName});
            }
            boolean result = AliasChainValidator.this.collector.containsKey(CompoundName.compound(destName, busName));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"contains", (Object)new Boolean(result));
            }
            return result;
        }

        private CompoundName getFirst() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getFirst");
            }
            CompoundName dest = null;
            Collection collectorValues = AliasChainValidator.this.collector.values();
            if (collectorValues != null) {
                dest = (CompoundName)collectorValues.toArray()[0];
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getFirst", (Object)dest);
            }
            return dest;
        }
    }

    public static class CompoundName {
        private String destName;
        private String busName;
        private static final String SEPERATOR = ":";

        public CompoundName(String myDestName, String myBusName) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"CompoundName", (Object)new Object[]{myDestName, myBusName});
            }
            this.destName = myDestName;
            this.busName = myBusName;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"CompoundName", (Object)this);
            }
        }

        public static String compound(String destName, String busName) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"compound");
            }
            String compound = destName + SEPERATOR + busName;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"compound", (Object)compound);
            }
            return compound;
        }

        public String getBusName() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getBusName");
                SibTr.exit((TraceComponent)tc, (String)"getBusName", (Object)this.busName);
            }
            return this.busName;
        }

        public String getDestName() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getDestName");
                SibTr.exit((TraceComponent)tc, (String)"getDestName", (Object)this.destName);
            }
            return this.destName;
        }

        public String toString() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"toString");
            }
            String compound = CompoundName.compound(this.destName, this.busName);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"toString", (Object)compound);
            }
            return compound;
        }
    }
}

