/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.values;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.channel.internal.values.CookieData;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;

public class CookieMaxAgeData
extends CookieData {
    private static final TraceComponent tc = Tr.register(CookieMaxAgeData.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");

    public CookieMaxAgeData() {
        super("max-age");
    }

    @Override
    public boolean set(HttpCookie cookie, byte[] attribValue) {
        try {
            if (null != attribValue && 0 < attribValue.length) {
                cookie.setMaxAge(GenericUtils.asIntValue(attribValue));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Cookie max-age set to " + cookie.getMaxAge()), (Object[])new Object[0]);
                }
            }
            return true;
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"set", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error in cookie max-age attribute: " + String.valueOf(attribValue)), (Object[])new Object[0]);
            }
            return false;
        }
    }

    @Override
    public boolean validForHeader(HeaderKeys hdr, boolean includesDollar) {
        if (HttpHeaderKeys.HDR_SET_COOKIE.equals(hdr) || HttpHeaderKeys.HDR_SET_COOKIE2.equals(hdr)) {
            return !includesDollar;
        }
        return false;
    }
}

