/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.admin.JsAdminUtils;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SITransaction;

public class UserTrace {
    public static final TraceComponent tc_mt = SibTr.register(UserTrace.class, (String)"SIBMessageTrace", (String)"com.ibm.ws.sib.processor.CWSJUMessages");
    public static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");

    public static final void trace_Receive(SITransaction siTran, JsMessage message, SIDestinationAddress destAddr, long id) {
        if (message != null) {
            if (message.isApiMessage()) {
                String apiMsgId = null;
                String correlationId = null;
                if (message instanceof JsApiMessage) {
                    apiMsgId = ((JsApiMessage)message).getApiMessageId();
                    correlationId = ((JsApiMessage)message).getCorrelationId();
                } else {
                    if (message.getApiMessageIdAsBytes() != null) {
                        apiMsgId = new String(message.getApiMessageIdAsBytes());
                    }
                    if (message.getCorrelationIdAsBytes() != null) {
                        correlationId = new String(message.getCorrelationIdAsBytes());
                    }
                }
                if (siTran != null) {
                    if (tc_mt.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc_mt, (String)nls_mt.getFormattedMessage("CONSUMER_RECEIVE_CWSJU0040", new Object[]{apiMsgId, message.getSystemMessageId(), correlationId, new Long(id), destAddr.getDestinationName(), ((TransactionCommon)siTran).getPersistentTranId()}, null));
                    }
                } else if (tc_mt.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc_mt, (String)nls_mt.getFormattedMessage("CONSUMER_RECEIVE_NO_TRAN_CWSJU0041", new Object[]{apiMsgId, message.getSystemMessageId(), correlationId, new Long(id), destAddr.getDestinationName()}, null));
                }
            }
        } else if (siTran != null) {
            if (tc_mt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc_mt, (String)nls_mt.getFormattedMessage("CONSUMER_RECEIVE_NO_MESSAGE_CWSJU0042", new Object[]{new Long(id), destAddr.getDestinationName(), ((TransactionCommon)siTran).getPersistentTranId()}, null));
            }
        } else if (tc_mt.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc_mt, (String)nls_mt.getFormattedMessage("CONSUMER_RECEIVE_NO_MESSAGE_NO_TRAN_CWSJU0043", new Object[]{new Long(id), destAddr.getDestinationName()}, null));
        }
    }

    public static final void traceOutboundSend(JsMessage jsMsg, SIBUuid8 targetMEUuid, String destName, boolean foreignBus, boolean mqLink, boolean temporary) {
        if (jsMsg.isApiMessage()) {
            String apiMsgId = null;
            String correlationId = null;
            String msg = "OUTBOUND_MESSAGE_SENT_CWSJU0021";
            if (foreignBus) {
                msg = "OUTBOUND_MESSAGE_SENT_CWSJU0023";
            } else if (mqLink) {
                msg = "OUTBOUND_MESSAGE_SENT_CWSJU0024";
            } else if (temporary) {
                msg = "OUTBOUND_MESSAGE_SENT_TEMP_CWSJU0121";
            }
            if (jsMsg instanceof JsApiMessage) {
                apiMsgId = ((JsApiMessage)jsMsg).getApiMessageId();
                correlationId = ((JsApiMessage)jsMsg).getCorrelationId();
            } else {
                if (jsMsg.getApiMessageIdAsBytes() != null) {
                    apiMsgId = new String(jsMsg.getApiMessageIdAsBytes());
                }
                if (jsMsg.getCorrelationIdAsBytes() != null) {
                    correlationId = new String(jsMsg.getCorrelationIdAsBytes());
                }
            }
            String meName = null;
            if (!foreignBus) {
                meName = JsAdminUtils.getMENameByUuidForMessage((String)targetMEUuid.toString());
            }
            if (meName == null) {
                meName = targetMEUuid.toString();
            }
            if (tc_mt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc_mt, (String)nls_mt.getFormattedMessage(msg, new Object[]{apiMsgId, jsMsg.getSystemMessageId(), correlationId, meName, destName}, null));
            }
        }
    }

    public static final void forwardJSMessage(JsMessage jsMsg, SIBUuid8 targetMEUuid, String destName, boolean temporary) {
        if (jsMsg.isApiMessage()) {
            String apiMsgId = null;
            String correlationId = null;
            String msg = "MESSAGE_FORWARDED_CWSJU0022";
            if (temporary) {
                msg = "MESSAGE_FORWARDED_TEMP_CWSJU0122";
            }
            if (jsMsg instanceof JsApiMessage) {
                apiMsgId = ((JsApiMessage)jsMsg).getApiMessageId();
                correlationId = ((JsApiMessage)jsMsg).getCorrelationId();
            } else {
                if (jsMsg.getApiMessageIdAsBytes() != null) {
                    apiMsgId = new String(jsMsg.getApiMessageIdAsBytes());
                }
                if (jsMsg.getCorrelationIdAsBytes() != null) {
                    correlationId = new String(jsMsg.getCorrelationIdAsBytes());
                }
            }
            String meName = targetMEUuid.toString();
            if (tc_mt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc_mt, (String)nls_mt.getFormattedMessage(msg, new Object[]{apiMsgId, jsMsg.getSystemMessageId(), correlationId, meName, destName}, null));
            }
        }
    }
}

