/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlCardinalityInfo;
import com.ibm.ws.sib.mfp.control.ControlCreateDurable;
import com.ibm.ws.sib.mfp.control.ControlCreateStream;
import com.ibm.ws.sib.mfp.control.ControlDeleteDurable;
import com.ibm.ws.sib.mfp.control.ControlDurableConfirm;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.processor.MPSelectionCriteria;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.DurableConstants;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.HashMap;
import java.util.Map;

public class DurableInputHandler
implements InputHandler,
ControlHandler,
DurableConstants {
    private static final TraceComponent tc = SibTr.register(DurableInputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static Map<Long, Object[]> _requestMap = new HashMap<Long, Object[]>();
    private static AlarmListener _alarmHandler = new AlarmListener(){

        public void alarm(Object arg) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)arg);
            }
            DurableInputHandler.internalAlarmHandler(arg);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    };
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    private DurableInputHandler() {
    }

    @Override
    public void handleMessage(MessageItem msg, TransactionCommon transaction, SIBUuid8 sourceMEUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleMessage", (Object)new Object[]{msg, transaction, sourceMEUuid});
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:143:1.52.1.1"}, null));
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DurableInputHandler.handleMessage", (String)"1:150:1.52.1.1", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:158:1.52.1.1"});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage", (Object)((Object)e));
        }
        throw e;
    }

    @Override
    public void handleControlMessage(SIBUuid8 sourceMEUuid, ControlMessage cMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{sourceMEUuid, cMsg});
        }
        InvalidOperationException e = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:183:1.52.1.1"}, null));
        FFDCFilter.processException((Throwable)((Object)e), (String)"com.ibm.ws.sib.processor.impl.DurableInputHandler.handleControlMessage", (String)"1:190:1.52.1.1", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:197:1.52.1.1"});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage", (Object)((Object)e));
        }
        throw e;
    }

    public static void staticHandleControlMessage(ControlMessage cMsg) {
        ControlMessageType type;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"staticHandleControlMessage", (Object)new Object[]{cMsg});
        }
        if ((type = cMsg.getControlMessageType()) == ControlMessageType.NOTFLUSHED || type == ControlMessageType.CARDINALITYINFO || type == ControlMessageType.DURABLECONFIRM) {
            long reqID = 0L;
            if (cMsg instanceof ControlNotFlushed) {
                reqID = ((ControlNotFlushed)cMsg).getRequestID();
            } else if (cMsg instanceof ControlCardinalityInfo) {
                reqID = ((ControlCardinalityInfo)cMsg).getRequestID();
            } else if (cMsg instanceof ControlDurableConfirm) {
                reqID = ((ControlDurableConfirm)cMsg).getRequestID();
            }
            DurableInputHandler.wakeupWaiter(reqID, cMsg);
        } else {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:245:1.52.1.1"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DurableInputHandler.staticHandleControlMessage", (String)"1:252:1.52.1.1", DurableInputHandler.class);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:258:1.52.1.1"});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"staticHandleControlMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static void wakeupWaiter(long reqID, Object result) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"wakeupWaiter", (Object)new Object[]{new Long(reqID), result});
        }
        Map<Long, Object[]> map = _requestMap;
        // MONITORENTER : map
        Long key = new Long(reqID);
        Object[] waiter = _requestMap.get(key);
        if (waiter != null) {
            waiter[0] = result;
            _requestMap.remove(key);
            Object[] objectArray = waiter;
            // MONITORENTER : waiter
            waiter.notify();
            // MONITOREXIT : objectArray
        }
        // MONITOREXIT : map
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"wakeupWaiter");
    }

    protected static ControlCreateStream createDurableCreateStream(MessageProcessor MP, ConsumerDispatcherState subState, long reqID, SIBUuid8 dme) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDurableCreateStream", (Object)new Object[]{MP, subState, new Long(reqID), dme});
        }
        ControlCreateStream msg = null;
        try {
            msg = MessageProcessor.getControlMessageFactory().createNewControlCreateStream();
            DurableInputHandler.initializeControlMessage(MP.getMessagingEngineUuid(), (ControlMessage)msg, dme);
            msg.setRequestID(reqID);
            msg.setDurableSubName(subState.getSubscriberID());
            msg.setGuaranteedTargetDestinationDefinitionUUID(subState.getTopicSpaceUuid());
            SelectionCriteria criteria = subState.getSelectionCriteria();
            if (criteria == null || criteria.getDiscriminator() == null) {
                msg.setDurableDiscriminator(null);
            } else {
                msg.setDurableDiscriminator(criteria.getDiscriminator());
            }
            if (criteria == null || criteria.getSelectorString() == null) {
                msg.setDurableSelector(null);
            } else {
                msg.setDurableSelector(subState.getSelectionCriteria().getSelectorString());
            }
            if (criteria == null || criteria.getSelectorDomain() == null) {
                msg.setDurableSelectorDomain(SelectorDomain.SIMESSAGE.toInt());
            } else {
                msg.setDurableSelectorDomain(criteria.getSelectorDomain().toInt());
            }
            msg.setCloned(subState.isCloned());
            msg.setNoLocal(subState.isNoLocal());
            msg.setSecurityUserid(subState.getUser());
            msg.setSecurityUseridSentBySystem(subState.isSIBServerSubject());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DurableInputHandler.createDurableCreateStream", (String)"1:372:1.52.1.1", DurableInputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDurableCreateStream", (Object)msg);
        }
        return msg;
    }

    protected static ControlCreateDurable createDurableCreateDurable(MessageProcessor MP, ConsumerDispatcherState subState, long reqID, SIBUuid8 dme) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDurableCreateDurable", (Object)new Object[]{MP, subState, new Long(reqID), dme});
        }
        ControlCreateDurable msg = null;
        try {
            msg = MessageProcessor.getControlMessageFactory().createNewControlCreateDurable();
            DurableInputHandler.initializeControlMessage(MP.getMessagingEngineUuid(), (ControlMessage)msg, dme);
            msg.setRequestID(reqID);
            msg.setDurableSubName(subState.getSubscriberID());
            SelectionCriteria criteria = subState.getSelectionCriteria();
            if (criteria == null || criteria.getDiscriminator() == null) {
                msg.setDurableDiscriminator(null);
            } else {
                msg.setDurableDiscriminator(criteria.getDiscriminator());
            }
            if (criteria == null || criteria.getSelectorString() == null) {
                msg.setDurableSelector(null);
            } else {
                msg.setDurableSelector(subState.getSelectionCriteria().getSelectorString());
            }
            if (criteria == null || criteria.getSelectorDomain() == null) {
                msg.setDurableSelectorDomain(SelectorDomain.SIMESSAGE.toInt());
            } else {
                msg.setDurableSelectorDomain(criteria.getSelectorDomain().toInt());
            }
            if (criteria == null) {
                msg.setDurableSelectorNamespaceMap(null);
            } else if (criteria instanceof MPSelectionCriteria) {
                MPSelectionCriteria mpCriteria = (MPSelectionCriteria)criteria;
                Map selectorProperties = mpCriteria.getSelectorProperties();
                if (selectorProperties != null) {
                    Map selectorNamespaceMap = (Map)selectorProperties.get("namespacePrefixMappings");
                    if (selectorNamespaceMap != null) {
                        msg.setDurableSelectorNamespaceMap(selectorNamespaceMap);
                    } else {
                        msg.setDurableSelectorNamespaceMap(null);
                    }
                } else {
                    msg.setDurableSelectorNamespaceMap(null);
                }
            } else {
                msg.setDurableSelectorNamespaceMap(null);
            }
            msg.setCloned(subState.isCloned());
            msg.setNoLocal(subState.isNoLocal());
            msg.setSecurityUserid(subState.getUser());
            msg.setSecurityUseridSentBySystem(subState.isSIBServerSubject());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DurableInputHandler.createDurableCreateDurable", (String)"1:495:1.52.1.1", DurableInputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDurableCreateDurable", (Object)msg);
        }
        return msg;
    }

    protected static ControlDeleteDurable createDurableDeleteDurable(MessageProcessor MP, String subName, String userName, long reqID, SIBUuid8 dme) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDurableDeleteDurable", (Object)new Object[]{MP, subName, userName, new Long(reqID), dme});
        }
        ControlDeleteDurable msg = null;
        try {
            msg = MessageProcessor.getControlMessageFactory().createNewControlDeleteDurable();
            DurableInputHandler.initializeControlMessage(MP.getMessagingEngineUuid(), (ControlMessage)msg, dme);
            msg.setRequestID(reqID);
            msg.setDurableSubName(subName);
            msg.setSecurityUserid(userName);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DurableInputHandler.createDurableDeleteDurable", (String)"1:540:1.52.1.1", DurableInputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDurableDeleteDurable", (Object)msg);
        }
        return msg;
    }

    protected static void initializeControlMessage(SIBUuid8 sourceME, ControlMessage msg, SIBUuid8 remoteMEId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeControlMessage", (Object)new Object[]{sourceME, msg, remoteMEId});
        }
        SIMPUtils.setGuaranteedDeliveryProperties(msg, sourceME, remoteMEId, null, null, null, ProtocolType.DURABLEOUTPUT, GDConfig.PROTOCOL_VERSION);
        msg.setPriority(11);
        msg.setReliability(SIMPConstants.CONTROL_MESSAGE_RELIABILITY);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeControlMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object issueRequest(MessageProcessor MP, ControlMessage msg, SIBUuid8 remoteUuid, long retry, int tries, long requestID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueRequest", (Object)new Object[]{MP, msg, remoteUuid, new Long(retry), new Integer(tries), new Long(requestID)});
        }
        if (!MP.getMPIO().isMEReachable(remoteUuid)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"issueRequest", null);
            }
            return null;
        }
        Object[] awaitResult = new Object[1];
        Object[] objectArray = _requestMap;
        synchronized (_requestMap) {
            _requestMap.put(new Long(requestID), awaitResult);
            // ** MonitorExit[var9_7] (shouldn't be in output)
            objectArray = awaitResult;
            synchronized (awaitResult) {
                MP.getMPIO().sendToMe(remoteUuid, 11, (AbstractMessage)msg);
                ResendRecord retryRecord = new ResendRecord(MP, msg, remoteUuid, retry, tries, requestID);
                MP.getAlarmManager().create(retry, _alarmHandler, retryRecord);
                while (true) {
                    try {
                        awaitResult.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                // ** MonitorExit[var9_7] (shouldn't be in output)
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"issueRequest", (Object)awaitResult[0]);
                }
                return awaitResult[0];
            }
        }
    }

    public static ControlNotFlushed issueCreateStreamRequest(MessageProcessor MP, ConsumerDispatcherState subState, SIBUuid12 destID, SIBUuid8 destME) throws SIResourceException, SIDestinationLockedException, SIDurableSubscriptionNotFoundException, SINotAuthorizedException, SIDurableSubscriptionMismatchException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)new Object[]{MP, subState, destID});
        }
        long requestID = MP.nextTick();
        SIBUuid8 durHomeID = destME;
        ControlCreateStream msg = DurableInputHandler.createDurableCreateStream(MP, subState, requestID, durHomeID);
        msg.setGuaranteedTargetDestinationDefinitionUUID(destID);
        Object result = DurableInputHandler.issueRequest(MP, (ControlMessage)msg, durHomeID, 3000L, -1, requestID);
        if (result == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)"SIResourceException");
            }
            throw new SIResourceException(nls.getFormattedMessage("REMOTE_DURABLE_TIMEOUT_ERROR_CWSIP0631", new Object[]{"attach", subState.getSubscriberID(), subState.getDurableHome()}, null));
        }
        if (result instanceof ControlCardinalityInfo) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)"SIDurableSubscriptionLockedException");
            }
            throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{subState.getSubscriberID(), subState.getDurableHome()}, null));
        }
        if (result instanceof ControlDurableConfirm) {
            int status = ((ControlDurableConfirm)result).getStatus();
            if (status == 3) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)"SIDurableSubscriptionNotFoundException");
                }
                throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0146", new Object[]{subState.getSubscriberID(), subState.getDurableHome()}, null));
            }
            if (status == 5) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)"SINotAuthorizedException");
                }
                throw new SINotAuthorizedException(nls.getFormattedMessage("USER_NOT_AUTH_ACTIVATE_ERROR_CWSIP0312", new Object[]{subState.getUser(), subState.getSubscriberID(), subState.getTopicSpaceUuid()}, null));
            }
            if (status == 6) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)"SIDurableSubscriptionMismatchException");
                }
                throw new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("SUBSCRIPTION_ALREADY_EXISTS_ERROR_CWSIP0143", new Object[]{subState.getSubscriberID(), subState.getDurableHome()}, null));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:751:1.52.1.1"});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:758:1.52.1.1"}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)result);
        }
        return (ControlNotFlushed)result;
    }

    public static int issueCreateDurableRequest(MessageProcessor MP, ConsumerDispatcherState subState, SIBUuid8 remoteMEUuid, SIBUuid12 destinationID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueCreateDurableRequest", (Object)new Object[]{MP, subState, remoteMEUuid, destinationID});
        }
        long requestID = MP.nextTick();
        ControlCreateDurable msg = DurableInputHandler.createDurableCreateDurable(MP, subState, requestID, remoteMEUuid);
        msg.setGuaranteedTargetDestinationDefinitionUUID(destinationID);
        Object result = DurableInputHandler.issueRequest(MP, (ControlMessage)msg, remoteMEUuid, 3000L, -1, requestID);
        if (result == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"issueCreateDurableRequest", (Object)"SIResourceException");
            }
            throw new SIResourceException(nls.getFormattedMessage("REMOTE_DURABLE_TIMEOUT_ERROR_CWSIP0631", new Object[]{"create", subState.getSubscriberID(), subState.getDurableHome()}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueCreateDurableRequest", (Object)new Integer(((ControlDurableConfirm)result).getStatus()));
        }
        return ((ControlDurableConfirm)result).getStatus();
    }

    public static int issueDeleteDurableRequest(MessageProcessor MP, String subName, String userName, SIBUuid8 remoteMEUuid) throws SIResourceException {
        long requestID;
        ControlDeleteDurable msg;
        Object result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueDeleteDurableRequest", (Object)new Object[]{MP, subName, userName, remoteMEUuid});
        }
        if ((result = DurableInputHandler.issueRequest(MP, (ControlMessage)(msg = DurableInputHandler.createDurableDeleteDurable(MP, subName, userName, requestID = MP.nextTick(), remoteMEUuid)), remoteMEUuid, 3000L, -1, requestID)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"issueDeleteDurableRequest", (Object)"SIResourceException");
            }
            throw new SIResourceException(nls.getFormattedMessage("REMOTE_DURABLE_TIMEOUT_ERROR_CWSIP0631", new Object[]{"delete", subName, remoteMEUuid}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueDeleteDurableRequest", (Object)new Integer(((ControlDurableConfirm)result).getStatus()));
        }
        return ((ControlDurableConfirm)result).getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void internalAlarmHandler(Object arg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalAlarmHandler", (Object)arg);
        }
        ResendRecord record = (ResendRecord)arg;
        Map<Long, Object[]> map = _requestMap;
        synchronized (map) {
            Long key = new Long(record.requestID);
            if (_requestMap.containsKey(key)) {
                if (record.triesRemaining != 0) {
                    if (!record.MP.getMPIO().isMEReachable(record.targetUuid)) {
                        DurableInputHandler.wakeupWaiter(record.requestID, null);
                    }
                    record.MP.getMPIO().sendToMe(record.targetUuid, 11, (AbstractMessage)record.msg);
                    if (record.triesRemaining > 0) {
                        --record.triesRemaining;
                    }
                    record.MP.getAlarmManager().create(record.resendInterval, _alarmHandler, record);
                } else {
                    DurableInputHandler.wakeupWaiter(record.requestID, null);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalAlarmHandler");
        }
    }

    public static void createRemoteDurableSubscription(MessageProcessor MP, ConsumerDispatcherState subState, SIBUuid8 remoteMEUuid, SIBUuid12 destinationID) throws SIDurableSubscriptionAlreadyExistsException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemoteDurableSubscription", (Object)new Object[]{MP, subState, remoteMEUuid, destinationID});
        }
        int status = DurableInputHandler.issueCreateDurableRequest(MP, subState, remoteMEUuid, destinationID);
        switch (status) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createRemoteDurableSubscription", (Object)"SIDurableSubscriptionAlreadyExistsException");
                }
                throw new SIDurableSubscriptionAlreadyExistsException(nls.getFormattedMessage("SUBSCRIPTION_ALREADY_EXISTS_ERROR_CWSIP0143", new Object[]{subState.getSubscriberID(), subState.getDurableHome()}, null));
            }
            case 2: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createRemoteDurableSubscription", (Object)"SIErrorException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:955:1.52.1.1"});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:962:1.52.1.1"}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemoteDurableSubscription");
        }
    }

    public static void deleteRemoteDurableSub(MessageProcessor MP, String subName, String userName, SIBUuid8 remoteMEUuid) throws SIResourceException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException, SINotAuthorizedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteRemoteDurableSub", (Object)new Object[]{MP, subName, userName, remoteMEUuid});
        }
        int status = DurableInputHandler.issueDeleteDurableRequest(MP, subName, userName, remoteMEUuid);
        switch (status) {
            case 3: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableSub", (Object)"SIDurableSubscriptionNotFoundException");
                }
                throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{subName, remoteMEUuid}, null));
            }
            case 4: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableSub", (Object)"SIDurableSubscriptionLockedException");
                }
                throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{subName, remoteMEUuid}, null));
            }
            case 5: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableSub", (Object)"SINotAuthorizedException");
                }
                throw new SINotAuthorizedException(nls.getFormattedMessage("USER_NOT_AUTH_DELETE_ERROR_CWSIP0311", new Object[]{userName, subName, null}, null));
            }
            case 7: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableSub", (Object)"SIDestinationLockedException");
                }
                throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0153", new Object[]{subName, remoteMEUuid}, null));
            }
            case 2: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableSub", (Object)"SIResourceException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:1053:1.52.1.1"});
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:1060:1.52.1.1"}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableSub");
        }
    }

    @Override
    public long handleControlMessageWithReturnValue(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIIncorrectCallException, SIResourceException, SIConnectionLostException, SIRollbackException {
        return 0L;
    }

    static class ResendRecord {
        MessageProcessor MP;
        ControlMessage msg;
        SIBUuid8 targetUuid;
        long resendInterval;
        int triesRemaining;
        long requestID;

        public ResendRecord(MessageProcessor MP, ControlMessage M, SIBUuid8 T, long resend, int tries, long req) {
            this.MP = MP;
            this.msg = M;
            this.targetUuid = T;
            this.resendInterval = resend;
            this.triesRemaining = tries;
            this.requestID = req;
        }
    }
}

