/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.StringArrayWrapper;
import com.ibm.ws.sib.api.jmsra.JmsJcaReferenceUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class JmsJcaReferenceUtilsImpl
extends JmsJcaReferenceUtils {
    private static TraceComponent TRACE = SibTr.register(JmsJcaReferenceUtilsImpl.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static final String FFDC_PROBE_1 = "1";
    private static final String PREFIX_NULL = "NULL";
    private static final String PREFIX_BOOLEAN = "BOOL";
    private static final String PREFIX_INT = "INT";
    private static final String PREFIX_BYTE = "BYTE";
    private static final String PREFIX_SHORT = "SHORT";
    private static final String PREFIX_STRING = "STRING";
    private static final String PREFIX_FLOAT = "FLOAT";
    private static final String PREFIX_DOUBLE = "DOUBLE";
    private static final String PREFIX_LONG = "LONG";
    private static final String PREFIX_ROUTING_PATH = "ROUTINGPATH";
    private static final String PREFIX_SEPARATOR = "_";
    private static Map<Class, String> prefixTable = null;

    public void populatePrefixTable() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"populatePrefixTable");
        }
        prefixTable = new HashMap<Class, String>();
        prefixTable.put(Boolean.class, PREFIX_BOOLEAN);
        prefixTable.put(Integer.class, PREFIX_INT);
        prefixTable.put(Byte.class, PREFIX_BYTE);
        prefixTable.put(Short.class, PREFIX_SHORT);
        prefixTable.put(String.class, PREFIX_STRING);
        prefixTable.put(Float.class, PREFIX_FLOAT);
        prefixTable.put(Double.class, PREFIX_DOUBLE);
        prefixTable.put(Long.class, PREFIX_LONG);
        prefixTable.put(StringArrayWrapper.class, PREFIX_ROUTING_PATH);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"populatePrefixTable");
        }
    }

    @Override
    public Map<String, String> getStringEncodedMap(Map raw, Map defaults) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getStringEncodedMap", (Object)new Object[]{raw, defaults});
        }
        HashMap<String, String> encodedMap = new HashMap<String, String>();
        for (String key : raw.keySet()) {
            if (key == null) continue;
            Object val = raw.get(key);
            if (prefixTable == null) {
                this.populatePrefixTable();
            }
            if (defaults.containsKey(key) && defaults.get(key) != null && defaults.get(key).equals(val)) continue;
            String prefix = null;
            String strForm = null;
            if (val == null) {
                prefix = PREFIX_NULL;
                strForm = null;
            } else {
                prefix = prefixTable.get(val.getClass());
                if (prefix == null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)TRACE, (String)("unsupported type for property: " + val.getClass().getName()));
                    continue;
                }
                strForm = val.toString();
            }
            String prefixedKey = prefix + PREFIX_SEPARATOR + key;
            encodedMap.put(prefixedKey, strForm);
            if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) continue;
            SibTr.debug((TraceComponent)TRACE, (String)("encoded: " + prefixedKey + " = '" + strForm + "'"));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getStringEncodedMap", encodedMap);
        }
        return encodedMap;
    }

    @Override
    public Map getStringDecodedMap(Map encodedMap, Map defaults) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getStringDecodedMap", (Object)new Object[]{encodedMap, defaults});
        }
        HashMap<String, String> decoded = new HashMap<String, String>();
        decoded.putAll(defaults);
        Iterator keyList = encodedMap.keySet().iterator();
        while (keyList.hasNext()) {
            String propName = null;
            Object propVal = null;
            String encodedKey = (String)keyList.next();
            String encodedVal = (String)encodedMap.get(encodedKey);
            String prefix = null;
            int sepIndex = encodedKey.indexOf(PREFIX_SEPARATOR);
            if (sepIndex == -1) {
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)TRACE, (String)("Ignoring malformed encoded name: " + encodedKey));
                continue;
            }
            prefix = encodedKey.substring(0, sepIndex);
            propName = encodedKey.substring(sepIndex + PREFIX_SEPARATOR.length());
            try {
                if (PREFIX_NULL.equals(prefix)) {
                    propVal = null;
                } else if (PREFIX_STRING.equals(prefix)) {
                    propVal = encodedVal;
                    if (propVal == null) {
                        propVal = "";
                    }
                } else if (PREFIX_BOOLEAN.equals(prefix)) {
                    propVal = Boolean.valueOf(encodedVal);
                } else if (PREFIX_INT.equals(prefix)) {
                    propVal = Integer.valueOf(encodedVal);
                } else if (PREFIX_BYTE.equals(prefix)) {
                    propVal = Byte.valueOf(encodedVal);
                } else if (PREFIX_SHORT.equals(prefix)) {
                    propVal = Short.valueOf(encodedVal);
                } else if (PREFIX_FLOAT.equals(prefix)) {
                    propVal = Float.valueOf(encodedVal);
                } else if (PREFIX_DOUBLE.equals(prefix)) {
                    propVal = Double.valueOf(encodedVal);
                } else if (PREFIX_LONG.equals(prefix)) {
                    propVal = Long.valueOf(encodedVal);
                } else if (PREFIX_ROUTING_PATH.equals(prefix)) {
                    String[] array = encodedVal.split("<#>");
                    String bigDestName = (String)encodedMap.get("STRING_DEST_NAME");
                    propVal = StringArrayWrapper.create(array, bigDestName);
                } else {
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)TRACE, (String)("Ignoring unknown prefix: " + prefix));
                    continue;
                }
                decoded.put(propName, (String)propVal);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)TRACE, (String)("retrieved: " + propName + " = " + propVal));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.api.jmsra.impl.JmsJcaReferenceUtilsImpl.getStringDecodedMap", (String)FFDC_PROBE_1, (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)TRACE, (String)"Error decoding string to object. ", (Object)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getStringDecodedMap", decoded);
        }
        return decoded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getMapFromReference(Reference ref, Map defaults) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getMapFromReference", (Object)new Object[]{ref, defaults});
        }
        Map extractedProps = null;
        Reference reference = ref;
        synchronized (reference) {
            Enumeration<RefAddr> propsList = ref.getAll();
            HashMap<String, String> encodedMap = new HashMap<String, String>();
            while (propsList.hasMoreElements()) {
                StringRefAddr refAddr = (StringRefAddr)propsList.nextElement();
                String codedName = refAddr.getType();
                String val = (String)refAddr.getContent();
                encodedMap.put(codedName, val);
            }
            extractedProps = this.getStringDecodedMap(encodedMap, defaults);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getMapFromReference", (Object)extractedProps);
        }
        return extractedProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateReference(Reference reference, Map properties, Map defaults) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"populateReference", (Object)new Object[]{reference, properties, defaults});
        }
        Map map = properties;
        synchronized (map) {
            Map<String, String> encodedMap = this.getStringEncodedMap(properties, defaults);
            for (Map.Entry<String, String> entry : encodedMap.entrySet()) {
                reference.add(new StringRefAddr(entry.getKey(), entry.getValue()));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"populateReference");
        }
    }
}

