/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.BaseSIXAResourceProxy;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ClientLinkLevelState;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.util.HashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SIXAResourceProxy
extends BaseSIXAResourceProxy {
    private static String CLASS_NAME = SIXAResourceProxy.class.getName();
    private static final TraceComponent tc = SibTr.register(SIXAResourceProxy.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private SIXAResourceProxy joinedResource = null;
    private ResourceState state = ResourceState.UNENLISTED;
    private boolean endHasBeenCalled = false;

    public SIXAResourceProxy(Conversation conv, ConnectionProxy cp, boolean isMSResource) {
        super(conv, cp, isMSResource);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public boolean isEnlisted() {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isEnlisted");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Current state = " + (Object)((Object)this.state)));
        }
        boolean bl = result = this.state == ResourceState.ENLISTED || this.state == ResourceState.JOINED;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isEnlisted", (Object)("" + result));
        }
        return result;
    }

    @Override
    void setEnlisted(Xid enlistedXid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setEnlisted", (Object)enlistedXid);
        }
        this.state = enlistedXid == null ? ResourceState.UNENLISTED : (this.joinedResource != null ? ResourceState.JOINED : ResourceState.ENLISTED);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("State is now = " + (Object)((Object)this.state)));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setEnlisted");
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commit", (Object)new Object[]{xid, "" + onePhase});
        }
        this.internalCommit(xid, onePhase);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"end", (Object)new Object[]{xid, "" + flags});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Current state = " + (Object)((Object)this.state)));
        }
        if (this.state == ResourceState.UNENLISTED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"We are not enlisted - rejecting this call");
            }
            throw new XAException(-6);
        }
        if (this.state == ResourceState.JOINED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"state == JOINED. Unjoining the resource.");
            }
            this.joinedResource.unjoin(this);
        }
        boolean performEndNow = false;
        if (this.joinedResource != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Joined resource state: " + (Object)((Object)this.joinedResource.state)));
            }
            performEndNow = !this.joinedResource.hasJoinedResources() && this.joinedResource.endHasBeenCalled;
        } else {
            boolean bl = performEndNow = !this.hasJoinedResources();
        }
        if (performEndNow) {
            HashMap<Xid, SIXAResourceProxy> map;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Ending the resource.");
            }
            this.internalEnd(xid, flags);
            HashMap<Xid, SIXAResourceProxy> hashMap = map = this.getLinkLevelXAResourceMap();
            synchronized (hashMap) {
                map.remove(xid);
            }
        }
        this.state = ResourceState.UNENLISTED;
        this.joinedResource = null;
        this.endHasBeenCalled = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"end");
        }
    }

    public void forget(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"forget", (Object)xid);
        }
        this.internalForget(xid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"forget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionTimeout() throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionTimeout");
        }
        int timeout = 0;
        try {
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putInt(this.getTransactionId());
            CommsByteBuffer reply = this.jfapExchange(request, 56, 7, true);
            try {
                reply.checkXACommandCompletionStatus(184, this.getConversation());
                timeout = reply.getInt();
            }
            finally {
                if (reply != null) {
                    reply.release();
                }
            }
        }
        catch (XAException xa) {
            throw xa;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getTransactionTimeout"), (String)"1-007-0004", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Caught a comms problem:", (Object)e);
            }
            throw new XAException(-7);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionTimeout", (Object)("" + timeout));
        }
        return timeout;
    }

    public int prepare(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepare", (Object)xid);
        }
        int result = this.internalPrepare(xid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)("" + result));
        }
        return result;
    }

    public Xid[] recover(int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"recover", (Object)("" + flags));
        }
        Xid[] result = this.internalRecover(flags);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"recover", (Object)result);
        }
        return result;
    }

    public void rollback(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object)xid);
        }
        this.internalRollback(xid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTransactionTimeout(int timeout) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTransactionTimeout", (Object)("" + timeout));
        }
        boolean success = false;
        try {
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putInt(this.getTransactionId());
            request.putInt(timeout);
            CommsByteBuffer reply = this.jfapExchange(request, 57, 7, true);
            try {
                reply.checkXACommandCompletionStatus(185, this.getConversation());
                if (reply.get() == 1) {
                    success = true;
                }
            }
            finally {
                if (reply != null) {
                    reply.release();
                }
            }
        }
        catch (XAException xa) {
            throw xa;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setTransactionTimeout"), (String)"1-007-0008", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught a comms problem:", (Object)e);
            }
            throw new XAException(-7);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTransactionTimeout", (Object)("" + success));
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)new Object[]{xid, "" + flags});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Current state = " + (Object)((Object)this.state)));
        }
        if (this.state == ResourceState.ENLISTED || this.state == ResourceState.JOINED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"We are already enlisted - rejecting this call");
            }
            throw new XAException(-6);
        }
        if ((flags & 0x200000) == 0x200000) {
            HashMap<Xid, SIXAResourceProxy> map;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"TMJOIN was specified");
            }
            HashMap<Xid, SIXAResourceProxy> hashMap = map = this.getLinkLevelXAResourceMap();
            synchronized (hashMap) {
                this.joinedResource = map.get(xid);
            }
            if (this.joinedResource == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"The resource cannot be joined as it doesn't exist");
                }
                throw new XAException(-5);
            }
            this.state = ResourceState.JOINED;
            this.joinedResource.join(this);
        } else {
            HashMap<Xid, SIXAResourceProxy> map;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Performing a normal start");
            }
            this.internalStart(xid, flags);
            this.state = ResourceState.ENLISTED;
            HashMap<Xid, SIXAResourceProxy> hashMap = map = this.getLinkLevelXAResourceMap();
            synchronized (hashMap) {
                map.put(xid, this);
            }
        }
        this.endHasBeenCalled = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        boolean result;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"isSameRM", (Object)xaRes);
            }
            result = false;
            if (xaRes instanceof SIXAResourceProxy) {
                try {
                    SICoreConnection thisConnection = ((ClientConversationState)this.getConversation().getAttachment()).getSICoreConnection();
                    SICoreConnection otherConnection = ((ClientConversationState)((SIXAResourceProxy)((Object)xaRes)).getConversation().getAttachment()).getSICoreConnection();
                    result = thisConnection.isEquivalentTo(otherConnection);
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    SibTr.debug((TraceComponent)tc, (String)"Caught an exception comparing the connections", (Object)t);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSameRM", (Object)("" + result));
        }
        return result;
    }

    private HashMap<Xid, SIXAResourceProxy> getLinkLevelXAResourceMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLinkLevelXAResourceMap");
        }
        HashMap<Xid, SIXAResourceProxy> map = ((ClientLinkLevelState)this.getConversation().getLinkLevelAttachment()).getXidToXAResourceMap();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLinkLevelXAResourceMap", map);
        }
        return map;
    }

    @Override
    public short getLowestMessagePriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLowestMessagePriority");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Current state = " + (Object)((Object)this.state)));
        }
        short result = this.state == ResourceState.JOINED ? this.joinedResource.getLowestMessagePriority() : super.getLowestMessagePriority();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLowestMessagePriority", (Object)result);
        }
        return result;
    }

    @Override
    public int getTransactionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Current state = " + (Object)((Object)this.state)));
        }
        int result = this.state == ResourceState.JOINED ? this.joinedResource.getTransactionId() : super.getTransactionId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionId", (Object)result);
        }
        return result;
    }

    @Override
    public void updateLowestMessagePriority(short messagePriority) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateLowestMessagePriority", (Object)messagePriority);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Current state = " + (Object)((Object)this.state)));
        }
        if (this.state == ResourceState.JOINED) {
            this.joinedResource.updateLowestMessagePriority(messagePriority);
        } else {
            super.updateLowestMessagePriority(messagePriority);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateLowestMessagePriority");
        }
    }

    public String toString() {
        return super.toString() + "[commsTx=" + this.getTransactionId() + "]";
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/SIXAResourceProxy.java, SIB.comms, WASX.SIB, uu1215.01 1.41");
        }
    }

    private static enum ResourceState {
        ENLISTED,
        UNENLISTED,
        JOINED;

    }
}

