/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.ws.logging.internal.TraceSpecification;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.FileLogSet;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoggingFileUtils {
    static String[] safelyFindFiles(final File directory, final Pattern p) {
        String[] rc = null;
        try {
            rc = AccessController.doPrivileged(new PrivilegedExceptionAction<String[]>(){

                @Override
                public String[] run() throws Exception {
                    return directory.list(new RegexFilenameFilter(p));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    static File validateDirectory(File directory) {
        return LoggingFileUtils.validateDirectory(directory, true);
    }

    static File validateDirectory(final File directory, final boolean showError) {
        File newDirectory = null;
        try {
            newDirectory = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws Exception {
                    boolean ok = true;
                    if (!directory.exists()) {
                        boolean bl = ok = directory.mkdirs() || directory.exists();
                    }
                    if (!ok) {
                        LoggingFileUtils.showErrorMsg(showError, "UNABLE_TO_CREATE_RESOURCE_NOEX", new Object[]{directory.getAbsolutePath()});
                        return null;
                    }
                    return directory;
                }
            });
        }
        catch (PrivilegedActionException e) {
            LoggingFileUtils.showErrorMsg(showError, "UNABLE_TO_CREATE_RESOURCE", new Object[]{directory.getAbsolutePath(), e});
        }
        return newDirectory;
    }

    private static void showErrorMsg(boolean showError, String msgKey, Object[] objs) {
        if (showError) {
            String msg = Tr.formatMessage(TraceSpecification.getTc(), msgKey, objs);
            BaseTraceService.rawSystemErr.println(msg);
        }
    }

    public static File createNewFile(FileLogSet fileLogSet) {
        return LoggingFileUtils.createNewFile(fileLogSet, true);
    }

    public static File createNewFile(final FileLogSet fileLogSet, final boolean showError) {
        File directory = fileLogSet.getDirectory();
        String fileName = fileLogSet.getFileName();
        String fileExtension = fileLogSet.getFileExtension();
        File f = null;
        try {
            f = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws Exception {
                    return fileLogSet.createNewFile(showError);
                }
            });
        }
        catch (PrivilegedActionException e) {
            File exf = new File(directory, fileName + fileExtension);
            LoggingFileUtils.showErrorMsg(showError, "UNABLE_TO_CREATE_RESOURCE", new Object[]{exf.getAbsolutePath(), e});
        }
        return f;
    }

    static Pattern compileLogFileRegex(String baseName, String extension) {
        StringBuilder builder = new StringBuilder();
        builder.append(Pattern.quote(baseName));
        builder.append("(_\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d)");
        builder.append("(?:\\.(\\d+))");
        builder.append(Pattern.quote(extension));
        return Pattern.compile(builder.toString());
    }

    static final void deleteFile(File directory, String name) {
        LoggingFileUtils.deleteFile(new File(directory, name));
    }

    public static boolean deleteFile(File f) {
        return LoggingFileUtils.deleteFile(f, true);
    }

    public static boolean deleteFile(final File f, final boolean showError) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    if (!f.delete()) {
                        LoggingFileUtils.showErrorMsg(showError, "UNABLE_TO_DELETE_RESOURCE_NOEX", new Object[]{f});
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (PrivilegedActionException e) {
            LoggingFileUtils.showErrorMsg(showError, "UNABLE_TO_DELETE_RESOURCE", new Object[]{f, e});
            return false;
        }
    }

    public static boolean tryToClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    static class RegexFilenameFilter
    implements FilenameFilter {
        final Pattern p;

        RegexFilenameFilter(Pattern p) {
            this.p = p;
        }

        @Override
        public boolean accept(File dir, String name) {
            Matcher m = this.p.matcher(name);
            return m.matches();
        }
    }
}

