/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.jms;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.jms.JMSContextInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class JMSContextInjected
implements JMSContext {
    private static final TraceComponent tc = Tr.register(JMSContextInjected.class, (String)"JMSCDI", (String)"com.ibm.ws.cdi.jms.resources.CWSIAJMSCDIMessages");
    private static final String TSR_LOOKUP_NAME = "java:comp/TransactionSynchronizationRegistry";
    private JMSContext internalJMSContext = null;
    private final JMSContextInfo jmsContextInfo;
    private boolean inTransaction = false;
    static final long serialVersionUID = 3817704021737061441L;

    JMSContextInjected(JMSContextInfo info) {
        this.jmsContextInfo = info;
    }

    private JMSContext createJMSContext(JMSContextInfo info, boolean tranIsActive) throws NamingException {
        this.inTransaction = tranIsActive;
        ConnectionFactory cf = (ConnectionFactory)new InitialContext().lookup(info.getConnectionFactoryString());
        if (this.inTransaction && cf instanceof XAConnectionFactory) {
            XAJMSContext xaContext = ((XAConnectionFactory)cf).createXAContext(info.getUserName(), info.getPassword());
            return xaContext.getContext();
        }
        return cf.createContext(info.getUserName(), info.getPassword(), info.getAcknowledgeMode());
    }

    synchronized void closeInternalJMSContext() {
        if (this.internalJMSContext != null && !this.inTransaction) {
            this.internalJMSContext.close();
            this.internalJMSContext = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized JMSContext getInternalJMSContext() {
        TransactionSynchronizationRegistry tranSyncRegistry = null;
        try {
            boolean tranIsActive = false;
            tranSyncRegistry = (TransactionSynchronizationRegistry)new InitialContext().lookup(TSR_LOOKUP_NAME);
            if (tranSyncRegistry != null) {
                boolean bl = tranIsActive = tranSyncRegistry.getTransactionStatus() == 0;
            }
            if (tranIsActive) {
                Object resource = tranSyncRegistry.getResource((Object)this.jmsContextInfo);
                if (resource != null) {
                    return (JMSContext)resource;
                }
                final JMSContext transactedContext = this.createJMSContext(this.jmsContextInfo, tranIsActive);
                tranSyncRegistry.putResource((Object)this.jmsContextInfo, (Object)transactedContext);
                tranSyncRegistry.registerInterposedSynchronization(new Synchronization(){
                    static final long serialVersionUID = -2684399248654195459L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public void beforeCompletion() {
                    }

                    public synchronized void afterCompletion(int status) {
                        transactedContext.close();
                        JMSContextInjected.this.inTransaction = false;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.cdi.jms.JMSContextInjected$1", 1.class, (String)"JMSCDI", (String)"com.ibm.ws.cdi.jms.resources.CWSIAJMSCDIMessages");
                    }
                });
                return transactedContext;
            }
            if (this.internalJMSContext == null) {
                this.internalJMSContext = this.createJMSContext(this.jmsContextInfo, tranIsActive);
            }
            return this.internalJMSContext;
        }
        catch (Exception tranIsActive) {
            void e;
            FFDCFilter.processException((Throwable)tranIsActive, (String)"com.ibm.ws.cdi.jms.JMSContextInjected", (String)"159", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void acknowledge() {
        throw new IllegalStateRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JMSCONTEXT_INJECTED_CWSIA0512", (Object[])new Object[]{"acknowledge"}));
    }

    public void close() {
        throw new IllegalStateRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JMSCONTEXT_INJECTED_CWSIA0512", (Object[])new Object[]{"acknowledge"}));
    }

    public void commit() {
        throw new IllegalStateRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JMSCONTEXT_INJECTED_CWSIA0512", (Object[])new Object[]{"commit"}));
    }

    public QueueBrowser createBrowser(Queue queue) {
        return this.getInternalJMSContext().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        return this.getInternalJMSContext().createBrowser(queue, messageSelector);
    }

    public BytesMessage createBytesMessage() {
        return this.getInternalJMSContext().createBytesMessage();
    }

    public JMSConsumer createConsumer(Destination destination) {
        return this.getInternalJMSContext().createConsumer(destination);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        return this.getInternalJMSContext().createConsumer(destination, messageSelector);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        return this.getInternalJMSContext().createConsumer(destination, messageSelector, noLocal);
    }

    public JMSContext createContext(int sessionMode) {
        return this.getInternalJMSContext().createContext(sessionMode);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        return this.getInternalJMSContext().createDurableConsumer(topic, name);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        return this.getInternalJMSContext().createDurableConsumer(topic, name, messageSelector, noLocal);
    }

    public MapMessage createMapMessage() {
        return this.getInternalJMSContext().createMapMessage();
    }

    public Message createMessage() {
        return this.getInternalJMSContext().createMessage();
    }

    public ObjectMessage createObjectMessage() {
        return this.getInternalJMSContext().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return this.getInternalJMSContext().createObjectMessage(object);
    }

    public JMSProducer createProducer() {
        return this.getInternalJMSContext().createProducer();
    }

    public Queue createQueue(String queueName) {
        return this.getInternalJMSContext().createQueue(queueName);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        return this.getInternalJMSContext().createSharedConsumer(topic, sharedSubscriptionName);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        return this.getInternalJMSContext().createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        return this.getInternalJMSContext().createSharedDurableConsumer(topic, name);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        return this.getInternalJMSContext().createSharedDurableConsumer(topic, name, messageSelector);
    }

    public StreamMessage createStreamMessage() {
        return this.getInternalJMSContext().createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() {
        return this.getInternalJMSContext().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() {
        return this.getInternalJMSContext().createTemporaryTopic();
    }

    public TextMessage createTextMessage() {
        return this.getInternalJMSContext().createTextMessage();
    }

    public TextMessage createTextMessage(String text) {
        return this.getInternalJMSContext().createTextMessage(text);
    }

    public Topic createTopic(String topicName) {
        return this.getInternalJMSContext().createTopic(topicName);
    }

    public boolean getAutoStart() {
        return this.getInternalJMSContext().getAutoStart();
    }

    public String getClientID() {
        return this.getInternalJMSContext().getClientID();
    }

    public ExceptionListener getExceptionListener() {
        return this.getInternalJMSContext().getExceptionListener();
    }

    public ConnectionMetaData getMetaData() {
        return this.getInternalJMSContext().getMetaData();
    }

    public int getSessionMode() {
        return this.getInternalJMSContext().getSessionMode();
    }

    public boolean getTransacted() {
        return this.getInternalJMSContext().getTransacted();
    }

    public void recover() {
        throw new IllegalStateRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JMSCONTEXT_INJECTED_CWSIA0512", (Object[])new Object[]{"recover"}));
    }

    public void rollback() {
        throw new IllegalStateRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JMSCONTEXT_INJECTED_CWSIA0512", (Object[])new Object[]{"rollback"}));
    }

    public void setAutoStart(boolean arg0) {
        throw new IllegalStateRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JMSCONTEXT_INJECTED_CWSIA0512", (Object[])new Object[]{"setAutoStart"}));
    }

    public void setClientID(String arg0) {
        throw new IllegalStateRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JMSCONTEXT_INJECTED_CWSIA0512", (Object[])new Object[]{"setClientID"}));
    }

    public void setExceptionListener(ExceptionListener arg0) {
        throw new IllegalStateRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JMSCONTEXT_INJECTED_CWSIA0512", (Object[])new Object[]{"setExceptionListener"}));
    }

    public void start() {
        throw new IllegalStateRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JMSCONTEXT_INJECTED_CWSIA0512", (Object[])new Object[]{"start"}));
    }

    public void stop() {
        throw new IllegalStateRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JMSCONTEXT_INJECTED_CWSIA0512", (Object[])new Object[]{"stop"}));
    }

    public void unsubscribe(String name) {
        this.getInternalJMSContext().unsubscribe(name);
    }
}

