/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.osgi.locator;

import java.util.Objects;
import org.apache.yoko.osgi.locator.LocalFactory;

public final class ServiceProvider
implements Comparable<ServiceProvider> {
    public static final int DEFAULT_PRIORITY = 1;
    private final LocalFactory localFactory;
    private final String id;
    private final String className;
    private final int priority;

    public ServiceProvider(LocalFactory localFactory, String id, String className, int priority) {
        this.localFactory = localFactory;
        this.id = id;
        this.className = className;
        this.priority = priority;
    }

    private ServiceProvider(LocalFactory localFactory, String id, String className) {
        this(localFactory, id, className, 1);
    }

    public ServiceProvider(LocalFactory localFactory, String id, Class<?> implClass, int priority) {
        this(localFactory, id, implClass.getName(), priority);
    }

    private <T, U extends T> ServiceProvider(LocalFactory localFactory, Class<T> idClass, Class<U> implClass) {
        this(localFactory, idClass.getName(), implClass.getName());
    }

    public <T> ServiceProvider(LocalFactory localFactory, Class<T> svcClass) {
        this(localFactory, svcClass, svcClass);
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public int getPriority() {
        return this.priority;
    }

    public <T> Class<T> getServiceClass() throws ClassNotFoundException {
        return this.localFactory.forName(this.className);
    }

    public <T> T getServiceInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return (T)this.localFactory.newInstance(this.getServiceClass());
    }

    public boolean equals(Object theOther) {
        if (this.getClass() != theOther.getClass()) {
            return false;
        }
        ServiceProvider that = (ServiceProvider)theOther;
        return Objects.equals(this.localFactory.getClass(), that.localFactory.getClass()) && Objects.equals(this.id, that.id) && Objects.equals(this.className, that.className) && Objects.equals(this.priority, that.priority);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.className, this.priority);
    }

    @Override
    public int compareTo(ServiceProvider that) {
        return that.priority - this.priority;
    }

    public String toString() {
        return String.format("Service id=%s class=%s priority=%d", this.id, this.className, this.priority);
    }
}

