/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.OB.Client;
import org.apache.yoko.orb.OB.ClientProfilePair;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OB.CodeSetUtil;
import org.apache.yoko.orb.OB.CollocatedClient;
import org.apache.yoko.orb.OB.CollocatedServer;
import org.apache.yoko.orb.OB.ConnectionReusePolicyHelper;
import org.apache.yoko.orb.OB.GIOPClient;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ProtocolPolicy;
import org.apache.yoko.orb.OB.ProtocolPolicyHelper;
import org.apache.yoko.orb.OBPortableServer.POAManager;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactory;
import org.apache.yoko.orb.OBPortableServer.POAManager_impl;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.ConFactory;
import org.apache.yoko.orb.OCI.ConFactoryRegistry;
import org.apache.yoko.orb.OCI.Connector;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.exceptions.Transients;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.MinorCodes;
import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.BiDirPolicy.BidirectionalPolicyHelper;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.IOP.IOR;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public final class ClientManager {
    static final Logger logger = Logger.getLogger(ClientManager.class.getName());
    private boolean destroyed = false;
    private ORBInstance orbInstance;
    private Set<Client> allClients = Collections.synchronizedSet(new HashSet());
    private Set<Client> reusableClients = Collections.synchronizedSet(new HashSet());
    private int concModel_;

    protected void finalize() throws Throwable {
        Assert.ensure((boolean)this.destroyed);
        Assert.ensure((boolean)this.allClients.isEmpty());
        Assert.ensure((boolean)this.reusableClients.isEmpty());
        super.finalize();
    }

    synchronized void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        for (Client c : this.allClients) {
            c.destroy();
        }
        this.orbInstance = null;
        this.allClients.clear();
        this.reusableClients.clear();
    }

    public ClientManager(int concModel) {
        this.concModel_ = concModel;
    }

    public void setORBInstance(ORBInstance instance) {
        this.orbInstance = instance;
    }

    public synchronized Vector<ClientProfilePair> getClientProfilePairs(IOR ior, Policy[] policies) {
        ConFactory[] factories;
        Assert.ensure((ior.type_id != null ? 1 : 0) != 0);
        if (ior.type_id.length() == 0 && ior.profiles.length == 0) {
            throw new INV_OBJREF("Object reference is nil");
        }
        if (this.destroyed) {
            throw new INITIALIZE(MinorCodes.describeInitialize((int)1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        boolean reuseConnections = true;
        for (Policy pol : policies) {
            if (pol.policy_type() != 1330577411) continue;
            reuseConnections = ConnectionReusePolicyHelper.narrow((Object)pol).value();
            break;
        }
        ProtocolPolicy protocolPolicy = null;
        for (Policy pol : policies) {
            if (pol.policy_type() != 1330577410) continue;
            protocolPolicy = ProtocolPolicyHelper.narrow((Object)pol);
            break;
        }
        boolean enableBidir = false;
        for (Policy pol : policies) {
            BidirectionalPolicy p;
            if (pol.policy_type() != 37 || (p = BidirectionalPolicyHelper.narrow((Object)pol)).value() != 1) continue;
            enableBidir = true;
        }
        Vector<ClientProfilePair> pairs = new Vector<ClientProfilePair>();
        POAManagerFactory pmFactory = this.orbInstance.getPOAManagerFactory();
        for (org.omg.PortableServer.POAManager mgr : pmFactory.list()) {
            try {
                boolean local = false;
                for (Acceptor acceptor : ((POAManager)mgr).get_acceptors()) {
                    ProfileInfo[] localProfileInfos = acceptor.get_local_profiles(ior);
                    if (localProfileInfos.length <= 0) continue;
                    local = true;
                }
                if (!local || mgr.get_state() != State.ACTIVE) continue;
                POAManager_impl manager = (POAManager_impl)mgr;
                CollocatedServer collocatedServer = manager._OB_getCollocatedServer();
                CollocatedClient client = new CollocatedClient(collocatedServer, this.concModel_);
                this.allClients.add(client);
                for (ProfileInfo profileInfo : ((Client)client).getUsableProfiles(ior, policies)) {
                    ClientProfilePair pair = new ClientProfilePair();
                    pair.client = client;
                    pair.profile = profileInfo;
                    pairs.addElement(pair);
                }
            }
            catch (AdapterInactive adapterInactive) {
                // empty catch block
            }
        }
        if (reuseConnections) {
            for (Client reusableClient : this.reusableClients) {
                ConnectorInfo info22;
                if (protocolPolicy != null && (info22 = reusableClient.connectorInfo()) != null && !protocolPolicy.contains(info22.id())) continue;
                ProfileInfo[] info22 = reusableClient.getUsableProfiles(ior, policies);
                int mgr = info22.length;
                for (int i = 0; i < mgr; ++i) {
                    ProfileInfo profileInfo = info22[i];
                    ClientProfilePair pair = new ClientProfilePair();
                    pair.client = reusableClient;
                    pair.profile = profileInfo;
                    pairs.addElement(pair);
                }
            }
        }
        ConFactoryRegistry conFactoryRegistry = this.orbInstance.getConFactoryRegistry();
        for (ConFactory factory : factories = conFactoryRegistry.get_factories()) {
            Connector[] connectors;
            for (Connector connector : connectors = factory.create_connectors(ior, policies)) {
                ProfileInfo[] profileInfos;
                if (protocolPolicy != null && !protocolPolicy.contains(connector.id()) || (profileInfos = connector.get_usable_profiles(ior, policies)).length == 0) continue;
                for (ProfileInfo profileInfo : profileInfos) {
                    CodeConverters conv = CodeSetUtil.getCodeConverters(this.orbInstance, profileInfo);
                    GIOPClient newClient = new GIOPClient(this.orbInstance, connector, this.concModel_, conv, enableBidir);
                    if (!pairs.isEmpty()) {
                        boolean matched = false;
                        for (ClientProfilePair pair : pairs) {
                            if (!pair.client.matches(newClient)) continue;
                            matched = true;
                            break;
                        }
                        if (matched) {
                            ((Client)newClient).destroy();
                            continue;
                        }
                    }
                    this.allClients.add(newClient);
                    for (ProfileInfo clientProfileInfo : ((Client)newClient).getUsableProfiles(ior, policies)) {
                        ClientProfilePair pair = new ClientProfilePair();
                        pair.client = newClient;
                        pair.profile = clientProfileInfo;
                        pairs.addElement(pair);
                    }
                    if (!reuseConnections) continue;
                    this.reusableClients.add(newClient);
                }
            }
        }
        if (!pairs.isEmpty() && protocolPolicy != null) {
            String[] protocols = protocolPolicy.value();
            Vector<ClientProfilePair> newPairs = new Vector<ClientProfilePair>();
            for (ClientProfilePair pair : pairs) {
                if (pair.client.connectorInfo() != null) continue;
                newPairs.addElement(pair);
            }
            for (String protocol : protocols) {
                for (ClientProfilePair pair : pairs) {
                    ConnectorInfo info = pair.client.connectorInfo();
                    if (info == null || !protocol.equals(info.id())) continue;
                    newPairs.addElement(pair);
                }
            }
            pairs = newPairs;
        }
        if (pairs.isEmpty()) {
            throw Transients.NO_USABLE_PROFILE_IN_IOR.create();
        }
        for (ClientProfilePair pair : pairs) {
            pair.client.obtain();
        }
        return pairs;
    }

    public synchronized void releaseClient(Client client) {
        if (this.destroyed) {
            return;
        }
        if (client.release()) {
            this.destroyClient(client);
        }
    }

    public synchronized void besmirchClient(Client client) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Client besmirched: " + client);
        }
        this.destroyClient(client);
    }

    private void destroyClient(Client client) {
        this.reusableClients.remove(client);
        this.allClients.remove(client);
        client.destroy();
    }

    public boolean equivalent(IOR ior1, IOR ior2) {
        ConFactoryRegistry conFactoryRegistry = this.orbInstance.getConFactoryRegistry();
        for (ConFactory factory : conFactoryRegistry.get_factories()) {
            if (factory.equivalent(ior1, ior2)) continue;
            return false;
        }
        return true;
    }

    public int hash(IOR ior, int maximum) {
        return Arrays.hashCode(this.orbInstance.getConFactoryRegistry().get_factories());
    }
}

