/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIXAResource;
import java.util.ArrayList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public abstract class BaseSIXAResourceProxy
extends Transaction
implements SIXAResource {
    private static String CLASS_NAME = BaseSIXAResourceProxy.class.getName();
    private static final TraceComponent tc = SibTr.register(BaseSIXAResourceProxy.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    protected final int fapLevel;
    protected final boolean isMSResource;
    protected boolean isSuspended = false;
    private ArrayList<SIXAResource> resourcesJoinedToThisResource = new ArrayList();

    public BaseSIXAResourceProxy(Conversation conv, ConnectionProxy cp, boolean isMSResource) {
        super(conv, cp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.fapLevel = conv.getHandshakeProperties().getFapLevel();
        this.isMSResource = isMSResource;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected synchronized void join(SIXAResource resource) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"join", (Object)resource);
        }
        this.resourcesJoinedToThisResource.add(resource);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"join");
        }
    }

    protected synchronized void unjoin(SIXAResource resource) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unjoin", (Object)resource);
        }
        this.resourcesJoinedToThisResource.remove(resource);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unjoin");
        }
    }

    protected synchronized boolean hasJoinedResources() {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasJoinedResources");
        }
        boolean bl = result = this.resourcesJoinedToThisResource.size() != 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasJoinedResources", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalCommit(Xid xid, boolean onePhase) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"internalCommit", (Object)new Object[]{xid, "" + onePhase});
        }
        try {
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putInt(this.getTransactionId());
            request.putXid(xid);
            request.put((byte)(onePhase ? 1 : 0));
            if (this.fapLevel >= 5) {
                request.put((byte)(this.isMSResource ? 1 : 0));
            }
            CommsByteBuffer reply = this.jfapExchange(request, 52, this.getLowestMessagePriority(), true);
            try {
                reply.checkXACommandCompletionStatus(180, this.getConversation());
            }
            finally {
                reply.release();
            }
        }
        catch (XAException xa) {
            throw xa;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".internalCommit"), (String)"1-007-0001", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught a comms problem:", (Object)e);
            }
            throw new XAException(-7);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"internalCommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalEnd(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"internalEnd", (Object)new Object[]{xid, "" + flags});
        }
        try {
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putInt(this.getTransactionId());
            request.putXid(xid);
            request.putInt(flags);
            if (this.fapLevel >= 5) {
                request.put((byte)(this.isMSResource ? 1 : 0));
            }
            CommsByteBuffer reply = this.jfapExchange(request, 50, this.getLowestMessagePriority(), true);
            try {
                reply.checkXACommandCompletionStatus(178, this.getConversation());
            }
            finally {
                reply.release();
            }
        }
        catch (XAException xa) {
            throw xa;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".internalEnd"), (String)"1-007-0002", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Caught a comms problem:", (Object)e);
            }
            this.invalidateConnection(true, e, "Exception in SIXAResourceProxy.end");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"internalEnd");
            }
            throw new XAException(-7);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"internalEnd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalForget(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"internalForget", (Object)xid);
        }
        try {
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putInt(this.getTransactionId());
            request.putXid(xid);
            if (this.fapLevel >= 5) {
                request.put((byte)(this.isMSResource ? 1 : 0));
            }
            CommsByteBuffer reply = this.jfapExchange(request, 55, 7, true);
            try {
                reply.checkXACommandCompletionStatus(183, this.getConversation());
            }
            finally {
                reply.release();
            }
        }
        catch (XAException xa) {
            throw xa;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".internalForget"), (String)"1-007-0003", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught a comms problem:", (Object)e);
            }
            throw new XAException(-7);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"internalForget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int internalPrepare(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"internalPrepare", (Object)xid);
        }
        int rc = 0;
        try {
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putInt(this.getTransactionId());
            request.putXid(xid);
            if (this.fapLevel >= 5) {
                request.put((byte)(this.isMSResource ? 1 : 0));
            }
            CommsByteBuffer reply = this.jfapExchange(request, 51, this.getLowestMessagePriority(), true);
            try {
                reply.checkXACommandCompletionStatus(179, this.getConversation());
                rc = reply.getInt();
            }
            finally {
                reply.release();
            }
        }
        catch (XAException xa) {
            throw xa;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".internalPrepare"), (String)"1-007-0005", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Caught a comms problem:", (Object)e);
            }
            throw new XAException(-7);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"internalPrepare", (Object)("" + rc));
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Xid[] internalRecover(int flags) throws XAException {
        Xid[] xids;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"internalRecover", (Object)("" + flags));
        }
        try {
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putInt(this.getTransactionId());
            request.putInt(flags);
            if (this.fapLevel >= 5) {
                request.put((byte)(this.isMSResource ? 1 : 0));
            }
            CommsByteBuffer reply = this.jfapExchange(request, 54, 7, true);
            try {
                reply.checkXACommandCompletionStatus(182, this.getConversation());
                int numberOfXids = reply.getShort();
                xids = new Xid[numberOfXids];
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Received " + numberOfXids + " Xid(s)"));
                }
                for (int x = 0; x < numberOfXids; ++x) {
                    xids[x] = reply.getXid();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)tc, (String)("Xid[" + x + "]: " + xids[x]));
                }
            }
            finally {
                reply.release();
            }
        }
        catch (XAException xa) {
            throw xa;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".recover"), (String)"1-007-0006", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Caught a comms problem:", (Object)e);
            }
            throw new XAException(-7);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"internalRecover");
        }
        return xids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRollback(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"internalRollback", (Object)xid);
        }
        try {
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putInt(this.getTransactionId());
            request.putXid(xid);
            if (this.fapLevel >= 5) {
                request.put((byte)(this.isMSResource ? 1 : 0));
            }
            CommsByteBuffer reply = this.jfapExchange(request, 53, this.getLowestMessagePriority(), true);
            try {
                reply.checkXACommandCompletionStatus(181, this.getConversation());
            }
            finally {
                reply.release();
            }
        }
        catch (XAException xa) {
            throw xa;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".internalRollback"), (String)"1-007-0007", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught a comms problem:", (Object)e);
            }
            throw new XAException(-7);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"internalRollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalStart(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"internalStart", (Object)new Object[]{xid, "" + flags});
        }
        try {
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putInt(this.getTransactionId());
            request.putXid(xid);
            request.putInt(flags);
            if (this.fapLevel >= 5) {
                request.put((byte)(this.isMSResource ? 1 : 0));
            }
            CommsByteBuffer reply = this.jfapExchange(request, 49, 7, true);
            try {
                reply.checkXACommandCompletionStatus(177, this.getConversation());
            }
            finally {
                reply.release();
            }
        }
        catch (XAException xa) {
            throw xa;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".internalStart"), (String)"1-007-0009", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught a comms problem:", (Object)e);
            }
            throw new XAException(-7);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"internalStart");
        }
    }

    @Override
    public boolean isValid() {
        return this.isEnlisted();
    }

    abstract void setEnlisted(Xid var1);

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) 1.22 SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/BaseSIXAResourceProxy.java, SIB.comms, WASX.SIB, uu1215.01");
        }
    }
}

