/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.security.Authentication;
import com.ibm.ws.messaging.security.Authorization;
import com.ibm.ws.messaging.security.MessagingSecurityException;
import com.ibm.ws.messaging.security.RuntimeSecurityService;
import com.ibm.ws.messaging.security.authentication.MessagingAuthenticationException;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsMEConfig;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.MQLinkDefinition;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.internal.JsAdminFactory;
import com.ibm.ws.sib.admin.internal.JsMainAdminComponentImpl;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.comms.MEConnectionListener;
import com.ibm.ws.sib.matchspace.impl.Matching;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.impl.ControlMessageFactory;
import com.ibm.ws.sib.mfp.impl.JsMessageHandleFactory;
import com.ibm.ws.sib.mfp.impl.SchemaStore;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.Administrator;
import com.ibm.ws.sib.processor.CommandHandler;
import com.ibm.ws.sib.processor.ExceptionDestinationHandler;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.SIMPAdmin;
import com.ibm.ws.sib.processor.SIMPFactory;
import com.ibm.ws.sib.processor.exceptions.SIMPConnectionUnavailableException;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationAlreadyExistsException;
import com.ibm.ws.sib.processor.exceptions.SIMPMessageProcessorCorruptException;
import com.ibm.ws.sib.processor.impl.AccessChecker;
import com.ibm.ws.sib.processor.impl.AdministratorImpl;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.ConsumerList;
import com.ibm.ws.sib.processor.impl.ConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.CustomProperties;
import com.ibm.ws.sib.processor.impl.DestinationChangeListener;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.DynamicConfigManager;
import com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl;
import com.ibm.ws.sib.processor.impl.LinkChangeListener;
import com.ibm.ws.sib.processor.impl.MQLinkHandler;
import com.ibm.ws.sib.processor.impl.MulticastPropertiesImpl;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPIConnFactory;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.MPCallsToUnitTestHandler;
import com.ibm.ws.sib.processor.impl.store.BatchHandler;
import com.ibm.ws.sib.processor.impl.store.MessageProcessorStore;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.io.MPIO;
import com.ibm.ws.sib.processor.matching.MessageProcessorMatching;
import com.ibm.ws.sib.processor.matching.TopicAuthorization;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.MessageProcessorControl;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.SearchResultsObjectPool;
import com.ibm.ws.sib.processor.utils.StoppableThreadCache;
import com.ibm.ws.sib.processor.utils.ThreadPoolListenerImpl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.trm.contact.CommsErrorListener;
import com.ibm.ws.sib.trm.dlm.DestinationLocationManager;
import com.ibm.ws.sib.trm.links.LinkManager;
import com.ibm.ws.sib.trm.links.mql.MQLinkManager;
import com.ibm.ws.sib.trm.topology.RoutingManager;
import com.ibm.ws.sib.trm.topology.TopologyListener;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.util.ThreadPoolListener;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;

public final class MessageProcessor
implements JsEngineComponent,
SICoreConnectionFactory,
SIMPAdmin,
SIMPFactory,
ControllableResource {
    private static final TraceComponent tc = SibTr.register(MessageProcessor.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private SearchResultsObjectPool _searchResultsPool;
    private ControlAdapter _controlAdapter;
    private long _highMessageThreshold = 1000L;
    private SIMPTransactionManager _txManager;
    private ThreadPool _consumerThreadPool;
    private ThreadPool _systemThreadPool;
    private JsMessagingEngine _engine;
    private MessageStore _msgStore;
    private volatile boolean _started;
    private boolean _starting = false;
    private static HashMap<String, Object> _factories = null;
    private HashMap<String, Object> _meFactories = null;
    private boolean _discardMsgsAfterQueueDeletion;
    private boolean _isSingleServer = false;
    private boolean _singleServerSet = false;
    private Set<SIBUuid8> _messagingEnginesOnBus;
    private HashMap<SICoreConnection, SICoreConnection> _connections;
    private final LockManager _connectionsLockManager = new LockManager();
    private ConsumerList _consumerList = null;
    private DestinationChangeListener _destinationChangeListener;
    private LinkChangeListener _linkChangeListener;
    private AdministratorImpl _administrator;
    private DestinationManager _destinationManager;
    private DynamicConfigManager _dynamicConfigManager;
    private MessageProcessorMatching _messageProcessorMatching;
    private MultiMEProxyHandler _multiMEProxyHandler;
    private MPCoreConnection _connectionToMP;
    private JsDestinationAddress _proxyHandlerDestAddr;
    private JsDestinationAddress _tdReceiverAddr;
    private MPIO _mpio;
    private DestinationLocationManager _destinationLocationManager = null;
    private LinkManager _linkManager = null;
    private MQLinkManager _mqLinkManager = null;
    private static ControlMessageFactory _controlMessageFactory;
    private MessageProcessorStore _persistentStore;
    private MPAlarmManager _mpAlarmManager;
    private ObjectPool _batchedTimeoutManagerEntryPool;
    private BatchHandler _publicationBatchHandler;
    private BatchHandler _targetBatchHandler;
    private BatchHandler _sourceBatchHandler;
    private AccessChecker _accessChecker;
    private final AuthUtils _authorisationUtils;
    private TopicAuthorization _topicAuthorization;
    private boolean _isBusSecure = false;
    private static MPCallsToUnitTestHandler _mpCallsToUnitTestHandler;
    private boolean _busReloaded = false;
    private SelectionCriteriaFactory _selectionCriteriaFactory;
    private static JsMessageHandleFactory _jsMessageHandleFactory;
    private MulticastPropertiesImpl _multicastProperties = null;
    private RuntimeEventListener _runtimeEventListener;
    private final StoppableThreadCache _stoppableThreadCache;
    private final Object _mpStartStopLock = new Object();
    private HashMap<String, CommandHandler> _registeredHandlers = null;
    private final CustomProperties _customProperties = new CustomProperties();
    HashSet _localistySet = new HashSet();
    private RuntimeSecurityService runtimeSecurityService;
    private Authentication _authentication;
    private Authorization _authorization;
    private volatile boolean _isWASOpenForEBusiness = false;

    public final RuntimeSecurityService getRuntimeSecurityService() {
        return this.runtimeSecurityService;
    }

    public MessageProcessor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageProcessor");
        }
        this._started = false;
        this._consumerList = new ConsumerList(this);
        this._stoppableThreadCache = new StoppableThreadCache();
        this._registeredHandlers = new HashMap();
        this._authorisationUtils = new AuthUtils();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageProcessor", (Object)this);
        }
    }

    public boolean isStarted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStarted");
            SibTr.exit((TraceComponent)tc, (String)"isStarted", (Object)new Boolean(this._started));
        }
        return this._started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SICoreConnection createConnection() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConnection");
        }
        ConnectionImpl newConn = new ConnectionImpl(this, null, null);
        this._connectionsLockManager.lock();
        try {
            this.checkStarted();
            HashMap<SICoreConnection, SICoreConnection> hashMap = this._connections;
            synchronized (hashMap) {
                this._connections.put((SICoreConnection)newConn, (SICoreConnection)newConn);
            }
        }
        finally {
            this._connectionsLockManager.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConnection", (Object)newConn);
        }
        return newConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(ConnectionImpl connection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConnection", (Object)connection);
        }
        HashMap<SICoreConnection, SICoreConnection> hashMap = this._connections;
        synchronized (hashMap) {
            this._connections.remove(connection);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConnection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SICoreConnection createConnection(Subject subject, boolean system, Map connectionProperties) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConnection", (Object)new Object[]{system, connectionProperties});
        }
        try {
            if (this.runtimeSecurityService.isUnauthenticated(subject)) {
                String userName = this.runtimeSecurityService.getUniqueUserName(subject);
                throw new SIResourceException(nls.getFormattedMessage("USER_NOT_AUTHENTICATED_MSE1009", new Object[]{userName}, "User " + userName + " is not authenticated"));
            }
        }
        catch (MessagingAuthenticationException mae) {
            throw new SIResourceException(mae.getMessage());
        }
        catch (MessagingSecurityException mse) {
            throw new SIResourceException(mse.getMessage());
        }
        ConnectionImpl newConn = new ConnectionImpl(this, subject, connectionProperties);
        this._connectionsLockManager.lock();
        try {
            if (!system) {
                this.checkStarted();
            }
            HashMap<SICoreConnection, SICoreConnection> hashMap = this._connections;
            synchronized (hashMap) {
                this._connections.put((SICoreConnection)newConn, (SICoreConnection)newConn);
            }
        }
        finally {
            this._connectionsLockManager.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConnection", (Object)newConn);
        }
        return newConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<SICoreConnection, SICoreConnection> getConnections() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnections");
        }
        HashMap connections = null;
        HashMap<SICoreConnection, SICoreConnection> hashMap = this._connections;
        synchronized (hashMap) {
            connections = (HashMap)this._connections.clone();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnections", (Object)connections);
        }
        return connections;
    }

    void addConsumer(ConsumerSessionImpl consumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumer", (Object)consumer);
        }
        this._consumerList.add(consumer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumer");
        }
    }

    ConsumerSessionImpl getConsumer(long id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumer", (Object)new Long(id));
        }
        ConsumerSessionImpl consumer = this._consumerList.get(id);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConsumer", (Object)consumer);
        }
        return consumer;
    }

    void removeConsumer(ConsumerSessionImpl consumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumer", (Object)consumer);
        }
        this._consumerList.remove(consumer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumer");
        }
    }

    public MessageStore getMessageStore() {
        return this._msgStore;
    }

    public JsMessagingEngine getMessagingEngine() {
        return this._engine;
    }

    public String getMessagingEngineName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessagingEngineName");
            SibTr.exit((TraceComponent)tc, (String)"getMessagingEngineName", (Object)this._engine.getName());
        }
        return this._engine.getName();
    }

    public String getMessagingEngineBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessagingEngineBus");
        }
        String returnString = this._engine.getBusName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessagingEngineBus", (Object)returnString);
        }
        return returnString;
    }

    public JsBus getBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBus");
        }
        JsBus jsBus = (JsBus)this._engine.getBus();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBus", (Object)jsBus);
        }
        return jsBus;
    }

    public SIBUuid8 getMessagingEngineBusUuid() {
        JsBus jsBus = (JsBus)this._engine.getBus();
        return jsBus.getUuid();
    }

    public DestinationManager getDestinationManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationManager");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationManager", (Object)((Object)this._destinationManager));
        }
        return this._destinationManager;
    }

    public Administrator getAdministrator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAdministrator");
            SibTr.exit((TraceComponent)tc, (String)"getAdministrator", (Object)this._administrator);
        }
        return this._administrator;
    }

    public MultiMEProxyHandler getProxyHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProxyHandler");
            SibTr.exit((TraceComponent)tc, (String)"getProxyHandler", (Object)((Object)this._multiMEProxyHandler));
        }
        return this._multiMEProxyHandler;
    }

    public SICoreConnection createConnection(String userName, String password, Map connectionProperties) throws SIResourceException, SINotAuthorizedException, SIAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnFactory.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)new Object[]{userName, connectionProperties});
        }
        this.checkStarted();
        Subject subject = null;
        try {
            subject = this._authentication.login(userName, password);
        }
        catch (MessagingAuthenticationException e) {
            throw new SIAuthenticationException(e.getMessage());
        }
        SICoreConnection connection = this.createConnection(subject, connectionProperties);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnFactory.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)connection);
        }
        return connection;
    }

    public SICoreConnection createConnection(Subject subject, Map connectionProperties) throws SIResourceException, SINotAuthorizedException, SIAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnFactory.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)connectionProperties);
        }
        this.checkStarted();
        SICoreConnection connection = null;
        try {
            if (this.runtimeSecurityService.isUnauthenticated(subject)) {
                String userName = this.runtimeSecurityService.getUniqueUserName(subject);
                throw new SIAuthenticationException(nls.getFormattedMessage("USER_NOT_AUTHENTICATED_MSE1009", new Object[]{userName}, "User " + userName + " is not authenticated"));
            }
            connection = this.createConnection(subject, false, connectionProperties);
        }
        catch (MessagingAuthenticationException mae) {
            throw new SIAuthenticationException(mae.getMessage());
        }
        catch (MessagingSecurityException mse) {
            throw new SIAuthenticationException(mse.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnFactory.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)connection);
        }
        return connection;
    }

    public SICoreConnection createConnection(ClientConnection cc, String credentialType, String userid, String password) throws SIResourceException, SINotAuthorizedException, SIAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnFactory.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)new Object[]{cc, credentialType, userid, password});
        }
        this.checkStarted();
        if ("".equals(userid)) {
            userid = null;
        }
        SICoreConnection connection = null;
        SSLSession sslSession = cc.getMetaData().getSSLSession();
        if (credentialType.equals("Userid+Password")) {
            Certificate[] peerCerts;
            block17: {
                peerCerts = null;
                if (userid == null && sslSession != null) {
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Authentication: attempting to retrieve SSL Peer certificates");
                        }
                        peerCerts = sslSession.getPeerCertificates();
                    }
                    catch (SSLPeerUnverifiedException sslPUE) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block17;
                        SibTr.debug((TraceComponent)tc, (String)("Authentication: Error obtaining SSL certificates >" + sslPUE + "<"));
                    }
                }
            }
            if (userid != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Authentication: Login using user ID and password");
                }
                connection = this.createConnection(userid, password, null);
            } else if (peerCerts != null && peerCerts.length > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Authentication: Login using SSL Peer certificates");
                }
                connection = this.createConnection(peerCerts);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Authentication: Anonymous Login using user ID and password; note that these may be null");
                }
                connection = this.createConnection(userid, password, null);
            }
        }
        if (null != sslSession) {
            ((ConnectionImpl)connection).setConnectionType(3);
        } else {
            ((ConnectionImpl)connection).setConnectionType(2);
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnFactory.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)connection);
        }
        return connection;
    }

    private SICoreConnection createConnection(Certificate[] certificate) throws SIAuthenticationException, SIResourceException, SINotAuthorizedException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnFactory.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)certificate);
        }
        this.checkStarted();
        Subject subject = null;
        try {
            subject = this._authentication.login(certificate);
        }
        catch (MessagingAuthenticationException e) {
            throw new SIAuthenticationException(e.getMessage());
        }
        SICoreConnection connection = this.createConnection(subject, null);
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIConnFactory.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)connection);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStarted() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkStarted");
        }
        Object object = this._mpStartStopLock;
        synchronized (object) {
            if (!this.isStarted()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkStarted", (Object)"ME not started");
                }
                throw new SIResourceException(nls.getFormattedMessage("MESSAGE_PROCESSOR_NOT_STARTED_ERROR_CWSIP0211", new Object[]{this.getMessagingEngineName(), this.getMessagingEngineBus()}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkStarted");
        }
    }

    public DestinationDefinition createDestinationDefinition(DestinationType destinationType, String destinationName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDestinationDefinition", (Object)new Object[]{destinationType, destinationName});
        }
        JsAdminFactory factory = (JsAdminFactory)MessageProcessor.getSingletonInstance("JsAdminFactory");
        DestinationDefinition destDef = factory.createDestinationDefinition(destinationType, destinationName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestinationDefinition", (Object)destDef);
        }
        return destDef;
    }

    public LocalizationDefinition createLocalizationDefinition(String destinationName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createLocalizationDefinition", (Object)destinationName);
        }
        JsAdminFactory factory = (JsAdminFactory)MessageProcessor.getSingletonInstance("JsAdminFactory");
        LocalizationDefinition locDef = factory.createLocalizationDefinition(destinationName);
        locDef.setDestinationHighMsgs(this.getHighMessageThreshold());
        locDef.setDestinationLowMsgs(this.getHighMessageThreshold() / 10L * 8L);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createLocalizationDefinition", (Object)locDef);
        }
        return locDef;
    }

    public MQLinkDefinition createMQLinkDefinition(String mqLinkUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMQLinkDefinition", (Object)new Object[]{mqLinkUuid});
        }
        JsAdminFactory factory = (JsAdminFactory)MessageProcessor.getSingletonInstance("JsAdminFactory");
        MQLinkDefinition mqLinkDef = factory.createMQLinkDefinition(mqLinkUuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMQLinkDefinition", (Object)mqLinkDef);
        }
        return mqLinkDef;
    }

    public ExceptionDestinationHandler createExceptionDestinationHandler(SIDestinationAddress address) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createExceptionDestinationHandler", (Object)address);
        }
        ExceptionDestinationHandlerImpl handler = new ExceptionDestinationHandlerImpl(address, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createExceptionDestinationHandler", (Object)handler);
        }
        return handler;
    }

    public ExceptionDestinationHandler createLinkExceptionDestinationHandler(SIBUuid8 mqLinkUuid) throws SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createLinkExceptionDestinationHandler", (Object)mqLinkUuid);
        }
        MQLinkHandler mqLink = this._destinationManager.getMQLinkLocalization(mqLinkUuid, true);
        ExceptionDestinationHandlerImpl handler = new ExceptionDestinationHandlerImpl(mqLink);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createLinkExceptionDestinationHandler", (Object)handler);
        }
        return handler;
    }

    public static Object getSingletonInstance(String className) {
        return _factories.get(className);
    }

    public Object getMEInstance(String className) {
        return this._meFactories.get(className);
    }

    public void initialize(JsMessagingEngine engine) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize", (Object)engine);
        }
        this._engine = engine;
        this._engine.setMEUUID(new SIBUuid8());
        this._mpio = new MPIO(this);
        this._meFactories = new HashMap();
        try {
            this._meFactories.put("JsMBeanFactory", engine.getMBeanFactory());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.initialize", (String)"1:1202:1.445", (Object)this);
            SIErrorException finalE = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1209:1.445", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1215:1.445", SIMPUtils.getStackTrace(e)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"initialize", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (_factories == null) {
            _factories = new HashMap();
            try {
                _factories.put("JsDestinationAddressFactory", SIDestinationAddressFactory.getInstance());
                _factories.put("SIDestinationAddressFactory", SIDestinationAddressFactory.getInstance());
                _factories.put("ControlMessageFactory", ControlMessageFactory.getInstance());
                _factories.put("JsAdminFactory", JsAdminFactory.getInstance());
                _factories.put("Matching", Matching.getInstance());
                _factories.put("SelectionCriteriaFactory", JsMainAdminComponentImpl.getSelectionCriteriaFactory());
                _factories.put("JsMessageHandleFactory", JsMessageHandleFactory.getInstance());
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.initialize", (String)"1:1261:1.445", (Object)this);
                SIErrorException finalE = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1268:1.445", e}, null), (Throwable)e);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1274:1.445", SIMPUtils.getStackTrace(e)});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"initialize", (Object)((Object)finalE));
                }
                throw finalE;
            }
        }
        this._discardMsgsAfterQueueDeletion = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int startMode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        try {
            Object object = this._mpStartStopLock;
            synchronized (object) {
                this._starting = true;
            }
            this.startInternal(startMode);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.start", (String)"1:1351:1.445", (Object)this);
            this._stoppableThreadCache.stopAllThreads();
            SIErrorException finalE = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.prWsWsocessor.impl.MessageProcessor", "1:1386:1.445", e}, null), (Throwable)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1394:1.445", SIMPUtils.getStackTrace(e)});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            Object object = this._mpStartStopLock;
            synchronized (object) {
                this._started = false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"start", (Object)((Object)finalE));
            }
            throw finalE;
        }
        finally {
            Object object = this._mpStartStopLock;
            synchronized (object) {
                this._starting = false;
                this._mpStartStopLock.notify();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInternal(int startMode) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startInternal", (Object)new Integer(startMode));
        }
        this._msgStore = (MessageStore)this._engine.getMessageStore();
        this._txManager = new SIMPTransactionManager(this, this._msgStore);
        this._mpAlarmManager = new MPAlarmManager(this, 20, 200);
        this._publicationBatchHandler = new BatchHandler(100, 1000L, this._txManager, this._mpAlarmManager);
        this._sourceBatchHandler = new BatchHandler(this._customProperties.get_source_batch_size(), this._customProperties.get_source_batch_timeout(), this._txManager, this._mpAlarmManager);
        this._targetBatchHandler = new BatchHandler(this._customProperties.get_target_batch_size(), this._customProperties.get_target_batch_timeout(), this._txManager, this._mpAlarmManager);
        String theBus = this._engine.getBusName();
        this._accessChecker = new AccessChecker(this);
        this.runtimeSecurityService = this._engine.getRuntimeSecurityservice();
        this._authentication = this.runtimeSecurityService.getAuthenticationInstance();
        this._authorization = this.runtimeSecurityService.getAuthorizationInstance();
        this._isBusSecure = this._authorisationUtils.isBusSecure(this.getMessagingEngineBus());
        this._searchResultsPool = new SearchResultsObjectPool("MatchingSearchResults", this._customProperties.get_searchResultsPoolSize());
        this._selectionCriteriaFactory = (SelectionCriteriaFactory)MessageProcessor.getSingletonInstance("SelectionCriteriaFactory");
        this._connections = new HashMap();
        boolean warmStarted = this.reconstitute(startMode);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Warm start state : " + warmStarted));
        }
        if (!warmStarted) {
            this._engine.setMEUUID(new SIBUuid8());
            this.coldStart();
        } else {
            this._engine.setMEUUID(this.getMessagingEngineUuid());
            this._destinationManager.prepareToReconcile();
        }
        if (this._linkManager == null) {
            this._linkManager = null;
        }
        if (this._linkManager != null) {
            this._linkManager.setChangeListener((com.ibm.ws.sib.trm.links.LinkChangeListener)this._linkChangeListener);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Link Manager is null");
        }
        this._localistySet.add(this._engine.getUuid().toString());
        this._engine.loadLocalizations();
        this.initializeTickGenerator();
        try {
            this._tdReceiverAddr = SIMPUtils.createJsSystemDestinationAddress("SIMP.TDRECEIVER", this.getMessagingEngineUuid());
            this._tdReceiverAddr.setBusName(this.getMessagingEngineBus());
            if (!this._destinationManager.destinationExists(this._tdReceiverAddr)) {
                this._tdReceiverAddr = this._destinationManager.createSystemDestination("SIMP.TDRECEIVER");
            }
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.startInternal", (String)"1:1615:1.445", (Object)this);
            SIErrorException finalE = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1626:1.445", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1636:1.445", SIMPUtils.getStackTrace(e)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"startInternal", (Object)((Object)finalE));
            }
            throw finalE;
        }
        this.createDynamicConfigManager();
        if (warmStarted) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Messaging engine " + this.getMessagingEngineName() + " is starting to reconcile the destination."));
            }
            this._destinationManager.validateUnreconciled();
            this._destinationManager.reconcileLocal();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Messaging engine " + this.getMessagingEngineName() + " has finished reconciling the destination."));
            }
            this._destinationManager.start();
        }
        this._msgStore.expirerStart();
        this._msgStore.deliveryDelayManagerStart();
        Object object = this._mpStartStopLock;
        synchronized (object) {
            this._started = true;
        }
        this._destinationManager.announceMPStarted(startMode);
        if (this._isBusSecure) {
            this._accessChecker.listTopicAuthorisations();
        }
        if (this._customProperties.get_multicastEnabled()) {
            this._multicastProperties = new MulticastPropertiesImpl(this._customProperties.get_multicastInterfaceAddress(), this._customProperties.get_multicastPort(), this._customProperties.get_multicastPacketSize(), this._customProperties.get_multicastTTL(), this._customProperties.get_multicastGroupAddress(), this._customProperties.get_multicastUseReliableRMM());
        }
        object = this._mpStartStopLock;
        synchronized (object) {
            if (this.isWASOpenForEBusiness()) {
                this.serverStarted();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startInternal");
        }
    }

    private void announceMPStopping() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceMPStopping");
        }
        if (this._destinationManager != null) {
            this._destinationManager.announceMPStopping();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceMPStopping");
        }
    }

    public boolean isWASOpenForEBusiness() {
        return this._isWASOpenForEBusiness;
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destroy");
        }
        if (this._destinationManager != null) {
            this._destinationManager.destroy();
        }
        if (this._consumerThreadPool != null) {
            this._consumerThreadPool.shutdownNow();
            this._consumerThreadPool = null;
        }
        if (this._systemThreadPool != null) {
            this._systemThreadPool.shutdownNow();
            this._systemThreadPool = null;
        }
        _factories = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stop(int mode) {
        block27: {
            block28: {
                block26: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"stop", (Object)new Integer(mode));
                    }
                    try {
                        if (mode == 2) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Stop request from Comms server for COMMS connections");
                            }
                            this.closeConnections(0, 2);
                            return;
                        }
                        if (mode == 3) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Stop request from Comms server for COMMS SSL connections");
                            }
                            this.closeConnections(0, 3);
                            return;
                        }
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled()) return;
                        if (!tc.isDebugEnabled()) return;
                        if (mode == 2) {
                            SibTr.debug((TraceComponent)tc, (String)"Failure in closing COMMS connections", (Object)e);
                            return;
                        }
                        SibTr.debug((TraceComponent)tc, (String)"Failure in closing COMMS over SSL connections", (Object)e);
                        return;
                    }
                    this.announceMPStopping();
                    this._connectionsLockManager.lockExclusive();
                    Object object = this._mpStartStopLock;
                    // MONITORENTER : object
                    if (this._starting) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Stop waiting until start complete");
                        }
                        try {
                            this._mpStartStopLock.wait();
                        }
                        catch (InterruptedException e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block26;
                            SibTr.exception((TraceComponent)tc, (Exception)e);
                        }
                    }
                }
                if (this._started) break block27;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"stop", (Object)"Returning as not started.");
                }
                // MONITOREXIT : object
                this._connectionsLockManager.unlockExclusive();
                if (this._consumerThreadPool == null) break block28;
                this._consumerThreadPool.shutdownNow();
                this._consumerThreadPool = null;
            }
            if (this._systemThreadPool == null) return;
            this._systemThreadPool.shutdownNow();
            this._systemThreadPool = null;
            return;
        }
        this._started = false;
        this._mpio.stop();
        this._stoppableThreadCache.stopAllThreads();
        this._msgStore.expirerStop();
        this._msgStore.deliveryDelayManagerStop();
        if (this._destinationManager == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"stop", (Object)"Null DM");
            }
            // MONITOREXIT : object
            this._connectionsLockManager.unlockExclusive();
            if (this._consumerThreadPool != null) {
                this._consumerThreadPool.shutdownNow();
                this._consumerThreadPool = null;
            }
            if (this._systemThreadPool == null) return;
            this._systemThreadPool.shutdownNow();
            this._systemThreadPool = null;
            return;
        }
        try {
            this._destinationManager.stop(mode);
            this.closeConnections(mode, 1);
            this._administrator.stop();
            SchemaStore.messageStoreStoppingNotify((MessageStore)this._msgStore);
            // MONITOREXIT : object
        }
        finally {
            this._connectionsLockManager.unlockExclusive();
            if (this._consumerThreadPool != null) {
                this._consumerThreadPool.shutdownNow();
                this._consumerThreadPool = null;
            }
            if (this._systemThreadPool != null) {
                this._systemThreadPool.shutdownNow();
                this._systemThreadPool = null;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"stop");
    }

    private void closeConnections(int mode, int connectionType) {
        if (mode == 0) {
            for (ConnectionImpl connectionImpl : this.getConnections().keySet()) {
                try {
                    int listenIndex;
                    if (!(connectionType == 2 && connectionImpl.getConnectionType() == 2 || connectionType == 3 && connectionImpl.getConnectionType() == 3) && (connectionType != 1 || connectionImpl.getConnectionType() != 1)) continue;
                    SICoreConnectionListener[] listeners = connectionImpl.getConnectionListeners();
                    for (listenIndex = 0; listenIndex < listeners.length; ++listenIndex) {
                        listeners[listenIndex].meQuiescing((SICoreConnection)connectionImpl);
                    }
                    connectionImpl._close(false);
                    listeners = connectionImpl.getConnectionListeners();
                    for (listenIndex = 0; listenIndex < listeners.length; ++listenIndex) {
                        listeners[listenIndex].meTerminated((SICoreConnection)connectionImpl);
                        connectionImpl.removeConnectionListener(listeners[listenIndex]);
                    }
                    connectionImpl._close(false);
                }
                catch (SIMPConnectionUnavailableException listeners) {
                }
                catch (SIException coreException) {
                    FFDCFilter.processException((Throwable)coreException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.stop", (String)"1:1938:1.445", (Object)this);
                }
            }
        } else {
            for (ConnectionImpl connectionImpl : this.getConnections().keySet()) {
                try {
                    if (!(connectionType == 2 && connectionImpl.getConnectionType() == 2 || connectionType == 3 && connectionImpl.getConnectionType() == 3) && (connectionType != 1 || connectionImpl.getConnectionType() != 1)) continue;
                    connectionImpl._close(false);
                    SICoreConnectionListener[] listeners = connectionImpl.getConnectionListeners();
                    for (int listenIndex = 0; listenIndex < listeners.length; ++listenIndex) {
                        listeners[listenIndex].meTerminated((SICoreConnection)connectionImpl);
                        connectionImpl.removeConnectionListener(listeners[listenIndex]);
                    }
                }
                catch (SIMPConnectionUnavailableException listeners) {
                }
                catch (SIException coreException) {
                    FFDCFilter.processException((Throwable)coreException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.stop", (String)"1:1976:1.445", (Object)this);
                }
            }
        }
    }

    private void coldStart() throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"coldStart");
        }
        this.createPersistentStore();
        this.createDestinationManager();
        this._proxyHandlerDestAddr = SIMPUtils.createJsSystemDestinationAddress("SIMP.PROXY.QUEUE", this.getMessagingEngineUuid());
        this.createProxyHandler();
        this.initializeNonPersistent();
        this._destinationChangeListener = new DestinationChangeListener(this);
        this._linkChangeListener = new LinkChangeListener(this);
        this.createControlAdapter();
        this.configureNeighbours();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"coldStart");
        }
    }

    private void initializeNonPersistent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent");
        }
        this._messageProcessorMatching = new MessageProcessorMatching(this);
        this._topicAuthorization = new TopicAuthorization(this);
        this._searchResultsPool.setTopicAuthorization(this._topicAuthorization);
        this._accessChecker.setTopicAuthorization(this._topicAuthorization);
        this._administrator = new AdministratorImpl(this);
        this._destinationLocationManager = null;
        this._linkManager = null;
        this._mqLinkManager = null;
        RoutingManager routingManager = null;
        CommsErrorListener errorListener = null;
        this._mpio.init(errorListener, routingManager);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    private void configureNeighbours() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"configureNeighbours");
        }
        try {
            JsAdminService service = JsMainAdminComponentImpl.getJsAdminService();
            this._messagingEnginesOnBus = new HashSet<SIBUuid8>();
            Set mes = null;
            if (service.isInitialized()) {
                mes = service.getMessagingEngineSet(this._engine.getBusName());
            }
            if (mes != null) {
                Iterator iterator = mes.iterator();
                LocalTransaction transaction = this._txManager.createLocalTransaction(true);
                while (iterator.hasNext()) {
                    SIBUuid8 jsEngineUUID = new SIBUuid8((String)iterator.next());
                    if (!jsEngineUUID.equals((Object)new SIBUuid8(this._engine.getUuid()))) {
                        this._multiMEProxyHandler.createNeighbour(jsEngineUUID, this._engine.getBusName(), (Transaction)transaction);
                    }
                    this._messagingEnginesOnBus.add(jsEngineUUID);
                }
                transaction.commit();
            }
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.configureNeighbours", (String)"1:2223:1.445", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SIErrorException finalE = new SIErrorException(nls.getFormattedMessage("MESSAGE_PROCESSOR_CONFIGURE_NEIGHBOURS_ERROR_CWSIP0391", new Object[]{this.getMessagingEngineName(), e}, null), (Throwable)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"configureNeighbours", (Object)((Object)finalE));
            }
            SibTr.error((TraceComponent)tc, (String)"MESSAGE_PROCESSOR_CONFIGURE_NEIGHBOURS_ERROR_CWSIP0391", (Object)new Object[]{this.getMessagingEngineName(), SIMPUtils.getStackTrace(e)});
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"configureNeighbours");
        }
    }

    private boolean reconstitute(int startMode) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)new Integer(startMode));
        }
        boolean reconstituted = false;
        this._persistentStore = (MessageProcessorStore)this._msgStore.findFirstMatching((Filter)new ClassEqualsFilter(MessageProcessorStore.class));
        if (this._persistentStore != null) {
            this._destinationManager = (DestinationManager)this._persistentStore.findFirstMatchingItemStream(new ClassEqualsFilter(DestinationManager.class));
            if (null == this._destinationManager) {
                SIMPMessageProcessorCorruptException e = new SIMPMessageProcessorCorruptException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2308:1.445"}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.reconstitute", (String)"1:2314:1.445", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2321:1.445"});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)e);
                }
                throw e;
            }
            this.initializeNonPersistent();
            this._destinationChangeListener = new DestinationChangeListener(this);
            this._linkChangeListener = new LinkChangeListener(this);
            this._destinationManager.initializeNonPersistent(this);
            this.createControlAdapter();
            try {
                this._destinationManager.reconstitute(startMode);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.reconstitute", (String)"1:2422:1.445", (Object)this);
                SIErrorException finalE = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2431:1.445", e}, null), (Throwable)e);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)((Object)finalE));
                }
                throw finalE;
            }
            reconstituted = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)new Boolean(reconstituted));
        }
        return reconstituted;
    }

    private void createProxyHandler() throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createProxyHandler");
        }
        this._multiMEProxyHandler = new MultiMEProxyHandler(this, this._txManager);
        this._persistentStore.addItemStream(this._multiMEProxyHandler, (Transaction)this._txManager.createAutoCommitTransaction());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createProxyHandler");
        }
    }

    private void createDestinationManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDestinationManager");
        }
        this._destinationManager = new DestinationManager(this, this._persistentStore);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestinationManager");
        }
    }

    private void createDynamicConfigManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDynamicConfigManager");
        }
        this._dynamicConfigManager = new DynamicConfigManager(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDynamicConfigManager");
        }
    }

    private void createPersistentStore() throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createPersistentStore");
        }
        this._persistentStore = new MessageProcessorStore(new SIBUuid8(this._engine.getUuid()), this._msgStore, this._txManager);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createPersistentStore");
        }
    }

    private void createSystemConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemConnection");
        }
        Subject subject = this._authorisationUtils.getSIBServerSubject();
        try {
            this._connectionToMP = (MPCoreConnection)this.createConnection(subject, true, null);
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.createSystemConnection", (String)"1:2529:1.445", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemConnection", (Object)("SIErrorException " + (Object)((Object)e)));
            }
            throw new SIErrorException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemConnection");
        }
    }

    public DestinationDefinition createSystemDefaultExceptionDestination() throws SIResourceException, SIMPDestinationAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemDefaultExceptionDestination");
        }
        DestinationDefinition defaultExceptionDestDef = this.createDestinationDefinition(DestinationType.QUEUE, "_SYSTEM.Exception.Destination." + this.getMessagingEngineName());
        defaultExceptionDestDef.setMaxReliability(Reliability.ASSURED_PERSISTENT);
        defaultExceptionDestDef.setDefaultReliability(Reliability.ASSURED_PERSISTENT);
        defaultExceptionDestDef.setUUID(SIMPUtils.createSIBUuid12("_SYSTEM.Exception.Destination." + this.getMessagingEngineName()));
        HashSet<String> destinationLocalizingMEs = new HashSet<String>();
        destinationLocalizingMEs.add(this.getMessagingEngineUuid().toString());
        this._destinationManager.createDestinationLocalization(defaultExceptionDestDef, this.createLocalizationDefinition(defaultExceptionDestDef.getName()), destinationLocalizingMEs, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemDefaultExceptionDestination", (Object)defaultExceptionDestDef);
        }
        return defaultExceptionDestDef;
    }

    private void createProxySystemDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createProxySystemDestination");
        }
        try {
            this._proxyHandlerDestAddr = this._connectionToMP.createSystemDestination("SIMP.PROXY.QUEUE");
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.createProxySystemDestination", (String)"1:2614:1.445", (Object)this);
            SIErrorException finalE = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2629:1.445", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2635:1.445", SIMPUtils.getStackTrace(e)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createProxySystemDestination", (Object)"SIErrorException");
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createProxySystemDestination");
        }
    }

    private void initializeTickGenerator() {
        long tick;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"initializeTickGenerator");
            }
            tick = -1L;
            try {
                tick = this._msgStore.getUniqueTickCount();
            }
            catch (PersistenceException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeTickGenerator", (Object)new Long(tick));
        }
    }

    public void startNewThread(Runnable runnable) throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startNewThread");
        }
        if (this._consumerThreadPool == null) {
            this.createConsumerThreadPool();
        }
        try {
            this._consumerThreadPool.execute(runnable, 3);
        }
        catch (ThreadPool.ThreadPoolQueueIsFullException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.startNewThread", (String)"1:2705:1.445", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startNewThread");
        }
    }

    private synchronized void createConsumerThreadPool() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerThreadPool");
        }
        if (this._consumerThreadPool == null) {
            this._consumerThreadPool = new ThreadPool("Consumer " + this.getMessagingEngineName(), 0, this._customProperties.get_max_consumer_threadpool_size(), new ThreadPoolListener[]{new ThreadPoolListenerImpl(this)});
            this._consumerThreadPool.setRequestBufferExpansionLimit(Integer.MAX_VALUE);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumerThreadPool");
        }
    }

    public void startNewSystemThread(Runnable runnable) throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startNewSystemThread", (Object)runnable);
        }
        if (this._systemThreadPool == null) {
            this.createSystemThreadPool();
        }
        try {
            this._systemThreadPool.execute(runnable, 3);
        }
        catch (ThreadPool.ThreadPoolQueueIsFullException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.startNewSystemThread", (String)"1:2758:1.445", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startNewSystemThread");
        }
    }

    private synchronized void createSystemThreadPool() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemThreadPool");
        }
        if (this._systemThreadPool == null) {
            this._systemThreadPool = new ThreadPool("System " + this.getMessagingEngineName(), 1, this._customProperties.get_max_system_threadpool_size(), new ThreadPoolListener[]{new ThreadPoolListenerImpl(this)});
            this._systemThreadPool.setRequestBufferExpansionLimit(Integer.MAX_VALUE);
            this._systemThreadPool.setGrowAsNeeded(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemThreadPool");
        }
    }

    public void setConfig(LWMConfig meConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setConfig", (Object)new Object[]{meConfig});
        }
        this._highMessageThreshold = ((JsMessagingEngine)meConfig).getMEThreshold();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setConfig");
        }
    }

    public void setCustomProperty(String propertyName, String propertyValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCustomProperty", (Object)new Object[]{propertyName, propertyValue});
        }
        this._customProperties.setProperty(propertyName, propertyValue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCustomProperty");
        }
    }

    public MessageProcessorMatching getMessageProcessorMatching() {
        return this._messageProcessorMatching;
    }

    public AccessChecker getAccessChecker() {
        return this._accessChecker;
    }

    public AuthUtils getAuthorisationUtils() {
        return this._authorisationUtils;
    }

    public TopicAuthorization getDiscriminatorAccessChecker() {
        return this._topicAuthorization;
    }

    public JsDestinationAddress getProxyHandlerDestAddr() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProxyHandlerDestAddr");
            SibTr.exit((TraceComponent)tc, (String)"getProxyHandlerDestAddr", (Object)this._proxyHandlerDestAddr);
        }
        return this._proxyHandlerDestAddr;
    }

    public SearchResultsObjectPool getSearchResultsObjectPool() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSearchResultsObjectPool");
            SibTr.exit((TraceComponent)tc, (String)"getSearchResultsObjectPool", (Object)this._connectionToMP);
        }
        return this._searchResultsPool;
    }

    public MPCoreConnection getSystemConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSystemConnection");
            SibTr.exit((TraceComponent)tc, (String)"getSystemConnection", (Object)this._connectionToMP);
        }
        return this._connectionToMP;
    }

    long getApiMajorVersion() {
        return 6L;
    }

    long getApiMinorVersion() {
        return 0L;
    }

    String getApiLevelDescription() {
        return "6.0";
    }

    public SIBUuid8 getMessagingEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessagingEngineUuid");
        }
        SIBUuid8 uuid = this._persistentStore.getMessagingEngineUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessagingEngineUuid", (Object)uuid);
        }
        return uuid;
    }

    public long nextTick() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"nextTick");
        }
        long tick = -1L;
        try {
            tick = this._msgStore.getUniqueTickCount();
        }
        catch (PersistenceException e) {
            if (TraceComponent.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"nextTick", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"nextTick", (Object)new Long(tick));
        }
        return tick;
    }

    public MEConnectionListener getMEConnectionListener() {
        return this._mpio;
    }

    public MPIO getMPIO() {
        return this._mpio;
    }

    public TopologyListener getTopologyListener() {
        return this._mpio;
    }

    public static ControlMessageFactory getControlMessageFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlMessageFactory");
        }
        if (_controlMessageFactory == null) {
            _controlMessageFactory = (ControlMessageFactory)MessageProcessor.getSingletonInstance("ControlMessageFactory");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlMessageFactory", (Object)_controlMessageFactory);
        }
        return _controlMessageFactory;
    }

    public static JsMessageHandleFactory getJsMessageHandleFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJsMessageHandleFactory");
        }
        if (_jsMessageHandleFactory == null) {
            _jsMessageHandleFactory = (JsMessageHandleFactory)MessageProcessor.getSingletonInstance("JsMessageHandleFactory");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJsMessageHandleFactory", (Object)_jsMessageHandleFactory);
        }
        return _jsMessageHandleFactory;
    }

    public void add(Item item, TransactionCommon transaction) throws MessageStoreException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"add", (Object)new Object[]{item, transaction});
        }
        Transaction msTran = this.resolveAndEnlistMsgStoreTransaction(transaction);
        this._persistentStore.addItem(item, msTran);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"add");
        }
    }

    public SIMPTransactionManager getTXManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTXManager");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTXManager", (Object)this._txManager);
        }
        return this._txManager;
    }

    public BatchHandler getTargetBatchHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetBatchHandler");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTargetBatchHandler", (Object)this._targetBatchHandler);
        }
        return this._targetBatchHandler;
    }

    public BatchHandler getSourceBatchHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSourceBatchHandler");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSourceBatchHandler", (Object)this._sourceBatchHandler);
        }
        return this._sourceBatchHandler;
    }

    public BatchHandler getPublicationBatchHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPublicationBatchHandler");
            SibTr.exit((TraceComponent)tc, (String)"getPublicationBatchHandler", (Object)this._sourceBatchHandler);
        }
        return this._publicationBatchHandler;
    }

    public StoppableThreadCache getStoppableThreadCache() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStoppableThreadCache");
            SibTr.exit((TraceComponent)tc, (String)"getStoppableThreadCache", (Object)this._stoppableThreadCache);
        }
        return this._stoppableThreadCache;
    }

    public MPAlarmManager getAlarmManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAlarmManager");
            SibTr.exit((TraceComponent)tc, (String)"getAlarmManager", (Object)this._mpAlarmManager);
        }
        return this._mpAlarmManager;
    }

    public ObjectPool getBatchedTimeoutManagerEntryPool() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBatchedTimeoutManagerEntryPool");
        }
        if (this._batchedTimeoutManagerEntryPool == null) {
            this._batchedTimeoutManagerEntryPool = new ObjectPool("BTMEntryPool", 200);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBatchedTimeoutManagerEntryPool");
        }
        return this._batchedTimeoutManagerEntryPool;
    }

    public DestinationLocationManager getDestinationLocationManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationLocationManager");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationLocationManager", (Object)this._destinationLocationManager);
        }
        return this._destinationLocationManager;
    }

    public LinkManager getLinkManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkManager");
            SibTr.exit((TraceComponent)tc, (String)"getLinkManager");
        }
        return this._linkManager;
    }

    MQLinkManager getMQLinkManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkManager");
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkManager");
        }
        return this._mqLinkManager;
    }

    public Set getSIBDestinationLocalitySet(String busName, String uuid, boolean newSet) throws SIBExceptionDestinationNotFound, SIBExceptionBase {
        return this._localistySet;
    }

    public JsDestinationAddress getTDReceiverAddr() {
        return this._tdReceiverAddr;
    }

    public boolean discardMsgsAfterQueueDeletion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"discardMsgsAfterQueueDeletion");
            SibTr.exit((TraceComponent)tc, (String)"discardMsgsAfterQueueDeletion", (Object)new Boolean(this._discardMsgsAfterQueueDeletion));
        }
        return this._discardMsgsAfterQueueDeletion;
    }

    public void setDiscardMsgsAfterQueueDeletion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDiscardMsgsAfterQueueDeletion");
            SibTr.exit((TraceComponent)tc, (String)"setDiscardMsgsAfterQueueDeletion");
        }
        this._discardMsgsAfterQueueDeletion = true;
    }

    public long getHighMessageThreshold() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHighMessageThreshold");
            SibTr.exit((TraceComponent)tc, (String)"getHighMessageThreshold", (Object)new Long(this._highMessageThreshold));
        }
        return this._highMessageThreshold;
    }

    public int getDefinedSendWindow() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefinedSendWindow");
            SibTr.exit((TraceComponent)tc, (String)"getDefinedSendWindow", (Object)new Integer(this._customProperties.get_definedSendWindow()));
        }
        return this._customProperties.get_definedSendWindow();
    }

    public DestinationChangeListener getDestinationChangeListener() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationChangeListener");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationChangeListener", (Object)this._destinationChangeListener);
        }
        return this._destinationChangeListener;
    }

    public ForeignBusDefinition getForeignBus(String busName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignBus", (Object)busName);
        }
        JsBus jsBus = (JsBus)this._engine.getBus();
        ForeignBusDefinition foreignBusDefinition = jsBus.getForeignBus(busName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getForeignBus", (Object)foreignBusDefinition);
        }
        return foreignBusDefinition;
    }

    public SIBUuid8 mapMeNameToUuid(String name) {
        SIBUuid8 result = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"mapMeNameToUuid", (Object)name);
        }
        if (name != null && name.equals(this.getMessagingEngineName())) {
            result = this.getMessagingEngineUuid();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"mapMeNameToUuid", (Object)result);
        }
        return result;
    }

    @Override
    public ControlAdapter getControlAdapter() {
        return this._controlAdapter;
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this._controlAdapter = new MessageProcessorControl(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    public static void setMPCallsToUnitTestHandler(MPCallsToUnitTestHandler newHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMPCallsToUnitTestHandler");
            SibTr.exit((TraceComponent)tc, (String)"setMPCallsToUnitTestHandler");
        }
        _mpCallsToUnitTestHandler = newHandler;
    }

    public static MPCallsToUnitTestHandler getMPCallsToUnitTestHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMPCallsToUnitTestHandler");
            SibTr.exit((TraceComponent)tc, (String)"getMPCallsToUnitTestHandler", (Object)_mpCallsToUnitTestHandler);
        }
        return _mpCallsToUnitTestHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStarted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"serverStarted");
        }
        Object object = this._mpStartStopLock;
        synchronized (object) {
            if (!this._started || this._isWASOpenForEBusiness) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"serverStarted", (Object)("Returning as ME not started " + this._started + " or already announced " + this._isWASOpenForEBusiness));
                }
                return;
            }
            this._isWASOpenForEBusiness = true;
        }
        this._destinationManager.announceWASOpenForEBusiness();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"serverStarted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStopping() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"serverStopping");
        }
        Object object = this._mpStartStopLock;
        synchronized (object) {
            this._isWASOpenForEBusiness = false;
        }
        if (this._destinationManager != null) {
            this._destinationManager.announceWASClosedForEBusiness();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"serverStopping");
        }
    }

    @Override
    public void dereferenceControlAdapter() {
        this._controlAdapter.dereferenceControllable();
        this._controlAdapter = null;
    }

    public DynamicConfigManager getDynamicConfigManager() {
        return this._dynamicConfigManager;
    }

    public boolean isBusSecure() {
        return this._isBusSecure;
    }

    public void setBusSecure(boolean secure) {
        this._isBusSecure = secure;
    }

    boolean isMulticastEnabled() {
        return this._customProperties.get_multicastEnabled();
    }

    MulticastPropertiesImpl getMulticastProperties() {
        return this._multicastProperties;
    }

    public long getID() {
        long id = -1L;
        try {
            id = this._persistentStore.getID();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.getID", (String)"1:3640:1.445", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        return id;
    }

    public void busReloaded(JsMEConfig newBus, boolean busChanged, boolean destChg, boolean medChg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"busReloaded");
        }
    }

    public void engineReloaded(Object newEngine) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"engineReloaded", (Object)newEngine);
        }
        this._engine = (JsMessagingEngine)newEngine;
        if (this._busReloaded) {
            this._dynamicConfigManager.refreshDestinations();
        }
        this._busReloaded = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"engineReloaded");
        }
    }

    public SelectionCriteriaFactory getSelectionCriteriaFactory() {
        return this._selectionCriteriaFactory;
    }

    public final boolean isSingleServer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSingleServer");
        }
        if (!this._singleServerSet) {
            JsAdminService service = JsMainAdminComponentImpl.getJsAdminService();
            this._isSingleServer = service.isInitialized() ? service.isStandaloneServer() : true;
            this._singleServerSet = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSingleServer", (Object)new Boolean(this._isSingleServer));
        }
        return this._isSingleServer;
    }

    public void setSingleServer(boolean ss) {
        this._singleServerSet = true;
        this._isSingleServer = ss;
    }

    final LockManager getConnectionLockManager() {
        return this._connectionsLockManager;
    }

    public LinkChangeListener getLinkChangeListener() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkChangeListener");
            SibTr.exit((TraceComponent)tc, (String)"getLinkChangeListener", (Object)this._linkChangeListener);
        }
        return this._linkChangeListener;
    }

    public void setRuntimeEventListener(RuntimeEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRuntimeEventListener", (Object)listener);
        }
        this._runtimeEventListener = listener;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRuntimeEventListener");
        }
    }

    public RuntimeEventListener getRuntimeEventListener() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRuntimeEventListener");
            SibTr.exit((TraceComponent)tc, (String)"getRuntimeEventListener", (Object)this._runtimeEventListener);
        }
        return this._runtimeEventListener;
    }

    private void fireNotAuthenticatedEvent(String userName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireNotAuthenticatedEvent", (Object)userName);
        }
        if (this._runtimeEventListener != null) {
            String message = nls.getFormattedMessage("USER_NOT_AUTHORIZED_ERROR_CWSIP0301", new Object[]{userName, this.getMessagingEngineName(), this.getMessagingEngineBus()}, null);
            Properties props = new Properties();
            props.put("operation", "operation.connect");
            props.put("security.userid", userName);
            props.put("security.reason", "security.reason.not.authenticated");
            this._runtimeEventListener.runtimeEventOccurred(this._engine, "SIB.security.not.authenticated", message, props);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Null RuntimeEventListener, cannot fire event");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireNotAuthenticatedEvent");
        }
    }

    private void fireNullUserEvent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireNullUserEvent");
        }
        if (this._runtimeEventListener != null) {
            String message = nls.getFormattedMessage("NULL_USER_NOT_AUTHORIZED_ERROR_CWSIP0303", new Object[]{this.getMessagingEngineName(), this.getMessagingEngineBus()}, null);
            Properties props = new Properties();
            props.put("operation", "operation.connect");
            props.put("security.userid", "");
            props.put("security.reason", "security.reason.no.userid");
            this._runtimeEventListener.runtimeEventOccurred(this._engine, "SIB.security.not.authenticated", message, props);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Null RuntimeEventListener, cannot fire event");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireNullUserEvent");
        }
    }

    public Transaction resolveAndEnlistMsgStoreTransaction(TransactionCommon transactionCommon) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolveAndEnlistMsgStoreTransaction", (Object)transactionCommon);
        }
        Transaction msgStoreTran = this.getTXManager().resolveAndEnlistMsgStoreTransaction(transactionCommon);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resolveAndEnlistMsgStoreTransaction", (Object)msgStoreTran);
        }
        return msgStoreTran;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCommandHandler(String key, CommandHandler handler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerCommandHandler", (Object)new Object[]{key, handler});
        }
        HashMap<String, CommandHandler> hashMap = this._registeredHandlers;
        synchronized (hashMap) {
            this._registeredHandlers.put(key, handler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerCommandHandler");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandHandler getRegisteredCommandHandler(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRegisteredCommandHandler", (Object)new Object[]{key});
        }
        CommandHandler cHandler = null;
        HashMap<String, CommandHandler> hashMap = this._registeredHandlers;
        synchronized (hashMap) {
            cHandler = this._registeredHandlers.get(key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRegisteredCommandHandler", (Object)cHandler);
        }
        return cHandler;
    }

    public CustomProperties getCustomProperties() {
        return this._customProperties;
    }

    public void busReloaded(Object newBus, boolean busChanged, boolean destChg, boolean medChg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"busReloaded", (Object)new Object[]{newBus, new Boolean(busChanged), new Boolean(destChg), new Boolean(medChg)});
        }
        this._busReloaded = true;
    }

    public Authentication getAuthentication() {
        return this._authentication;
    }

    public Authorization getAuthorization() {
        return this._authorization;
    }

    public void dump(FormattedWriter writer, String arg) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"dump");
            }
            try {
                writer.startTag(this.getClass().getSimpleName());
                writer.indent();
                writer.newLine();
                writer.startTag("Connections");
                writer.indent();
                for (SICoreConnection siCoreConnection : this.getConnections().values()) {
                    writer.newLine();
                    writer.write("<siCoreConnection");
                    writer.write(siCoreConnection.toString());
                    writer.write(" />");
                }
                writer.outdent();
                writer.newLine();
                writer.endTag("Connections");
                writer.outdent();
                writer.newLine();
                writer.endTag(this.getClass().getSimpleName());
            }
            catch (IOException exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught writing MessageProcessor dump!", (Object)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dump");
        }
    }

    static {
        _mpCallsToUnitTestHandler = null;
    }
}

