/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20InvalidTokenException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20InvalidTokenException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private String _key;
    private String _tokenType;
    private String _tokenSubType;

    public OAuth20InvalidTokenException(String key, String tokenType, String tokenSubType, boolean isTokenRequest) {
        super(null, "The token with key: " + key + " type: " + tokenType + " subType: " + tokenSubType + " was not found in the token cache.", null);
        this.resolveErrorType(isTokenRequest);
        this._key = key;
        this._tokenType = tokenType;
        this._tokenSubType = tokenSubType;
    }

    public OAuth20InvalidTokenException(String msgKey, String key, String tokenType, String tokenSubType, boolean isTokenRequest) {
        super(null, Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{key, tokenType, tokenSubType}), null);
        this.resolveErrorType(isTokenRequest);
        this._msgKey = msgKey;
        this._key = key;
        this._tokenType = tokenType;
        this._tokenSubType = tokenSubType;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode(this._key, locale, encoding), WebUtils.encode(this._tokenType, locale, encoding), WebUtils.encode(this._tokenSubType, locale, encoding));
    }

    public String getKey() {
        return this._key;
    }

    public String getTokenType() {
        return this._tokenType;
    }

    public String getTokenSubType() {
        return this._tokenSubType;
    }

    private void resolveErrorType(boolean isTokenRequest) {
        this._error = isTokenRequest ? "invalid_grant" : "invalid_token";
    }
}

