/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.security.openidconnect.clients.common.RedirectionEntry;
import io.openliberty.security.oidcclientcore.storage.OidcStorageUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

public class RedirectionProcessor {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final TraceComponent tc;

    public RedirectionProcessor(HttpServletRequest request, HttpServletResponse response, TraceComponent tc) {
        this.request = request;
        this.response = response;
        this.tc = tc;
    }

    public void processRedirection(RedirectionEntry redirectionEntry) throws IOException {
        String state = this.request.getParameter("state");
        if (state == null && "GET".equalsIgnoreCase(this.request.getMethod())) {
            this.getTokenFromFragment(redirectionEntry);
        } else {
            this.continueWithRedirection(redirectionEntry, state);
        }
    }

    private void getTokenFromFragment(RedirectionEntry redirectionEntry) throws IOException {
        ConvergedClientConfig clientConfig = redirectionEntry.getConvergedClientConfig(this.request, this.getClientId());
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\"><HEAD><title>Submit This Form</title></HEAD>");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
        sb.append("<BODY onload=\"javascript:document.forms[0].submit()\">");
        String requestUrl = clientConfig.getRedirectUrlFromServerToClient();
        if (requestUrl == null) {
            requestUrl = this.request.getRequestURL().toString();
        }
        requestUrl = WebUtils.htmlEncode((String)requestUrl);
        sb.append("<FORM name=\"redirectform\" id=\"redirectform\" action=\"");
        sb.append(requestUrl);
        sb.append("\" method=\"POST\">");
        sb.append("<script type=\"text/javascript\" language=\"javascript\">");
        sb.append("function createInput(name, value) {");
        sb.append("var input = document.createElement(\"input\");");
        sb.append("input.setAttribute(\"type\", \"hidden\");");
        sb.append("input.setAttribute(\"name\", name);");
        sb.append("input.setAttribute(\"value\", value);");
        sb.append("return input;");
        sb.append("}");
        sb.append("var form=document.forms[0];");
        sb.append("var state=null;");
        sb.append("var params = {}, postBody = location.hash.substring(1),");
        sb.append("regex = /([^&=]+)=([^&]*)/g, m;");
        sb.append("while (m = regex.exec(postBody)){");
        sb.append("form.appendChild( createInput(decodeURIComponent(m[1]), decodeURIComponent(m[2])));");
        sb.append("}");
        sb.append("</script>");
        sb.append("<button type=\"submit\" name=\"redirectform\">Process Form Post</button></FORM></BODY></HTML>");
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)("... expect to be redirected by the browser (\"POST\")\n" + sb.toString()), (Object[])new Object[0]);
        }
        this.response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private, max-age=0");
        this.response.setHeader("Pragma", "no-cache");
        this.response.setDateHeader("Expires", 0L);
        this.response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = this.response.getWriter();
        out.println(sb.toString());
        out.flush();
    }

    @FFDCIgnore(value={Exception.class})
    private void continueWithRedirection(RedirectionEntry redirectionEntry, String state) throws IOException {
        if (state == null || state.isEmpty()) {
            redirectionEntry.handleNoState(this.request, this.response);
            return;
        }
        String requestUrl = this.getOriginalRequestUrl(state);
        if (requestUrl == null || requestUrl.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)this.tc, (String)"OIDC_CLIENT_BAD_REQUEST_NO_COOKIE", (Object[])new Object[]{this.request.getRequestURL()});
            Tr.error((TraceComponent)this.tc, (String)errorMsg, (Object[])new Object[0]);
            this.response.sendError(500);
            return;
        }
        try {
            OidcClientUtil.verifyReferrerHostIsValid(this.request, requestUrl, OidcStorageUtils.getOriginalReqUrlStorageKey((String)state));
        }
        catch (Exception e) {
            Tr.error((TraceComponent)this.tc, (String)e.getMessage(), (Object[])new Object[0]);
            this.response.sendError(500);
            return;
        }
        String clientId = this.getClientId();
        String oidcClientId = this.getOidcClientId(state);
        String code = this.request.getParameter("code");
        String idToken = this.request.getParameter("id_token");
        if (code != null || idToken != null) {
            ConvergedClientConfig clientConfig = redirectionEntry.getConvergedClientConfig(this.request, clientId);
            this.sendToOriginalRequestUrl(requestUrl, state, clientId, oidcClientId, idToken, clientConfig);
        } else {
            redirectionEntry.sendError(this.request, this.response);
        }
    }

    private String getOriginalRequestUrl(String state) {
        String cookieName = OidcStorageUtils.getOriginalReqUrlStorageKey((String)state);
        String requestUrl = OidcClientUtil.getReferrerURLCookieHandler().getReferrerURLFromCookies(this.request, cookieName);
        OidcClientUtil.invalidateReferrerURLCookie(this.request, this.response, cookieName);
        return requestUrl;
    }

    private String getClientId() {
        String clientId = null;
        int iPrefix = this.request.getRequestURI().lastIndexOf("/");
        if (iPrefix > -1) {
            clientId = this.request.getRequestURI().substring(iPrefix + 1);
        }
        return clientId;
    }

    private String getOidcClientId(String state) {
        String oidcClientId = null;
        if (state.length() > 24) {
            oidcClientId = state.substring(24);
        }
        return oidcClientId;
    }

    private void sendToOriginalRequestUrl(String requestUrl, String state, String clientId, String oidcClientId, String id_token, ConvergedClientConfig clientCfg) throws IOException {
        String sessionState = this.request.getParameter("session_state");
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)("Request info: state: " + state + " session_state: " + sessionState), (Object[])new Object[0]);
        }
        boolean isHttpsRequest = requestUrl.toLowerCase().startsWith("https");
        OidcClientUtil.setCookieForRequestParameter(this.request, this.response, clientId, state, isHttpsRequest, clientCfg);
        if (oidcClientId != null && !oidcClientId.isEmpty() || id_token != null) {
            this.postToWASReqURLForImplicitFlow(requestUrl, oidcClientId);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)("... expect to be redirected by the browser:" + requestUrl), (Object[])new Object[0]);
            }
            this.response.sendRedirect(requestUrl);
        }
    }

    private void postToWASReqURLForImplicitFlow(String requestUrl, String oidcClientId) throws IOException {
        String access_token = this.request.getParameter("access_token");
        String id_token = this.request.getParameter("id_token");
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)("id_token:" + id_token), (Object[])new Object[0]);
        }
        StringBuffer sb = new StringBuffer("");
        this.response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private, max-age=0");
        this.response.setHeader("Pragma", "no-cache");
        this.response.setDateHeader("Expires", 0L);
        this.response.setContentType("text/html");
        sb.append("<HTML xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">");
        sb.append("<HEAD>");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        sb.append("<meta http-equiv=\"Cache-Control\" content=\"no-cache, no-store, must-revalidate\"/>");
        sb.append("<meta http-equiv=\"Pragma\" content=\"no-cache\"/>");
        sb.append("<meta http-equiv=\"Expires\" content=\"0\"/>");
        sb.append("</HEAD>");
        sb.append("<BODY onload=\"document.forms[0].submit()\">");
        sb.append("<FORM name=\"redirectform\" id=\"redirectform\" action=\"");
        sb.append(WebUtils.htmlEncode((String)requestUrl));
        sb.append("\" method=\"POST\"><div>");
        if (oidcClientId != null) {
            sb.append("<input type=\"hidden\" name=\"oidc_client\" value=\"" + WebUtils.htmlEncode((String)oidcClientId) + "\"/>");
        }
        if (access_token != null) {
            sb.append("<input type=\"hidden\" name=\"access_token\" value=\"" + WebUtils.htmlEncode((String)access_token) + "\"/>");
        }
        if (id_token != null) {
            sb.append("<input type=\"hidden\" name=\"id_token\" value=\"" + WebUtils.htmlEncode((String)id_token) + "\"/>");
        }
        sb.append("</div>");
        sb.append("<noscript><div>");
        sb.append("<button type=\"submit\" name=\"redirectform\">Process request</button>");
        sb.append("</div></noscript>");
        sb.append("</FORM></BODY></HTML>");
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)("... expect to be redirected by the browser\n" + sb.toString()), (Object[])new Object[0]);
        }
        PrintWriter out = this.response.getWriter();
        out.println(sb.toString());
        out.flush();
    }
}

