/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.backchannellogout.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.CacheValue;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class JtiCacheValue
extends CacheValue {
    private static final TraceComponent tc = Tr.register(JtiCacheValue.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    private final long clockSkew;
    static final long serialVersionUID = 7393987458985669805L;

    public JtiCacheValue(JwtClaims claims, long clockSkew) {
        super((Object)claims, clockSkew);
        this.clockSkew = clockSkew;
    }

    @FFDCIgnore(value={MalformedClaimException.class})
    public boolean isExpired(long timeoutInMilliseconds) {
        if (super.isExpired(timeoutInMilliseconds)) {
            return true;
        }
        JwtClaims claims = (JwtClaims)this.getValue();
        if (claims == null) {
            return true;
        }
        long jwtExp = 0L;
        try {
            NumericDate expirationTime = claims.getExpirationTime();
            if (expirationTime == null) {
                return false;
            }
            jwtExp = expirationTime.getValueInMillis();
        }
        catch (MalformedClaimException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting expiration time for JWT: " + (Object)((Object)e)), (Object[])new Object[0]);
            }
            return true;
        }
        return System.currentTimeMillis() > jwtExp + this.clockSkew;
    }
}

