/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.SecureRandom;
import java.util.Random;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SamlUtil {
    private static final TraceComponent tc = Tr.register(SamlUtil.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static final String chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static final long serialVersionUID = -4242735343933902811L;

    public static String hash(String stringToEncrypt) {
        if (stringToEncrypt == null) {
            return null;
        }
        int hashCode = stringToEncrypt.hashCode();
        if (hashCode < 0) {
            return "n" + (hashCode *= -1);
        }
        return "p" + hashCode;
    }

    public static String generateRandomID() {
        return "_" + SamlUtil.generateRandom(32);
    }

    public static String generateRandom() {
        return SamlUtil.generateRandom(32);
    }

    public static String generateRandom(int iCharCnt) {
        StringBuffer sb = new StringBuffer();
        Random r = SamlUtil.getRandom();
        for (int i = 0; i < iCharCnt; ++i) {
            sb.append(chars.charAt(r.nextInt(chars.length())));
        }
        return sb.toString();
    }

    static Random getRandom() {
        return new SecureRandom();
    }

    public static QName cloneQName(QName qName) {
        if (qName == null) {
            return null;
        }
        return new QName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());
    }

    public static WSCredential getWSCredential(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<WSCredential> credentials = subject.getPublicCredentials(WSCredential.class);
        return credentials.iterator().next();
    }

    public static boolean sameUser(String realmName, String userId, String cRealmName, String cUserId) {
        if (realmName == null ? cRealmName != null : !realmName.equals(cRealmName)) {
            return false;
        }
        if (userId == null) {
            return false;
        }
        return userId.equals(cUserId);
    }

    public static boolean sameUser(String userName, String accessId) {
        if (userName == null) {
            return false;
        }
        return userName.equals(accessId);
    }

    @Trivial
    public static StringBuffer dumpStackTrace(Throwable cause, int iLimited) {
        int iI;
        StackTraceElement[] stackTrace = cause.getStackTrace();
        if (iLimited == -1 || iLimited > stackTrace.length) {
            iLimited = stackTrace.length;
        }
        StringBuffer sb = new StringBuffer("\n  ");
        for (iI = 0; iI < iLimited; ++iI) {
            sb.append(stackTrace[iI].toString() + "\n  ");
        }
        if (iI < stackTrace.length) {
            sb.append("  ....\n");
        }
        return sb;
    }
}

