/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.utils.JsonUtils;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.tai.TAIJwtUtils;
import com.ibm.ws.security.social.tai.TAISubjectUtils;
import com.ibm.ws.security.social.tai.TAIWebUtils;
import com.ibm.ws.security.social.twitter.TwitterTokenServices;
import com.ibm.ws.security.social.web.utils.SocialWebUtils;
import com.ibm.wsspi.security.tai.TAIResult;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TwitterLoginFlow {
    public static final TraceComponent tc = Tr.register(TwitterLoginFlow.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    TAIWebUtils taiWebUtils = new TAIWebUtils();
    TwitterTokenServices twitterTokenServices = new TwitterTokenServices();
    SocialWebUtils webUtils = new SocialWebUtils();
    TAIJwtUtils taiJwtUtils = new TAIJwtUtils();
    static final long serialVersionUID = 7921360858788122634L;

    public TAIResult handleTwitterRequest(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig config) throws WebTrustAssociationFailedException {
        String accessToken = this.webUtils.getAndClearCookie(request, response, "WASSocialAccessToken");
        String accessTokenSecret = this.webUtils.getAndClearCookie(request, response, "WASSocialAccessTokenSecret");
        if (accessToken != null && accessTokenSecret != null) {
            this.taiWebUtils.restorePostParameters(request);
            return this.createSubjectFromTwitterCredentials(response, config, accessToken, accessTokenSecret);
        }
        this.getTwitterRequestToken(request, response, config);
        return TAIResult.create((int)403);
    }

    protected void getTwitterRequestToken(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig config) {
        this.taiWebUtils.savePostParameters(request);
        String stateValue = this.taiWebUtils.createStateCookie(request, response);
        String callbackUrl = this.taiWebUtils.getRedirectUrl(request, config);
        this.twitterTokenServices.getRequestToken(request, response, callbackUrl, stateValue, config);
    }

    protected TAIResult createSubjectFromTwitterCredentials(HttpServletResponse response, SocialLoginConfig config, String accessToken, @Sensitive String accessTokenSecret) throws WebTrustAssociationFailedException {
        Map<String, Object> userApiResponseMap = this.twitterTokenServices.verifyCredentials(response, accessToken, accessTokenSecret, config);
        if (userApiResponseMap == null) {
            return this.taiWebUtils.sendToErrorPage(response, TAIResult.create((int)401));
        }
        String userApiResponse = JsonUtils.toJson(userApiResponseMap);
        if (userApiResponse == null || userApiResponse.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"USER_API_RESPONSE_NULL_OR_EMPTY", (Object[])new Object[]{config.getUniqueId()});
            return this.taiWebUtils.sendToErrorPage(response, TAIResult.create((int)401));
        }
        return this.createResultFromUserApiResponse(response, config, userApiResponseMap, userApiResponse);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={SocialLoginException.class})
    TAIResult createResultFromUserApiResponse(HttpServletResponse response, SocialLoginConfig config, Map<String, Object> userApiResponseMap, String userApiResponse) throws WebTrustAssociationFailedException {
        String token = (String)userApiResponseMap.get("access_token");
        JwtToken issuedJwtToken = null;
        try {
            if (config.getJwtRef() != null) {
                issuedJwtToken = this.taiJwtUtils.createJwtTokenFromJson(userApiResponse, config, false);
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.tai.TwitterLoginFlow", (String)"98", (Object)this, (Object[])new Object[]{response, config, userApiResponseMap, userApiResponse});
            Tr.error((TraceComponent)tc, (String)"AUTH_CODE_FAILED_TO_CREATE_JWT", (Object[])new Object[]{config.getUniqueId(), e.getLocalizedMessage()});
            return this.taiWebUtils.sendToErrorPage(response, TAIResult.create((int)401));
        }
        try {
            TAISubjectUtils subjectUtils = this.getTAISubjectUtils(token, null, issuedJwtToken, userApiResponseMap, userApiResponse);
            return subjectUtils.createResult(response, config);
        }
        catch (SocialLoginException e) {
            Tr.error((TraceComponent)tc, (String)"TWITTER_ERROR_CREATING_RESULT", (Object[])new Object[]{config.getUniqueId(), e.getLocalizedMessage()});
            return this.taiWebUtils.sendToErrorPage(response, TAIResult.create((int)401));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.social.tai.TwitterLoginFlow", (String)"109", (Object)this, (Object[])new Object[]{response, config, userApiResponseMap, userApiResponse});
            Tr.error((TraceComponent)tc, (String)"TWITTER_ERROR_CREATING_RESULT", (Object[])new Object[]{config.getUniqueId(), e.getLocalizedMessage()});
            return this.taiWebUtils.sendToErrorPage(response, TAIResult.create((int)401));
        }
    }

    TAISubjectUtils getTAISubjectUtils(@Sensitive String accessToken, JwtToken jwt, JwtToken issuedJwt, @Sensitive Map<String, Object> userApiResponseTokens, String userApiResponse) {
        return new TAISubjectUtils(accessToken, jwt, issuedJwt, userApiResponseTokens, userApiResponse);
    }
}

