/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import com.google.common.base.Strings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public final class SimpleURLCanonicalizer {
    private static Map<String, Integer> schemePortMap = new HashMap<String, Integer>();

    private SimpleURLCanonicalizer() {
    }

    public static void registerSchemePortMapping(@Nonnull @NotEmpty String scheme, @Nonnull Integer port) {
        String trimmedScheme = Constraint.isNotNull(StringSupport.trimOrNull(scheme), "Scheme cannot be null");
        Constraint.isNotNull(port, "Port cannot be null");
        schemePortMap.put(trimmedScheme.toLowerCase(), port);
    }

    public static void deregisterSchemePortMapping(@Nonnull String scheme) {
        String trimmedScheme = Constraint.isNotNull(StringSupport.trimOrNull(scheme), "Scheme cannot be null");
        schemePortMap.remove(trimmedScheme.toLowerCase());
    }

    @Nullable
    public static Integer getRegisteredPort(@Nonnull @NotEmpty String scheme) {
        String trimmedScheme = Constraint.isNotNull(StringSupport.trimOrNull(scheme), "Scheme cannot be null");
        return schemePortMap.get(trimmedScheme.toLowerCase());
    }

    @Nonnull
    @NotEmpty
    public static String canonicalize(@Nonnull @NotEmpty String url) throws MalformedURLException {
        Constraint.isFalse(Strings.isNullOrEmpty((String)url), "URL was null or empty");
        URLBuilder urlBuilder = new URLBuilder(url);
        SimpleURLCanonicalizer.canonicalize(urlBuilder);
        return Constraint.isNotEmpty(urlBuilder.buildURL(), "Canonical URL was null");
    }

    private static void canonicalize(@Nonnull URLBuilder url) {
        Integer port;
        String scheme;
        if (url.getScheme() != null) {
            url.setScheme(url.getScheme().toLowerCase());
        }
        if ((scheme = url.getScheme()) != null && (port = SimpleURLCanonicalizer.getRegisteredPort(scheme)) != null && port.equals(url.getPort())) {
            url.setPort(null);
        }
        if (url.getHost() != null) {
            url.setHost(url.getHost().toLowerCase());
        }
    }

    static {
        SimpleURLCanonicalizer.registerSchemePortMapping("ftp", 23);
        SimpleURLCanonicalizer.registerSchemePortMapping("http", 80);
        SimpleURLCanonicalizer.registerSchemePortMapping("https", 443);
        SimpleURLCanonicalizer.registerSchemePortMapping("ldap", 389);
        SimpleURLCanonicalizer.registerSchemePortMapping("ldaps", 636);
    }
}

