/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class DynamicResponseHeaderFilter
implements Filter {
    @Nonnull
    @NonnullElements
    private Map<String, String> headers = Collections.emptyMap();
    @Nonnull
    @NonnullElements
    private Collection<Function<Pair<HttpServletRequest, HttpServletResponse>, Boolean>> callbacks = Collections.emptyList();

    public void setHeaders(@Nullable @NonnullElements Map<String, String> map) {
        if (map != null) {
            this.headers = new HashMap<String, String>(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String trimmedName = StringSupport.trimOrNull(entry.getKey());
                String trimmedValue = StringSupport.trimOrNull(entry.getValue());
                if (trimmedName == null || trimmedValue == null) continue;
                this.headers.put(trimmedName, trimmedValue);
            }
        } else {
            this.headers = Collections.emptyMap();
        }
    }

    public void setCallbacks(@Nullable @NonnullElements Collection<Function<Pair<HttpServletRequest, HttpServletResponse>, Boolean>> theCallbacks) {
        this.callbacks = theCallbacks != null ? Collections.unmodifiableList(new ArrayList<Function<Pair<HttpServletRequest, HttpServletResponse>, Boolean>>(theCallbacks)) : Collections.emptyList();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.headers.isEmpty() && this.callbacks.isEmpty()) {
            chain.doFilter(request, response);
            return;
        }
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Request is not an instance of HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Response is not an instance of HttpServletResponse");
        }
        chain.doFilter(request, (ServletResponse)new ResponseProxy((HttpServletRequest)request, (HttpServletResponse)response));
    }

    private class ResponseProxy
    extends HttpServletResponseWrapper {
        @Nonnull
        private final HttpServletRequest request;

        public ResponseProxy(@Nonnull HttpServletRequest req, HttpServletResponse response) {
            super(response);
            this.request = req;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            this.addHeaders();
            return super.getOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            this.addHeaders();
            return super.getWriter();
        }

        public void sendError(int sc, String msg) throws IOException {
            this.addHeaders();
            super.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            this.addHeaders();
            super.sendError(sc);
        }

        public void sendRedirect(String location) throws IOException {
            this.addHeaders();
            super.sendRedirect(location);
        }

        private void addHeaders() {
            for (Map.Entry header : DynamicResponseHeaderFilter.this.headers.entrySet()) {
                ((HttpServletResponse)this.getResponse()).addHeader((String)header.getKey(), (String)header.getValue());
            }
            if (!DynamicResponseHeaderFilter.this.callbacks.isEmpty()) {
                Pair<HttpServletRequest, HttpServletResponse> p = new Pair<HttpServletRequest, HttpServletResponse>(this.request, (HttpServletResponse)this.getResponse());
                for (Function callback : DynamicResponseHeaderFilter.this.callbacks) {
                    callback.apply(p);
                }
            }
        }
    }
}

