/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.PolicyUtils;
import org.apache.cxf.ws.security.policy.custom.DefaultAlgorithmSuiteLoader;
import org.apache.cxf.ws.security.tokenstore.TokenStoreException;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AsymmetricBindingHandler;
import org.apache.cxf.ws.security.wss4j.policyhandlers.SymmetricBindingHandler;
import org.apache.cxf.ws.security.wss4j.policyhandlers.TransportBindingHandler;
import org.apache.neethi.Policy;
import org.apache.wss4j.common.crypto.ThreadLocalSecurityProvider;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractBinding;
import org.apache.wss4j.policy.model.AsymmetricBinding;
import org.apache.wss4j.policy.model.SymmetricBinding;
import org.apache.wss4j.policy.model.TransportBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class PolicyBasedWSS4JOutInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public static final String SECURITY_PROCESSED = PolicyBasedWSS4JOutInterceptor.class.getName() + ".DONE";
    public static final PolicyBasedWSS4JOutInterceptor INSTANCE = new PolicyBasedWSS4JOutInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyBasedWSS4JOutInterceptor.class);
    private PolicyBasedWSS4JOutInterceptorInternal ending;
    private SAAJOutInterceptor saajOut;
    static final long serialVersionUID = 7669032982420442012L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PolicyBasedWSS4JOutInterceptor() {
        super("pre-protocol");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor", "<init>", new Object[0]);
        }
        this.saajOut = new SAAJOutInterceptor();
        this.getAfter().add(SAAJOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(SoapMessage mc) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor", "handleMessage", new Object[]{mc});
        }
        boolean enableStax = MessageUtils.getContextualBoolean((Message)mc, (String)"ws-security.enable.streaming");
        if (!enableStax) {
            if (mc.getContent(SOAPMessage.class) == null) {
                this.saajOut.handleMessage(mc);
            }
            mc.put((Object)SECURITY_PROCESSED, (Object)Boolean.TRUE);
            mc.getInterceptorChain().add((Interceptor)this.ending);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleFault(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor", "handleFault", new Object[]{message});
        }
        this.saajOut.handleFault(message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor", "handleFault");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final PolicyBasedWSS4JOutInterceptorInternal createEndingInterceptor() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor", "createEndingInterceptor", new Object[0]);
        }
        PolicyBasedWSS4JOutInterceptorInternal policyBasedWSS4JOutInterceptorInternal = new PolicyBasedWSS4JOutInterceptorInternal();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            policyBasedWSS4JOutInterceptorInternal = policyBasedWSS4JOutInterceptorInternal;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor", "createEndingInterceptor", policyBasedWSS4JOutInterceptorInternal);
        }
        return policyBasedWSS4JOutInterceptorInternal;
    }

    public final class PolicyBasedWSS4JOutInterceptorInternal
    implements PhaseInterceptor<SoapMessage> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(SoapMessage message) throws Fault {
            Object provider = message.getExchange().get(Provider.class);
            boolean useCustomProvider = provider != null && ThreadLocalSecurityProvider.isInstalled();
            try {
                if (useCustomProvider) {
                    ThreadLocalSecurityProvider.setProvider((Provider)((Provider)provider));
                }
                this.handleMessageInternal(message);
            }
            finally {
                if (useCustomProvider) {
                    ThreadLocalSecurityProvider.unsetProvider();
                }
            }
        }

        private void handleMessageInternal(SoapMessage message) throws Fault {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim == null) {
                return;
            }
            SOAPMessage saaj = (SOAPMessage)message.getContent(SOAPMessage.class);
            boolean mustUnderstand = MessageUtils.getContextualBoolean((Message)message, (String)"ws-security.must-understand", (boolean)true);
            String actor = (String)message.getContextualProperty("ws-security.actor");
            AbstractBinding binding = PolicyUtils.getSecurityBinding(aim);
            if (binding == null && PolicyBasedWSS4JOutInterceptor.this.isRequestor((Message)message)) {
                Policy policy = new Policy();
                binding = new TransportBinding(SPConstants.SPVersion.SP11, policy);
            }
            if (binding != null) {
                String symSignatureAlgorithm;
                String asymSignatureAlgorithm;
                Element el;
                WSSecHeader secHeader = new WSSecHeader(actor, mustUnderstand, (Document)saaj.getSOAPPart());
                try {
                    el = secHeader.insertSecurityHeader();
                }
                catch (WSSecurityException e) {
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("SECURITY_FAILED", LOG, new Object[0]), (Throwable)e, message.getVersion().getSender());
                }
                try {
                    SAAJUtils.getHeader((SOAPMessage)saaj).removeChild((Node)el);
                    SAAJUtils.getHeader((SOAPMessage)saaj).appendChild((Node)el);
                }
                catch (SOAPException e) {
                    // empty catch block
                }
                WSSConfig config = (WSSConfig)message.getContextualProperty(WSSConfig.class.getName());
                if (config == null) {
                    config = WSSConfig.getNewInstance();
                }
                this.translateProperties(message);
                if (binding.getAlgorithmSuite() != null) {
                    HashMap<String, Object> customAlgSuiteParameters = new HashMap<String, Object>();
                    Set keys = message.getContextualPropertyKeys();
                    for (String k : keys) {
                        if (!k.startsWith("ws-security.custom.alg.suite.")) continue;
                        customAlgSuiteParameters.put(k, message.getContextualProperty(k));
                    }
                    DefaultAlgorithmSuiteLoader.customize(binding.getAlgorithmSuite().getAlgorithmSuiteType(), customAlgSuiteParameters);
                }
                if ((asymSignatureAlgorithm = (String)message.getContextualProperty("ws-security.asymmetric.signature.algorithm")) != null && binding.getAlgorithmSuite() != null) {
                    binding.getAlgorithmSuite().getAlgorithmSuiteType().setAsymmetricSignature(asymSignatureAlgorithm);
                }
                if ((symSignatureAlgorithm = (String)message.getContextualProperty("ws-security.symmetric.signature.algorithm")) != null && binding.getAlgorithmSuite() != null) {
                    binding.getAlgorithmSuite().getAlgorithmSuiteType().setSymmetricSignature(symSignatureAlgorithm);
                }
                try {
                    if (binding instanceof TransportBinding) {
                        new TransportBindingHandler(config, (TransportBinding)binding, saaj, secHeader, aim, message).handleBinding();
                    } else if (binding instanceof SymmetricBinding) {
                        new SymmetricBindingHandler(config, (SymmetricBinding)binding, saaj, secHeader, aim, message).handleBinding();
                    } else {
                        new AsymmetricBindingHandler(config, (AsymmetricBinding)binding, saaj, secHeader, aim, message).handleBinding();
                    }
                }
                catch (SOAPException | TokenStoreException e) {
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("SECURITY_FAILED", LOG, new Object[0]), e, message.getVersion().getSender());
                }
                if (el.getFirstChild() == null) {
                    el.getParentNode().removeChild(el);
                }
            }
        }

        public Set<String> getAfter() {
            return Collections.emptySet();
        }

        public Set<String> getBefore() {
            return Collections.emptySet();
        }

        public String getId() {
            return PolicyBasedWSS4JOutInterceptorInternal.class.getName();
        }

        public String getPhase() {
            return "post-protocol";
        }

        public void handleFault(SoapMessage message) {
        }

        public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
            return null;
        }

        private void translateProperties(SoapMessage msg) {
            String bspCompliant = (String)msg.getContextualProperty("ws-security.is-bsp-compliant");
            if (bspCompliant != null) {
                msg.put((Object)"isBSPCompliant", (Object)bspCompliant);
            }
        }
    }
}

