/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import jakarta.annotation.Nonnull;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.dh.DHSupport;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.impl.AbstractDerivationKeyAgreementProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHWithExplicitKDFKeyAgreementProcessor
extends AbstractDerivationKeyAgreementProcessor {
    private final Logger log = LoggerFactory.getLogger(DHWithExplicitKDFKeyAgreementProcessor.class);

    @Override
    public String getAlgorithm() {
        return "http://www.w3.org/2009/xmlenc11#dh-es";
    }

    @Override
    protected Credential obtainPrivateCredential(@Nonnull Credential publicCredential, @Nonnull KeyAgreementParameters parameters) throws KeyAgreementException {
        Credential suppliedCredential = super.obtainPrivateCredential(publicCredential, parameters);
        if (suppliedCredential != null) {
            return suppliedCredential;
        }
        this.log.debug("Found no supplied PrivateCredential in KeyAgreementParameters, generating ephemeral key pair");
        if (!DHPublicKey.class.isInstance(publicCredential.getPublicKey())) {
            throw new KeyAgreementException("Public credential's public key is not an instance of DHPublicKey");
        }
        DHPublicKey publicKey = (DHPublicKey)DHPublicKey.class.cast(publicCredential.getPublicKey());
        try {
            KeyPair privateKeyPair = DHSupport.generateCompatibleKeyPair(publicKey, null);
            return new BasicCredential(privateKeyPair.getPublic(), privateKeyPair.getPrivate());
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new KeyAgreementException("Error generating private KeyPair from DH public key", e);
        }
    }

    @Override
    protected byte[] generateAgreementSecret(@Nonnull Credential publicCredential, @Nonnull Credential privateCredential, @Nonnull KeyAgreementParameters parameters) throws KeyAgreementException {
        if (!DHPublicKey.class.isInstance(publicCredential.getPublicKey())) {
            throw new KeyAgreementException("Public credential's public key is not an instance of DHPublicKey");
        }
        if (!DHPrivateKey.class.isInstance(privateCredential.getPrivateKey())) {
            throw new KeyAgreementException("Private credential's private key is not an instance of DHPrivateKey");
        }
        DHPublicKey publicKey = (DHPublicKey)DHPublicKey.class.cast(publicCredential.getPublicKey());
        DHPrivateKey privateKey = (DHPrivateKey)DHPrivateKey.class.cast(privateCredential.getPrivateKey());
        try {
            return DHSupport.performKeyAgreement(publicKey, privateKey, null);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new KeyAgreementException("Error generating secret from public and private DH keys", e);
        }
    }
}

