/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transport.netty.SipHandlerUtils;
import com.ibm.ws.sip.stack.transport.sip.netty.SIPConnectionFactoryImplWs;
import com.ibm.ws.sip.stack.transport.sip.netty.SipInboundChannel;
import com.ibm.ws.sip.stack.transport.sip.netty.SipTcpInboundConnLink;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;

public class SipStreamHandler
extends SimpleChannelInboundHandler<SipMessageByteBuffer> {
    private static final TraceComponent tc = Tr.register(SipStreamHandler.class);
    private final AttributeKey<SipTcpInboundConnLink> attrKey = AttributeKey.valueOf((String)"SipTcpInboundConnLink");

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelActive", (Object[])new Object[]{ctx.channel().remoteAddress() + " connected"});
        }
        ListeningPoint lp = SipHandlerUtils.getListeningPoint(ctx.channel().localAddress(), "tcp");
        SipInboundChannel inboundChannel = null;
        if (lp != null) {
            inboundChannel = SIPConnectionFactoryImplWs.instance().getInboundChannels().get(lp);
        }
        if (inboundChannel != null) {
            Attribute attr = ctx.channel().attr(this.attrKey);
            attr.setIfAbsent((Object)new SipTcpInboundConnLink(inboundChannel, ctx.channel()));
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelActive", (Object[])new Object[]{"could not associate an incoming connection with a SIP channel"});
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, SipMessageByteBuffer msg) throws Exception {
        Attribute attr;
        SipTcpInboundConnLink connLink;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelRead0", (Object[])new Object[]{ctx.channel() + ". [" + msg.getMarkedBytesNumber() + "] bytes received"});
        }
        if ((connLink = (SipTcpInboundConnLink)(attr = ctx.channel().attr(this.attrKey)).get()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelRead0", (Object[])new Object[]{"could not associate an incoming message with a SIP channel"});
            }
            throw new IOException("could not associate an incoming message with a SIP channel");
        }
        connLink.complete(msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Attribute attr;
        SipTcpInboundConnLink connLink;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelInactive", (Object[])new Object[]{ctx.channel().remoteAddress() + " has been disconnected"});
        }
        if ((connLink = (SipTcpInboundConnLink)(attr = ctx.channel().attr(this.attrKey)).get()) != null) {
            connLink.destroy();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelInactive", (Object[])new Object[]{"could not find a SIP channel"});
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("exceptionCaught. " + cause.getClass()), (Object[])new Object[0]);
        }
        Attribute attr = ctx.channel().attr(this.attrKey);
        if (cause instanceof Exception) {
            SipTcpInboundConnLink connLink = (SipTcpInboundConnLink)attr.get();
            if (connLink != null) {
                connLink.destroy((Exception)cause);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"exceptionCaught", (Object[])new Object[]{"could not find a SIP channel"});
            }
        }
        ctx.close();
    }
}

