/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import com.ibm.ws.sip.stack.transport.sip.netty.SIPConnectionFactoryImplWs;
import jain.protocol.ip.sip.ListeningPoint;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class SipHandlerUtils {
    private static final TraceComponent tc = Tr.register(SipHandlerUtils.class);

    protected static ListeningPoint getListeningPoint(SocketAddress addr, String transport) {
        ListeningPoint lp = null;
        ListeningPoint defaultLp = null;
        if (!(addr instanceof InetSocketAddress)) {
            return null;
        }
        InetSocketAddress isa = (InetSocketAddress)addr;
        for (ListeningPoint lPoint : SIPConnectionFactoryImplWs.instance().getInboundChannels().keySet()) {
            String lpHost;
            if (lPoint.getPort() != isa.getPort() || !lPoint.getTransport().equalsIgnoreCase(transport)) continue;
            String addHost = SIPStackUtil.getHostAddress(isa.getHostName());
            if (SIPStackUtil.isSameHost(addHost, lpHost = SIPStackUtil.getHostAddress(lPoint.getHost()))) {
                lp = lPoint;
                break;
            }
            defaultLp = lPoint;
        }
        if (lp == null) {
            lp = defaultLp;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getListeningPoint", (Object[])new Object[]{"a listening point was not found for: " + addr + "," + transport + ". returning the default value: " + lp});
            }
        }
        return lp;
    }
}

