/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.properties;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.AddressFactory;
import jain.protocol.ip.sip.header.HeaderFactory;
import jain.protocol.ip.sip.message.MessageFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class StackProperties {
    private static final TraceComponent tc = Tr.register(StackProperties.class);
    private static StackProperties c_instance = new StackProperties();
    private static long WAIT_FOR_PROVIDERS_TIMEOUT_MS = 10000L;
    private static final int ANY_PORT = -1;
    private MessageFactory m_messageFactory;
    private HeaderFactory m_headerFactory;
    private AddressFactory m_addressFactory;
    private CopyOnWriteArrayList<SipProvider> m_providers = new CopyOnWriteArrayList();
    private Object waitForProvidersLock = new Object(){};
    private Map<Integer, CopyOnWriteArrayList<SipProvider>> m_udpProviders = new HashMap<Integer, CopyOnWriteArrayList<SipProvider>>();
    private Map<Integer, CopyOnWriteArrayList<SipProvider>> m_tcpProviders = new HashMap<Integer, CopyOnWriteArrayList<SipProvider>>();
    private Map<Integer, CopyOnWriteArrayList<SipProvider>> m_tlsProviders = new HashMap<Integer, CopyOnWriteArrayList<SipProvider>>();
    private SipProvider m_udpProvider;
    private SipProvider m_tcpProvider;
    private SipProvider m_tlsProvider;

    protected StackProperties() {
    }

    public void setFactories(MessageFactory messageFactory, HeaderFactory headerFactory, AddressFactory addressFactory) {
        this.m_messageFactory = messageFactory;
        this.m_headerFactory = headerFactory;
        this.m_addressFactory = addressFactory;
    }

    private boolean anyProviderExists(CopyOnWriteArrayList<SipProvider> providers) {
        return providers != null && providers.size() > 0;
    }

    private void waitForAnyProvider(CopyOnWriteArrayList<SipProvider> allProviders) {
        this.waitForProviders(null, -1, allProviders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForProviders(String transport, int port, CopyOnWriteArrayList<SipProvider> allProviders) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"waitForProviders", (Object[])new Object[]{transport, port, allProviders});
        }
        try {
            Object object = this.waitForProvidersLock;
            synchronized (object) {
                long waitStart;
                CopyOnWriteArrayList<SipProvider> providers = allProviders == null ? this.getMatchingProvidersList(transport, port) : allProviders;
                long waitEnd = waitStart = System.nanoTime();
                while (!this.anyProviderExists(providers)) {
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"waitForProviders", (Object[])new Object[]{"List of SIP listening points providers is empty. Waiting for a listening points to be added.", transport, port, allProviders});
                        }
                        this.waitForProvidersLock.wait(WAIT_FOR_PROVIDERS_TIMEOUT_MS);
                        waitEnd = System.nanoTime();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.anyProviderExists(providers = allProviders == null ? this.getMatchingProvidersList(transport, port) : allProviders) || waitEnd - waitStart < WAIT_FOR_PROVIDERS_TIMEOUT_MS * 1000000L) continue;
                    throw new RuntimeException("An application is trying to access SIP endpoints, but none were set for this server. Transport=" + (transport == null ? "Any" : transport) + " port=" + port);
                }
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"waitForProviders");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announceProviderAdded() {
        Object object = this.waitForProvidersLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"announceProviderAdded", (Object[])new Object[]{"New SIP listening point provider was added. Releasing any waiting resource."});
            }
            this.waitForProvidersLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProvider(SipProvider provider) {
        Object object = this.waitForProvidersLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"addProvider", (Object[])new Object[]{provider});
            }
            this.m_providers.add(provider);
            ListeningPoint lp = provider.getListeningPoint();
            Map<Integer, CopyOnWriteArrayList<SipProvider>> providersMap = null;
            if (lp.isSecure()) {
                this.m_tlsProvider = provider;
                providersMap = this.m_tlsProviders;
            } else if (lp.getTransport().equalsIgnoreCase("tcp")) {
                this.m_tcpProvider = provider;
                providersMap = this.m_tcpProviders;
            } else if (lp.getTransport().equalsIgnoreCase("udp")) {
                this.m_udpProvider = provider;
                providersMap = this.m_udpProviders;
            }
            CopyOnWriteArrayList<SipProvider> providers = providersMap.get(lp.getPort());
            if (providers == null) {
                providers = new CopyOnWriteArrayList();
                providersMap.put(lp.getPort(), providers);
            }
            providers.add(provider);
            this.announceProviderAdded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Iterator<SipProvider> getProviders(String transport, int port) {
        CopyOnWriteArrayList<SipProvider> providers;
        block7: {
            Iterator<SipProvider> iterator;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"getProviders", (Object[])new Object[]{transport, port});
            }
            providers = null;
            try {
                Object object = this.waitForProvidersLock;
                // MONITORENTER : object
                this.waitForProviders(transport, port, null);
                providers = this.getMatchingProvidersList(transport, port);
                if (providers == null) break block7;
                iterator = providers.iterator();
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getProviders", providers);
                throw throwable;
            }
            if (!TraceComponent.isAnyTracingEnabled()) return iterator;
            if (!tc.isEntryEnabled()) return iterator;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getProviders", providers);
            return iterator;
        }
        Iterator<SipProvider> iterator = null;
        // MONITOREXIT : object
        if (!TraceComponent.isAnyTracingEnabled()) return iterator;
        if (!tc.isEntryEnabled()) return iterator;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"getProviders", providers);
        return iterator;
    }

    private CopyOnWriteArrayList<SipProvider> getMatchingProvidersList(String transport, int port) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getMatchingProvidersList", (Object[])new Object[]{transport, port});
        }
        CopyOnWriteArrayList<SipProvider> providers = null;
        Map<Integer, CopyOnWriteArrayList<SipProvider>> providersMap = null;
        if (transport == null) {
            providersMap = this.m_udpProviders;
            if (null == providersMap) {
                providers = this.m_providers;
            }
        } else if (transport.equalsIgnoreCase("tls")) {
            providersMap = this.m_tlsProviders;
        } else if (transport.equalsIgnoreCase("tcp")) {
            providersMap = this.m_tcpProviders;
        } else if (transport.equalsIgnoreCase("udp")) {
            providersMap = this.m_udpProviders;
        }
        if (providersMap != null && !providersMap.isEmpty()) {
            CopyOnWriteArrayList<SipProvider> copyOnWriteArrayList = providers = port == -1 ? providersMap.values().iterator().next() : providersMap.get(port);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getMatchingProvidersList", providers);
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipProvider getFirstProvider() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getFirstProvider", (Object[])new Object[0]);
        }
        Object object = this.waitForProvidersLock;
        synchronized (object) {
            this.waitForAnyProvider(this.m_providers);
            SipProvider provider = this.m_providers.get(0);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getFirstProvider", (Object)provider);
            }
            return provider;
        }
    }

    public MessageFactory getMessageFactory() {
        return this.m_messageFactory;
    }

    public HeaderFactory getHeadersFactory() {
        return this.m_headerFactory;
    }

    public AddressFactory getAddressFactory() {
        return this.m_addressFactory;
    }

    public static StackProperties getInstance() {
        return c_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipProvider getProvider(String transport) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getProvider", (Object[])new Object[]{transport});
        }
        Object object = this.waitForProvidersLock;
        synchronized (object) {
            this.waitForProviders(transport, -1, null);
            SipProvider provider = null;
            if (transport == null) {
                provider = this.m_udpProvider;
                if (null == provider) {
                    provider = this.getFirstProvider();
                }
            } else if (transport.equalsIgnoreCase("tls")) {
                provider = this.m_tlsProvider;
            } else if (transport.equalsIgnoreCase("tcp")) {
                provider = this.m_tcpProvider;
            } else if (transport.equalsIgnoreCase("udp")) {
                provider = this.m_udpProvider;
            }
            if (provider == null) {
                provider = this.getFirstProvider();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getProvider", (Object)provider);
            }
            return provider;
        }
    }
}

