/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.dar;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.dar.repository.ApplicationRepository;
import com.ibm.ws.sip.dar.repository.impl.PropertyApplicationRepository;
import com.ibm.ws.sip.dar.repository.impl.StartOrderApplicationRepository;
import java.io.File;
import java.io.IOException;

public class ApplicationRepositoryFactory {
    private static final LogMgr c_logger = Log.get(ApplicationRepositoryFactory.class);

    public static ApplicationRepository createApplicationRepository() {
        ApplicationRepository applicationRepository = null;
        String darConfigLocation = PropertiesStore.getInstance().getProperties().getString("sipDarConfiguration");
        if (!darConfigLocation.equals("")) {
            block10: {
                darConfigLocation = darConfigLocation.replace('\\', '/');
                darConfigLocation = darConfigLocation.replace(" ", "%20");
                Object[] params = new Object[]{darConfigLocation};
                try {
                    File propFile = new File(darConfigLocation);
                    applicationRepository = new PropertyApplicationRepository(propFile);
                    if (c_logger.isInfoEnabled()) {
                        c_logger.info("info.dar.init.4", (Object)"Start", params);
                    }
                }
                catch (IOException e2) {
                    if (!c_logger.isErrorEnabled()) break block10;
                    c_logger.error("error.dar.no.config", (String)null, params);
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Loading default application router, property file " + darConfigLocation);
            }
        }
        if (applicationRepository == null) {
            if (c_logger.isInfoEnabled()) {
                c_logger.info("info.dar.init.5", "Start");
            }
            try {
                applicationRepository = new StartOrderApplicationRepository();
                if (c_logger.isInfoEnabled()) {
                    c_logger.info("info.dar.start.order", null);
                }
            }
            catch (Exception e3) {
                c_logger.error("error.dar.repository.create.1", "Configure", e3.getMessage());
            }
        }
        return applicationRepository;
    }
}

