/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.timer;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.SipProviderImpl;
import com.ibm.ws.sip.container.events.EventsDispatcher;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.timer.BaseTimer;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.stack.transaction.SIPTransactionConstants;
import jain.protocol.ip.sip.SipException;
import javax.servlet.sip.SipApplicationSession;

public class Invite2xxRetransmitTimer
extends BaseTimer {
    private static final LogMgr c_logger = Log.get(Invite2xxRetransmitTimer.class);
    private SipServletResponseImpl _response;
    private int _count = 1;
    private long _startTime = System.currentTimeMillis();
    private long _cseq;

    public Invite2xxRetransmitTimer(SipServletResponseImpl response) {
        this._response = response;
        this._cseq = ((SipServletRequestImpl)response.getRequest()).getRequest().getCSeqHeader().getSequenceNumber();
        this.setQueueIndex(this.extractQueueIndex());
    }

    @Override
    protected int extractQueueIndex() {
        int result = -1;
        if (this._response != null) {
            TransactionUserWrapper tuImpl = this._response.getTransactionUser();
            if (tuImpl != null) {
                String sessId = tuImpl.getApplicationId();
                result = SipApplicationSessionImpl.extractAppSessionCounter(sessId);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceEntry(this, "getQueueIndex - sessId = " + sessId + " QueueIndex result = " + result);
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "getQueueIndex - can't find the appropriate TU for incoming request ...");
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "getQueueIndex - can't find incoming request ...");
        }
        return result;
    }

    @Override
    public void run() {
        TransactionUserWrapper transactionUser = this._response.getTransactionUser();
        transactionUser.handle2xxRetransmittion(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescheduleNextTimer(TransactionUserWrapper transactionUser) {
        long cTime = System.currentTimeMillis();
        if (cTime - this._startTime < SIPTransactionConstants._64T1) {
            this.retransmitResponse();
            long nextRetransmit = (long)Math.min((double)SIPTransactionConstants.T1 * Math.pow(2.0, this._count), (double)SIPTransactionConstants.T2);
            long delay = Math.min(this._startTime + SIPTransactionConstants._64T1 - cTime, nextRetransmit);
            Invite2xxRetransmitTimer invite2xxRetransmitTimer = this;
            synchronized (invite2xxRetransmitTimer) {
                if (!this.isCancelled()) {
                    SipContainerComponent.getTimerService().schedule(this, false, delay);
                    ++this._count;
                }
            }
        } else {
            EventsDispatcher.noAckReceived(this._response, transactionUser.getSipServletDesc().getSipApp());
        }
    }

    @Override
    public synchronized void cancel() {
        super.cancel();
    }

    private void retransmitResponse() {
        block2: {
            try {
                ((SipProviderImpl)this._response.getSipProvider()).sendResponse(this._response.getResponse());
            }
            catch (SipException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                c_logger.error("error.exception", "Send Failure", null, (Throwable)e2);
            }
        }
    }

    @Override
    public String getAppName() {
        SipApplicationSessionImpl sApp;
        if (this._response != null && (sApp = (SipApplicationSessionImpl)this._response.getApplicationSession()) != null && sApp.getAppDescriptor() != null) {
            return sApp.getAppDescriptor().getAppName();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted response is null...");
        }
        return null;
    }

    @Override
    public Integer getAppIndexForPMI() {
        SipApplicationSessionImpl sApp;
        if (this._response != null && (sApp = (SipApplicationSessionImpl)this._response.getApplicationSession()) != null && sApp.getAppDescriptor() != null) {
            return sApp.getAppDescriptor().getAppIndexForPmi();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted response is null...");
        }
        return null;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        if (this._response != null) {
            return this._response.getApplicationSession();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted response is null...");
        }
        return null;
    }

    @Override
    public TransactionUserWrapper getTuWrapper() {
        if (this._response != null) {
            SipSessionImplementation sSession = (SipSessionImplementation)this._response.getSession();
            if (sSession != null) {
                return sSession.getInternalTuWrapper();
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "sipSession is null...");
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted response is null...");
        }
        return null;
    }

    public long getRetransmittedResponseCSeq() {
        return this._cseq;
    }
}

