/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl.netty;

import com.ibm.ws.sip.channel.resolver.impl.netty.SipResolverService;
import com.ibm.wsspi.sip.channel.resolver.SIPUri;
import com.ibm.wsspi.sip.channel.resolver.SipURILookup;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupCallback;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class SipURILookupExample
implements SipURILookupCallback,
Runnable {
    private Hashtable<Integer, SipURILookup> _requestTable = new Hashtable();

    private SipURILookupExample() {
    }

    public static void main(String[] args) {
        SipURILookupExample re = new SipURILookupExample();
        new Thread(re).start();
    }

    private void resolveUri(SIPUri uri) {
        SipURILookup request = SipResolverService.getInstance(this, uri);
        try {
            if (request.lookup()) {
                this.handleSuccessfulResolution(request);
            } else {
                this._requestTable.put(new Integer(request.hashCode()), request);
            }
        }
        catch (SipURILookupException e2) {
            System.out.println(e2.getMessage());
        }
    }

    @Override
    public void complete(SipURILookup sl) {
        this.handleSuccessfulResolution(sl);
        this._requestTable.remove(new Integer(sl.hashCode()));
    }

    @Override
    public void error(SipURILookup sl, SipURILookupException e2) {
        SIPUri suri = null;
        suri = sl.getSipURI();
        System.out.println(suri.getHost() + ": " + e2.getMessage());
        this._requestTable.remove(new Integer(sl.hashCode()));
    }

    private void handleSuccessfulResolution(SipURILookup request) {
        ArrayList<SIPUri> al = null;
        Iterator<SIPUri> i = null;
        SIPUri answer2 = null;
        SIPUri suri = null;
        suri = request.getSipURI();
        System.out.println("SIPUri sip:user@" + suri.getHost() + " resolved to");
        al = request.getAnswer();
        for (SIPUri answer2 : al) {
            System.out.println("Transport: " + answer2.getTransport() + "\nAddress: " + answer2.getHost() + "\nPort: " + answer2.getPort());
        }
    }

    @Override
    public void run() {
        System.out.println("Entering SipResolverExample::run");
        SIPUri suri = SIPUri.createSIPUri(null);
        suri.setHost("example.com");
        suri.setTransport(null);
        suri.setPortInt(-1);
        this.resolveUri(suri);
        SIPUri suri2 = SIPUri.createSIPUri(null);
        suri2.setHost("another.com");
        suri2.setTransport(null);
        suri2.setPortInt(-1);
        this.resolveUri(suri2);
        SIPUri suri3 = SIPUri.createSIPUri(null);
        suri3.setHost("doesnotresolve.com");
        suri3.setTransport(null);
        suri3.setPortInt(-1);
        this.resolveUri(suri3);
        System.out.println("Exiting SipResolverExample::run");
    }
}

