/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.message;

import com.ibm.ws.jain.protocol.ip.sip.message.SipResponseCodes;
import com.ibm.ws.jain.protocol.ip.sip.message.SipVersion;
import com.ibm.ws.jain.protocol.ip.sip.message.SipVersionFactory;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import java.io.Serializable;
import java.util.Objects;

public class StatusLine
implements Serializable {
    SipVersion m_version = SipVersionFactory.createVersion();
    int m_code;
    String m_reasonPhrase;

    public SipVersion getSipVersion() {
        return this.m_version;
    }

    public int getStatusCode() {
        return this.m_code;
    }

    public String getReasonPhrase() {
        if (this.m_reasonPhrase == null) {
            return SipResponseCodes.getResponseCodeText(this.m_code);
        }
        return this.m_reasonPhrase;
    }

    public void setSipVersion(SipVersion version) {
        this.m_version = version;
    }

    public void setStatusCode(int code) {
        this.m_code = code;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.m_reasonPhrase = reasonPhrase;
    }

    public void setReasonPhrase(int code, char[] array, int start, int length) {
        String standard = SipResponseCodes.getResponseCodeText(code);
        if (length != standard.length()) {
            String proprietary;
            this.m_reasonPhrase = proprietary = String.valueOf(array, start, length);
            return;
        }
        for (int i = 0; i < length; ++i) {
            String proprietary;
            if (array[start + i] == standard.charAt(i)) continue;
            this.m_reasonPhrase = proprietary = String.valueOf(array, start, length);
            return;
        }
        this.m_reasonPhrase = standard;
    }

    public String toString() {
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        this.writeToCharBuffer(buffer);
        String value = buffer.toString();
        CharsBuffersPool.putBufferBack(buffer);
        return value;
    }

    public void writeToCharBuffer(CharsBuffer ret) {
        ret.append(this.m_version.toString());
        ret.append(' ');
        ret.append(this.m_code);
        ret.append(' ');
        ret.append(this.getReasonPhrase());
        ret.append("\r\n");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StatusLine)) {
            return false;
        }
        StatusLine other = (StatusLine)obj;
        boolean ret = true;
        if (this.m_reasonPhrase != null) {
            ret = this.m_reasonPhrase.equals(other.m_reasonPhrase);
        }
        return ret && this.m_version.equals(other.m_version) && this.m_code == other.m_code;
    }

    public int hashCode() {
        return Objects.hash(this.m_reasonPhrase, this.m_version, this.m_code);
    }
}

