/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.google.gson.JsonArray;
import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20AccessDeniedException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.internal.oauth20.OAuthResultImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.krb5.SpnegoUtil;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.error.impl.OAuth20AuthorizeRequestExceptionHandler;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.TemplateRetriever;
import com.ibm.ws.security.oauth20.web.AuthType;
import com.ibm.ws.security.oauth20.web.Prompt;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticatorFactory;
import com.ibm.ws.webcontainer.security.WebAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.internal.CertificateLoginAuthenticator;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UserAuthentication {
    private static TraceComponent tc = Tr.register(UserAuthentication.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    public static final String KEY_SECURITY_SERVICE = "securityService";
    protected AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    private static final Pattern FORWARD_TEMPLATE_PATTERN = Pattern.compile("\\{(/[\\w-/]+)\\}(/.+)");
    private static final String BASIC_AUTH_HEADER_NAME = "Authorization";
    public static final String PARAM_AUTHZ_FORM_TEMPLATE = "oauth20.authorization.form.template";
    public static final String PARAM_AUTHZ_LOGIN_URL = "oauth20.authorization.loginURL";
    public static final String PARAM_AUTHZ_ERROR_TEMPLATE = "oauth20.authorization.error.template";
    private static final String ATTR_OAUTH_RESULT = "oauthResult";
    private final SubjectManager subjectManager = new SubjectManager();
    private final SubjectHelper subjectHelper = new SubjectHelper();
    private ServletContext servletContext = null;
    private final AuthenticationResult SPNEGO_CONT = new AuthenticationResult(AuthResult.CONTINUE, "OIDC -> SPNEGO said continue...");
    private final SpnegoUtil spnegoUtil = new SpnegoUtil();
    static final long serialVersionUID = -7345374710003269565L;

    public OAuthResult handleAuthentication(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, Prompt prompt, AtomicServiceReference<SecurityService> securityServiceRef, ServletContext servletContext, String requiredRole) throws IOException, ServletException {
        this.securityServiceRef = securityServiceRef;
        this.servletContext = servletContext;
        boolean loggedout = false;
        AuthType authnType = this.hasAuthenticationData(request);
        if (authnType != AuthType.NONE) {
            AuthenticationResult authResult;
            if (prompt.hasLogin()) {
                this.LogoutIfRequired(request);
                loggedout = true;
            }
            if ((authResult = this.loginWithAuthenticationData(request, response, authnType, provider)).getStatus() == AuthResult.SUCCESS) {
                this.postAuthentication(request, authResult.getSubject());
                if (!request.isUserInRole(requiredRole)) {
                    response.sendError(403);
                    return new OAuthResultImpl(1, null);
                }
                return new OAuthResultImpl(0, null);
            }
            if (authResult.getStatus() == AuthResult.FAILURE || authResult.getStatus() == AuthResult.SEND_401) {
                if (authnType == AuthType.CERT || provider.isCertAuthentication()) {
                    Tr.error((TraceComponent)tc, (String)"OAUATH_CLIENT_CERT_AUTH_FAIL", (Object[])new Object[0]);
                } else {
                    Tr.error((TraceComponent)tc, (String)"OAUATH_BASIC_AUTH_FAIL", (Object[])new Object[0]);
                }
                response.setStatus(307);
                return prompt.errorLoginRequired();
            }
        }
        if (prompt.hasNone()) {
            return prompt.errorLoginRequired();
        }
        if (prompt.hasLogin() && !loggedout) {
            this.LogoutIfRequired(request);
        }
        this.sendForLogin(provider, request, response);
        return null;
    }

    public OAuthResult handleAuthenticationWithOAuthResult(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, Prompt prompt, AtomicServiceReference<SecurityService> securityServiceRef, ServletContext servletContext, String requiredRole, OAuthResult result) throws IOException, ServletException {
        this.securityServiceRef = securityServiceRef;
        this.servletContext = servletContext;
        boolean loggedout = false;
        AuthenticationResult authResult = null;
        AttributeList al = this.getAttributeList(result);
        AuthType authnType = this.hasAuthenticationData(request);
        if (authnType != AuthType.NONE) {
            if (prompt.hasLogin()) {
                this.LogoutIfRequired(request);
                loggedout = true;
            }
            if ((authResult = this.loginWithAuthenticationData(request, response, authnType, provider)).getStatus() == AuthResult.SUCCESS) {
                return this.processPostAuthentication(request, response, requiredRole, al, authResult);
            }
            if (authResult.getStatus() == AuthResult.FAILURE || authResult.getStatus() == AuthResult.SEND_401) {
                boolean bOAuth;
                this.setAuthTypeAndPrintError(provider, al, authResult, authnType);
                boolean bl = bOAuth = request.getAttribute("OidcRequest") == null;
                if (bOAuth || !prompt.hasNone()) {
                    response.sendError(401);
                    return new OAuthResultImpl(1, al, new OAuth20AccessDeniedException("security.oauth20.error.access.denied"));
                }
            }
        }
        if ((authResult = this.processSpnego(request, response, provider)).getStatus() == AuthResult.TAI_CHALLENGE) {
            return new OAuthResultImpl(2, al);
        }
        if (authResult.getStatus() == AuthResult.SUCCESS) {
            return this.processPostAuthentication(request, response, requiredRole, al, authResult);
        }
        if (prompt.hasNone()) {
            return prompt.errorLoginRequired(al);
        }
        if (prompt.hasLogin() && !loggedout) {
            this.LogoutIfRequired(request);
        }
        this.sendForLogin(provider, request, response);
        return null;
    }

    private AttributeList getAttributeList(OAuthResult result) {
        AttributeList al = result != null ? result.getAttributeList() : new AttributeList();
        return al;
    }

    private void setAuthTypeAndPrintError(OAuth20Provider provider, AttributeList al, AuthenticationResult authResult, AuthType authnType) {
        if (authnType == AuthType.CERT || provider.isCertAuthentication()) {
            if (al != null) {
                al.setAttribute("WWW-Authenticate", "WWW-Authenticate", new String[]{"Client Certificate Authentication"});
            }
            Tr.error((TraceComponent)tc, (String)"OAUATH_CLIENT_CERT_AUTH_FAIL", (Object[])new Object[]{authResult.getReason()});
        } else {
            if (al != null) {
                al.setAttribute("WWW-Authenticate", "WWW-Authenticate", new String[]{"Basic"});
            }
            Tr.error((TraceComponent)tc, (String)"OAUATH_BASIC_AUTH_FAIL", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private OAuthResult processPostAuthentication(HttpServletRequest request, HttpServletResponse response, String requiredRole, AttributeList al, AuthenticationResult authResult) throws ServletException, IOException {
        if (al != null) {
            try {
                this.validateIdTokenHint(authResult.getSubject().getPrincipals(WSPrincipal.class).iterator().next().getName(), al);
            }
            catch (OAuth20Exception oAuth20Exception) {
                void oe;
                FFDCFilter.processException((Throwable)oAuth20Exception, (String)"com.ibm.ws.security.oauth20.web.UserAuthentication", (String)"249", (Object)this, (Object[])new Object[]{request, response, requiredRole, al, authResult});
                if ("login_required".equals(oe.getError())) {
                    request.logout();
                }
                return new OAuthResultImpl(1, al, (OAuthException)oe);
            }
        }
        this.postAuthentication(request, authResult.getSubject());
        if (!request.isUserInRole(requiredRole)) {
            response.sendError(403);
            return new OAuthResultImpl(1, al);
        }
        return new OAuthResultImpl(0, al);
    }

    /*
     * WARNING - void declaration
     */
    private AuthenticationResult processSpnego(HttpServletRequest request, HttpServletResponse response, OAuth20Provider provider) {
        AuthenticationResult authResult = this.SPNEGO_CONT;
        if (!provider.isAllowSpnegoAuthentication()) {
            return authResult;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("authType", "com.ibm.ws.security.spnego");
        WebAuthenticatorFactory webAuthenticatorFactory = WebAppSecurityCollaboratorImpl.getWebAuthenticatorFactory();
        if (webAuthenticatorFactory != null) {
            try {
                WebProviderAuthenticatorProxy webProviderAuthenticatorProxy = webAuthenticatorFactory.getWebProviderAuthenticatorProxy();
                if (webProviderAuthenticatorProxy != null) {
                    authResult = webProviderAuthenticatorProxy.authenticate(request, response, props);
                }
            }
            catch (Exception webProviderAuthenticatorProxy) {
                void e;
                FFDCFilter.processException((Throwable)webProviderAuthenticatorProxy, (String)"com.ibm.ws.security.oauth20.web.UserAuthentication", (String)"281", (Object)this, (Object[])new Object[]{request, response, provider});
                e.printStackTrace();
            }
        }
        return authResult;
    }

    public void handleBasicAuthenticationWithRequiredRole(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, AtomicServiceReference<SecurityService> securityServiceRef, ServletContext servletContext, String requiredRole) throws OidcServerException {
        this.handleBasicAuthenticationWithRequiredRole(provider, request, response, securityServiceRef, servletContext, requiredRole, true);
    }

    public void handleBasicAuthenticationWithRequiredRole(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, AtomicServiceReference<SecurityService> securityServiceRef, ServletContext servletContext, String requiredRole, boolean fallbackToBasicAuth) throws OidcServerException {
        this.securityServiceRef = securityServiceRef;
        this.servletContext = servletContext;
        String description = "The user is not authenticated, or is not in the role that is required to complete this request";
        if (request.getUserPrincipal() == null) {
            AuthType authnType = this.hasAuthenticationData(request);
            if (authnType == AuthType.NONE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Request does not contain Basic Authentication header or Client Certificate", (Object[])new Object[0]);
                }
                throw new OidcServerException(description, "access_denied", 401);
            }
            if (fallbackToBasicAuth) {
                AuthenticationResult authResult = this.loginWithAuthenticationData(request, response, authnType, provider);
                if (authResult.getStatus() != AuthResult.SUCCESS) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Authentication failure...", (Object[])new Object[0]);
                    }
                    throw new OidcServerException(description, "access_denied", 401);
                }
                this.postAuthentication(request, authResult.getSubject());
            } else {
                throw new OidcServerException(description, "access_denied", 401);
            }
        }
        if (requiredRole != null) {
            boolean isClientAdminCheck = requiredRole.equals("clientManager");
            if (!(request.isUserInRole(requiredRole) || isClientAdminCheck && this.isUserProviderClientAdmin(provider, request.getUserPrincipal()))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)description, (Object[])new Object[0]);
                }
                throw new OidcServerException(description, "access_denied", 403);
            }
        }
    }

    private void postAuthentication(HttpServletRequest request, Subject subject) {
        HttpSession session;
        Subject current = this.subjectManager.getInvocationSubject();
        if (current != null && !this.subjectHelper.isUnauthenticated(current) && !subject.equals(current) && (session = request.getSession(false)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"invalidating existing HTTP Session", (Object[])new Object[0]);
            }
            session.invalidate();
        }
        this.subjectManager.setInvocationSubject(subject);
        this.subjectManager.setCallerSubject(subject);
    }

    private boolean isUserProviderClientAdmin(OAuth20Provider provider, Principal principal) {
        String userName;
        String clientManager = provider == null ? null : provider.getClientAdmin();
        String string = userName = principal == null ? null : principal.getName();
        if (userName == null || clientManager == null) {
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Provider clientManager:" + clientManager + " userName:" + userName), (Object[])new Object[0]);
        }
        return clientManager.equals(userName);
    }

    public AuthType hasAuthenticationData(HttpServletRequest request) {
        String authzHeader = request.getHeader(BASIC_AUTH_HEADER_NAME);
        if (authzHeader != null) {
            if (this.spnegoUtil.isSpnegoOrKrb5Token(authzHeader)) {
                return AuthType.SPNEGO;
            }
            return AuthType.BASIC;
        }
        X509Certificate[] certChain = (X509Certificate[])request.getAttribute("javax.net.ssl.peer_certificates");
        if (certChain != null && certChain.length > 0) {
            return AuthType.CERT;
        }
        return AuthType.NONE;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthenticationResult loginWithAuthenticationData(HttpServletRequest request, HttpServletResponse response, AuthType authType, OAuth20Provider provider) {
        AuthenticationResult authResult = null;
        CertificateLoginAuthenticator authenticator = null;
        WebAppSecurityConfig webAppSecurityConfig = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
        WebAuthenticatorProxy authenticatorProxy = webAppSecurityConfig.createWebAuthenticatorProxy();
        if (provider.isCertAuthentication()) {
            if (authType != AuthType.CERT) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"OAUATH_CERT_AUTH_WITH_NO_CERT", (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"OAUATH_CERT_AUTH_WITH_NO_CERT", (Object[])new Object[0]);
                return new AuthenticationResult(AuthResult.FAILURE, message);
            }
            authenticator = authenticatorProxy.createCertificateLoginAuthenticator();
        } else {
            switch (authType) {
                case BASIC: {
                    authenticator = authenticatorProxy.getBasicAuthAuthenticator();
                    break;
                }
                case CERT: {
                    if (!provider.isAllowCertAuthentication()) {
                        if (!TraceComponent.isAnyTracingEnabled()) return new AuthenticationResult(AuthResult.CONTINUE, "The login of the request failed because the request has authType CERT but allowCertAuthentication is false.");
                        if (!tc.isDebugEnabled()) return new AuthenticationResult(AuthResult.CONTINUE, "The login of the request failed because the request has authType CERT but allowCertAuthentication is false.");
                        Tr.debug((TraceComponent)tc, (String)"The login of the request failed because the request has authType CERT but allowCertAuthentication is false.", (Object[])new Object[0]);
                        return new AuthenticationResult(AuthResult.CONTINUE, "The login of the request failed because the request has authType CERT but allowCertAuthentication is false.");
                    }
                    authenticator = authenticatorProxy.createCertificateLoginAuthenticator();
                    break;
                }
                case SPNEGO: {
                    authResult = this.processSpnego(request, response, provider);
                    break;
                }
                default: {
                    if (!TraceComponent.isAnyTracingEnabled()) return new AuthenticationResult(AuthResult.CONTINUE, "The login of the request failed because the request has an unknown authentication type.");
                    if (!tc.isDebugEnabled()) return new AuthenticationResult(AuthResult.CONTINUE, "The login of the request failed because the request has an unknown authentication type.");
                    Tr.debug((TraceComponent)tc, (String)"The login of the request failed because the request has an unknown authentication type.", (Object[])new Object[0]);
                    return new AuthenticationResult(AuthResult.CONTINUE, "The login of the request failed because the request has an unknown authentication type.");
                }
            }
        }
        if (authType != AuthType.BASIC) {
            if (authType != AuthType.CERT) return authResult;
        }
        try {
            return authenticator.authenticate(request, response, null);
        }
        catch (Exception message) {
            void e;
            FFDCFilter.processException((Throwable)message, (String)"com.ibm.ws.security.oauth20.web.UserAuthentication", (String)"446", (Object)this, (Object[])new Object[]{request, response, authType, provider});
            if (!TraceComponent.isAnyTracingEnabled()) return new AuthenticationResult(AuthResult.FAILURE, e.getMessage());
            if (!tc.isDebugEnabled()) return new AuthenticationResult(AuthResult.FAILURE, e.getMessage());
            Tr.debug((TraceComponent)tc, (String)("The direct login of http request failed because of exception: " + e), (Object[])new Object[0]);
            return new AuthenticationResult(AuthResult.FAILURE, e.getMessage());
        }
    }

    public void renderErrorPage(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, OAuthResult result) throws ServletException, IOException {
        String templateUrl = provider.getAuthorizationErrorTemplate();
        Matcher m = FORWARD_TEMPLATE_PATTERN.matcher(templateUrl);
        if (m.matches()) {
            String contextPath = m.group(1);
            String path = m.group(2);
            request.setAttribute(ATTR_OAUTH_RESULT, (Object)result);
            RequestDispatcher dispatcher = this.getDispatcher(contextPath, path);
            if (dispatcher != null) {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                Tr.error((TraceComponent)tc, (String)"security.oauth20.endpoint.template.forward.error", (Object[])new Object[]{PARAM_AUTHZ_ERROR_TEMPLATE, contextPath, path});
            }
        } else {
            templateUrl = TemplateRetriever.normallizeTemplateUrl(request, templateUrl);
            AttributeList attrs = result.getAttributeList();
            String responseType = attrs.getAttributeValueByName("response_type");
            String redirectUri = attrs.getAttributeValueByName("redirect_uri");
            if (redirectUri == null || redirectUri.length() == 0) {
                redirectUri = this.getRegisteredRedirectUri(provider, result.getAttributeList());
            }
            OAuth20AuthorizeRequestExceptionHandler handler = new OAuth20AuthorizeRequestExceptionHandler(responseType, redirectUri, templateUrl);
            handler.handleResultException(request, response, result);
        }
    }

    private void sendForLogin(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String loginURL = provider.getCustomLoginURL();
        Integer realPort = null;
        if (request.getScheme().toLowerCase().contains("https")) {
            realPort = new WebUtils().getRedirectPortFromRequest(request);
        }
        int port = request.getServerPort();
        boolean rewriteURLs = false;
        if (realPort != null && realPort != port) {
            rewriteURLs = true;
        }
        boolean isAbsoluteLoginURL = loginURL.toLowerCase().startsWith("http://") || loginURL.toLowerCase().startsWith("https://");
        String requestURI = request.getRequestURI();
        if (request.getQueryString() != null) {
            requestURI = requestURI + "?" + request.getQueryString();
        }
        if (!(loginURL.startsWith("/") || loginURL.toLowerCase().startsWith("http://") || loginURL.toLowerCase().startsWith("https://"))) {
            loginURL = request.getContextPath() + "/" + loginURL;
        }
        if (rewriteURLs) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("rewriting urls and changing port from " + port + " to: " + realPort), (Object[])new Object[0]);
            }
            HttpServletRequest r = request;
            if (!isAbsoluteLoginURL) {
                String buf = r.getScheme() + "://" + r.getServerName() + ":" + realPort;
                if (!loginURL.startsWith("/")) {
                    buf = buf + "/";
                }
                loginURL = buf + loginURL;
            }
            requestURI = r.getScheme() + "://" + r.getServerName() + ":" + realPort + requestURI;
        }
        ReferrerURLCookieHandler handler = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig().createReferrerURLCookieHandler();
        Cookie c = handler.createCookie("WASReqURL", requestURI, request);
        if (provider.isHttpsRequired()) {
            c.setSecure(true);
        }
        response.addCookie(c);
        c = handler.createCookie("WASReLoginURL", loginURL, request);
        if (provider.isHttpsRequired()) {
            c.setSecure(true);
        }
        response.addCookie(c);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_SSO OP redirecting to login page [" + loginURL + "]"), (Object[])new Object[0]);
        }
        request.getSession(true).setAttribute("afterLogin", (Object)Boolean.TRUE);
        response.sendRedirect(loginURL);
    }

    private RequestDispatcher getDispatcher(String contextPath, String path) {
        RequestDispatcher retVal = null;
        ServletContext ctx = this.servletContext.getContext(contextPath);
        if (ctx != null) {
            retVal = ctx.getRequestDispatcher(path);
        }
        return retVal;
    }

    private void LogoutIfRequired(HttpServletRequest request) throws ServletException {
        if (request.getUserPrincipal() != null) {
            request.logout();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"login is set as a prompt parameter, thus the current user is forced to be logged out.", (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={OidcServerException.class})
    protected String getRegisteredRedirectUri(OAuth20Provider provider, AttributeList attrs) {
        String uri = null;
        String clientId = attrs.getAttributeValueByName("client_id");
        if (clientId != null && clientId.length() != 0) {
            JsonArray redirectUris;
            OidcBaseClient client;
            block5: {
                client = null;
                try {
                    OidcOAuth20ClientProvider clientProvider = provider.getClientProvider();
                    if (clientProvider != null) {
                        client = clientProvider.get(clientId);
                    }
                }
                catch (OidcServerException e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("Exception is caught" + e), (Object[])new Object[0]);
                }
            }
            if (client != null && (redirectUris = client.getRedirectUris()) != null && redirectUris.size() == 1 && (uri = redirectUris.get(0).getAsString()).startsWith("regexp:")) {
                uri = null;
            }
        }
        return uri;
    }

    boolean validateIdTokenHint(String username, AttributeList attrs) throws OAuth20Exception {
        String status;
        if (username != null && attrs != null && (status = attrs.getAttributeValueByName("id_token_hint_status")) != null) {
            if ("success".equals(status)) {
                String hint_username = attrs.getAttributeValueByName("id_token_hint_username");
                String hint_clientId = attrs.getAttributeValueByName("id_token_hint_clientid");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("username in id_token_hint : " + hint_username + " current username : " + username), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("clientid in id_token_hint : " + hint_clientId + " current clientid : " + attrs.getAttributeValueByName("client_id")), (Object[])new Object[0]);
                }
                if (hint_username != null && !hint_username.equals(username) || hint_clientId != null && !hint_clientId.equals(attrs.getAttributeValueByName("client_id"))) {
                    throw new OAuth20Exception("login_required", "End-User authentication was unsuccessful. The id_token_hint parameter value does not match the user credential or client id parameter.", null);
                }
            } else if ("fail_invalid_id_token".equals(status)) {
                throw new OAuth20Exception("invalid_request", "End-User authentication was unsuccessful. The id_token_hint parameter value is not valid.", null);
            }
        }
        return true;
    }
}

