/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.db;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.exception.OAuthDataException;
import com.ibm.ws.security.oauth20.plugins.CacheEntry;
import com.ibm.ws.security.oauth20.plugins.OAuth20TokenImpl;
import com.ibm.ws.security.oauth20.plugins.db.DetectDatabaseType;
import com.ibm.ws.security.oauth20.plugins.db.OAuthJDBCImpl;
import com.ibm.ws.security.oauth20.util.CacheUtil;
import com.ibm.ws.security.oauth20.util.DynaCacheUtils;
import com.ibm.ws.security.oauth20.util.MessageDigestUtil;
import com.ibm.ws.security.oauth20.web.EndpointUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class CachedDBTokenStore
extends OAuthJDBCImpl
implements OAuth20EnhancedTokenCache {
    private static final TraceComponent tc = Tr.register(CachedDBTokenStore.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    static final String CLASS = CachedDBTokenStore.class.getName();
    Logger _log;
    static final String CONFIG_CLEANUP_INTERVAL = "oauthjdbc.CleanupInterval";
    static final String CONFIG_LIMIT_REFRESH = "oauthjdbc.LimitRefreshToken";
    static final String CONFIG_CLEANUP_BATCH_SIZE = "oauthjdbc.CleanupBatchSize";
    static final String TYPE_AZN_GRANT = "authorization_grant";
    static final String SUBTYPE_REFRESH = "refresh_token";
    int cleanupInterval;
    int cleanupBatchSize;
    boolean limitRefreshTokens;
    static Thread cleanupThread = null;
    protected String componentId;
    protected String tableName;
    private String tokenCacheJndi;
    boolean cleanupThreadExitSemaphore;
    static Map<String, CacheEntry> cache;
    String accessTokenEncoding;
    int accessTokenLength;
    static final long serialVersionUID = 3611162169020599728L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public CachedDBTokenStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        this._log = Logger.getLogger(CLASS);
        this.cleanupInterval = 0;
        this.cleanupBatchSize = 250;
        this.limitRefreshTokens = true;
        this.cleanupThreadExitSemaphore = false;
        this.accessTokenEncoding = "plain";
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public CachedDBTokenStore(String componentId, DataSource ds, String tableName, @Sensitive Object[] credentials, String tokenCacheJndi, int cleanupInterval, int cleanupBatchSize, boolean limitRefreshTokens, String accessTokenEncoding, int accessTokenLength) {
        super(ds, credentials);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Object[] objectArray = new Object[10];
            objectArray[0] = componentId;
            objectArray[1] = ds;
            objectArray[2] = tableName;
            objectArray[3] = "<sensitive java.lang.Object[]>";
            objectArray[4] = tokenCacheJndi;
            objectArray[5] = cleanupInterval;
            objectArray[6] = cleanupBatchSize;
            objectArray[7] = limitRefreshTokens;
            objectArray[8] = accessTokenEncoding;
            objectArray[9] = accessTokenLength;
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)objectArray);
        }
        this._log = Logger.getLogger(CLASS);
        this.cleanupInterval = 0;
        this.cleanupBatchSize = 250;
        this.limitRefreshTokens = true;
        this.cleanupThreadExitSemaphore = false;
        this.accessTokenEncoding = "plain";
        this.componentId = componentId;
        this.tableName = tableName;
        this.tokenCacheJndi = tokenCacheJndi == null || "".equals(tokenCacheJndi) ? "services/cache/OAuth20DBTokenCache" : tokenCacheJndi;
        this.cleanupInterval = cleanupInterval;
        this.cleanupBatchSize = cleanupBatchSize;
        this.limitRefreshTokens = limitRefreshTokens;
        this.accessTokenEncoding = accessTokenEncoding;
        this.accessTokenLength = accessTokenLength;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void initialize() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)new Object[0]);
        }
        String methodName = "initialize";
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        if (finestLoggable) {
            this._log.logp(Level.FINEST, CLASS, methodName, "Using cleanup interval: " + this.cleanupInterval + " limitRefreshTokens: " + this.limitRefreshTokens + " cleanupBatchSize: " + this.cleanupBatchSize);
        }
        this.startCleanupThread();
        CachedDBTokenStore.getCache(this.tokenCacheJndi);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    @FFDCIgnore(value={NumberFormatException.class})
    public void init(OAuthComponentConfiguration config) {
        String methodName = "init";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName);
        }
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        super.init(config);
        this.componentId = config.getUniqueId();
        this.tableName = config.getConfigPropertyValue("oauthjdbc.token.table");
        this.cleanupInterval = config.getConfigPropertyIntValue(CONFIG_CLEANUP_INTERVAL);
        this.limitRefreshTokens = config.getConfigPropertyBooleanValue(CONFIG_LIMIT_REFRESH);
        try {
            this.cleanupBatchSize = config.getConfigPropertyIntValue(CONFIG_CLEANUP_BATCH_SIZE);
        }
        catch (NumberFormatException e) {
            this._log.logp(Level.FINEST, CLASS, methodName, "No setting for oauthjdbc.CleanupBatchSize, using default cleanup batch size of: " + this.cleanupBatchSize);
        }
        if (finestLoggable) {
            this._log.logp(Level.FINEST, CLASS, methodName, "Using cleanup interval: " + this.cleanupInterval + " limitRefreshTokens: " + this.limitRefreshTokens + " cleanupBatchSize: " + this.cleanupBatchSize);
        }
        this.startCleanupThread();
        String tokenCacheJndi = config.getConfigPropertyValue("oauth20.db.token.cache.jndi.tokens");
        if (tokenCacheJndi == null || "".equals(tokenCacheJndi)) {
            tokenCacheJndi = "services/cache/OAuth20DBTokenCache";
        }
        CachedDBTokenStore.getCache(tokenCacheJndi);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private static synchronized void getCache(String tokenCacheJndi) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCache", (Object)new Object[]{tokenCacheJndi});
        }
        if (cache == null) {
            cache = DynaCacheUtils.getDynamicCache(tokenCacheJndi, new String[0], new CacheEntry[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public OAuth20Token getByHash(String hash) {
        OAuth20Token result;
        String methodName;
        block21: {
            CacheEntry ce;
            String cacheKey;
            block19: {
                methodName = "getByHash";
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)methodName, (Object)new Object[]{hash});
                }
                result = null;
                Connection conn = null;
                boolean error = false;
                ResultSet queryResults = null;
                cacheKey = this.getCacheKey(hash);
                ce = cache.get(cacheKey);
                if (ce != null) {
                    if (!ce.isExpired()) {
                        result = ce._token;
                    } else {
                        cache.remove(cacheKey);
                    }
                }
                if (result != null) break block21;
                try {
                    conn = this.getDBConnection();
                    conn.setAutoCommit(false);
                    String query = "SELECT * FROM " + this.tableName + " WHERE " + "LOOKUPKEY" + " = ? AND " + "COMPONENTID" + " = ?";
                    PreparedStatement st = conn.prepareStatement(query);
                    st.setString(1, hash);
                    st.setString(2, this.componentId);
                    queryResults = st.executeQuery();
                    while (queryResults != null && result == null && queryResults.next()) {
                        result = this.createToken(queryResults);
                    }
                    this.closeResultSet(queryResults);
                }
                catch (Exception query) {
                    void e;
                    FFDCFilter.processException((Throwable)query, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"210", (Object)this, (Object[])new Object[]{hash});
                    this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                    error = true;
                    break block19;
                }
                finally {
                    this.closeResultSet(queryResults);
                    this.closeConnection(conn, error);
                    this._log.exiting(CLASS, methodName, result);
                }
                this.closeConnection(conn, error);
                this._log.exiting(CLASS, methodName, result);
            }
            if (result != null) {
                cache.put(cacheKey, new CacheEntry(result, result.getLifetimeSeconds()));
            } else {
                block20: {
                    try {
                        Thread.yield();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"227", (Object)this, (Object[])new Object[]{hash});
                        if (!tc.isDebugEnabled()) break block20;
                        Tr.debug((TraceComponent)tc, (String)"Internal error while yielding", (Object)new Object[]{e});
                    }
                }
                ce = cache.get(cacheKey);
                if (ce != null) {
                    if (!ce.isExpired()) {
                        result = ce._token;
                    } else {
                        cache.remove(cacheKey);
                    }
                }
            }
        }
        if (tc.isDebugEnabled() && result == null) {
            Tr.debug((TraceComponent)tc, (String)"Token not found, lookup details follow:");
            Tr.debug((TraceComponent)tc, (String)("  table name: " + this.tableName));
            Tr.debug((TraceComponent)tc, (String)("  lookup key: " + hash));
            Tr.debug((TraceComponent)tc, (String)("  component ID: " + this.componentId));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void removeByHash(String hash) {
        String methodName = "removeByHash";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object)new Object[]{hash});
        }
        Connection conn = null;
        boolean error = false;
        String cacheKey = this.getCacheKey(hash);
        CacheEntry ce = cache.get(cacheKey);
        if (ce != null) {
            cache.remove(cacheKey);
        }
        try {
            conn = this.getDBConnection();
            conn.setAutoCommit(false);
            String delete = "DELETE FROM " + this.tableName + " WHERE " + "LOOKUPKEY" + " = ? AND " + "COMPONENTID" + " = ?";
            PreparedStatement st = conn.prepareStatement(delete);
            st.setString(1, hash);
            st.setString(2, this.componentId);
            st.execute();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Token removed, details follow:");
                Tr.debug((TraceComponent)tc, (String)("  table name: " + this.tableName));
                Tr.debug((TraceComponent)tc, (String)("  lookup key: " + hash));
                Tr.debug((TraceComponent)tc, (String)("  component ID: " + this.componentId));
            }
        }
        catch (Exception delete) {
            void e;
            FFDCFilter.processException((Throwable)delete, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"293", (Object)this, (Object[])new Object[]{hash});
            this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
            error = true;
        }
        finally {
            this.closeConnection(conn, error);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void add(String lookupKeyParm, OAuth20Token entry, int lifetime) {
        String methodName = "add";
        String lookupKey = lookupKeyParm;
        boolean shouldHash = false;
        CacheUtil cacheUtil = new CacheUtil();
        if (cacheUtil.shouldHash(entry, this.accessTokenEncoding)) {
            shouldHash = true;
            lookupKey = cacheUtil.computeHash(lookupKeyParm, this.accessTokenEncoding);
        } else {
            lookupKey = MessageDigestUtil.getDigest(lookupKeyParm);
        }
        this._log.entering(CLASS, methodName, new Object[]{lookupKeyParm, lookupKey});
        Connection conn = null;
        boolean error = false;
        String cacheKey = this.getCacheKey(lookupKey);
        cache.put(cacheKey, new CacheEntry(entry, lifetime));
        long expires = 0L;
        if (entry.getLifetimeSeconds() > 0) {
            expires = entry.getCreatedAt() + 1000L * (long)entry.getLifetimeSeconds();
        }
        StringBuffer scopes = new StringBuffer();
        String[] ascopes = entry.getScope();
        if (ascopes != null && ascopes.length > 0) {
            for (int i = 0; i < ascopes.length; ++i) {
                scopes.append(ascopes[i].trim());
                if (i >= ascopes.length - 1) continue;
                scopes.append(" ");
            }
        }
        String tokenId = entry.getId();
        String tokenString = entry.getTokenString();
        if (shouldHash) {
            tokenId = cacheUtil.computeHash(tokenId, this.accessTokenEncoding);
            tokenString = cacheUtil.computeHash(tokenString, this.accessTokenEncoding);
        } else {
            tokenString = PasswordUtil.passwordEncode((String)tokenString);
        }
        try {
            conn = this.getDBConnection();
            conn.setAutoCommit(false);
            String insert = "INSERT INTO " + this.tableName + " (" + "LOOKUPKEY" + "," + "UNIQUEID" + "," + "COMPONENTID" + "," + "TYPE" + "," + "SUBTYPE" + "," + "CREATEDAT" + "," + "LIFETIME" + "," + "EXPIRES" + "," + "TOKENSTRING" + "," + "CLIENTID" + "," + "USERNAME" + "," + "SCOPE" + "," + "REDIRECTURI" + "," + "STATEID" + ") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement st = conn.prepareStatement(insert);
            st.setString(1, lookupKey);
            st.setString(2, tokenId);
            st.setString(3, this.componentId);
            st.setString(4, entry.getType());
            st.setString(5, entry.getSubType());
            st.setLong(6, entry.getCreatedAt());
            st.setInt(7, entry.getLifetimeSeconds());
            st.setLong(8, expires);
            st.setString(9, tokenString);
            st.setString(10, entry.getClientId());
            st.setString(11, entry.getUsername());
            st.setString(12, scopes.toString());
            st.setString(13, entry.getRedirectUri());
            st.setString(14, entry.getStateId());
            st.execute();
        }
        catch (Exception insert) {
            void e;
            FFDCFilter.processException((Throwable)insert, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"394", (Object)this, (Object[])new Object[]{lookupKeyParm, entry, lifetime});
            this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
            error = true;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.adminTasks.securityDomain.SecurityConfigProvider", (String)"334", (Object)this);
        }
        finally {
            this.closeConnection(conn, error);
            if (tc.isDebugEnabled() && !error) {
                Tr.debug((TraceComponent)tc, (String)"Token added, details follow:");
                Tr.debug((TraceComponent)tc, (String)("  table: " + this.tableName));
                Tr.debug((TraceComponent)tc, (String)("  key: " + lookupKey));
                Tr.debug((TraceComponent)tc, (String)("  id: " + entry.getId()));
                Tr.debug((TraceComponent)tc, (String)("  component: " + this.componentId));
                Tr.debug((TraceComponent)tc, (String)("  type: " + entry.getType()));
                Tr.debug((TraceComponent)tc, (String)("  subtype: " + entry.getSubType()));
                Tr.debug((TraceComponent)tc, (String)("  creation: " + entry.getCreatedAt()));
                Tr.debug((TraceComponent)tc, (String)("  lifetime: " + entry.getLifetimeSeconds()));
                Tr.debug((TraceComponent)tc, (String)("  expires: " + expires));
                Tr.debug((TraceComponent)tc, (String)"  (password skipped)");
                Tr.debug((TraceComponent)tc, (String)("  client id: " + entry.getClientId()));
                Tr.debug((TraceComponent)tc, (String)("  username: " + entry.getUsername()));
                Tr.debug((TraceComponent)tc, (String)("  scopes: " + scopes.toString()));
                Tr.debug((TraceComponent)tc, (String)("  redirect: " + entry.getRedirectUri()));
                Tr.debug((TraceComponent)tc, (String)("  state: " + entry.getStateId()));
            }
            this._log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Collection<OAuth20Token> getAll() {
        ArrayList<OAuth20Token> results;
        block6: {
            String methodName = "getAll";
            this._log.entering(CLASS, methodName, new Object[0]);
            results = new ArrayList<OAuth20Token>();
            Connection conn = null;
            boolean error = false;
            ResultSet queryResults = null;
            try {
                conn = this.getDBConnection();
                conn.setAutoCommit(false);
                String query = "SELECT * FROM " + this.tableName + " WHERE " + "COMPONENTID" + " =? ";
                PreparedStatement st = conn.prepareStatement(query);
                st.setString(1, this.componentId);
                queryResults = st.executeQuery();
                while (queryResults != null && queryResults.next()) {
                    OAuth20Token result = this.createToken(queryResults);
                    results.add(result);
                }
                this.closeResultSet(queryResults);
            }
            catch (Exception query) {
                void e;
                FFDCFilter.processException((Throwable)query, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"453", (Object)this, (Object[])new Object[0]);
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                error = true;
                break block6;
            }
            finally {
                this.closeResultSet(queryResults);
                this.closeConnection(conn, error);
                this._log.exiting(CLASS, methodName, results);
            }
            this.closeConnection(conn, error);
            this._log.exiting(CLASS, methodName, results);
        }
        return results;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected OAuth20Token createToken(ResultSet queryResults) throws SQLException {
        Date now;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createToken", (Object)new Object[]{queryResults});
        }
        String methodName = "createToken";
        OAuth20TokenImpl result = null;
        String uniqueId = queryResults.getString("UNIQUEID");
        String componentId = queryResults.getString("COMPONENTID");
        String type = queryResults.getString("TYPE");
        String subType = queryResults.getString("SUBTYPE");
        long createdAt = queryResults.getLong("CREATEDAT");
        int lifetime = queryResults.getInt("LIFETIME");
        long expires = queryResults.getLong("EXPIRES");
        String tokenString = queryResults.getString("TOKENSTRING");
        try {
            if (!PasswordUtil.isHashed((String)tokenString)) {
                tokenString = PasswordUtil.passwordDecode((String)tokenString);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"486", (Object)this, (Object[])new Object[]{queryResults});
        }
        String clientId = queryResults.getString("CLIENTID");
        String username = queryResults.getString("USERNAME");
        String scopeStr = queryResults.getString("SCOPE");
        String redirectUri = queryResults.getString("REDIRECTURI");
        String stateId = queryResults.getString("STATEID");
        String[] scopes = null;
        if (scopeStr != null) {
            scopes = scopeStr.split(" ");
        }
        if ((now = new Date()).getTime() < expires) {
            result = new OAuth20TokenImpl(uniqueId, componentId, type, subType, createdAt, lifetime, tokenString, clientId, username, scopes, redirectUri, stateId, null, null);
        } else {
            FFDCFilter.processException((Throwable)new Exception("The OAuth20Token is expired already"), (String)"com.ibm.ws.security.adminTasks.securityDomain.SecurityConfigProvider", (String)"441", (Object)this);
            this._log.logp(Level.FINEST, CLASS, methodName, "The OAuth20Token is expired already");
        }
        OAuth20TokenImpl oAuth20TokenImpl = result;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            oAuth20TokenImpl = oAuth20TokenImpl;
            Tr.exit((TraceComponent)tc, (String)"createToken", (Object)oAuth20TokenImpl);
        }
        return oAuth20TokenImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private void dumpTokens(Connection conn) {
        String methodName = "dumpTokens";
        this._log.entering(CLASS, methodName);
        ResultSet queryResults = null;
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        try {
            String query = "SELECT * FROM " + this.tableName;
            PreparedStatement st = conn.prepareStatement(query);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                boolean expired;
                String type = queryResults.getString("TYPE");
                String subType = queryResults.getString("SUBTYPE");
                long expires = queryResults.getLong("EXPIRES");
                String tokenString = queryResults.getString("TOKENSTRING");
                Date now = new Date();
                boolean bl = expired = now.getTime() >= expires;
                if (!finestLoggable) continue;
                this._log.logp(Level.FINEST, CLASS, methodName, "token: " + tokenString + " type: " + type + " subtype: " + subType + " expires: " + expires + " expired: " + expired);
            }
        }
        catch (Exception query) {
            try {
                void e;
                FFDCFilter.processException((Throwable)query, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"546", (Object)this, (Object[])new Object[]{conn});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(queryResults);
                this._log.exiting(CLASS, methodName);
                throw throwable;
            }
            this.closeResultSet(queryResults);
            this._log.exiting(CLASS, methodName);
        }
        this.closeResultSet(queryResults);
        this._log.exiting(CLASS, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    void startCleanupThread() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startCleanupThread", (Object)new Object[0]);
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (cleanupThread == null && this.cleanupInterval > 0) {
                cleanupThread = new CleanupThread(this);
                cleanupThread.start();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startCleanupThread");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void stopCleanupThread() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopCleanupThread", (Object)new Object[0]);
        }
        this.cleanupThreadExitSemaphore = true;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopCleanupThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected int getExpiredCount(long nowTime) {
        String methodName = "getExpiredCount";
        this._log.entering(CLASS, methodName, new Object[0]);
        int result = -1;
        ResultSet queryResults = null;
        Statement st = null;
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            conn.setAutoCommit(false);
            this._log.logp(Level.FINE, CLASS, methodName, "Checking for expired with time: " + nowTime);
            String query = "SELECT COUNT(*) AS \"TOTAL\" FROM " + this.tableName + " WHERE " + "EXPIRES" + " > 0 AND " + "EXPIRES" + " <= ? ";
            st = conn.prepareStatement(query);
            st.setLong(1, nowTime);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                result = queryResults.getInt("TOTAL");
                this._log.logp(Level.FINE, CLASS, methodName, "Updated result to: " + result);
            }
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"743", (Object)this, (Object[])new Object[]{nowTime});
            this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), e);
            this.closeResultSet(queryResults);
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e2222222222) {
                    FFDCFilter.processException((Throwable)e2222222222, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"754", (Object)this, (Object[])new Object[]{nowTime});
                    this._log.logp(Level.SEVERE, CLASS, methodName, e2222222222.getMessage(), e2222222222);
                }
            }
            this.closeConnection(conn, false);
            this._log.exiting(CLASS, methodName, result);
        }
        catch (OAuthDataException e2) {
            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"746", (Object)this, (Object[])new Object[]{nowTime});
            this._log.logp(Level.SEVERE, CLASS, methodName, e2.getMessage(), e2);
            {
                catch (Throwable throwable) {
                    this.closeResultSet(queryResults);
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException sQLException) {
                            void e3;
                            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"754", (Object)this, (Object[])new Object[]{nowTime});
                            this._log.logp(Level.SEVERE, CLASS, methodName, e3.getMessage(), (Throwable)e3);
                        }
                    }
                    this.closeConnection(conn, false);
                    this._log.exiting(CLASS, methodName, result);
                    throw throwable;
                }
            }
            this.closeResultSet(queryResults);
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e4222222222) {
                    FFDCFilter.processException((Throwable)e4222222222, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"754", (Object)this, (Object[])new Object[]{nowTime});
                    this._log.logp(Level.SEVERE, CLASS, methodName, e4222222222.getMessage(), e4222222222);
                }
            }
            this.closeConnection(conn, false);
            this._log.exiting(CLASS, methodName, result);
        }
        this.closeResultSet(queryResults);
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException query) {
                void e;
                FFDCFilter.processException((Throwable)query, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"754", (Object)this, (Object[])new Object[]{nowTime});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
            }
        }
        this.closeConnection(conn, false);
        this._log.exiting(CLASS, methodName, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public int getNumTokens(String username, String client) {
        String methodName = "getNumTokens";
        this._log.entering(CLASS, methodName, new Object[]{username, client});
        int result = -1;
        ResultSet queryResults = null;
        Statement st = null;
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            conn.setAutoCommit(false);
            String query = "SELECT COUNT(*) AS \"TOTAL\" FROM " + this.tableName + " WHERE " + "COMPONENTID" + " =? AND " + "CLIENTID" + " =? AND " + "USERNAME" + " =?";
            st = conn.prepareStatement(query);
            st.setString(1, this.componentId);
            st.setString(2, client);
            st.setString(3, username);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                result = queryResults.getInt("TOTAL");
                this._log.logp(Level.FINE, CLASS, methodName, "Updated result to: " + result);
            }
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"796", (Object)this, (Object[])new Object[]{username, client});
            this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), e);
            this.closeResultSet(queryResults);
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e2222222222) {
                    FFDCFilter.processException((Throwable)e2222222222, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"807", (Object)this, (Object[])new Object[]{username, client});
                    this._log.logp(Level.SEVERE, CLASS, methodName, e2222222222.getMessage(), e2222222222);
                }
            }
            this.closeConnection(conn, false);
            this._log.exiting(CLASS, methodName, result);
        }
        catch (OAuthDataException e2) {
            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"799", (Object)this, (Object[])new Object[]{username, client});
            this._log.logp(Level.SEVERE, CLASS, methodName, e2.getMessage(), e2);
            {
                catch (Throwable throwable) {
                    this.closeResultSet(queryResults);
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException sQLException) {
                            void e3;
                            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"807", (Object)this, (Object[])new Object[]{username, client});
                            this._log.logp(Level.SEVERE, CLASS, methodName, e3.getMessage(), (Throwable)e3);
                        }
                    }
                    this.closeConnection(conn, false);
                    this._log.exiting(CLASS, methodName, result);
                    throw throwable;
                }
            }
            this.closeResultSet(queryResults);
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e4222222222) {
                    FFDCFilter.processException((Throwable)e4222222222, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"807", (Object)this, (Object[])new Object[]{username, client});
                    this._log.logp(Level.SEVERE, CLASS, methodName, e4222222222.getMessage(), e4222222222);
                }
            }
            this.closeConnection(conn, false);
            this._log.exiting(CLASS, methodName, result);
        }
        this.closeResultSet(queryResults);
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException query) {
                void e;
                FFDCFilter.processException((Throwable)query, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"807", (Object)this, (Object[])new Object[]{username, client});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
            }
        }
        this.closeConnection(conn, false);
        this._log.exiting(CLASS, methodName, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Collection<OAuth20Token> getAllUserTokens(String username) {
        ArrayList<OAuth20Token> results;
        block6: {
            String methodName = "getAllAccessTokens";
            this._log.entering(CLASS, methodName, new Object[]{username});
            results = new ArrayList<OAuth20Token>();
            Connection conn = null;
            boolean error = false;
            ResultSet queryResults = null;
            try {
                conn = this.getDBConnection();
                conn.setAutoCommit(false);
                String query = "SELECT * FROM " + this.tableName + " WHERE " + "COMPONENTID" + " =? AND " + "USERNAME" + " =?";
                PreparedStatement st = conn.prepareStatement(query);
                st.setString(1, this.componentId);
                st.setString(2, username);
                queryResults = st.executeQuery();
                while (queryResults != null && queryResults.next()) {
                    OAuth20Token result = this.createToken(queryResults);
                    if (result == null) continue;
                    results.add(result);
                }
                this.closeResultSet(queryResults);
            }
            catch (Exception query) {
                void e;
                FFDCFilter.processException((Throwable)query, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"847", (Object)this, (Object[])new Object[]{username});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                error = true;
                break block6;
            }
            finally {
                this.closeResultSet(queryResults);
                this.closeConnection(conn, error);
                this._log.exiting(CLASS, methodName, results);
            }
            this.closeConnection(conn, error);
            this._log.exiting(CLASS, methodName, results);
        }
        return results;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected String getCacheKey(String lookupKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCacheKey", (Object)new Object[]{lookupKey});
        }
        String string = lookupKey + "_" + this.componentId;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((TraceComponent)tc, (String)"getCacheKey", (Object)string);
        }
        return string;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public OAuth20Token get(String lookupKey) {
        Tr.entry((TraceComponent)tc, (String)"get", (Object)lookupKey);
        String hash = lookupKey;
        if (!PasswordUtil.isHashed((String)hash)) {
            hash = !"plain".equals(this.accessTokenEncoding) || lookupKey.length() == this.accessTokenLength + 2 ? EndpointUtils.computeTokenHash(lookupKey, this.accessTokenEncoding) : MessageDigestUtil.getDigest(lookupKey);
        }
        return this.getByHash(hash);
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void remove(String lookupKey) {
        Tr.entry((TraceComponent)tc, (String)"remove", (Object)lookupKey);
        String hash = lookupKey;
        if (!PasswordUtil.isHashed((String)hash)) {
            hash = !"plain".equals(this.accessTokenEncoding) || lookupKey.length() == this.accessTokenLength + 2 ? EndpointUtils.computeTokenHash(lookupKey, this.accessTokenEncoding) : MessageDigestUtil.getDigest(lookupKey);
        }
        this.removeByHash(hash);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void addByHash(String hash, OAuth20Token entry, int lifetime) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addByHash", (Object)new Object[]{hash, entry, lifetime});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addByHash");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Collection<OAuth20Token> getMatchingTokens(String username, String client, String tokenType) {
        ArrayList<OAuth20Token> results;
        block8: {
            String methodName = "getMatchingTokens";
            this._log.entering(CLASS, methodName, new Object[]{username});
            results = new ArrayList<OAuth20Token>();
            Connection conn = null;
            boolean error = false;
            ResultSet queryResults = null;
            try {
                PreparedStatement st;
                String query;
                conn = this.getDBConnection();
                conn.setAutoCommit(false);
                if (tokenType != null) {
                    query = "SELECT * FROM " + this.tableName + " WHERE " + "COMPONENTID" + " =? AND " + "CLIENTID" + " =? AND " + "USERNAME" + " =? AND " + "STATEID" + " =?";
                    st = conn.prepareStatement(query);
                    st.setString(1, this.componentId);
                    st.setString(2, client);
                    st.setString(3, username);
                    st.setString(4, tokenType);
                    queryResults = st.executeQuery();
                } else {
                    query = "SELECT * FROM " + this.tableName + " WHERE " + "COMPONENTID" + " =? AND " + "CLIENTID" + " =? AND " + "USERNAME" + " =?";
                    st = conn.prepareStatement(query);
                    st.setString(1, this.componentId);
                    st.setString(2, client);
                    st.setString(3, username);
                    queryResults = st.executeQuery();
                }
                while (queryResults != null && queryResults.next()) {
                    OAuth20Token result = this.createToken(queryResults);
                    if (result == null) continue;
                    results.add(result);
                }
                this.closeResultSet(queryResults);
            }
            catch (Exception result) {
                void e;
                FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBTokenStore", (String)"946", (Object)this, (Object[])new Object[]{username, client, tokenType});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                error = true;
                break block8;
            }
            finally {
                this.closeResultSet(queryResults);
                this.closeConnection(conn, error);
                this._log.exiting(CLASS, methodName, results);
            }
            this.closeConnection(conn, error);
            this._log.exiting(CLASS, methodName, results);
        }
        return results;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Collection<OAuth20Token> getUserAndClientTokens(String username, String client) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserAndClientTokens", (Object)new Object[]{username, client});
        }
        Collection<OAuth20Token> collection = this.getMatchingTokens(username, client, null);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            collection = collection;
            Tr.exit((TraceComponent)tc, (String)"getUserAndClientTokens", collection);
        }
        return collection;
    }

    @Trivial
    class CleanupThread
    extends Thread {
        final String MYCLASS = CleanupThread.class.getName();
        Logger _log = Logger.getLogger(this.MYCLASS);
        protected boolean fineLoggable;
        protected boolean finestLoggable;
        protected CachedDBTokenStore _me;
        protected DetectDatabaseType.DBType databaseType = null;

        public CleanupThread(CachedDBTokenStore me) {
            this._me = me;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String methodName = "run";
            this._log.entering(this.MYCLASS, methodName);
            Connection connCheck = null;
            try {
                connCheck = this._me.getDBConnection();
                this.databaseType = DetectDatabaseType.DetectionUtils.detectDbType(connCheck);
            }
            catch (OAuthDataException e) {
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), e);
                return;
            }
            finally {
                block17: {
                    try {
                        if (connCheck != null && !connCheck.isClosed()) {
                            connCheck.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!this.finestLoggable) break block17;
                        this._log.logp(Level.FINEST, this.MYCLASS, methodName, "Unable to close connection.");
                    }
                }
            }
            this.fineLoggable = this._log.isLoggable(Level.FINE);
            this.finestLoggable = this._log.isLoggable(Level.FINEST);
            while (true) {
                block18: {
                    try {
                        CleanupThread.sleep(this._me.cleanupInterval * 1000);
                    }
                    catch (InterruptedException e) {
                        if (!this.finestLoggable) break block18;
                        this._log.logp(Level.FINEST, this.MYCLASS, methodName, "Cleanup thread was interrupted");
                    }
                }
                if (this._me.cleanupThreadExitSemaphore) {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"cacheddb token store cleanup thread exiting because exit semaphore is true");
                    break;
                }
                this.runCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runCleanup() {
            String methodName = "runCleanup";
            this._log.entering(this.MYCLASS, methodName);
            Date now = new Date();
            long nowTime = now.getTime();
            int expiredCount = CachedDBTokenStore.this.getExpiredCount(nowTime);
            if (this.fineLoggable) {
                this._log.logp(Level.FINEST, this.MYCLASS, methodName, "About to delete all tokens with expiry <= " + nowTime);
                this._log.logp(Level.FINEST, this.MYCLASS, methodName, "Number of expired tokens in the DB: " + expiredCount);
            }
            if (expiredCount > 10000) {
                String msg = expiredCount + " expired tokens to delete. Consider increasing OAuth provider cleanup interval";
                this._log.logp(Level.WARNING, this.MYCLASS, methodName, msg);
            }
            boolean error = false;
            Connection conn = null;
            int numDeleted = 0;
            while (expiredCount > 0 && numDeleted < expiredCount) {
                try {
                    String delete;
                    conn = this._me.getDBConnection();
                    conn.setAutoCommit(false);
                    if (DetectDatabaseType.DBType.DB2 == this.databaseType) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Running cleanup with LIMIT in DB2");
                        }
                        delete = "DELETE FROM (SELECT EXPIRES FROM " + CachedDBTokenStore.this.tableName + " WHERE " + "EXPIRES" + " > 0 AND " + "EXPIRES" + " <= ?  ORDER BY " + "EXPIRES" + " FETCH FIRST " + CachedDBTokenStore.this.cleanupBatchSize + " ROWS ONLY)";
                        numDeleted += CachedDBTokenStore.this.cleanupBatchSize;
                    } else if (this.databaseType.isSqlLimitSupported()) {
                        this._log.logp(Level.FINEST, this.MYCLASS, methodName, "Running cleanup with LIMIT");
                        delete = "DELETE FROM " + CachedDBTokenStore.this.tableName + " WHERE " + "EXPIRES" + " > 0 AND " + "EXPIRES" + " <= ? LIMIT " + CachedDBTokenStore.this.cleanupBatchSize;
                        numDeleted += CachedDBTokenStore.this.cleanupBatchSize;
                    } else {
                        this._log.logp(Level.FINEST, this.MYCLASS, methodName, "Running cleanup without LIMIT");
                        delete = "DELETE FROM " + CachedDBTokenStore.this.tableName + " WHERE " + "EXPIRES" + " > 0 AND " + "EXPIRES" + " <= ?";
                        numDeleted += expiredCount;
                    }
                    PreparedStatement st = conn.prepareStatement(delete);
                    st.setLong(1, nowTime);
                    st.execute();
                }
                catch (SQLException syne) {
                    this.databaseType = DetectDatabaseType.DBType.UNKNOWN;
                    this._log.logp(Level.WARNING, CLASS, methodName, syne.getMessage(), syne);
                    this._log.logp(Level.FINE, this.MYCLASS, methodName, "SQL error, switching off LIMIT");
                }
                catch (Exception e) {
                    this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), e);
                    error = true;
                }
                finally {
                    CachedDBTokenStore.this.closeConnection(conn, error);
                }
            }
            this._log.exiting(this.MYCLASS, methodName);
        }
    }
}

