/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.openidconnect.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.web.OAuth20Request;
import com.ibm.ws.security.openidconnect.server.internal.OidcServerConfigImpl;
import com.ibm.ws.security.openidconnect.web.OidcEndpointServices;
import com.ibm.ws.security.openidconnect.web.OidcRequest;
import io.openliberty.security.common.http.SupportedHttpMethodHandler;
import io.openliberty.security.oauth20.web.OAuthSupportedHttpMethodHandler;
import io.openliberty.security.openidconnect.server.config.OidcEndpointSettings;
import io.openliberty.security.openidconnect.server.config.SpecificOidcEndpointSettings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcSupportedHttpMethodHandler
extends OAuthSupportedHttpMethodHandler {
    private static TraceComponent tc = Tr.register(OidcSupportedHttpMethodHandler.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    protected OidcRequest oidcRequest = null;
    protected String oidcProviderName = null;
    protected OidcEndpointServices endpointServices = null;
    protected OidcServerConfigImpl oidcConfig = null;
    static final long serialVersionUID = -3942926019773515083L;

    public OidcSupportedHttpMethodHandler(HttpServletRequest request, HttpServletResponse response, OidcEndpointServices endpointServices) {
        super(request, response);
        this.endpointServices = endpointServices;
        this.oidcRequest = this.getOidcRequestAttribute();
        if (this.oidcRequest != null) {
            this.oidcProviderName = this.oidcRequest.getProviderName();
            this.oidcConfig = this.getOidcProviderConfig();
            if (this.oidcConfig != null) {
                this.oauth20ProviderName = this.oidcConfig.getOauthProviderName();
                this.oauthProvider = this.getOAuth20Provider();
            }
        }
    }

    protected OAuth20Request.EndpointType getEndpointType() {
        if (this.oidcRequest != null) {
            return this.oidcRequest.getType();
        }
        return super.getEndpointType();
    }

    protected Set<SupportedHttpMethodHandler.HttpMethod> getDefaultSupportedMethodsForEndpoint(OAuth20Request.EndpointType endpointType) {
        HashSet<SupportedHttpMethodHandler.HttpMethod> supportedMethods = new HashSet<SupportedHttpMethodHandler.HttpMethod>();
        supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.OPTIONS);
        if (endpointType != OAuth20Request.EndpointType.discovery && endpointType != OAuth20Request.EndpointType.userinfo && endpointType != OAuth20Request.EndpointType.end_session && endpointType != OAuth20Request.EndpointType.check_session_iframe && endpointType != OAuth20Request.EndpointType.jwk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received a request for an unknown OIDC endpoint: [" + endpointType + "]. Checking if it's an OAuth endpoint..."), (Object[])new Object[0]);
            }
            return super.getDefaultSupportedMethodsForEndpoint(endpointType);
        }
        supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.GET);
        supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.HEAD);
        supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.POST);
        return supportedMethods;
    }

    protected Set<SupportedHttpMethodHandler.HttpMethod> getConfiguredSupportedMethodsForEndpoint(OAuth20Request.EndpointType endpoint) {
        OidcEndpointSettings endpointConfigSettings = this.getConfiguredOidcEndpointSettings();
        if (endpointConfigSettings == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Did not find any OIDC endpoint settings for provider. Checking for OAuth endpoint settings...", (Object[])new Object[0]);
            }
            return super.getConfiguredSupportedMethodsForEndpoint(endpoint);
        }
        SpecificOidcEndpointSettings specificEndpointSettings = endpointConfigSettings.getSpecificOidcEndpointSettings(endpoint);
        if (specificEndpointSettings == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Did not find any specific OIDC endpoint settings for endpoint [" + endpoint + "]. Checking if it's an OAuth endpoint..."), (Object[])new Object[0]);
            }
            return super.getConfiguredSupportedMethodsForEndpoint(endpoint);
        }
        return specificEndpointSettings.getSupportedHttpMethods();
    }

    OidcEndpointSettings getConfiguredOidcEndpointSettings() {
        if (this.oidcConfig == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Did not find an OIDC provider matching the name [" + this.oidcProviderName + "]"), (Object[])new Object[0]);
            }
            return null;
        }
        return this.oidcConfig.getOidcEndpointSettings();
    }

    @FFDCIgnore(value={Exception.class})
    OidcServerConfigImpl getOidcProviderConfig() {
        if (this.oidcProviderName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot look up configured endpoint settings because OIDC provider name is not known", (Object[])new Object[0]);
            }
            return null;
        }
        if (this.endpointServices == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Did not find OIDC endpoint services object to use to get configured OIDC endpoint settings", (Object[])new Object[0]);
            }
            return null;
        }
        try {
            boolean sendErrorIfProviderNotFound = false;
            return (OidcServerConfigImpl)this.endpointServices.getOidcServerConfig(this.response, this.oidcProviderName, sendErrorIfProviderNotFound);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught an exception attempting to get OIDC server configuration for provider [" + this.oidcProviderName + "]: " + e), (Object[])new Object[0]);
            }
            return null;
        }
    }

    OidcRequest getOidcRequestAttribute() {
        OidcRequest oidcRequest = (OidcRequest)((Object)this.request.getAttribute("OidcRequest"));
        if (oidcRequest == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to find OidcRequest information from the inbound request", (Object[])new Object[0]);
            }
            return null;
        }
        return oidcRequest;
    }
}

