/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl.rldispatcher;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.DispatchQueue;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.AbstractInvocation;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDispatchBarrier;
import com.ibm.ws.sib.jfapchannel.threadpool.ThreadPool;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class ReceiveListenerDispatchQueue
implements DispatchQueue,
Runnable {
    private static final TraceComponent tc;
    static final String MAXQUEUESIZE = "com.ibm.ws.sib.jfapchannel.RL_DISPATCHER_MAXQUEUESIZE";
    static final String MAXQUEUESIZE_ME = "com.ibm.ws.sib.jfapchannel.RL_DISPATCHER_MAXQUEUESIZE_ME";
    static final String MAXQUEUEMSGS_ME = "com.ibm.ws.sib.jfapchannel.RL_DISPATCHER_MAXQUEUEMSGS_ME";
    static final String MAXQUEUESIZE_CLIENT = "com.ibm.ws.sib.jfapchannel.RL_DISPATCHER_MAXQUEUESIZE_CLIENT";
    static final String MAXQUEUEMSGS_CLIENT = "com.ibm.ws.sib.jfapchannel.RL_DISPATCHER_MAXQUEUEMSGS_CLIENT";
    static final String MAX_CONCURRENT_DISPATCHES = "com.ibm.ws.sib.jfapchannel.MAX_CONCURRENT_DISPATCHES";
    private static int MAX_ME_QUEUE_SIZE;
    private static int MAX_ME_QUEUE_MSGS;
    private static int MAX_CLIENT_QUEUE_SIZE;
    private static int MAX_CLIENT_QUEUE_MSGS;
    private static int rldThreadRepoolDelay;
    private final ArrayList<AbstractInvocation> queue = new ArrayList();
    private final ReceiveListenerDispatchBarrier barrier = new ReceiveListenerDispatchBarrier();
    private final List<ReceiveListenerDispatchQueue> emptyDispatchQueues;
    private final ThreadPool threadPool;
    private int queueSize = 0;
    private final QueueType queueType;
    private final int maxQueueSize;
    private final int maxQueueMsgs;
    private volatile boolean running = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReceiveListenerDispatchQueue(List<ReceiveListenerDispatchQueue> edq, ThreadPool tp, QueueType qt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String edqString;
            if (edq != null) {
                List<ReceiveListenerDispatchQueue> list = edq;
                synchronized (list) {
                    edqString = edq.toString();
                }
            } else {
                edqString = null;
            }
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("emptyDispatchQueues=" + edqString + ", threadPool=" + tp + ", queueType=" + (Object)((Object)qt)));
        }
        this.emptyDispatchQueues = edq;
        this.threadPool = tp;
        this.queueType = qt;
        if (this.queueType == QueueType.ME_ME) {
            this.maxQueueSize = MAX_ME_QUEUE_SIZE;
            this.maxQueueMsgs = MAX_ME_QUEUE_MSGS;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Queue type is ME-ME maxQueueSize=" + this.maxQueueSize + ", maxQueueMsgs=" + this.maxQueueMsgs));
            }
        } else {
            this.maxQueueSize = MAX_CLIENT_QUEUE_SIZE;
            this.maxQueueMsgs = MAX_CLIENT_QUEUE_MSGS;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Queue type is ME-Client maxQueueSize=" + this.maxQueueSize + ", maxQueueMsgs=" + this.maxQueueMsgs));
            }
        }
        if (this.emptyDispatchQueues != null) {
            List<ReceiveListenerDispatchQueue> list = this.emptyDispatchQueues;
            synchronized (list) {
                this.emptyDispatchQueues.add(this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Added this queue (" + this + ") to empty dispatch list (" + this.emptyDispatchQueues + ")"));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(AbstractInvocation invocation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"enqueue", (Object)invocation);
        }
        this.barrier.pass();
        ReceiveListenerDispatchQueue receiveListenerDispatchQueue = this;
        synchronized (receiveListenerDispatchQueue) {
            boolean isEmpty = this.isEmpty();
            ReceiveListenerDispatchBarrier receiveListenerDispatchBarrier = this.barrier;
            synchronized (receiveListenerDispatchBarrier) {
                this.queue.add(invocation);
                this.queueSize += invocation.getSize();
                if (this.queueSize >= this.maxQueueSize || this.maxQueueMsgs > 0 && this.queue.size() >= this.maxQueueMsgs) {
                    this.barrier.lock();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Locked the barrier: bytes=" + this.queueSize + " (" + this.maxQueueSize + ") msgs=" + this.queue.size() + " (" + this.maxQueueMsgs + ")"));
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Leaving barrier unlocked: bytes=" + this.queueSize + " (" + this.maxQueueSize + ") msgs=" + this.queue.size() + " (" + this.maxQueueMsgs + ")"));
                }
            }
            if (isEmpty) {
                if (this.running) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Notifying existing thread");
                    }
                    this.notify();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Starting a new thread");
                    }
                    boolean interrupted = true;
                    while (interrupted) {
                        try {
                            this.threadPool.execute(this);
                            interrupted = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"enqueue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractInvocation dequeue() {
        AbstractInvocation invocation;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dequeue");
        }
        ReceiveListenerDispatchBarrier receiveListenerDispatchBarrier = this.barrier;
        synchronized (receiveListenerDispatchBarrier) {
            invocation = this.queue.remove(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dequeue", (Object)invocation);
        }
        return invocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockBarrier(int size, Conversation.ConversationType conversationType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockBarrier", (Object)new Object[]{size, conversationType});
        }
        ReceiveListenerDispatchBarrier receiveListenerDispatchBarrier = this.barrier;
        synchronized (receiveListenerDispatchBarrier) {
            this.queueSize -= size;
            if (this.queueSize < this.maxQueueSize && (this.maxQueueMsgs == 0 || this.maxQueueMsgs > 0 && this.queue.size() < this.maxQueueMsgs)) {
                if (this.barrier.unlock()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unlocked the barrier: bytes=" + this.queueSize + " (" + this.maxQueueSize + ") msgs=" + this.queue.size() + " (" + this.maxQueueMsgs + ")"));
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Barrier already unlocked: bytes=" + this.queueSize + " (" + this.maxQueueSize + ") msgs=" + this.queue.size() + " (" + this.maxQueueMsgs + ")"));
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Leaving barrier locked: bytes=" + this.queueSize + " (" + this.maxQueueSize + ") msgs=" + this.queue.size() + " (" + this.maxQueueMsgs + ")"));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockBarrier");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEmpty() {
        boolean rc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isEmpty");
        }
        ReceiveListenerDispatchBarrier receiveListenerDispatchBarrier = this.barrier;
        synchronized (receiveListenerDispatchBarrier) {
            rc = this.queue.isEmpty();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isEmpty", (Object)rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getDepth() {
        int depth;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDepth");
        }
        ReceiveListenerDispatchBarrier receiveListenerDispatchBarrier = this.barrier;
        synchronized (receiveListenerDispatchBarrier) {
            depth = this.queue.size();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDepth", (Object)depth);
        }
        return depth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractInvocation head() {
        AbstractInvocation rc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"head");
        }
        ReceiveListenerDispatchBarrier receiveListenerDispatchBarrier = this.barrier;
        synchronized (receiveListenerDispatchBarrier) {
            rc = this.queue.get(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"head", (Object)rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"run");
        }
        this.running = true;
        boolean continueProcessing = true;
        while (continueProcessing) {
            try {
                Conversation.ConversationType conversationType;
                int size;
                AbstractInvocation invocation = this.head();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("invocation=" + invocation));
                }
                Dispatchable dispatchable = invocation.getDispatchable();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("dispatchable=" + dispatchable));
                }
                boolean repoolInvocation = false;
                Object object = invocation;
                synchronized (object) {
                    invocation.decrementReferenceCount();
                    if (invocation.getReferenceCount() == 0 && invocation.isReady()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Invoking: " + invocation));
                        }
                        invocation.invoke();
                        ConversationImpl convImpl = (ConversationImpl)invocation.getConversation();
                        Object object2 = convImpl.getTotalOutstandingRequestCountLock();
                        synchronized (object2) {
                            AbstractInvocation errorInvoc;
                            convImpl.decrementTotalOutstandingCount();
                            if (convImpl.getTotalOutstandingRequestCount() == 0 && (errorInvoc = convImpl.getErrorOccurredInvocation()) != null) {
                                errorInvoc.invoke();
                                errorInvoc.repool();
                                convImpl.setErrorOccurredInvocation(null);
                            }
                        }
                        repoolInvocation = true;
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Not invoking " + invocation + " at this time"));
                    }
                    size = invocation.getSize();
                    Connection connection = invocation.getConnection();
                    conversationType = connection != null ? connection.getConversationType() : null;
                }
                this.dequeue();
                this.unlockBarrier(size, conversationType);
                if (repoolInvocation) {
                    invocation.repool();
                }
                object = dispatchable.getDispatchLockObject();
                synchronized (object) {
                    dispatchable.decrementDispatchQueueRefCount();
                    if (dispatchable.getDispatchQueueRefCount() == 0) {
                        dispatchable.setDispatchQueue(null);
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Dispatchable refCount = " + dispatchable.getDispatchQueueRefCount()));
                }
                object = this;
                synchronized (object) {
                    if (this.isEmpty()) {
                        List<ReceiveListenerDispatchQueue> list;
                        if (this.emptyDispatchQueues != null) {
                            list = this.emptyDispatchQueues;
                            synchronized (list) {
                                this.emptyDispatchQueues.add(this);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Added this queue (" + this + ") to empty dispatch list (" + this.emptyDispatchQueues + ")"));
                                }
                            }
                        }
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Thread waiting " + rldThreadRepoolDelay + "ms for new work to arrive"));
                            }
                            this.wait(rldThreadRepoolDelay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        boolean bl = continueProcessing = !this.isEmpty();
                        if (continueProcessing && this.emptyDispatchQueues != null) {
                            list = this.emptyDispatchQueues;
                            synchronized (list) {
                                this.emptyDispatchQueues.remove(this);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Removed this queue (" + this + ") from empty dispatch list (" + this.emptyDispatchQueues + ")"));
                                }
                            }
                        }
                        this.running = continueProcessing;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("continue running thread=" + continueProcessing));
                    }
                }
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDispatchQueue.run", (String)"00230001", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"ReceiveListenerDispatchQueue thread caught exception: ", (Object)e);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doesQueueContainConversation(Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"doesQueueContainConversation", (Object)conversation);
        }
        boolean rc = false;
        ReceiveListenerDispatchBarrier receiveListenerDispatchBarrier = this.barrier;
        synchronized (receiveListenerDispatchBarrier) {
            for (int i = 0; i < this.queue.size(); ++i) {
                AbstractInvocation invocation = this.queue.get(i);
                if (!invocation.getConversation().equals(conversation)) continue;
                rc = true;
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"doesQueueContainConversation", (Object)rc);
        }
        return rc;
    }

    static {
        block17: {
            block16: {
                tc = SibTr.register(ReceiveListenerDispatchQueue.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
                try {
                    String mqm_me;
                    String mqs_me;
                    String mqm_client;
                    String mqs_client;
                    String mqs;
                    int numberOfQueues = Integer.parseInt(RuntimeInfo.getPropertyWithMsg((String)MAX_CONCURRENT_DISPATCHES, (String)"32"));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Number of Receive Listener Dispatch queues = " + numberOfQueues));
                    }
                    Runtime rt = Runtime.getRuntime();
                    long maxMemory = rt.maxMemory();
                    long totalMemory = rt.totalMemory();
                    long freeMemory = rt.freeMemory();
                    long available = maxMemory - totalMemory + freeMemory;
                    long twentyPercent = (long)((double)available * 0.2);
                    MAX_CLIENT_QUEUE_SIZE = (int)(twentyPercent / (long)numberOfQueues);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        NumberFormat f = NumberFormat.getInstance();
                        SibTr.debug((TraceComponent)tc, (String)("Max memory   : " + f.format(maxMemory)));
                        SibTr.debug((TraceComponent)tc, (String)("Total memory : " + f.format(totalMemory)));
                        SibTr.debug((TraceComponent)tc, (String)("Free memory  : " + f.format(freeMemory)));
                        SibTr.debug((TraceComponent)tc, (String)("Available    : " + f.format(available)));
                        SibTr.debug((TraceComponent)tc, (String)("20%          : " + f.format(twentyPercent)));
                        SibTr.debug((TraceComponent)tc, (String)("Default ME-Client queue size : " + MAX_CLIENT_QUEUE_SIZE));
                    }
                    MAX_CLIENT_QUEUE_MSGS = 0;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Default ME-Client queue msgs : " + MAX_CLIENT_QUEUE_MSGS));
                    }
                    MAX_ME_QUEUE_SIZE = 16384;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Default ME-ME queue size :" + MAX_ME_QUEUE_SIZE));
                    }
                    MAX_ME_QUEUE_MSGS = 96;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Default ME-ME queue msgs : " + MAX_ME_QUEUE_MSGS));
                    }
                    if ((mqs = RuntimeInfo.getProperty((String)MAXQUEUESIZE)) != null) {
                        com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)MAXQUEUESIZE, (String)mqs);
                        MAX_ME_QUEUE_SIZE = MAX_CLIENT_QUEUE_SIZE = Integer.parseInt(mqs);
                    }
                    if ((mqs_client = RuntimeInfo.getProperty((String)MAXQUEUESIZE_CLIENT)) != null) {
                        com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)MAXQUEUESIZE_CLIENT, (String)mqs_client);
                        MAX_CLIENT_QUEUE_SIZE = Integer.parseInt(mqs_client);
                    }
                    if ((mqm_client = RuntimeInfo.getProperty((String)MAXQUEUEMSGS_CLIENT)) != null) {
                        com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)MAXQUEUEMSGS_CLIENT, (String)mqm_client);
                        MAX_CLIENT_QUEUE_MSGS = Integer.parseInt(mqm_client);
                    }
                    if ((mqs_me = RuntimeInfo.getProperty((String)MAXQUEUESIZE_ME)) != null) {
                        com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)MAXQUEUESIZE_ME, (String)mqs_me);
                        MAX_ME_QUEUE_SIZE = Integer.parseInt(mqs_me);
                    }
                    if ((mqm_me = RuntimeInfo.getProperty((String)MAXQUEUEMSGS_ME)) != null) {
                        com.ibm.ws.sib.utils.Runtime.changedPropertyValue((String)MAXQUEUEMSGS_ME, (String)mqm_me);
                        MAX_ME_QUEUE_MSGS = Integer.parseInt(mqm_me);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Max ME-Client queue size: " + MAX_CLIENT_QUEUE_SIZE + " max msgs: " + MAX_CLIENT_QUEUE_MSGS));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Max ME-ME queue size: " + MAX_ME_QUEUE_SIZE + " max msgs: " + MAX_ME_QUEUE_MSGS));
                    }
                }
                catch (NumberFormatException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
            }
            try {
                rldThreadRepoolDelay = Integer.parseInt(RuntimeInfo.getPropertyWithMsg((String)"com.ibm.ws.sib.jfapchannel.impl.rldRepoolThreadDelayProperty", (String)"10000"));
            }
            catch (NumberFormatException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block17;
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
    }

    public static enum QueueType {
        ME_ME,
        ME_Client;

    }
}

