/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.scalar.time;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import java.time.DateTimeException;

public class DateCoercing
implements Coercing {
    private final Class[] supportedTypes;
    private final String name;

    public DateCoercing(String name, Class ... supportedTypes) {
        this.name = name;
        this.supportedTypes = supportedTypes;
    }

    private Object convertImpl(Object input) {
        for (Class supportedType : this.supportedTypes) {
            if (!supportedType.isInstance(input)) continue;
            return supportedType.cast(input);
        }
        if (input instanceof String) {
            return input;
        }
        throw SmallRyeGraphQLServerMessages.msg.unknownDateFormat(input.toString());
    }

    public Object serialize(Object input) {
        if (input == null) {
            return null;
        }
        try {
            return this.convertImpl(input);
        }
        catch (DateTimeException e) {
            throw SmallRyeGraphQLServerMessages.msg.coercingSerializeException(this.name, input.getClass().getSimpleName(), e);
        }
    }

    public Object parseValue(Object input) {
        try {
            return this.convertImpl(input);
        }
        catch (DateTimeException e) {
            throw SmallRyeGraphQLServerMessages.msg.coercingParseValueException(this.name, input.getClass().getSimpleName(), e);
        }
    }

    public Object parseLiteral(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof StringValue) {
            return ((StringValue)input).getValue();
        }
        throw SmallRyeGraphQLServerMessages.msg.coercingParseLiteralException(input.getClass().getSimpleName());
    }
}

