/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.FlowHandler;
import jakarta.faces.flow.FlowScoped;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.cdi.util.BeanProvider;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;
import org.apache.myfaces.flow.FlowReference;
import org.apache.myfaces.flow.cdi.FlowScopeBeanHolder;
import org.apache.myfaces.flow.util.FlowUtils;

@Typed
public class FlowScopedContextImpl
implements Context {
    private final boolean passivatingScope;
    private BeanManager beanManager;
    private Map<Class, FlowReference> flowBeanReferences;

    public FlowScopedContextImpl(BeanManager beanManager, Map<Class, FlowReference> flowBeanReferences) {
        this.beanManager = beanManager;
        this.flowBeanReferences = flowBeanReferences;
        this.passivatingScope = beanManager.isPassivatingScope(this.getScope());
    }

    protected FlowScopeBeanHolder getFlowScopeBeanHolder() {
        return this.getFlowScopeBeanHolder(FacesContext.getCurrentInstance());
    }

    protected FlowScopeBeanHolder getFlowScopeBeanHolder(FacesContext facesContext) {
        FlowScopeBeanHolder flowScopeBeanHolder = (FlowScopeBeanHolder)facesContext.getExternalContext().getApplicationMap().get("oam.flow.FlowScopeBeanHolder");
        if (flowScopeBeanHolder == null) {
            flowScopeBeanHolder = BeanProvider.getContextualReference(this.beanManager, FlowScopeBeanHolder.class, false, new Annotation[0]);
            facesContext.getExternalContext().getApplicationMap().put("oam.flow.FlowScopeBeanHolder", flowScopeBeanHolder);
        }
        return flowScopeBeanHolder;
    }

    public String getCurrentClientWindowFlowId(FacesContext facesContext) {
        String flowMapKey = null;
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        Flow flow = flowHandler.getCurrentFlow(facesContext);
        if (flow != null) {
            flowMapKey = FlowUtils.getFlowMapKey(facesContext, flow);
        }
        return flowMapKey;
    }

    protected ContextualStorage getContextualStorage(boolean createIfNotExist, String clientWindowFlowId) {
        if (clientWindowFlowId == null) {
            throw new ContextNotActiveException("FlowScopedContextImpl: no current active flow");
        }
        if (createIfNotExist) {
            return this.getFlowScopeBeanHolder().getContextualStorage(this.beanManager, clientWindowFlowId);
        }
        return this.getFlowScopeBeanHolder().getContextualStorageNoCreate(this.beanManager, clientWindowFlowId);
    }

    public Class<? extends Annotation> getScope() {
        return FlowScoped.class;
    }

    public boolean isActive() {
        return this.isActive(FacesContext.getCurrentInstance());
    }

    public boolean isActive(FacesContext facesContext) {
        if (facesContext == null) {
            return false;
        }
        Flow flow = facesContext.getApplication().getFlowHandler().getCurrentFlow(facesContext);
        return flow != null;
    }

    public boolean isPassivatingScope() {
        return this.passivatingScope;
    }

    public <T> T get(Contextual<T> bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        FlowReference reference = this.flowBeanReferences.get(((Bean)bean).getBeanClass());
        if (reference != null) {
            String flowMapKey = FlowUtils.getFlowMapKey(facesContext, reference);
            if (flowMapKey != null) {
                Map<Object, ContextualInstanceInfo<?>> contextMap;
                ContextualInstanceInfo<?> contextualInstanceInfo;
                ContextualStorage storage = this.getContextualStorage(false, flowMapKey);
                if (storage != null && (contextualInstanceInfo = (contextMap = storage.getStorage()).get(storage.getBeanKey(bean))) != null) {
                    return (T)contextualInstanceInfo.getContextualInstance();
                }
            } else {
                throw new IllegalStateException("Flow " + reference.getId() + " cannot be found when resolving bean " + bean.toString());
            }
        }
        List<String> activeFlowMapKeys = this.getFlowScopeBeanHolder().getActiveFlowMapKeys(facesContext);
        for (String flowMapKey : activeFlowMapKeys) {
            Map<Object, ContextualInstanceInfo<?>> contextMap;
            ContextualInstanceInfo<?> contextualInstanceInfo;
            ContextualStorage storage = this.getContextualStorage(false, flowMapKey);
            if (storage == null || (contextualInstanceInfo = (contextMap = storage.getStorage()).get(storage.getBeanKey(bean))) == null) continue;
            return (T)contextualInstanceInfo.getContextualInstance();
        }
        return null;
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        if (this.passivatingScope && !(bean instanceof PassivationCapable)) {
            throw new IllegalStateException(bean.toString() + " doesn't implement " + PassivationCapable.class.getName());
        }
        FlowReference reference = this.flowBeanReferences.get(((Bean)bean).getBeanClass());
        if (reference != null) {
            Object instance2;
            String flowMapKey = FlowUtils.getFlowMapKey(facesContext, reference);
            if (flowMapKey != null) {
                Map<Object, ContextualInstanceInfo<?>> contextMap;
                ContextualInstanceInfo<?> contextualInstanceInfo;
                ContextualStorage storage = this.getContextualStorage(false, flowMapKey);
                if (storage != null && (contextualInstanceInfo = (contextMap = storage.getStorage()).get(storage.getBeanKey(bean))) != null) {
                    return (T)contextualInstanceInfo.getContextualInstance();
                }
            } else {
                throw new IllegalStateException("Flow " + reference.getId() + " cannot be found when resolving bean " + bean.toString());
            }
            FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
            Flow flow = flowHandler.getFlow(facesContext, reference.getDocumentId() == null ? "" : reference.getDocumentId(), reference.getId());
            if (flow == null) {
                throw new IllegalStateException(bean.toString() + "cannot be created because flow " + reference.getId() + " is not registered");
            }
            if (!flowHandler.isActive(facesContext, flow.getDefiningDocumentId(), flow.getId())) {
                throw new IllegalStateException(bean.toString() + "cannot be created if flow " + reference.getId() + " is not active");
            }
            ContextualStorage storage = this.getContextualStorage(true, flowMapKey);
            Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
            ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
            if (contextualInstanceInfo != null && (instance2 = contextualInstanceInfo.getContextualInstance()) != null) {
                return (T)instance2;
            }
            return storage.createContextualInstance(bean, creationalContext);
        }
        List<String> activeFlowMapKeys = this.getFlowScopeBeanHolder().getActiveFlowMapKeys(facesContext);
        for (String flowMapKey : activeFlowMapKeys) {
            Object instance3;
            ContextualStorage storage = this.getContextualStorage(true, flowMapKey);
            Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
            ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
            if (contextualInstanceInfo == null || (instance3 = contextualInstanceInfo.getContextualInstance()) == null) continue;
            return (T)instance3;
        }
        ContextualStorage storage = this.getContextualStorage(true, this.getCurrentClientWindowFlowId(facesContext));
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return storage.createContextualInstance(bean, creationalContext);
    }

    public boolean destroy(Contextual bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        List<String> activeFlowMapKeys = this.getFlowScopeBeanHolder().getActiveFlowMapKeys(facesContext);
        for (String flowMapKey : activeFlowMapKeys) {
            ContextualInstanceInfo<?> contextualInstanceInfo;
            ContextualStorage storage = this.getContextualStorage(false, flowMapKey);
            if (storage == null || (contextualInstanceInfo = storage.getStorage().get(storage.getBeanKey(bean))) == null) continue;
            bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
            return true;
        }
        return false;
    }

    public static void destroyAllActive(ContextualStorage storage) {
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : contextMap.entrySet()) {
            if ("oam.CURRENT_FLOW_SCOPE_MAP".equals(entry.getKey())) continue;
            Contextual<?> bean = storage.getBean(entry.getKey());
            ContextualInstanceInfo<?> contextualInstanceInfo = entry.getValue();
            bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        }
    }

    protected void checkActive(FacesContext facesContext) {
        if (!this.isActive(facesContext)) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }
}

