/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet;

import com.google.common.io.BaseEncoding;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.grpc.Attributes;
import io.grpc.InternalLogId;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.AbstractServerStream;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SerializingExecutor;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.TransportFrameUtil;
import io.grpc.internal.TransportTracer;
import io.grpc.internal.WritableBuffer;
import io.grpc.servlet.AsyncServletOutputStreamWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;

@Trivial
final class ServletServerStream
extends AbstractServerStream {
    private static final Logger logger = Logger.getLogger(ServletServerStream.class.getName());
    private final ServletTransportState transportState;
    private final Sink sink = new Sink();
    private final AsyncContext asyncCtx;
    private final HttpServletResponse resp;
    private final Attributes attributes;
    private final String authority;
    private final InternalLogId logId;
    private final AsyncServletOutputStreamWriter writer;

    ServletServerStream(AsyncContext asyncCtx, ServletResponse respParm, StatsTraceContext statsTraceCtx, int maxInboundMessageSize, Attributes attributes, String authority, InternalLogId logId) throws IOException {
        super(ByteArrayWritableBuffer::new, statsTraceCtx);
        this.transportState = new ServletTransportState(maxInboundMessageSize, statsTraceCtx, new TransportTracer());
        this.attributes = attributes;
        this.authority = authority;
        this.logId = logId;
        this.asyncCtx = asyncCtx;
        this.resp = (HttpServletResponse)respParm;
        this.writer = new AsyncServletOutputStreamWriter(asyncCtx, this.resp.getOutputStream(), this.transportState, logId);
    }

    public void setWriteListener() throws IOException {
        this.resp.getOutputStream().setWriteListener((WriteListener)new GrpcWriteListener());
    }

    protected ServletTransportState transportState() {
        return this.transportState;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAuthority() {
        return this.authority;
    }

    public int streamId() {
        return -1;
    }

    protected Sink abstractServerStreamSink() {
        return this.sink;
    }

    private void writeHeadersToServletResponse(Metadata metadata) {
        metadata.discardAll(GrpcUtil.CONTENT_TYPE_KEY);
        metadata.discardAll(GrpcUtil.TE_HEADER);
        metadata.discardAll(GrpcUtil.USER_AGENT_KEY);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[{0}] writeHeaders {1}", new Object[]{this.logId, metadata});
        }
        this.resp.setStatus(200);
        this.resp.setContentType("application/grpc");
        byte[][] serializedHeaders = TransportFrameUtil.toHttp2Headers((Metadata)metadata);
        for (int i = 0; i < serializedHeaders.length; i += 2) {
            this.resp.addHeader(new String(serializedHeaders[i], StandardCharsets.US_ASCII), new String(serializedHeaders[i + 1], StandardCharsets.US_ASCII));
        }
    }

    static String toHexString(byte[] bytes, int length) {
        String hex = BaseEncoding.base16().encode(bytes, 0, Math.min(length, 64));
        if (length > 80) {
            hex = hex + "...";
        }
        if (length > 64) {
            int offset = Math.max(64, length - 16);
            hex = hex + BaseEncoding.base16().encode(bytes, offset, length - offset);
        }
        return hex;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    final class ServletTransportState
    extends AbstractServerStream.TransportState {
        private final SerializingExecutor transportThreadExecutor;
        static final long serialVersionUID = -4120207401199701633L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ServletTransportState(int maxMessageSize, StatsTraceContext statsTraceCtx, TransportTracer transportTracer) {
            super(maxMessageSize, statsTraceCtx, transportTracer);
            this.transportThreadExecutor = new SerializingExecutor((Executor)CHFWBundle.getExecutorService());
        }

        public void runOnTransportThread(Runnable r) {
            this.transportThreadExecutor.execute(r);
        }

        public void bytesRead(int numBytes) {
        }

        public void deframeFailed(Throwable cause) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("[{%s}] Exception processing message", ServletServerStream.this.logId), cause);
            }
            ServletServerStream.this.cancel(Status.fromThrowable((Throwable)cause));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerStream$ServletTransportState", ServletTransportState.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class Sink
    implements AbstractServerStream.Sink {
        final TrailerSupplier trailerSupplier = new TrailerSupplier();
        static final long serialVersionUID = -3909549564927328633L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Sink() {
        }

        /*
         * WARNING - void declaration
         */
        public void writeHeaders(Metadata headers, boolean flush) {
            ServletServerStream.this.writeHeadersToServletResponse(headers);
            ServletServerStream.this.resp.setTrailerFields((Supplier)this.trailerSupplier);
            try {
                if (flush) {
                    ServletServerStream.this.writer.flush();
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, String.format("[{%s}] Skipping flushing buffer", ServletServerStream.this.logId));
                }
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"io.grpc.servlet.ServletServerStream$Sink", (String)"250", (Object)this, (Object[])new Object[]{headers, flush});
                logger.log(Level.WARNING, String.format("[{%s}] Exception when flushBuffer", ServletServerStream.this.logId), (Throwable)e);
                this.cancel(Status.fromThrowable((Throwable)e));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void writeFrame(@Nullable WritableBuffer frame, boolean flush, int numMessages) {
            if (frame == null && !flush) {
                return;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "[{0}] writeFrame: numBytes = {1}, flush = {2}, numMessages = {3}", new Object[]{ServletServerStream.this.logId, frame == null ? 0 : frame.readableBytes(), flush, numMessages});
            }
            try {
                if (frame != null) {
                    int numBytes = frame.readableBytes();
                    if (numBytes > 0) {
                        ServletServerStream.this.onSendingBytes(numBytes);
                    }
                    ServletServerStream.this.writer.writeBytes(((ByteArrayWritableBuffer)frame).bytes, frame.readableBytes());
                }
                if (flush) {
                    ServletServerStream.this.writer.flush();
                }
            }
            catch (IOException numBytes) {
                void e;
                FFDCFilter.processException((Throwable)numBytes, (String)"io.grpc.servlet.ServletServerStream$Sink", (String)"284", (Object)this, (Object[])new Object[]{frame, flush, numMessages});
                logger.log(Level.WARNING, String.format("[{%s}] Exception writing message", ServletServerStream.this.logId), (Throwable)e);
                this.cancel(Status.fromThrowable((Throwable)e));
            }
        }

        public void writeTrailers(Metadata trailers, boolean headersSent, Status status) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[{0}] writeTrailers: {1}, headersSent = {2}, status = {3}", new Object[]{ServletServerStream.this.logId, trailers, headersSent, status});
            }
            if (!headersSent) {
                ServletServerStream.this.writeHeadersToServletResponse(trailers);
            } else {
                byte[][] serializedHeaders = TransportFrameUtil.toHttp2Headers((Metadata)trailers);
                for (int i = 0; i < serializedHeaders.length; i += 2) {
                    String key = new String(serializedHeaders[i], StandardCharsets.US_ASCII);
                    String newValue = new String(serializedHeaders[i + 1], StandardCharsets.US_ASCII);
                    this.trailerSupplier.get().computeIfPresent(key, (k, v) -> v + "," + newValue);
                    this.trailerSupplier.get().putIfAbsent(key, newValue);
                }
            }
            ServletServerStream.this.writer.completeWithFlush();
        }

        public void cancel(Status status) {
            if (ServletServerStream.this.resp.isCommitted() && Status.Code.DEADLINE_EXCEEDED == status.getCode()) {
                return;
            }
            ServletServerStream.this.transportState.runOnTransportThread(() -> ServletServerStream.this.transportState.transportReportStatus(status));
            ServletServerStream.this.close(status.withCause((Throwable)status.asRuntimeException()), new Metadata());
            ServletServerStream.this.transportState.runOnTransportThread(() -> ServletServerStream.this.asyncCtx.complete());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerStream$Sink", Sink.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class GrpcWriteListener
    implements WriteListener {
        static final long serialVersionUID = 99788335110468578L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GrpcWriteListener() {
        }

        public void onError(Throwable t) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("[{%s}] Error: ", ServletServerStream.this.logId), t);
            }
            if (!ServletServerStream.this.resp.isCommitted()) {
                ServletServerStream.this.cancel(Status.fromThrowable((Throwable)t));
            } else {
                ServletServerStream.this.transportState.runOnTransportThread(() -> ServletServerStream.this.transportState.transportReportStatus(Status.fromThrowable((Throwable)t)));
            }
        }

        public void onWritePossible() throws IOException {
            ServletServerStream.this.writer.onWritePossible();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerStream$GrpcWriteListener", GrpcWriteListener.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class TrailerSupplier
    implements Supplier<Map<String, String>> {
        final Map<String, String> trailers = Collections.synchronizedMap(new HashMap());
        static final long serialVersionUID = -7006355955498986583L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        TrailerSupplier() {
        }

        @Override
        public Map<String, String> get() {
            return this.trailers;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerStream$TrailerSupplier", TrailerSupplier.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class ByteArrayWritableBuffer
    implements WritableBuffer {
        private final int capacity;
        final byte[] bytes;
        private int index;
        static final long serialVersionUID = 2518445909558509235L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ByteArrayWritableBuffer(int capacityHint) {
            this.bytes = new byte[Math.min(0x100000, Math.max(4096, capacityHint))];
            this.capacity = this.bytes.length;
        }

        public void write(@Sensitive byte[] src, int srcIndex, int length) {
            System.arraycopy(src, srcIndex, this.bytes, this.index, length);
            this.index += length;
        }

        public void write(byte b) {
            this.bytes[this.index++] = b;
        }

        public int writableBytes() {
            return this.capacity - this.index;
        }

        public int readableBytes() {
            return this.index;
        }

        public void release() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.grpc.servlet.ServletServerStream$ByteArrayWritableBuffer", ByteArrayWritableBuffer.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
        }
    }
}

