/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.stream.Field;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.ProvidersContextRetainer;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.Mime4JWorkaround;
import org.jboss.resteasy.plugins.providers.multipart.MultipartConstants;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInputImpl;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedInputImpl;
import org.jboss.resteasy.plugins.providers.multipart.i18n.Messages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class MultipartInputImpl
implements MultipartInput,
ProvidersContextRetainer {
    protected MediaType contentType;
    protected Providers workers;
    protected Message mimeMessage;
    protected List<InputPart> parts = new ArrayList<InputPart>();
    protected static final Annotation[] empty = new Annotation[0];
    protected MediaType defaultPartContentType = MultipartConstants.TEXT_PLAIN_WITH_CHARSET_US_ASCII_TYPE;
    protected String defaultPartCharset = null;
    protected Providers savedProviders;

    public MultipartInputImpl(MediaType contentType, Providers workers) {
        this.contentType = contentType;
        this.workers = workers;
        HttpRequest httpRequest = ResteasyContext.getContextData(HttpRequest.class);
        if (httpRequest != null) {
            String defaultContentType = (String)httpRequest.getAttribute("resteasy.provider.multipart.inputpart.defaultContentType");
            if (defaultContentType != null) {
                this.defaultPartContentType = MediaType.valueOf((String)defaultContentType);
            }
            this.defaultPartCharset = (String)httpRequest.getAttribute("resteasy.provider.multipart.inputpart.defaultCharset");
            if (this.defaultPartCharset != null) {
                this.defaultPartContentType = this.getMediaTypeWithDefaultCharset(this.defaultPartContentType);
            }
        }
    }

    public MultipartInputImpl(MediaType contentType, Providers workers, MediaType defaultPartContentType, String defaultPartCharset) {
        this.contentType = contentType;
        this.workers = workers;
        if (defaultPartContentType != null) {
            this.defaultPartContentType = defaultPartContentType;
        }
        this.defaultPartCharset = defaultPartCharset;
        if (defaultPartCharset != null) {
            this.defaultPartContentType = this.getMediaTypeWithDefaultCharset(this.defaultPartContentType);
        }
    }

    public MultipartInputImpl(Multipart multipart, Providers workers) throws IOException {
        for (Entity entity : multipart.getBodyParts()) {
            if (!(entity instanceof BodyPart)) continue;
            this.parts.add(this.extractPart((BodyPart)entity));
        }
        this.workers = workers;
    }

    public void parse(InputStream is) throws IOException {
        this.mimeMessage = Mime4JWorkaround.parseMessage(this.addHeaderToHeadlessStream(is));
        this.extractParts();
    }

    protected InputStream addHeaderToHeadlessStream(InputStream is) throws UnsupportedEncodingException {
        return new SequenceInputStream(this.createHeaderInputStream(), is);
    }

    protected InputStream createHeaderInputStream() throws UnsupportedEncodingException {
        String header = "Content-Type: " + this.contentType + "\r\n\r\n";
        return new ByteArrayInputStream(header.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getPreamble() {
        return ((Multipart)this.mimeMessage.getBody()).getPreamble();
    }

    @Override
    public List<InputPart> getParts() {
        return this.parts;
    }

    protected void extractParts() throws IOException {
        Multipart multipart = (Multipart)this.mimeMessage.getBody();
        for (Entity entity : multipart.getBodyParts()) {
            if (!(entity instanceof BodyPart)) continue;
            this.parts.add(this.extractPart((BodyPart)entity));
        }
    }

    protected InputPart extractPart(BodyPart bodyPart) throws IOException {
        return new PartImpl(bodyPart);
    }

    public static void main(String[] args) throws Exception {
        String input = "URLSTR: file:/Users/billburke/jboss/resteasy-jaxrs/resteasy-jaxrs/src/test/test-data/data.txt\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3\r\nContent-Disposition: form-data; name=\"part1\"\r\nContent-Type: text/plain; charset=US-ASCII\r\nContent-Transfer-Encoding: 8bit\r\n\r\nThis is Value 1\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3\r\nContent-Disposition: form-data; name=\"part2\"\r\nContent-Type: text/plain; charset=US-ASCII\r\nContent-Transfer-Encoding: 8bit\r\n\r\nThis is Value 2\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3\r\nContent-Disposition: form-data; name=\"data.txt\"; filename=\"data.txt\"\r\nContent-Type: application/octet-stream; charset=ISO-8859-1\r\nContent-Transfer-Encoding: binary\r\n\r\nhello world\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3--";
        ByteArrayInputStream bais = new ByteArrayInputStream(input.getBytes());
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("boundary", "B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3");
        MediaType contentType = new MediaType("multipart", "form-data", parameters);
        MultipartInputImpl multipart = new MultipartInputImpl(contentType, null);
        multipart.parse(bais);
        Logger LOG = Logger.getLogger(MultipartInputImpl.class);
        LOG.info((Object)multipart.getPreamble());
        LOG.info((Object)"**********");
        for (InputPart part : multipart.getParts()) {
            LOG.info((Object)"--");
            LOG.info((Object)("\"" + part.getBodyAsString() + "\""));
        }
        LOG.info((Object)"done");
    }

    @Override
    public void close() {
        if (this.mimeMessage != null) {
            try {
                this.mimeMessage.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    protected String getCharset(MediaType mediaType) {
        for (String key : mediaType.getParameters().keySet()) {
            if (!"charset".equalsIgnoreCase(key)) continue;
            return (String)mediaType.getParameters().get(key);
        }
        return null;
    }

    private MediaType getMediaTypeWithDefaultCharset(MediaType mediaType) {
        String charset = this.defaultPartCharset;
        return this.getMediaTypeWithCharset(mediaType, charset);
    }

    private MediaType getMediaTypeWithCharset(MediaType mediaType, String charset) {
        Map params = mediaType.getParameters();
        LinkedHashMap<String, String> newParams = new LinkedHashMap<String, String>();
        newParams.put("charset", charset);
        for (String key : params.keySet()) {
            if ("charset".equalsIgnoreCase(key)) continue;
            newParams.put(key, (String)params.get(key));
        }
        return new MediaType(mediaType.getType(), mediaType.getSubtype(), newParams);
    }

    @Override
    public void setProviders(Providers providers) {
        this.savedProviders = providers;
    }

    public class PartImpl
    implements InputPart {
        private BodyPart bodyPart;
        private MediaType contentType;
        private MultivaluedMap<String, String> headers = new CaseInsensitiveMap<String>();
        private boolean contentTypeFromMessage;

        public PartImpl(BodyPart bodyPart) {
            this.bodyPart = bodyPart;
            for (Field field : bodyPart.getHeader()) {
                this.headers.add((Object)field.getName(), (Object)field.getBody());
                if (!(field instanceof ContentTypeField)) continue;
                this.contentType = MediaType.valueOf((String)field.getBody());
                this.contentTypeFromMessage = true;
            }
            if (this.contentType == null) {
                this.contentType = MultipartInputImpl.this.defaultPartContentType;
            }
            if (MultipartInputImpl.this.getCharset(this.contentType) == null) {
                if (MultipartInputImpl.this.defaultPartCharset != null) {
                    this.contentType = MultipartInputImpl.this.getMediaTypeWithDefaultCharset(this.contentType);
                } else if (this.contentType.getType().equalsIgnoreCase("text")) {
                    this.contentType = MultipartInputImpl.this.getMediaTypeWithCharset(this.contentType, "us-ascii");
                }
            }
        }

        @Override
        public void setMediaType(MediaType mediaType) {
            this.contentType = mediaType;
            this.contentTypeFromMessage = false;
            this.headers.putSingle((Object)"Content-Type", (Object)mediaType.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T getBody(Class<T> type, Type genericType) throws IOException {
            boolean pushProviders;
            boolean bl = pushProviders = MultipartInputImpl.this.savedProviders != null && ResteasyContext.getContextData(Providers.class) == null;
            if (MultipartInput.class.isAssignableFrom(type) && this.bodyPart.getBody() instanceof Multipart) {
                if (MultipartInput.class.equals(type)) {
                    return (T)new MultipartInputImpl((Multipart)Multipart.class.cast(this.bodyPart.getBody()), MultipartInputImpl.this.workers);
                }
                if (MultipartRelatedInput.class.equals(type)) {
                    return (T)new MultipartRelatedInputImpl((Multipart)Multipart.class.cast(this.bodyPart.getBody()), MultipartInputImpl.this.workers);
                }
                if (MultipartFormDataInput.class.equals((Object)this.bodyPart.getBody())) {
                    return (T)new MultipartFormDataInputImpl((Multipart)Multipart.class.cast(this.bodyPart.getBody()), MultipartInputImpl.this.workers);
                }
            }
            try {
                MessageBodyReader reader;
                if (pushProviders) {
                    ResteasyContext.pushContext(Providers.class, MultipartInputImpl.this.savedProviders);
                }
                if ((reader = MultipartInputImpl.this.workers.getMessageBodyReader(type, genericType, empty, this.contentType)) == null) {
                    throw new RuntimeException(Messages.MESSAGES.unableToFindMessageBodyReader(this.contentType, type.getName()));
                }
                LogMessages.LOGGER.debugf("MessageBodyReader: %s", reader.getClass().getName());
                Object object = reader.readFrom(type, genericType, empty, this.contentType, this.headers, this.getBody());
                return (T)object;
            }
            finally {
                if (pushProviders) {
                    ResteasyContext.popContextData(Providers.class);
                }
            }
        }

        @Override
        public <T> T getBody(GenericType<T> type) throws IOException {
            return this.getBody(type.getRawType(), type.getType());
        }

        public InputStream getBody() throws IOException {
            Body body = this.bodyPart.getBody();
            InputStream result = null;
            if (body instanceof TextBody) {
                throw new UnsupportedOperationException();
            }
            if (body instanceof BinaryBody) {
                return ((BinaryBody)body).getInputStream();
            }
            return result;
        }

        @Override
        public String getBodyAsString() throws IOException {
            return this.getBody(String.class, null);
        }

        @Override
        public MultivaluedMap<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public MediaType getMediaType() {
            return this.contentType;
        }

        @Override
        public boolean isContentTypeFromMessage() {
            return this.contentTypeFromMessage;
        }
    }
}

